/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.annotation.ActionInput;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.util.ActionInputsHelper;
import org.openhab.core.library.types.QuantityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AnnotationActionHandler
extends BaseActionModuleHandler {
    public static final String MODULE_RESULT = "result";
    private final Logger logger = LoggerFactory.getLogger(AnnotationActionHandler.class);
    private final Method method;
    private final ActionType moduleType;
    private final Object actionProvider;
    private final ActionInputsHelper actionInputsHelper;

    public AnnotationActionHandler(Action module, ActionType mt, Method method, Object actionProvider, ActionInputsHelper actionInputsHelper) {
        super(module);
        this.method = method;
        this.moduleType = mt;
        this.actionProvider = actionProvider;
        this.actionInputsHelper = actionInputsHelper;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        Object value;
        Object object;
        HashMap<String, Object> output = new HashMap<String, Object>();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        ArrayList<@Nullable Object> args = new ArrayList<Object>();
        int i = 0;
        while (i < annotations.length) {
            block28: {
                block27: {
                    Annotation[] annotationsOnParam = annotations[i];
                    if (annotationsOnParam == null || annotationsOnParam.length != 1) break block27;
                    object = annotationsOnParam[0];
                    if (object instanceof ActionInput) {
                        Object configValue;
                        void inputAnnotation;
                        ActionInput cfr_ignored_0 = (ActionInput)object;
                        ActionInput cfr_ignored_1 = (ActionInput)object;
                        if (!this.hasInput(this.moduleType, inputAnnotation.name())) {
                            this.logger.error("Annotated method defines input '{}' but the module type '{}' does not specify an input with this name.", (Object)inputAnnotation.name(), (Object)this.moduleType);
                            return output;
                        }
                        value = context.get(inputAnnotation.name());
                        if (value == null && (configValue = ((Action)this.module).getConfiguration().get(inputAnnotation.name())) != null) {
                            try {
                                value = this.actionInputsHelper.mapSerializedInputToActionInput(this.moduleType.getInputs().get(i), configValue);
                            }
                            catch (IllegalArgumentException e) {
                                this.logger.debug("{} Input parameter is ignored.", (Object)e.getMessage());
                            }
                        }
                        args.add(i, value);
                    }
                    break block28;
                }
                args.add(i, context.get("p" + i));
            }
            ++i;
        }
        Object result = null;
        Object @Nullable [] arguments = args.toArray();
        if (arguments.length > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug("Calling action method {} with the following arguments:", (Object)this.method.getName());
            int i2 = 0;
            while (i2 < arguments.length) {
                if (arguments[i2] == null) {
                    this.logger.debug("  - Argument {}: null", (Object)i2);
                } else {
                    this.logger.debug("  - Argument {}: type {} value {}", new Object[]{i2, arguments[i2].getClass().getCanonicalName(), arguments[i2]});
                }
                ++i2;
            }
        }
        try {
            result = this.method.invoke(this.actionProvider, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Could not call method '{}' from module type '{}'.", new Object[]{this.method, this.moduleType.getUID(), e});
        }
        if (result == null) return output;
        if (result instanceof Map) {
            try {
                Map resultMap = (Map)result;
                value = resultMap.entrySet().iterator();
                while (true) {
                    if (!value.hasNext()) {
                        return output;
                    }
                    Map.Entry entry = value.next();
                    if (!this.hasOutput(this.moduleType, (String)entry.getKey())) continue;
                    output.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (ClassCastException ex) {
                this.logger.error("The return type of action method '{}' from module type '{}' should be Map<String, Object>, because {}", new Object[]{this.method, this.moduleType.getUID(), ex.getMessage()});
                return output;
            }
        }
        object = result;
        if (object instanceof Boolean) {
            void booleanValue;
            Boolean ex = (Boolean)object;
            Boolean cfr_ignored_2 = (Boolean)object;
            output.put(MODULE_RESULT, booleanValue);
            return output;
        }
        Object object2 = result;
        if (object2 instanceof String) {
            void stringValue;
            value = (String)object2;
            String cfr_ignored_3 = (String)object2;
            output.put(MODULE_RESULT, stringValue);
            return output;
        }
        Object object3 = result;
        if (object3 instanceof Byte) {
            void byteValue;
            Byte e = (Byte)object3;
            Byte cfr_ignored_4 = (Byte)object3;
            output.put(MODULE_RESULT, byteValue);
            return output;
        }
        Object object4 = result;
        if (object4 instanceof Short) {
            void shortValue;
            Short s = (Short)object4;
            Short cfr_ignored_5 = (Short)object4;
            output.put(MODULE_RESULT, shortValue);
            return output;
        }
        Object object5 = result;
        if (object5 instanceof Integer) {
            void integerValue;
            Integer n = (Integer)object5;
            Integer cfr_ignored_6 = (Integer)object5;
            output.put(MODULE_RESULT, integerValue);
            return output;
        }
        Object object6 = result;
        if (object6 instanceof Long) {
            void longValue;
            Long l = (Long)object6;
            Long cfr_ignored_7 = (Long)object6;
            output.put(MODULE_RESULT, longValue);
            return output;
        }
        Object object7 = result;
        if (object7 instanceof Double) {
            void doubleValue;
            Double d = (Double)object7;
            Double cfr_ignored_8 = (Double)object7;
            output.put(MODULE_RESULT, doubleValue);
            return output;
        }
        Object object8 = result;
        if (object8 instanceof Float) {
            void floatValue;
            Float f = (Float)object8;
            Float cfr_ignored_9 = (Float)object8;
            output.put(MODULE_RESULT, floatValue);
            return output;
        }
        Object object9 = result;
        if (object9 instanceof BigDecimal) {
            void bigDecimalValue;
            BigDecimal bigDecimal = (BigDecimal)object9;
            BigDecimal cfr_ignored_10 = (BigDecimal)object9;
            output.put(MODULE_RESULT, bigDecimalValue.doubleValue());
            return output;
        }
        if (!(result instanceof QuantityType || result instanceof LocalDate || result instanceof LocalTime || result instanceof LocalDateTime || result instanceof ZonedDateTime || result instanceof Instant || result instanceof Duration)) {
            this.logger.warn("Non compatible return type '{}' on action method.", result.getClass());
            return output;
        }
        output.put(MODULE_RESULT, result.toString());
        return output;
    }

    private boolean hasInput(ActionType moduleType, String in) {
        for (Input i : moduleType.getInputs()) {
            if (!i.getName().equals(in)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(ActionType moduleType, String out) {
        for (Output o : moduleType.getOutputs()) {
            if (!o.getName().equals(out)) continue;
            return true;
        }
        return false;
    }
}

