/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog;

import liquibase.change.Change;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.ChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.util.ObjectUtil;

public abstract class AbstractChangeGenerator
implements ChangeGenerator {
    @Override
    public Change[] fixSchema(Change[] changes, CompareControl.SchemaComparison[] schemaComparisons) {
        if (changes == null || this instanceof UnexpectedObjectChangeGenerator) {
            return changes;
        }
        for (Change change : changes) {
            for (String field : change.getSerializableFields()) {
                String newValue;
                Object value;
                if (!field.toLowerCase().contains("schemaname") && !field.toLowerCase().contains("catalogname") || (value = change.getSerializableFieldValue(field)) == null || !(value instanceof String) || (newValue = CompareControl.SchemaComparison.convertSchema((String)value, schemaComparisons)) == null || newValue.equalsIgnoreCase((String)value)) continue;
                ObjectUtil.setProperty((Object)change, field, newValue);
            }
        }
        return changes;
    }

    @Override
    public Change[] fixOutputAsSchema(Change[] changes, CompareControl.SchemaComparison[] schemaComparisons) {
        if (changes == null) {
            return null;
        }
        for (Change change : changes) {
            for (String field : change.getSerializableFields()) {
                if (!field.toLowerCase().contains("schemaname") && !field.toLowerCase().contains("catalogname")) continue;
                Object value = change.getSerializableFieldValue(field);
                if (schemaComparisons == null || value == null || !(value instanceof String)) continue;
                for (CompareControl.SchemaComparison comparison : schemaComparisons) {
                    if (comparison.getOutputSchemaAs() == null || comparison.getComparisonSchema() == null || !comparison.getComparisonSchema().getSchemaName().equalsIgnoreCase((String)value) && !comparison.getComparisonSchema().getCatalogName().equalsIgnoreCase((String)value)) continue;
                    ObjectUtil.setProperty((Object)change, field, comparison.getOutputSchemaAs());
                }
            }
        }
        return changes;
    }
}

