/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.OID4VCEnvironmentProviderFactory;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class OID4VCMapper
implements ProtocolMapper,
OID4VCEnvironmentProviderFactory {
    protected static final String SUPPORTED_CREDENTIALS_KEY = "supportedCredentialTypes";
    protected ProtocolMapperModel mapperModel;
    private static final List<ProviderConfigProperty> OID4VC_CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    protected abstract List<ProviderConfigProperty> getIndividualConfigProperties();

    public List<ProviderConfigProperty> getConfigProperties() {
        return Stream.concat(OID4VC_CONFIG_PROPERTIES.stream(), this.getIndividualConfigProperties().stream()).toList();
    }

    public OID4VCMapper setMapperModel(ProtocolMapperModel mapperModel) {
        this.mapperModel = mapperModel;
        return this;
    }

    public String getProtocol() {
        return "oid4vc";
    }

    public String getDisplayCategory() {
        return "OID4VC Mapper";
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
    }

    public void close() {
    }

    public boolean isScopeSupported(String credentialScope) {
        Optional<String> optionalScopes = Optional.ofNullable((String)this.mapperModel.getConfig().get(SUPPORTED_CREDENTIALS_KEY));
        if (optionalScopes.isEmpty()) {
            return false;
        }
        return Arrays.asList(optionalScopes.get().split(",")).contains(credentialScope);
    }

    public abstract void setClaimsForCredential(VerifiableCredential var1, UserSessionModel var2);

    public abstract void setClaimsForSubject(Map<String, Object> var1, UserSessionModel var2);

    static {
        ProviderConfigProperty supportedCredentialsConfig = new ProviderConfigProperty();
        supportedCredentialsConfig.setType("String");
        supportedCredentialsConfig.setLabel("Supported Credential Types");
        supportedCredentialsConfig.setDefaultValue((Object)"VerifiableCredential");
        supportedCredentialsConfig.setHelpText("Types of Credentials to apply the mapper. Needs to be a comma-separated list.");
        supportedCredentialsConfig.setName(SUPPORTED_CREDENTIALS_KEY);
        OID4VC_CONFIG_PROPERTIES.clear();
        OID4VC_CONFIG_PROPERTIES.add(supportedCredentialsConfig);
    }
}

