/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.quarkus.vertx.http.runtime.cors.CORSFilter;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevUICORSFilter
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(DevUICORSFilter.class);
    private static final String HTTP_PORT_CONFIG_PROP = "quarkus.http.port";
    private static final String HTTPS_PORT_CONFIG_PROP = "quarkus.http.ssl-port";
    private static final String LOCAL_HOST = "localhost";
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private static final String HTTP_LOCAL_HOST = "http://localhost";
    private static final String HTTPS_LOCAL_HOST = "https://localhost";
    private static final String HTTP_LOCAL_HOST_IP = "http://127.0.0.1";
    private static final String HTTPS_LOCAL_HOST_IP = "https://127.0.0.1";

    private static CORSFilter corsFilter() {
        int httpPort = (Integer)ConfigProvider.getConfig().getValue(HTTP_PORT_CONFIG_PROP, Integer.TYPE);
        int httpsPort = (Integer)ConfigProvider.getConfig().getValue(HTTPS_PORT_CONFIG_PROP, Integer.TYPE);
        CORSConfig config = new CORSConfig();
        config.origins = Optional.of(List.of("http://localhost:" + httpPort, "http://127.0.0.1:" + httpPort, "https://localhost:" + httpsPort, "https://127.0.0.1:" + httpsPort));
        return new CORSFilter(config);
    }

    public void handle(RoutingContext event) {
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            DevUICORSFilter.corsFilter().handle(event);
        } else if (origin.startsWith(HTTP_LOCAL_HOST) || origin.startsWith(HTTPS_LOCAL_HOST) || origin.startsWith(HTTP_LOCAL_HOST_IP) || origin.startsWith(HTTPS_LOCAL_HOST_IP)) {
            DevUICORSFilter.corsFilter().handle(event);
        } else {
            LOG.errorf("Only localhost origin is allowed, but Origin header value is: %s", (Object)origin);
            response.setStatusCode(403);
            response.setStatusMessage("CORS Rejected - Invalid origin");
            response.end();
        }
    }
}

