/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.protocol;

import io.sentry.SpanContext;
import io.sentry.protocol.App;
import io.sentry.protocol.Browser;
import io.sentry.protocol.Device;
import io.sentry.protocol.Gpu;
import io.sentry.protocol.OperatingSystem;
import io.sentry.protocol.SentryRuntime;
import io.sentry.util.Objects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Contexts
extends ConcurrentHashMap<String, Object> {
    private static final long serialVersionUID = 252445813254943011L;

    public Contexts() {
    }

    public Contexts(@NotNull Contexts contexts) {
        for (Map.Entry entry : contexts.entrySet()) {
            if (entry == null) continue;
            Object value2 = entry.getValue();
            if ("app".equals(entry.getKey()) && value2 instanceof App) {
                this.setApp(new App((App)value2));
                continue;
            }
            if ("browser".equals(entry.getKey()) && value2 instanceof Browser) {
                this.setBrowser(new Browser((Browser)value2));
                continue;
            }
            if ("device".equals(entry.getKey()) && value2 instanceof Device) {
                this.setDevice(new Device((Device)value2));
                continue;
            }
            if ("os".equals(entry.getKey()) && value2 instanceof OperatingSystem) {
                this.setOperatingSystem(new OperatingSystem((OperatingSystem)value2));
                continue;
            }
            if ("runtime".equals(entry.getKey()) && value2 instanceof SentryRuntime) {
                this.setRuntime(new SentryRuntime((SentryRuntime)value2));
                continue;
            }
            if ("gpu".equals(entry.getKey()) && value2 instanceof Gpu) {
                this.setGpu(new Gpu((Gpu)value2));
                continue;
            }
            if ("trace".equals(entry.getKey()) && value2 instanceof SpanContext) {
                this.setTrace(new SpanContext((SpanContext)value2));
                continue;
            }
            this.put((String)entry.getKey(), value2);
        }
    }

    @Nullable
    private <T> T toContextType(@NotNull String key, @NotNull Class<T> clazz) {
        Object item = this.get(key);
        return clazz.isInstance(item) ? (T)clazz.cast(item) : null;
    }

    @Nullable
    public SpanContext getTrace() {
        return this.toContextType("trace", SpanContext.class);
    }

    public void setTrace(@Nullable SpanContext traceContext) {
        Objects.requireNonNull(traceContext, "traceContext is required");
        this.put("trace", traceContext);
    }

    @Nullable
    public App getApp() {
        return this.toContextType("app", App.class);
    }

    public void setApp(@NotNull App app) {
        this.put("app", app);
    }

    @Nullable
    public Browser getBrowser() {
        return this.toContextType("browser", Browser.class);
    }

    public void setBrowser(@NotNull Browser browser) {
        this.put("browser", browser);
    }

    @Nullable
    public Device getDevice() {
        return this.toContextType("device", Device.class);
    }

    public void setDevice(@NotNull Device device) {
        this.put("device", device);
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.toContextType("os", OperatingSystem.class);
    }

    public void setOperatingSystem(@NotNull OperatingSystem operatingSystem) {
        this.put("os", operatingSystem);
    }

    @Nullable
    public SentryRuntime getRuntime() {
        return this.toContextType("runtime", SentryRuntime.class);
    }

    public void setRuntime(@NotNull SentryRuntime runtime) {
        this.put("runtime", runtime);
    }

    @Nullable
    public Gpu getGpu() {
        return this.toContextType("gpu", Gpu.class);
    }

    public void setGpu(@NotNull Gpu gpu) {
        this.put("gpu", gpu);
    }
}

