/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.NetworkReplyObject;
import net.sf.freecol.common.networking.QuestionMessage;
import net.sf.freecol.common.networking.ReplyMessage;
import net.sf.freecol.common.networking.TrivialMessage;
import org.xml.sax.SAXException;

final class ReceivingThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ReceivingThread.class.getName());
    private static final int MAXIMUM_RETRIES = 5;
    private final Map<Integer, NetworkReplyObject> waitingThreads = Collections.synchronizedMap(new HashMap());
    private final Connection connection;
    private boolean shouldRun;
    private int nextNetworkReplyId;

    public ReceivingThread(Connection connection, String threadName) {
        super("ReceivingThread-" + threadName);
        this.connection = connection;
        this.shouldRun = true;
        this.nextNetworkReplyId = 1;
    }

    public synchronized int getNextNetworkReplyId() {
        return this.nextNetworkReplyId++;
    }

    public NetworkReplyObject waitForNetworkReply(int networkReplyId) {
        NetworkReplyObject nro = new NetworkReplyObject(networkReplyId);
        this.waitingThreads.put(networkReplyId, nro);
        return nro;
    }

    private synchronized boolean shouldRun() {
        return this.shouldRun;
    }

    private synchronized boolean stopRun() {
        if (!this.shouldRun) {
            return false;
        }
        this.shouldRun = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopThread() {
        Collection<NetworkReplyObject> nros;
        if (!this.stopRun()) {
            return false;
        }
        Map<Integer, NetworkReplyObject> map = this.waitingThreads;
        synchronized (map) {
            nros = this.waitingThreads.values();
        }
        for (NetworkReplyObject o : nros) {
            o.interrupt();
        }
        return true;
    }

    public void askToStop(String reason) {
        if (this.stopThread()) {
            logger.info(this.getName() + ": stopped receiving thread: " + reason);
        }
    }

    private void disconnect() {
        this.askToStop("disconnect");
        this.connection.sendDisconnect();
    }

    private Thread messageQuestion(QuestionMessage qm, int replyId) {
        Message query = qm.getMessage();
        return query == null ? null : new QuestionThread(this.getName() + "-question-" + replyId + "-" + query.getType(), this.connection, query, replyId);
    }

    private Thread messageUpdate(Message message) {
        if (message == null) {
            return null;
        }
        String inTag = message.getType();
        return new UpdateThread(this.getName() + "-update-" + inTag, this.connection, message);
    }

    private void listen() throws IOException, SAXException, XMLStreamException {
        String tag;
        int replyId = -1;
        try {
            tag = this.connection.startListen();
        }
        catch (XMLStreamException xse) {
            if (!this.shouldRun()) {
                return;
            }
            logger.log(Level.WARNING, this.getName() + ": listen fail", xse);
            tag = "disconnect";
        }
        Thread t = null;
        switch (tag) {
            case "disconnect": {
                this.askToStop("listen-disconnect");
                t = this.messageUpdate(TrivialMessage.disconnectMessage);
                break;
            }
            case "reply": {
                Message rm;
                replyId = this.connection.getReplyId();
                try {
                    rm = this.connection.reader();
                }
                catch (Exception ex) {
                    rm = null;
                    logger.log(Level.WARNING, this.getName() + ": reply fail", ex);
                }
                NetworkReplyObject nro = this.waitingThreads.remove(replyId);
                if (nro == null) {
                    logger.warning(this.getName() + ": did not find reply " + replyId);
                    break;
                }
                nro.setResponse(rm);
                break;
            }
            case "question": {
                replyId = this.connection.getReplyId();
                Message m = null;
                try {
                    m = this.connection.reader();
                    assert (m instanceof QuestionMessage);
                    t = this.messageQuestion((QuestionMessage)m, replyId);
                }
                catch (FreeColException fce) {
                    logger.log(Level.WARNING, "No reader for " + replyId, fce);
                    t = null;
                }
                break;
            }
            default: {
                try {
                    t = this.messageUpdate(this.connection.reader());
                    break;
                }
                catch (Exception ex) {
                    logger.log(Level.FINEST, this.getName() + ": fail", ex);
                    this.askToStop("listen-update-fail");
                }
            }
        }
        if (t != null) {
            t.start();
        }
        this.connection.endListen();
    }

    @Override
    public void run() {
        int timesFailed = 0;
        try {
            while (this.shouldRun()) {
                try {
                    this.listen();
                    timesFailed = 0;
                }
                catch (XMLStreamException | SAXException ex) {
                    if (!this.shouldRun()) {
                        break;
                    }
                    logger.log(Level.WARNING, this.getName() + ": XML fail", ex);
                    if (++timesFailed <= 5) continue;
                    this.disconnect();
                }
                catch (IOException ioe) {
                    if (!this.shouldRun()) {
                        break;
                    }
                    logger.log(Level.WARNING, this.getName() + ": IO fail", ioe);
                    this.disconnect();
                }
            }
        }
        finally {
            this.askToStop("run complete");
        }
    }

    private static class UpdateThread
    extends Thread {
        private final Connection conn;
        private final Message message;

        public UpdateThread(String name, Connection conn, Message message) {
            super(name);
            this.conn = conn;
            this.message = message;
        }

        @Override
        public void run() {
            Message reply;
            try {
                reply = this.conn.handle(this.message);
            }
            catch (FreeColException fce) {
                logger.log(Level.WARNING, this.getName() + ": handler fail", fce);
                return;
            }
            String outTag = reply == null ? "null" : reply.getType();
            try {
                this.conn.sendMessage(reply);
                logger.log(Level.FINEST, this.getName() + " -> " + outTag);
            }
            catch (IOException | XMLStreamException | FreeColException ex) {
                logger.log(Level.WARNING, this.getName() + " -> " + outTag + " failed", ex);
            }
        }
    }

    private static class QuestionThread
    extends Thread {
        private final Connection conn;
        private final Message query;
        private final int replyId;

        public QuestionThread(String name, Connection conn, Message query, int replyId) {
            super(name);
            this.conn = conn;
            this.query = query;
            this.replyId = replyId;
        }

        @Override
        public void run() {
            Message reply;
            try {
                reply = this.conn.handle(this.query);
            }
            catch (FreeColException fce) {
                logger.log(Level.WARNING, this.getName() + ": handler fail", fce);
                return;
            }
            String replyTag = reply == null ? "null" : reply.getType();
            try {
                this.conn.sendMessage(new ReplyMessage(this.replyId, reply));
                logger.log(Level.FINEST, this.getName() + " -> " + replyTag);
            }
            catch (IOException | XMLStreamException | FreeColException ex) {
                logger.log(Level.WARNING, this.getName() + " -> " + replyTag + " failed", ex);
            }
        }
    }
}

