#include "rmixenumbox.h"
#include "mixerhandle.h"

rmixEnumBox::rmixEnumBox(snd_hctl_elem_t *elem, ushort ch, rmixEnumBox *prev) {
	m_elem= elem;
	m_channel= ch;
	m_prev= prev;
	snd_ctl_elem_value_malloc(&m_val);
	snd_ctl_elem_info_malloc(&m_info);
	snd_hctl_elem_info(elem, m_info);
	for(ushort i= 0; i < snd_ctl_elem_info_get_items(m_info); i++)
	{
		snd_ctl_elem_info_set_item(m_info, i);
		snd_hctl_elem_info(elem, m_info);
		addItem(snd_ctl_elem_info_get_item_name(m_info), i);
	}
	connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(changeVal(int)));
	snd_hctl_elem_set_callback_private(elem, new mixerHandle::callbackData{ mixerHandle::EB, this });
	snd_hctl_elem_set_callback(elem, callback);
	updat();
}

rmixEnumBox::~rmixEnumBox() {
	snd_ctl_elem_value_free(m_val);
	snd_ctl_elem_info_free(m_info);
	snd_hctl_elem_set_callback(m_elem, nullptr);
	snd_hctl_elem_set_callback_private(m_elem, nullptr);
}

void rmixEnumBox::changeVal(int newVal) {
	snd_hctl_elem_read(m_elem, m_val);
	snd_ctl_elem_value_set_enumerated(m_val, m_channel, newVal);
	snd_hctl_elem_write(m_elem, m_val);
}

void rmixEnumBox::updat() {
	if(m_prev != nullptr)
		m_prev->updat();
	snd_hctl_elem_read(m_elem, m_val);
	blockSignals(1);
	setCurrentIndex(snd_ctl_elem_value_get_enumerated(m_val, m_channel));
	blockSignals(0);
}
