#include "cardselector.h"
#include "jmixmenubar.h"
#include "paramswidget.h"
#include <QApplication>
#include <QMainWindow>

int main(int argc, char *argv[]) {
	QApplication a(argc, argv);
	QMainWindow w;
	w.resize(621, 621);
	w.setWindowTitle("Soundcard Configuration");

	QWidget *wMain= new QWidget(&w);
	w.setCentralWidget(wMain);
	w.setMenuBar(new jmixMenuBar);
	QVBoxLayout *lMain= new QVBoxLayout(wMain);

	QWidget *wcs= new QWidget;
	QFormLayout *formCs= new QFormLayout(wcs);
	CardSelector *cs= new CardSelector;
	cs->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
	formCs->addRow(QObject::tr("Card:"), cs);
	lMain->addWidget(wcs);

	ParamsWidget *pw= new ParamsWidget(cs);
	lMain->addWidget(pw);

	if(cs->count())
	{
		pw->update();
		QObject::connect(cs, SIGNAL(currentIndexChanged(int)), pw, SLOT(update()));
	} else
		cs->addItem("<no cards found>");

	w.show();
	return a.exec();
}
