/*
 * Decompiled with CFR 0.152.
 */
package ru.serce.jnrfuse.examples;

import java.nio.file.Paths;
import java.util.Objects;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;

public class HelloFuse
extends FuseStubFS {
    public static final String HELLO_PATH = "/hello";
    public static final String HELLO_STR = "Hello World!";

    @Override
    public int getattr(String path, FileStat stat) {
        int res = 0;
        if (Objects.equals(path, "/")) {
            stat.st_mode.set((Number)16877);
            stat.st_nlink.set((Number)2);
        } else if (HELLO_PATH.equals(path)) {
            stat.st_mode.set((Number)33060);
            stat.st_nlink.set((Number)1);
            stat.st_size.set((Number)HELLO_STR.getBytes().length);
        } else {
            res = -ErrorCodes.ENOENT();
        }
        return res;
    }

    @Override
    public int readdir(String path, Pointer buf, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        if (!"/".equals(path)) {
            return -ErrorCodes.ENOENT();
        }
        filter.apply(buf, ".", null, 0L);
        filter.apply(buf, "..", null, 0L);
        filter.apply(buf, HELLO_PATH.substring(1), null, 0L);
        return 0;
    }

    @Override
    public int open(String path, FuseFileInfo fi) {
        if (!HELLO_PATH.equals(path)) {
            return -ErrorCodes.ENOENT();
        }
        return 0;
    }

    @Override
    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        if (!HELLO_PATH.equals(path)) {
            return -ErrorCodes.ENOENT();
        }
        byte[] bytes = HELLO_STR.getBytes();
        int length = bytes.length;
        if (offset < (long)length) {
            if (offset + size > (long)length) {
                size = (long)length - offset;
            }
            buf.put(0L, bytes, 0, bytes.length);
        } else {
            size = 0L;
        }
        return (int)size;
    }

    public static void main(String[] args) {
        HelloFuse stub = new HelloFuse();
        try {
            String path;
            switch (Platform.getNativePlatform().getOS()) {
                case WINDOWS: {
                    path = "J:\\";
                    break;
                }
                default: {
                    path = "/tmp/mnth";
                }
            }
            stub.mount(Paths.get(path, new String[0]), true, true);
        }
        finally {
            stub.umount();
        }
    }
}

