/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import java.util.concurrent.ExecutorService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.settings.WhenUnlocked;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnlockScoped
public class UnlockSuccessController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(UnlockSuccessController.class);
    private final Stage window;
    private final Vault vault;
    private final ExecutorService executor;
    private final VaultService vaultService;
    private final ObjectProperty<ContentDisplay> revealButtonState;
    private final BooleanProperty revealButtonDisabled;
    public CheckBox rememberChoiceCheckbox;

    @Inject
    public UnlockSuccessController(@UnlockWindow Stage window, @UnlockWindow Vault vault, ExecutorService executor, VaultService vaultService) {
        this.window = window;
        this.vault = vault;
        this.executor = executor;
        this.vaultService = vaultService;
        this.revealButtonState = new SimpleObjectProperty((Object)ContentDisplay.TEXT_ONLY);
        this.revealButtonDisabled = new SimpleBooleanProperty();
    }

    @FXML
    public void close() {
        LOG.trace("UnlockSuccessController.close()");
        this.window.close();
        if (this.rememberChoiceCheckbox.isSelected()) {
            this.vault.getVaultSettings().actionAfterUnlock().setValue((Object)WhenUnlocked.IGNORE);
        }
    }

    @FXML
    public void revealAndClose() {
        LOG.trace("UnlockSuccessController.revealAndClose()");
        this.revealButtonState.set((Object)ContentDisplay.LEFT);
        this.revealButtonDisabled.set(true);
        Task<Vault> revealTask = this.vaultService.createRevealTask(this.vault);
        revealTask.setOnSucceeded(evt -> {
            this.revealButtonState.set((Object)ContentDisplay.TEXT_ONLY);
            this.revealButtonDisabled.set(false);
            this.window.close();
        });
        revealTask.setOnFailed(evt -> {
            LOG.warn("Reveal failed.", revealTask.getException());
            this.revealButtonState.set((Object)ContentDisplay.TEXT_ONLY);
            this.revealButtonDisabled.set(false);
        });
        this.executor.execute((Runnable)revealTask);
        if (this.rememberChoiceCheckbox.isSelected()) {
            this.vault.getVaultSettings().actionAfterUnlock().setValue((Object)WhenUnlocked.REVEAL);
        }
    }

    public Vault getVault() {
        return this.vault;
    }

    public ReadOnlyObjectProperty<ContentDisplay> revealButtonStateProperty() {
        return this.revealButtonState;
    }

    public ContentDisplay getRevealButtonState() {
        return (ContentDisplay)this.revealButtonState.get();
    }

    public BooleanProperty revealButtonDisabledProperty() {
        return this.revealButtonDisabled;
    }

    public boolean isRevealButtonDisabled() {
        return this.revealButtonDisabled.get();
    }
}

