/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dagger.Lazy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.ShutdownHook;
import org.cryptomator.ipc.IpcCommunicator;
import org.cryptomator.launcher.CryptomatorComponent;
import org.cryptomator.launcher.DaggerCryptomatorComponent;
import org.cryptomator.launcher.IpcMessageHandler;
import org.cryptomator.logging.DebugMode;
import org.cryptomator.logging.LoggerConfiguration;
import org.cryptomator.ui.launcher.UiLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Cryptomator {
    private static final CryptomatorComponent CRYPTOMATOR_COMPONENT = DaggerCryptomatorComponent.create();
    private static final Logger LOG = LoggerFactory.getLogger(Cryptomator.class);
    private final LoggerConfiguration logConfig;
    private final DebugMode debugMode;
    private final Environment env;
    private final Lazy<IpcMessageHandler> ipcMessageHandler;
    private final CountDownLatch shutdownLatch;
    private final ShutdownHook shutdownHook;
    private final Lazy<UiLauncher> uiLauncher;

    @Inject
    Cryptomator(LoggerConfiguration logConfig, DebugMode debugMode, Environment env, Lazy<IpcMessageHandler> ipcMessageHandler, @Named(value="shutdownLatch") CountDownLatch shutdownLatch, ShutdownHook shutdownHook, Lazy<UiLauncher> uiLauncher) {
        this.logConfig = logConfig;
        this.debugMode = debugMode;
        this.env = env;
        this.ipcMessageHandler = ipcMessageHandler;
        this.shutdownLatch = shutdownLatch;
        this.shutdownHook = shutdownHook;
        this.uiLauncher = uiLauncher;
    }

    public static void main(String[] args) {
        int exitCode = CRYPTOMATOR_COMPONENT.application().run(args);
        LOG.info("Exit {}", (Object)exitCode);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int run(String[] args) {
        this.logConfig.init();
        LOG.info("Starting Cryptomator {} on {} {} ({})", new Object[]{this.env.getAppVersion().orElse("SNAPSHOT"), SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH});
        this.debugMode.initialize();
        try (IpcCommunicator communicator = IpcCommunicator.create(this.env.ipcSocketPath().toList());){
            if (communicator.isClient()) {
                communicator.sendHandleLaunchargs(List.of(args));
                communicator.sendRevealRunningApp();
                LOG.info("Found running application instance. Shutting down...");
                int n2 = 2;
                return n2;
            }
            this.shutdownHook.runOnShutdown(communicator::closeUnchecked);
            ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("IPC-%d").build());
            IpcMessageHandler msgHandler = (IpcMessageHandler)this.ipcMessageHandler.get();
            msgHandler.handleLaunchArgs(List.of(args));
            communicator.listen(msgHandler, executor);
            LOG.debug("Did not find running application instance. Launching GUI...");
            int n = this.runGuiApplication();
            return n;
        }
        catch (Throwable e) {
            LOG.error("Running application failed", e);
            return 1;
        }
    }

    private int runGuiApplication() {
        try {
            ((UiLauncher)this.uiLauncher.get()).launch();
            this.shutdownLatch.await();
            LOG.info("UI shut down");
            return 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 1;
        }
    }
}

