/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.common.vaults.PerVault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerVault
public class VaultStats {
    private static final Logger LOG = LoggerFactory.getLogger(VaultStats.class);
    private final AtomicReference<CryptoFileSystem> fs;
    private final VaultState state;
    private final ScheduledService<Optional<CryptoFileSystemStats>> updateService;
    private final LongProperty bytesPerSecondRead = new SimpleLongProperty();
    private final LongProperty bytesPerSecondWritten = new SimpleLongProperty();
    private final LongProperty bytesPerSecondEncrypted = new SimpleLongProperty();
    private final LongProperty bytesPerSecondDecrypted = new SimpleLongProperty();
    private final DoubleProperty cacheHitRate = new SimpleDoubleProperty();
    private final LongProperty totalBytesRead = new SimpleLongProperty();
    private final LongProperty totalBytesWritten = new SimpleLongProperty();
    private final LongProperty totalBytesEncrypted = new SimpleLongProperty();
    private final LongProperty totalBytesDecrypted = new SimpleLongProperty();
    private final LongProperty filesRead = new SimpleLongProperty();
    private final LongProperty filesWritten = new SimpleLongProperty();
    private final ObjectProperty<Instant> lastActivity = new SimpleObjectProperty();

    @Inject
    VaultStats(AtomicReference<CryptoFileSystem> fs, VaultState state, ExecutorService executor) {
        this.fs = fs;
        this.state = state;
        this.updateService = new UpdateStatsService();
        this.updateService.setExecutor((Executor)executor);
        this.updateService.setPeriod(Duration.seconds((double)1.0));
        state.addListener(this::vaultStateChanged);
    }

    private void vaultStateChanged(Observable observable) {
        if (VaultState.Value.UNLOCKED == this.state.get()) {
            assert (this.fs.get() != null);
            LOG.debug("start recording stats");
            Platform.runLater(() -> {
                this.lastActivity.set((Object)Instant.now());
                this.updateService.restart();
            });
        } else {
            LOG.debug("stop recording stats");
            Platform.runLater(() -> this.updateService.cancel());
        }
    }

    private void updateStats(Optional<CryptoFileSystemStats> stats) {
        assert (Platform.isFxApplicationThread());
        this.bytesPerSecondRead.set(stats.map(CryptoFileSystemStats::pollBytesRead).orElse(0L).longValue());
        this.bytesPerSecondWritten.set(stats.map(CryptoFileSystemStats::pollBytesWritten).orElse(0L).longValue());
        this.cacheHitRate.set(stats.map(this::getCacheHitRate).orElse(0.0).doubleValue());
        this.bytesPerSecondDecrypted.set(stats.map(CryptoFileSystemStats::pollBytesDecrypted).orElse(0L).longValue());
        this.bytesPerSecondEncrypted.set(stats.map(CryptoFileSystemStats::pollBytesEncrypted).orElse(0L).longValue());
        this.totalBytesRead.set(stats.map(CryptoFileSystemStats::pollTotalBytesRead).orElse(0L).longValue());
        this.totalBytesWritten.set(stats.map(CryptoFileSystemStats::pollTotalBytesWritten).orElse(0L).longValue());
        this.totalBytesEncrypted.set(stats.map(CryptoFileSystemStats::pollTotalBytesEncrypted).orElse(0L).longValue());
        this.totalBytesDecrypted.set(stats.map(CryptoFileSystemStats::pollTotalBytesDecrypted).orElse(0L).longValue());
        long oldAccessCount = this.filesRead.get() + this.filesWritten.get();
        this.filesRead.set(stats.map(CryptoFileSystemStats::pollAmountOfAccessesRead).orElse(0L).longValue());
        this.filesWritten.set(stats.map(CryptoFileSystemStats::pollAmountOfAccessesWritten).orElse(0L).longValue());
        long newAccessCount = this.filesRead.get() + this.filesWritten.get();
        if (newAccessCount > oldAccessCount) {
            this.lastActivity.set((Object)Instant.now());
        }
    }

    private double getCacheHitRate(CryptoFileSystemStats stats) {
        long accesses = stats.pollChunkCacheAccesses();
        long hits = stats.pollChunkCacheHits();
        if (accesses == 0L) {
            return 0.0;
        }
        return (double)hits / (double)accesses;
    }

    public LongProperty bytesPerSecondReadProperty() {
        return this.bytesPerSecondRead;
    }

    public long getBytesPerSecondRead() {
        return this.bytesPerSecondRead.get();
    }

    public LongProperty bytesPerSecondWrittenProperty() {
        return this.bytesPerSecondWritten;
    }

    public long getBytesPerSecondWritten() {
        return this.bytesPerSecondWritten.get();
    }

    public LongProperty bytesPerSecondEncryptedProperty() {
        return this.bytesPerSecondEncrypted;
    }

    public long getBytesPerSecondEncrypted() {
        return this.bytesPerSecondEncrypted.get();
    }

    public LongProperty bytesPerSecondDecryptedProperty() {
        return this.bytesPerSecondDecrypted;
    }

    public long getBytesPerSecondDecrypted() {
        return this.bytesPerSecondDecrypted.get();
    }

    public DoubleProperty cacheHitRateProperty() {
        return this.cacheHitRate;
    }

    public double getCacheHitRate() {
        return this.cacheHitRate.get();
    }

    public LongProperty totalBytesReadProperty() {
        return this.totalBytesRead;
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead.get();
    }

    public LongProperty totalBytesWrittenProperty() {
        return this.totalBytesWritten;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public LongProperty totalBytesEncryptedProperty() {
        return this.totalBytesEncrypted;
    }

    public long getTotalBytesEncrypted() {
        return this.totalBytesEncrypted.get();
    }

    public LongProperty totalBytesDecryptedProperty() {
        return this.totalBytesDecrypted;
    }

    public long getTotalBytesDecrypted() {
        return this.totalBytesDecrypted.get();
    }

    public LongProperty filesRead() {
        return this.filesRead;
    }

    public long getFilesRead() {
        return this.filesRead.get();
    }

    public LongProperty filesWritten() {
        return this.filesWritten;
    }

    public long getFilesWritten() {
        return this.filesWritten.get();
    }

    public ObjectProperty<Instant> lastActivityProperty() {
        return this.lastActivity;
    }

    public Instant getLastActivity() {
        return (Instant)this.lastActivity.get();
    }

    private class UpdateStatsService
    extends ScheduledService<Optional<CryptoFileSystemStats>> {
        private UpdateStatsService() {
            this.setOnFailed(event -> LOG.error("Error in UpdateStateService.", this.getException()));
        }

        protected Task<Optional<CryptoFileSystemStats>> createTask() {
            return new Task<Optional<CryptoFileSystemStats>>(){

                protected Optional<CryptoFileSystemStats> call() {
                    return Optional.ofNullable(VaultStats.this.fs.get()).map(CryptoFileSystem::getStats);
                }
            };
        }

        protected void succeeded() {
            assert (this.getValue() != null);
            VaultStats.this.updateStats((Optional)this.getValue());
            super.succeeded();
        }
    }
}

