/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany;

import com.dokany.java.DokanyException;
import com.dokany.java.DokanyMount;
import com.dokany.java.constants.DokanOption;
import com.dokany.java.constants.FileSystemFeature;
import com.dokany.java.structure.DeviceOptions;
import com.dokany.java.structure.EnumIntegerSet;
import com.dokany.java.structure.VolumeInformation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.apache.commons.cli.ParseException;
import org.cryptomator.frontend.dokany.DokanyMountFailedException;
import org.cryptomator.frontend.dokany.Mount;
import org.cryptomator.frontend.dokany.MountUtil;
import org.cryptomator.frontend.dokany.OpenHandleCheck;
import org.cryptomator.frontend.dokany.ReadWriteAdapter;
import org.cryptomator.frontend.dokany.locks.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MountFactory.class);
    private static final short THREAD_COUNT = 5;
    private static final String UNC_NAME = "";
    private static final int TIMEOUT = 10000;
    private static final int ALLOC_UNIT_SIZE = 4096;
    private static final int SECTOR_SIZE = 4096;
    private static final EnumIntegerSet<FileSystemFeature> FILE_SYSTEM_FEATURES = new EnumIntegerSet((Enum)FileSystemFeature.CASE_PRESERVED_NAMES, (Enum[])new FileSystemFeature[]{FileSystemFeature.CASE_SENSITIVE_SEARCH, FileSystemFeature.UNICODE_ON_DISK});

    private MountFactory() {
    }

    public static Mount mount(Path fileSystemRoot, Path mountPoint, String volumeName, String fileSystemName) throws DokanyMountFailedException {
        Path absMountPoint = mountPoint.toAbsolutePath();
        DeviceOptions deviceOptions = new DeviceOptions(absMountPoint.toString(), 5, new EnumIntegerSet<DokanOption>(DokanOption.class), UNC_NAME, 10000L, 4096L, 4096L);
        return MountFactory.mount(fileSystemRoot, volumeName, fileSystemName, deviceOptions, (Throwable ignored) -> {});
    }

    public static Mount mount(Path fileSystemRoot, Path mountPoint, String volumeName, String fileSystemName, String additionalOptions) throws DokanyMountFailedException {
        Path absMountPoint = mountPoint.toAbsolutePath();
        MountUtil.MountOptions mountOptions = MountFactory.parseMountOptions(additionalOptions);
        DeviceOptions deviceOptions = new DeviceOptions(absMountPoint.toString(), mountOptions.getThreadCount().orElse((short)5), mountOptions.getDokanOptions(), UNC_NAME, mountOptions.getTimeout().orElse(10000).intValue(), mountOptions.getAllocationUnitSize().orElse(4096).intValue(), mountOptions.getSectorSize().orElse(4096).intValue());
        return MountFactory.mount(fileSystemRoot, volumeName, fileSystemName, deviceOptions, (Throwable ignored) -> {});
    }

    public static Mount mount(Path fileSystemRoot, Path mountPoint, String volumeName, String fileSystemName, String additionalOptions, Consumer<Throwable> onDokanExit) throws DokanyMountFailedException {
        Path absMountPoint = mountPoint.toAbsolutePath();
        MountUtil.MountOptions mountOptions = MountFactory.parseMountOptions(additionalOptions);
        DeviceOptions deviceOptions = new DeviceOptions(absMountPoint.toString(), mountOptions.getThreadCount().orElse((short)5), mountOptions.getDokanOptions(), UNC_NAME, mountOptions.getTimeout().orElse(10000).intValue(), mountOptions.getAllocationUnitSize().orElse(4096).intValue(), mountOptions.getSectorSize().orElse(4096).intValue());
        return MountFactory.mount(fileSystemRoot, volumeName, fileSystemName, deviceOptions, onDokanExit);
    }

    private static Mount mount(Path fileSystemRoot, String volumeName, String fileSystemName, DeviceOptions deviceOptions, Consumer<Throwable> onDokanExit) throws DokanyMountFailedException {
        VolumeInformation volumeInfo = new VolumeInformation(255, volumeName, -1737075662, fileSystemName, FILE_SYSTEM_FEATURES);
        OpenHandleCheck.OpenHandleCheckBuilder handleCheckBuilder = OpenHandleCheck.getBuilder();
        ReadWriteAdapter dokanyFs = new ReadWriteAdapter(fileSystemRoot, new LockManager(), volumeInfo, handleCheckBuilder);
        DokanyMount mount = new DokanyMount(deviceOptions, dokanyFs, handleCheckBuilder.build());
        LOG.debug("Mounting on {}: ...", (Object)deviceOptions.MountPoint);
        try {
            mount.mount(onDokanExit);
            LOG.debug("Mounted directory at {} successfully.", (Object)deviceOptions.MountPoint);
        }
        catch (DokanyException e) {
            LOG.error("Mounting failed.", (Throwable)e);
            throw new DokanyMountFailedException("Error while mounting.", e);
        }
        return mount;
    }

    private static MountUtil.MountOptions parseMountOptions(String options) throws DokanyMountFailedException {
        try {
            return MountUtil.parse(options);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new DokanyMountFailedException("Unable to parse mount options", e);
        }
    }

    public static boolean isApplicable() {
        return System.getProperty("os.name").toLowerCase().contains("windows") && Files.exists(Paths.get("C:\\Windows\\System32\\drivers\\dokan1.sys", new String[0]), new LinkOption[0]);
    }
}

