/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.nio.file.AccessMode;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import jnr.posix.util.Platform;
import org.cryptomator.frontend.fuse.PerAdapter;
import ru.serce.jnrfuse.flags.AccessConstants;
import ru.serce.jnrfuse.struct.FileStat;

@PerAdapter
public class FileAttributesUtil {
    private static final int DUMMY_UID = 65534;
    private static final int DUMMY_GID = 65534;

    @Inject
    public FileAttributesUtil() {
    }

    public Set<AccessMode> accessModeMaskToSet(int mask) {
        EnumSet<AccessMode> accessModes = EnumSet.noneOf(AccessMode.class);
        if ((mask & AccessConstants.R_OK) == AccessConstants.R_OK) {
            accessModes.add(AccessMode.READ);
        }
        if ((mask & AccessConstants.W_OK) == AccessConstants.W_OK) {
            accessModes.add(AccessMode.WRITE);
        }
        if ((mask & AccessConstants.X_OK) == AccessConstants.X_OK) {
            accessModes.add(AccessMode.EXECUTE);
        }
        return accessModes;
    }

    public Set<PosixFilePermission> octalModeToPosixPermissions(long mode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100L) == 256L) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80L) == 128L) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40L) == 64L) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20L) == 32L) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10L) == 16L) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8L) == 8L) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4L) == 4L) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2L) == 2L) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1L) == 1L) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public void copyBasicFileAttributesFromNioToFuse(BasicFileAttributes attrs, FileStat stat) {
        if (attrs.isDirectory()) {
            stat.st_mode.set((Number)(stat.st_mode.longValue() | 0x4000L));
        } else if (attrs.isRegularFile()) {
            stat.st_mode.set((Number)(stat.st_mode.longValue() | 0x8000L));
        } else if (attrs.isSymbolicLink()) {
            stat.st_mode.set((Number)(stat.st_mode.longValue() | 0xA000L));
        }
        stat.st_uid.set(65534L);
        stat.st_gid.set(65534L);
        stat.st_mtim.tv_sec.set(attrs.lastModifiedTime().toInstant().getEpochSecond());
        stat.st_mtim.tv_nsec.set((Number)attrs.lastModifiedTime().toInstant().getNano());
        stat.st_ctim.tv_sec.set(attrs.creationTime().toInstant().getEpochSecond());
        stat.st_ctim.tv_nsec.set((Number)attrs.creationTime().toInstant().getNano());
        if (Platform.IS_MAC || Platform.IS_WINDOWS) {
            assert (stat.st_birthtime != null);
            stat.st_birthtime.tv_sec.set(attrs.creationTime().toInstant().getEpochSecond());
            stat.st_birthtime.tv_nsec.set((Number)attrs.creationTime().toInstant().getNano());
        }
        stat.st_atim.tv_sec.set(attrs.lastAccessTime().toInstant().getEpochSecond());
        stat.st_atim.tv_nsec.set((Number)attrs.lastAccessTime().toInstant().getNano());
        stat.st_size.set((Number)attrs.size());
        stat.st_nlink.set((Number)1);
        if (Platform.IS_MAC) {
            stat.st_flags.set(0L);
            stat.st_gen.set(0L);
        }
    }

    public long posixPermissionsToOctalMode(Set<PosixFilePermission> permissions) {
        long mode = 0L;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100L;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20L;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4L;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80L;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10L;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2L;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40L;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8L;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1L;
        }
        return mode;
    }
}

