/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.history;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.modules.gedcom.history.DisplayHistoryAction;
import ancestris.modules.gedcom.history.GedcomHistoryPlugin;
import genj.gedcom.Context;
import java.awt.event.ActionEvent;
import java.io.File;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ClearHistoryAction
extends AbstractAncestrisContextAction {
    public ClearHistoryAction() {
        this.setImage("ancestris/modules/gedcom/history/ClearHistoryIcon.png");
        this.setText(NbBundle.getMessage(DisplayHistoryAction.class, (String)"CTL_ClearHistoryAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        for (PluginInterface pluginInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
            if (!(pluginInterface instanceof GedcomHistoryPlugin)) continue;
            Context context = this.getContext();
            if (context == null) break;
            String gedcomName = context.getGedcom().getName().substring(0, context.getGedcom().getName().lastIndexOf(".") == -1 ? context.getGedcom().getName().length() : context.getGedcom().getName().lastIndexOf("."));
            File cacheSubdirectory = Places.getCacheSubdirectory((String)GedcomHistoryPlugin.class.getCanonicalName());
            File historyFile = new File(cacheSubdirectory.getAbsolutePath() + System.getProperty("file.separator") + gedcomName + ".hist");
            ((GedcomHistoryPlugin)pluginInterface).getGedcomHistory(context.getGedcom()).clear();
            if (!historyFile.exists()) break;
            historyFile.delete();
            break;
        }
    }
}

