/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.arrange;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.arrange.AlignLeftArranger;
import java.util.logging.Logger;

public class AlignGenLeftArranger
extends AlignLeftArranger {
    private static final Logger LOG = Logger.getLogger("ancestris.report.svgtree", null);

    public AlignGenLeftArranger(int spacing) {
        super(spacing);
    }

    @Override
    public void filter(IndiBox indibox) {
        indibox.wPlus = indibox.width;
        indibox.hPlus = 1;
        if (indibox.spouse != null) {
            this.arrangeSpouse(indibox, indibox.spouse);
            this.updateSpouse(indibox);
        }
        this.updateFamily(indibox);
        if (indibox.hasChildren()) {
            this.arrangeChildren(indibox);
            this.updateChildren(indibox);
        }
        if (indibox.parent != null) {
            this.arrangeParent(indibox, indibox.parent);
            this.updateParent(indibox);
        }
        if (indibox.spouse != null && indibox.spouse.parent != null) {
            this.arrangeSpouseParent(indibox, indibox.spouse.parent);
            this.updateSpouseParent(indibox);
        }
        if (indibox.spouse != null && indibox.spouse.nextMarriage != null) {
            this.arrangeNextMarriages(indibox, indibox.spouse.nextMarriage);
            this.updateSpouseNextMarriage(indibox);
        }
        if (indibox.nextMarriage != null) {
            this.arrangeNextMarriages(indibox, indibox.nextMarriage);
            this.updateNextMarriage(indibox);
        }
    }

    @Override
    protected void arrangeChildren(IndiBox indibox) {
        int currentX = 0;
        if (indibox.getDir() == IndiBox.Direction.PARENT) {
            currentX = indibox.prev.width / 2 - indibox.x + this.spacing;
        }
        for (IndiBox child : indibox.children) {
            child.y = 1;
            this.filter(child);
            child.x = currentX + child.wMinus;
            currentX += child.wMinus + child.wPlus + this.spacing;
        }
        int parentWidth = indibox.wMinus + indibox.wPlus;
        int childrenWidth = currentX - this.spacing;
        if (parentWidth > childrenWidth) {
            int diff = (parentWidth - childrenWidth) / 2 - indibox.wMinus;
            for (IndiBox child : indibox.children) {
                child.x += diff;
            }
        }
    }

    @Override
    protected void arrangeSpouseParent(IndiBox indibox, IndiBox parent) {
        super.arrangeSpouseParent(indibox, parent);
        parent.x = indibox.wPlus + indibox.wMinus + this.spacing - indibox.spouse.x;
    }
}

