/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.file.FileSink;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Color;
import org.graphstream.ui.graphicGraph.stylesheet.Colors;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;

public class FileSinkSVG
implements FileSink {
    @Override
    public void begin(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void begin(OutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void begin(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void end() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void writeAll(Graph graph, String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.writeAll(graph, out);
        out.close();
    }

    @Override
    public void writeAll(Graph graph, OutputStream stream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(stream);
        this.writeAll(graph, out);
    }

    @Override
    public void writeAll(Graph g, Writer w) throws IOException {
        XMLWriter out = new XMLWriter();
        SVGContext ctx = new SVGContext();
        try {
            out.start(w);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        try {
            ctx.init(out, g);
            ctx.writeElements(out, g);
            ctx.end(out);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        try {
            out.end();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String d(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }

    private static double getX(Node n) {
        Object[] xyz;
        Object[] xy;
        if (n.hasNumber("x")) {
            return n.getNumber("x");
        }
        if (n.hasArray("xy") && (xy = n.getArray("xy")) != null && xy.length > 0 && xy[0] instanceof Number) {
            return ((Number)xy[0]).doubleValue();
        }
        if (n.hasArray("xyz") && (xyz = n.getArray("xyz")) != null && xyz.length > 0 && xyz[0] instanceof Number) {
            return ((Number)xyz[0]).doubleValue();
        }
        System.err.printf("[WARNING] no x attribute for node \"%s\" %s\n", n.getId(), n.hasAttribute("xyz"));
        return Math.random();
    }

    private static double getY(Node n) {
        Object[] xyz;
        Object[] xy;
        if (n.hasNumber("y")) {
            return n.getNumber("y");
        }
        if (n.hasArray("xy") && (xy = n.getArray("xy")) != null && xy.length > 1 && xy[1] instanceof Number) {
            return ((Number)xy[1]).doubleValue();
        }
        if (n.hasArray("xyz") && (xyz = n.getArray("xyz")) != null && xyz.length > 1 && xyz[1] instanceof Number) {
            return ((Number)xyz[1]).doubleValue();
        }
        return Math.random();
    }

    private static String getSize(Value v) {
        String u = v.units.name().toLowerCase();
        return String.format(Locale.ROOT, "%f%s", v.value, u);
    }

    private static String getSize(Values v, int index) {
        String u = v.units.name().toLowerCase();
        if (StyleConstants.Units.PERCENTS.equals((Object)v.units)) {
            u = "%";
        }
        return String.format(Locale.ROOT, "%f%s", v.get(index), u);
    }

    private static void concat(StringBuilder buffer, Object ... args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                buffer.append(args[i].toString());
                ++i;
            }
        }
    }

    private static String toHexColor(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
    }

    static class SVGContext {
        StyleGroupSet groups;
        StyleSheet stylesheet = new StyleSheet();
        HashMap<StyleGroup, SVGStyle> svgStyles;
        ViewBox viewBox;

        public SVGContext() {
            this.groups = new StyleGroupSet(this.stylesheet);
            this.svgStyles = new HashMap();
            this.viewBox = new ViewBox(0.0, 0.0, 1000.0, 1000.0);
        }

        public void init(XMLWriter out, Graph g) throws IOException, XMLStreamException {
            block6: {
                if (g.hasAttribute("ui.stylesheet")) {
                    this.stylesheet.load((String)g.getAttribute("ui.stylesheet"));
                }
                this.groups.addElement(g);
                this.viewBox.compute(g, this.groups.getStyleFor(g));
                out.open("svg");
                out.attribute("xmlns", "http://www.w3.org/2000/svg");
                out.attribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
                out.attribute("xmlns:cc", "http://creativecommons.org/ns#");
                out.attribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                out.attribute("xmlns:svg", "http://www.w3.org/2000/svg");
                out.attribute("viewBox", String.format(Locale.ROOT, "%f %f %f %f", this.viewBox.x1, this.viewBox.y1, this.viewBox.x2, this.viewBox.y2));
                out.attribute("id", g.getId());
                out.attribute("version", "1.1");
                try {
                    g.edges().forEach(e -> {
                        this.groups.addElement((Element)e);
                        if (e.hasAttribute("ui.style")) {
                            try {
                                this.stylesheet.parseStyleFromString(new Selector(Selector.Type.EDGE, e.getId(), null), (String)e.getAttribute("ui.style"));
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        this.groups.checkElementStyleGroup((Element)e);
                    });
                    g.nodes().forEach(n -> {
                        this.groups.addElement((Element)n);
                        if (n.hasAttribute("ui.style")) {
                            try {
                                this.stylesheet.parseStyleFromString(new Selector(Selector.Type.NODE, n.getId(), null), (String)n.getAttribute("ui.style"));
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        this.groups.checkElementStyleGroup((Element)n);
                    });
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getCause() instanceof IOException) {
                        throw (IOException)runtimeException.getCause();
                    }
                    if (!(runtimeException.getCause() instanceof XMLStreamException)) break block6;
                    throw (IOException)runtimeException.getCause();
                }
            }
            for (StyleGroup styleGroup : this.groups.groups()) {
                this.svgStyles.put(styleGroup, new SVGStyle(styleGroup));
            }
            out.open("defs");
            for (SVGStyle sVGStyle : this.svgStyles.values()) {
                sVGStyle.writeDef(out);
            }
            out.close();
        }

        public void end(XMLWriter out) throws XMLStreamException {
            out.close();
        }

        public void writeElements(XMLWriter out, Graph g) throws XMLStreamException {
            out.open("g");
            out.attribute("id", "graph-misc");
            this.writeElement(out, g);
            out.close();
            Iterator<HashSet<StyleGroup>> it = this.groups.getZIterator();
            out.open("g");
            out.attribute("id", "elements");
            while (it.hasNext()) {
                HashSet<StyleGroup> set = it.next();
                for (StyleGroup sg : set) {
                    for (Element element : sg.elements()) {
                        this.writeElement(out, element);
                    }
                }
            }
            out.close();
        }

        public void writeElement(XMLWriter out, Element e) throws XMLStreamException {
            String id = "";
            SVGStyle style = null;
            String transform = null;
            if (e instanceof Edge) {
                id = String.format("egde-%s", e.getId());
                style = this.svgStyles.get(this.groups.getStyleFor((Edge)e));
            } else if (e instanceof Node) {
                id = String.format("node-%s", e.getId());
                style = this.svgStyles.get(this.groups.getStyleFor((Node)e));
                transform = String.format(Locale.ROOT, "translate(%f,%f)", this.viewBox.convertX((Node)e), this.viewBox.convertY((Node)e));
            } else if (e instanceof Graph) {
                id = "graph-background";
                style = this.svgStyles.get(this.groups.getStyleFor((Graph)e));
            }
            out.open("g");
            out.attribute("id", id);
            out.open("path");
            if (style != null) {
                out.attribute("style", style.getElementStyle(e));
            }
            if (transform != null) {
                out.attribute("transform", transform);
            }
            out.attribute("d", this.getPath(e, style));
            out.close();
            if (e.hasLabel("label")) {
                this.writeElementText(out, (String)e.getAttribute("label"), e, style.group);
            }
            out.close();
        }

        public void writeElementText(XMLWriter out, String text, Element e, StyleGroup style) throws XMLStreamException {
            if (style == null || style.getTextVisibilityMode() != StyleConstants.TextVisibilityMode.HIDDEN) {
                double x = 0.0;
                double y = 0.0;
                if (e instanceof Node) {
                    x = this.viewBox.convertX((Node)e);
                    y = this.viewBox.convertY((Node)e);
                } else if (e instanceof Edge) {
                    Node n0 = ((Edge)e).getNode0();
                    Node n1 = ((Edge)e).getNode0();
                    x = this.viewBox.convertX((FileSinkSVG.getX(n0) + FileSinkSVG.getX(n1)) / 2.0);
                    y = this.viewBox.convertY((FileSinkSVG.getY(n0) + FileSinkSVG.getY(n1)) / 2.0);
                }
                out.open("g");
                out.open("text");
                out.attribute("x", FileSinkSVG.d(x));
                out.attribute("y", FileSinkSVG.d(y));
                if (style != null) {
                    if (style.getTextColorCount() > 0) {
                        out.attribute("fill", FileSinkSVG.toHexColor(style.getTextColor(0)));
                    }
                    switch (style.getTextAlignment()) {
                        case CENTER: {
                            out.attribute("text-anchor", "middle");
                            out.attribute("alignment-baseline", "central");
                            break;
                        }
                        case LEFT: {
                            out.attribute("text-anchor", "start");
                            break;
                        }
                        case RIGHT: {
                            out.attribute("text-anchor", "end");
                            break;
                        }
                    }
                    switch (style.getTextSize().units) {
                        case PX: 
                        case GU: {
                            out.attribute("font-size", FileSinkSVG.d(style.getTextSize().value));
                            break;
                        }
                        case PERCENTS: {
                            out.attribute("font-size", String.valueOf(FileSinkSVG.d(style.getTextSize().value)) + "%");
                        }
                    }
                    if (style.getTextFont() != null) {
                        out.attribute("font-family", style.getTextFont());
                    }
                    switch (style.getTextStyle()) {
                        case NORMAL: {
                            break;
                        }
                        case ITALIC: {
                            out.attribute("font-style", "italic");
                            break;
                        }
                        case BOLD: {
                            out.attribute("font-weight", "bold");
                            break;
                        }
                        case BOLD_ITALIC: {
                            out.attribute("font-weight", "bold");
                            out.attribute("font-style", "italic");
                        }
                    }
                }
                out.characters(text);
                out.close();
                out.close();
            }
        }

        public String getPath(Element e, SVGStyle style) {
            StringBuilder buffer = new StringBuilder();
            if (e instanceof Node) {
                Values size = style.group.getSize();
                double sx = this.getValue(size.get(0), size.units, true);
                double sy = size.getValueCount() > 1 ? this.getValue(size.get(1), size.units, false) : this.getValue(size.get(0), size.units, false);
                switch (style.group.getShape()) {
                    case ROUNDED_BOX: {
                        double rx = Math.min(5.0, sx / 2.0);
                        double ry = Math.min(5.0, sy / 2.0);
                        FileSinkSVG.concat(buffer, new Object[]{" m ", FileSinkSVG.d(-sx / 2.0 + rx), " ", FileSinkSVG.d(-sy / 2.0)});
                        FileSinkSVG.concat(buffer, new Object[]{" h ", FileSinkSVG.d(sx - 2.0 * rx)});
                        FileSinkSVG.concat(buffer, new Object[]{" a ", FileSinkSVG.d(rx), ",", FileSinkSVG.d(ry), " 0 0 1 ", FileSinkSVG.d(rx), ",", FileSinkSVG.d(ry)});
                        FileSinkSVG.concat(buffer, new Object[]{" v ", FileSinkSVG.d(sy - 2.0 * ry)});
                        FileSinkSVG.concat(buffer, new Object[]{" a ", FileSinkSVG.d(rx), ",", FileSinkSVG.d(ry), " 0 0 1 -", FileSinkSVG.d(rx), ",", FileSinkSVG.d(ry)});
                        FileSinkSVG.concat(buffer, new Object[]{" h ", FileSinkSVG.d(-sx + 2.0 * rx)});
                        FileSinkSVG.concat(buffer, new Object[]{" a ", FileSinkSVG.d(rx), ",", FileSinkSVG.d(ry), " 0 0 1 -", FileSinkSVG.d(rx), ",-", FileSinkSVG.d(ry)});
                        FileSinkSVG.concat(buffer, new Object[]{" v ", FileSinkSVG.d(-sy + 2.0 * ry)});
                        FileSinkSVG.concat(buffer, new Object[]{" a ", FileSinkSVG.d(rx), ",", FileSinkSVG.d(ry), " 0 0 1 ", FileSinkSVG.d(rx), "-", FileSinkSVG.d(ry)});
                        FileSinkSVG.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    case BOX: {
                        FileSinkSVG.concat(buffer, new Object[]{" m ", FileSinkSVG.d(-sx / 2.0), " ", FileSinkSVG.d(-sy / 2.0)});
                        FileSinkSVG.concat(buffer, new Object[]{" h ", FileSinkSVG.d(sx)});
                        FileSinkSVG.concat(buffer, new Object[]{" v ", FileSinkSVG.d(sy)});
                        FileSinkSVG.concat(buffer, new Object[]{" h ", FileSinkSVG.d(-sx)});
                        FileSinkSVG.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    case DIAMOND: {
                        FileSinkSVG.concat(buffer, new Object[]{" m ", FileSinkSVG.d(-sx / 2.0), " 0"});
                        FileSinkSVG.concat(buffer, new Object[]{" l ", FileSinkSVG.d(sx / 2.0), " ", FileSinkSVG.d(-sy / 2.0)});
                        FileSinkSVG.concat(buffer, new Object[]{" l ", FileSinkSVG.d(sx / 2.0), " ", FileSinkSVG.d(sy / 2.0)});
                        FileSinkSVG.concat(buffer, new Object[]{" l ", FileSinkSVG.d(-sx / 2.0), " ", FileSinkSVG.d(sy / 2.0)});
                        FileSinkSVG.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    case TRIANGLE: {
                        FileSinkSVG.concat(buffer, new Object[]{" m ", FileSinkSVG.d(0.0), " ", FileSinkSVG.d(-sy / 2.0)});
                        FileSinkSVG.concat(buffer, new Object[]{" l ", FileSinkSVG.d(sx / 2.0), " ", FileSinkSVG.d(sy)});
                        FileSinkSVG.concat(buffer, new Object[]{" h ", FileSinkSVG.d(-sx)});
                        FileSinkSVG.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    default: {
                        FileSinkSVG.concat(buffer, new Object[]{" m ", FileSinkSVG.d(-sx / 2.0), " 0"});
                        FileSinkSVG.concat(buffer, new Object[]{" a ", FileSinkSVG.d(sx / 2.0), ",", FileSinkSVG.d(sy / 2.0), " 0 1 0 ", FileSinkSVG.d(sx), ",0"});
                        FileSinkSVG.concat(buffer, new Object[]{" ", FileSinkSVG.d(sx / 2.0), ",", FileSinkSVG.d(sy / 2.0), " 0 1 0 -", FileSinkSVG.d(sx), ",0"});
                        FileSinkSVG.concat(buffer, new Object[]{" z"});
                        break;
                    }
                }
            } else if (e instanceof Graph) {
                FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(this.viewBox.x1), " ", FileSinkSVG.d(this.viewBox.y1)});
                FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(this.viewBox.x2), " ", FileSinkSVG.d(this.viewBox.y1)});
                FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(this.viewBox.x2), " ", FileSinkSVG.d(this.viewBox.y2)});
                FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(this.viewBox.x1), " ", FileSinkSVG.d(this.viewBox.y2)});
                FileSinkSVG.concat(buffer, new Object[]{" Z"});
            } else if (e instanceof Edge) {
                double[] perpen;
                double nodeSize;
                double sizeEdge = this.getValue(style.group.getSize().get(0), style.group.getSize().units, true);
                Values sizeArrow = style.group.getArrowSize();
                double sx = this.getValue(sizeArrow.get(0), sizeArrow.units, true);
                double sy = sizeArrow.getValueCount() > 1 ? this.getValue(sizeArrow.get(1), sizeArrow.units, false) : this.getValue(sizeArrow.get(0), sizeArrow.units, false);
                Edge edge = (Edge)e;
                Node src = edge.getSourceNode();
                Node trg = edge.getTargetNode();
                double x1 = this.viewBox.convertX(src);
                double y1 = this.viewBox.convertY(src);
                double x2 = this.viewBox.convertX(trg);
                double y2 = this.viewBox.convertY(trg);
                switch (style.group.getShape()) {
                    case ANGLE: {
                        double[] perpendicular = this.getPerpendicular(x1, y1, x2, y2, sizeEdge);
                        double x1Prim = perpendicular[0];
                        double y1Prim = perpendicular[1];
                        double x2Prim = perpendicular[2];
                        double y2Prim = perpendicular[3];
                        FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(x1), " ", FileSinkSVG.d(y1)});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x1Prim), " ", FileSinkSVG.d(y1Prim)});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2Prim), " ", FileSinkSVG.d(y2Prim)});
                        FileSinkSVG.concat(buffer, new Object[]{" Z"});
                        break;
                    }
                    case CUBIC_CURVE: {
                        nodeSize = this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(0);
                        if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().getValueCount() > 1) {
                            nodeSize = Math.max(nodeSize, this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1));
                        }
                        double xCenter = (x1 + x2) / 2.0;
                        double yCenter = (y1 + y2) / 2.0;
                        perpen = this.getPerpendicular(x1, y1, xCenter, yCenter, Math.sqrt(Math.pow(Math.abs(x1 - xCenter), 2.0) + Math.pow(Math.abs(y1 - yCenter), 2.0)) * 2.0);
                        double x45degrees = (x1 + perpen[2]) / 2.0;
                        double y45degrees = (y1 + perpen[3]) / 2.0;
                        double xCenterCenter = (x1 + xCenter) / 2.0;
                        double yCenterCenter = (y1 + yCenter) / 2.0;
                        double x20degrees = (xCenterCenter + x45degrees) / 2.0;
                        double y20degrees = (yCenterCenter + y45degrees) / 2.0;
                        FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(x1), " ", FileSinkSVG.d(y1)});
                        FileSinkSVG.concat(buffer, new Object[]{" C ", FileSinkSVG.d(x20degrees), " ", FileSinkSVG.d(y20degrees), " ", FileSinkSVG.d(x20degrees), " ", FileSinkSVG.d(y20degrees), " ", FileSinkSVG.d(xCenter), " ", FileSinkSVG.d(yCenter)});
                        double x45degrees2nd = (x2 + perpen[0]) / 2.0;
                        double y45degrees2nd = (y2 + perpen[1]) / 2.0;
                        double xCenterCenter2nd = (x2 + xCenter) / 2.0;
                        double yCenterCenter2nd = (y2 + yCenter) / 2.0;
                        double x20degrees2nd = (xCenterCenter2nd + x45degrees2nd) / 2.0;
                        double y20degrees2nd = (yCenterCenter2nd + y45degrees2nd) / 2.0;
                        FileSinkSVG.concat(buffer, new Object[]{" S ", FileSinkSVG.d(x20degrees2nd), " ", FileSinkSVG.d(y20degrees2nd), " ", FileSinkSVG.d(x2), " ", FileSinkSVG.d(y2)});
                        FileSinkSVG.concat(buffer, new Object[]{" C ", FileSinkSVG.d(x20degrees2nd), " ", FileSinkSVG.d(y20degrees2nd), " ", FileSinkSVG.d(x20degrees2nd), " ", FileSinkSVG.d(y20degrees2nd), " ", FileSinkSVG.d(xCenter), " ", FileSinkSVG.d(yCenter)});
                        FileSinkSVG.concat(buffer, new Object[]{" S ", FileSinkSVG.d(x20degrees), " ", FileSinkSVG.d(y20degrees), " ", FileSinkSVG.d(x1), " ", FileSinkSVG.d(y1)});
                        FileSinkSVG.concat(buffer, new Object[]{" Z"});
                        break;
                    }
                    case BLOB: {
                        nodeSize = this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(0);
                        if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().getValueCount() > 1) {
                            nodeSize = Math.max(nodeSize, this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1));
                        }
                        double xCenter = (x1 + x2) / 2.0;
                        double yCenter = (y1 + y2) / 2.0;
                        double xCenterCenter = (x1 + xCenter) / 2.0;
                        double yCenterCenter = (y1 + yCenter) / 2.0;
                        double[] perpenCenter = this.getPerpendicular(x1, y1, xCenter, yCenter, sizeEdge);
                        double[] perpenX1 = this.getPerpendicular(xCenter, yCenter, x1, y1, nodeSize);
                        double[] perpenXCenter1 = this.getPerpendicular(x1, y1, xCenterCenter, yCenterCenter, sizeEdge);
                        FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(perpenX1[0]), " ", FileSinkSVG.d(perpenX1[1])});
                        FileSinkSVG.concat(buffer, new Object[]{" Q ", FileSinkSVG.d(perpenXCenter1[0]), " ", FileSinkSVG.d(perpenXCenter1[1]), " ", FileSinkSVG.d(perpenCenter[0]), " ", FileSinkSVG.d(perpenCenter[1])});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2), " ", FileSinkSVG.d(y2)});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(perpenCenter[2]), " ", FileSinkSVG.d(perpenCenter[3])});
                        FileSinkSVG.concat(buffer, new Object[]{" Q ", FileSinkSVG.d(perpenXCenter1[2]), " ", FileSinkSVG.d(perpenXCenter1[3]), " ", FileSinkSVG.d(perpenX1[2]), " ", FileSinkSVG.d(perpenX1[3])});
                        FileSinkSVG.concat(buffer, new Object[]{" Z"});
                        if (edge.isDirected()) break;
                        double[] perpenX2 = this.getPerpendicular(xCenter, yCenter, x2, y2, nodeSize);
                        double xCenterCenter2nd = (x2 + xCenter) / 2.0;
                        double yCenterCenter2nd = (y2 + yCenter) / 2.0;
                        double[] perpenXCenter2 = this.getPerpendicular(x2, y2, xCenterCenter2nd, yCenterCenter2nd, sizeEdge);
                        FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(perpenX2[0]), " ", FileSinkSVG.d(perpenX2[1])});
                        FileSinkSVG.concat(buffer, new Object[]{" Q ", FileSinkSVG.d(perpenXCenter2[0]), " ", FileSinkSVG.d(perpenXCenter2[1]), " ", FileSinkSVG.d(perpenCenter[0]), " ", FileSinkSVG.d(perpenCenter[1])});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x1), " ", FileSinkSVG.d(y1)});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(perpenCenter[2]), " ", FileSinkSVG.d(perpenCenter[3])});
                        FileSinkSVG.concat(buffer, new Object[]{" Q ", FileSinkSVG.d(perpenXCenter2[2]), " ", FileSinkSVG.d(perpenXCenter2[3]), " ", FileSinkSVG.d(perpenX2[2]), " ", FileSinkSVG.d(perpenX2[3])});
                        FileSinkSVG.concat(buffer, new Object[]{" Z"});
                        break;
                    }
                    default: {
                        FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(x1), " ", FileSinkSVG.d(y1)});
                        FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2), " ", FileSinkSVG.d(y2)});
                    }
                }
                if (edge.isDirected()) {
                    nodeSize = this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(0);
                    double diag = -1.0;
                    if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().getValueCount() > 1) {
                        diag = Math.sqrt(Math.pow(nodeSize, 2.0) + Math.pow(this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1), 2.0));
                        nodeSize = Math.min(nodeSize, this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getSize().get(1));
                    } else {
                        diag = Math.sqrt(Math.pow(nodeSize, 2.0) + Math.pow(nodeSize, 2.0));
                    }
                    if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.CIRCLE)) {
                        nodeSize /= 2.0;
                    } else if (this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.BOX) || this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.ROUNDED_BOX) || this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.DIAMOND) || this.svgStyles.get((Object)this.groups.getStyleFor((Node)trg)).group.getShape().equals((Object)StyleConstants.Shape.TRIANGLE)) {
                        nodeSize = diag / 2.0;
                    }
                    double distance = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    switch (style.group.getArrowShape()) {
                        case CIRCLE: {
                            double ratioPoint = 1.0 - nodeSize / distance;
                            double ratioLine = 1.0 - (sx / 2.0 + nodeSize) / distance;
                            double x2Root = (1.0 - ratioLine) * x1 + ratioLine * x2;
                            double y2Root = (1.0 - ratioLine) * y1 + ratioLine * y2;
                            double x2Point = (1.0 - ratioPoint) * x1 + ratioPoint * x2;
                            double y2Point = (1.0 - ratioPoint) * y1 + ratioPoint * y2;
                            perpen = this.getPerpendicular(x2, y2, x2Root, y2Root, sy);
                            double x1Prim = perpen[0];
                            double y1Prim = perpen[1];
                            double x2Prim = perpen[2];
                            double y2Prim = perpen[3];
                            FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(x1Prim), " ", FileSinkSVG.d(y1Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" A ", FileSinkSVG.d(sx / 4.0), " ", FileSinkSVG.d(sy / 4.0), " 0 1 0 ", FileSinkSVG.d(x2Prim), " ", FileSinkSVG.d(y2Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" ", FileSinkSVG.d(sx / 4.0), " ", FileSinkSVG.d(sy / 4.0), " 0 1 0 ", FileSinkSVG.d(x1Prim), " ", FileSinkSVG.d(y1Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" Z"});
                            break;
                        }
                        case DIAMOND: {
                            double ratioPoint = 1.0 - nodeSize / distance;
                            double ratioLine = 1.0 - (sx / 2.0 + nodeSize) / distance;
                            double x2Root = (1.0 - ratioLine) * x1 + ratioLine * x2;
                            double y2Root = (1.0 - ratioLine) * y1 + ratioLine * y2;
                            double x2Point = (1.0 - ratioPoint) * x1 + ratioPoint * x2;
                            double y2Point = (1.0 - ratioPoint) * y1 + ratioPoint * y2;
                            System.out.println(String.valueOf(nodeSize) + " " + sx);
                            double ratioEnd = 1.0 - (sx + nodeSize) / distance;
                            double x2End = (1.0 - ratioEnd) * x1 + ratioEnd * x2;
                            double y2End = (1.0 - ratioEnd) * y1 + ratioEnd * y2;
                            perpen = this.getPerpendicular(x2, y2, x2Root, y2Root, sy);
                            double x1Prim = perpen[0];
                            double y1Prim = perpen[1];
                            double x2Prim = perpen[2];
                            double y2Prim = perpen[3];
                            FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(x2Point), " ", FileSinkSVG.d(y2Point)});
                            FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x1Prim), " ", FileSinkSVG.d(y1Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2End), " ", FileSinkSVG.d(y2End)});
                            FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2Prim), " ", FileSinkSVG.d(y2Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" Z"});
                            break;
                        }
                        default: {
                            double ratioPoint = 1.0 - nodeSize / distance;
                            double ratioLine = 1.0 - (sx + nodeSize) / distance;
                            double x2Root = (1.0 - ratioLine) * x1 + ratioLine * x2;
                            double y2Root = (1.0 - ratioLine) * y1 + ratioLine * y2;
                            double x2Point = (1.0 - ratioPoint) * x1 + ratioPoint * x2;
                            double y2Point = (1.0 - ratioPoint) * y1 + ratioPoint * y2;
                            perpen = this.getPerpendicular(x2, y2, x2Root, y2Root, sy);
                            double x1Prim = perpen[0];
                            double y1Prim = perpen[1];
                            double x2Prim = perpen[2];
                            double y2Prim = perpen[3];
                            if (style.group.getShape().equals((Object)StyleConstants.Shape.CUBIC_CURVE)) {
                                double rotation = 25.0;
                                System.out.println(y2Point - y2);
                                if (y2Point - y2 <= 1.0) {
                                    rotation = -rotation;
                                }
                                Vector2 v = SVGContext.rotatePoint(x2, y2, rotation, x2Point, y2Point);
                                x2Point = v.x();
                                y2Point = v.y();
                                v = SVGContext.rotatePoint(x2, y2, rotation, x1Prim, y1Prim);
                                x1Prim = v.x();
                                y1Prim = v.y();
                                v = SVGContext.rotatePoint(x2, y2, rotation, x2Prim, y2Prim);
                                x2Prim = v.x();
                                y2Prim = v.y();
                            }
                            FileSinkSVG.concat(buffer, new Object[]{" M ", FileSinkSVG.d(x1Prim), " ", FileSinkSVG.d(y1Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2Prim), " ", FileSinkSVG.d(y2Prim)});
                            FileSinkSVG.concat(buffer, new Object[]{" L ", FileSinkSVG.d(x2Point), " ", FileSinkSVG.d(y2Point)});
                            FileSinkSVG.concat(buffer, new Object[]{" Z"});
                            System.out.println("Arrow = (" + x1Prim + ", " + y1Prim + ") (" + x1Prim + ", " + y2Prim + ") (" + x2Point + ", " + y2Point + ")");
                        }
                    }
                }
            }
            return buffer.toString();
        }

        public static Vector2 rotatePoint(double cx, double cy, double angle, double px, double py) {
            double ynew;
            double xnew;
            double absangl = Math.abs(angle);
            double s = Math.sin(Math.toRadians(absangl));
            double c = Math.cos(Math.toRadians(absangl));
            px -= cx;
            py -= cy;
            if (angle > 0.0) {
                xnew = px * c - py * s;
                ynew = px * s + py * c;
            } else {
                xnew = px * c + py * s;
                ynew = -px * s + py * c;
            }
            px = xnew + cx;
            py = ynew + cy;
            return new Vector2(px, py);
        }

        public double[] getPerpendicular(double x1, double y1, double x2, double y2, double size) {
            double y2Prim;
            double x2Prim;
            double y1Prim;
            double x1Prim;
            double slope = (y2 - y1) / (x2 - x1);
            if (Double.isInfinite(slope)) {
                x1Prim = x2 - size / 2.0;
                y1Prim = y2;
                x2Prim = x2 + size / 2.0;
                y2Prim = y2;
            } else if (slope == 0.0) {
                x1Prim = x2;
                y1Prim = y2 - size / 2.0;
                x2Prim = x2;
                y2Prim = y2 + size / 2.0;
            } else {
                double slopePerpen = -1.0 / slope;
                double deltaX = 1.0 / Math.sqrt(slopePerpen * slopePerpen + 1.0);
                double deltaY = slopePerpen / Math.sqrt(slopePerpen * slopePerpen + 1.0);
                x1Prim = x2 - size / 2.0 * deltaX;
                y1Prim = y2 - size / 2.0 * deltaY;
                x2Prim = x2 + size / 2.0 * deltaX;
                y2Prim = y2 + size / 2.0 * deltaY;
            }
            return new double[]{x1Prim, y1Prim, x2Prim, y2Prim};
        }

        public double getValue(Value v, boolean horizontal) {
            return this.getValue(v.value, v.units, horizontal);
        }

        public double getValue(double d, StyleConstants.Units units, boolean horizontal) {
            switch (units) {
                case PX: {
                    return d;
                }
                case GU: {
                    return d;
                }
                case PERCENTS: {
                    if (horizontal) {
                        return (this.viewBox.x2 - this.viewBox.x1) * d / 100.0;
                    }
                    return (this.viewBox.y2 - this.viewBox.y1) * d / 100.0;
                }
            }
            return d;
        }
    }

    static class SVGStyle {
        static int gradientId = 0;
        String style;
        StyleGroup group;
        boolean gradient;
        boolean dynfill;

        public SVGStyle(StyleGroup group) throws XMLStreamException {
            this.group = group;
            this.gradient = false;
            this.dynfill = false;
            switch (group.getType()) {
                case EDGE: {
                    this.buildEdgeStyle();
                    break;
                }
                case NODE: {
                    this.buildNodeStyle();
                    break;
                }
                case GRAPH: {
                    this.buildGraphStyle();
                    break;
                }
            }
        }

        void buildNodeStyle() {
            StringBuilder styleSB = new StringBuilder();
            switch (this.group.getFillMode()) {
                case GRADIENT_RADIAL: 
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    FileSinkSVG.concat(styleSB, new Object[]{"fill:url(#%gradient-id%);"});
                    this.gradient = true;
                    break;
                }
                case PLAIN: {
                    FileSinkSVG.concat(styleSB, new Object[]{"fill:", FileSinkSVG.toHexColor(this.group.getFillColor(0)), ";"});
                    FileSinkSVG.concat(styleSB, new Object[]{"fill-opacity:", FileSinkSVG.d((double)this.group.getFillColor(0).getAlpha() / 255.0), ";"});
                    break;
                }
                case DYN_PLAIN: {
                    this.dynfill = true;
                    FileSinkSVG.concat(styleSB, new Object[]{"fill:%fill-color%;"});
                    FileSinkSVG.concat(styleSB, new Object[]{"fill-opacity:%fill-opacity%;"});
                    break;
                }
            }
            FileSinkSVG.concat(styleSB, new Object[]{"fill-rule:nonzero;"});
            if (this.group.getStrokeMode() != StyleConstants.StrokeMode.NONE) {
                FileSinkSVG.concat(styleSB, new Object[]{"stroke:", FileSinkSVG.toHexColor(this.group.getStrokeColor(0)), ";"});
                FileSinkSVG.concat(styleSB, new Object[]{"stroke-width:", FileSinkSVG.getSize(this.group.getStrokeWidth()), ";"});
            }
            this.style = styleSB.toString();
        }

        void buildGraphStyle() {
            this.buildNodeStyle();
        }

        void buildEdgeStyle() {
            StringBuilder styleSB = new StringBuilder();
            switch (this.group.getFillMode()) {
                case GRADIENT_RADIAL: 
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    FileSinkSVG.concat(styleSB, new Object[]{"stroke:url(#%gradient-id%);"});
                    this.gradient = true;
                    break;
                }
                case PLAIN: {
                    FileSinkSVG.concat(styleSB, new Object[]{"fill:", FileSinkSVG.toHexColor(this.group.getFillColor(0)), ";"});
                    FileSinkSVG.concat(styleSB, new Object[]{"fill-opacity:", FileSinkSVG.d((double)this.group.getFillColor(0).getAlpha() / 255.0), ";"});
                    FileSinkSVG.concat(styleSB, new Object[]{"stroke:", FileSinkSVG.toHexColor(this.group.getFillColor(0)), ";"});
                    break;
                }
                case DYN_PLAIN: {
                    FileSinkSVG.concat(styleSB, new Object[]{"stroke:", FileSinkSVG.toHexColor(this.group.getFillColor(0)), ";"});
                    break;
                }
            }
            if (!this.group.getShape().equals((Object)StyleConstants.Shape.ANGLE) && !this.group.getShape().equals((Object)StyleConstants.Shape.BLOB)) {
                FileSinkSVG.concat(styleSB, new Object[]{"stroke-width:", FileSinkSVG.getSize(this.group.getSize(), 0), ";"});
            }
            this.style = styleSB.toString();
        }

        public void writeDef(XMLWriter out) throws XMLStreamException {
            if (this.gradient) {
                String gid = String.format("gradient%x", gradientId++);
                String type = "linearGradient";
                String x1 = null;
                String x2 = null;
                String y1 = null;
                String y2 = null;
                switch (this.group.getFillMode()) {
                    case GRADIENT_RADIAL: {
                        type = "radialGradient";
                        break;
                    }
                    case GRADIENT_HORIZONTAL: {
                        x1 = "0%";
                        y1 = "50%";
                        x2 = "100%";
                        y2 = "50%";
                        break;
                    }
                    case GRADIENT_VERTICAL: {
                        x1 = "50%";
                        y1 = "0%";
                        x2 = "50%";
                        y2 = "100%";
                        break;
                    }
                    case GRADIENT_DIAGONAL1: {
                        x1 = "0%";
                        y1 = "0%";
                        x2 = "100%";
                        y2 = "100%";
                        break;
                    }
                    case GRADIENT_DIAGONAL2: {
                        x1 = "100%";
                        y1 = "100%";
                        x2 = "0%";
                        y2 = "0%";
                        break;
                    }
                }
                out.open(type);
                out.attribute("id", gid);
                out.attribute("gradientUnits", "objectBoundingBox");
                if (type.equals("linearGradient")) {
                    out.attribute("x1", x1);
                    out.attribute("y1", y1);
                    out.attribute("x2", x2);
                    out.attribute("y2", y2);
                }
                int i = 0;
                while (i < this.group.getFillColorCount()) {
                    out.open("stop");
                    out.attribute("stop-color", FileSinkSVG.toHexColor(this.group.getFillColor(i)));
                    out.attribute("stop-opacity", FileSinkSVG.d((double)this.group.getFillColor(i).getAlpha() / 255.0));
                    out.attribute("offset", Double.toString((double)i / (double)(this.group.getFillColorCount() - 1)));
                    out.close();
                    ++i;
                }
                out.close();
                this.style = this.style.replace("%gradient-id%", gid);
            }
        }

        public String getElementStyle(Element e) {
            String st = this.style;
            if (this.dynfill && this.group.getFillColorCount() > 1) {
                double d = e.hasNumber("ui.color") ? e.getNumber("ui.color") : 0.0;
                Colors colors = this.group.getFillColors();
                int s = Math.min((int)(d * (double)this.group.getFillColorCount()), colors.size() - 2);
                double a = (double)s / (double)(colors.size() - 1);
                double b = (double)(s + 1) / (double)(colors.size() - 1);
                d = (d - a) / (b - a);
                Color c1 = (Color)colors.get(s);
                Color c2 = (Color)colors.get(s + 1);
                String color = String.format("#%02x%02x%02x", (int)((double)c1.getRed() + d * (double)(c2.getRed() - c1.getRed())), (int)((double)c1.getGreen() + d * (double)(c2.getGreen() - c1.getGreen())), (int)((double)c1.getBlue() + d * (double)(c2.getBlue() - c1.getBlue())));
                String opacity = Double.toString(((double)c1.getAlpha() + d * (double)(c2.getAlpha() - c1.getAlpha())) / 255.0);
                st = st.replace("%fill-color%", color);
                st = st.replace("%fill-opacity%", opacity);
            }
            return st;
        }
    }

    static class ViewBox {
        double x1;
        double y1;
        double x2;
        double y2;
        double x3;
        double y3;
        double x4;
        double y4;
        double[] padding = new double[]{0.0, 0.0};

        ViewBox(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        void compute(Graph g, StyleGroup style) {
            this.y3 = Double.MAX_VALUE;
            this.x3 = Double.MAX_VALUE;
            this.y4 = Double.MIN_VALUE;
            this.x4 = Double.MIN_VALUE;
            g.nodes().forEach(n -> {
                this.x3 = Math.min(this.x3, FileSinkSVG.getX(n));
                this.y3 = Math.min(this.y3, FileSinkSVG.getY(n));
                this.x4 = Math.max(this.x4, FileSinkSVG.getX(n));
                this.y4 = Math.max(this.y4, FileSinkSVG.getY(n));
            });
            Values v = style.getPadding();
            if (v.getValueCount() > 0) {
                this.padding[0] = v.get(0);
                this.padding[1] = v.getValueCount() > 1 ? v.get(1) : v.get(0);
            }
        }

        double convertX(double x) {
            return (this.x2 - this.x1 - 2.0 * this.padding[0]) * (x - this.x3) / (this.x4 - this.x3) + this.x1 + this.padding[0];
        }

        double convertX(Node n) {
            return this.convertX(FileSinkSVG.getX(n));
        }

        double convertY(double y) {
            return (this.y2 - this.y1 - 2.0 * this.padding[1]) * (y - this.y3) / (this.y4 - this.y3) + this.y1 + this.padding[1];
        }

        double convertY(Node n) {
            return this.convertY(FileSinkSVG.getY(n));
        }
    }

    static class XMLWriter {
        XMLStreamWriter out;
        int depth;
        boolean closed;

        XMLWriter() {
        }

        void start(Writer w) throws XMLStreamException, FactoryConfigurationError, IOException {
            if (this.out != null) {
                this.end();
            }
            this.out = XMLOutputFactory.newInstance().createXMLStreamWriter(w);
            this.out.writeStartDocument();
        }

        void end() throws XMLStreamException {
            this.out.writeEndDocument();
            this.out.flush();
            this.out.close();
            this.out = null;
        }

        void open(String name) throws XMLStreamException {
            this.out.writeCharacters("\n");
            int i = 0;
            while (i < this.depth) {
                this.out.writeCharacters("  ");
                ++i;
            }
            this.out.writeStartElement(name);
            ++this.depth;
        }

        void close() throws XMLStreamException {
            this.out.writeEndElement();
            --this.depth;
        }

        void attribute(String key, String value) throws XMLStreamException {
            this.out.writeAttribute(key, value);
        }

        void characters(String data) throws XMLStreamException {
            this.out.writeCharacters(data);
        }
    }
}

