/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.EventLabel;
import ancestris.modules.editors.standard.tools.NoteWrapper;
import ancestris.modules.editors.standard.tools.SourceWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import ancestris.modules.viewers.media.MediaWrapper;
import ancestris.util.GedcomUtilities;
import genj.edit.beans.DateBean;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySharedNote;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.io.InputSource;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EventWrapper {
    public static String AGE_FORMAT = "#.###";
    public boolean isGeneral = true;
    private Entity hostingEntity = null;
    public Property eventProperty = null;
    public String newTag = null;
    public Entity newParent = null;
    private double ageAsDouble;
    public EventLabel eventLabel = null;
    public String eventYear = "-";
    public String eventAge = "-";
    public String label = "";
    public String attribute = "";
    public String type = "";
    public boolean yFlag = false;
    public boolean hasAttribute = false;
    private Property dummyProperty = null;
    public PropertyDate date = null;
    public String time = "";
    public PropertyPlace place = null;
    public String dayOfWeek = "";
    public String age = "";
    public List<MediaWrapper> eventMediaSet = null;
    public List<MediaWrapper> eventMediaRemovedSet = null;
    public int eventMediaIndex = 0;
    public List<NoteWrapper> eventNoteSet = null;
    public List<NoteWrapper> eventNoteRemovedSet = null;
    public int eventNoteIndex = 0;
    public List<SourceWrapper> eventSourceSet = null;
    public List<SourceWrapper> eventSourceRemovedSet = null;
    public int eventSourceIndex = 0;
    public boolean isNonEvent = false;

    public EventWrapper(Property property, Indi indi, Fam fam) {
        this.eventProperty = property;
        this.hostingEntity = fam == null ? property.getEntity() : fam;
        this.createDummyProperty(indi.getGedcom());
        this.eventLabel = new EventLabel(property);
        this.eventLabel.setIcon((Icon)property.getImage());
        if (!property.equals(indi)) {
            this.isGeneral = false;
            this.attribute = this.getAttribute();
            this.type = this.getType();
            this.yFlag = this.calcYFlag();
            if (this.eventProperty.getTag().equals("EVEN")) {
                this.eventLabel.setTableLabel(this.type);
            }
            if (this.eventProperty.getTag().equals("NO")) {
                this.isNonEvent = true;
            }
            this.date = (PropertyDate)this.dummyProperty.addProperty("DATE", "");
            PropertyDate tmpDate = (PropertyDate)this.eventProperty.getProperty("DATE");
            if (tmpDate != null) {
                this.date.setValue(tmpDate.getFormat(), tmpDate.getStart(), tmpDate.getEnd(), tmpDate.getPhrase());
            }
            try {
                this.dayOfWeek = this.date != null && this.date.getStart() != null ? this.date.getStart().getDayOfWeek(true) : "";
            }
            catch (GedcomException ex) {
                this.dayOfWeek = "";
            }
            this.eventYear = "-";
            if (tmpDate != null && !tmpDate.getValue().isEmpty() && tmpDate.isValid() && tmpDate.getStart() != null) {
                try {
                    PointInTime pit = tmpDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
                    String dispValue = pit.toString();
                    if (!"?".equals(dispValue)) {
                        this.eventYear = pit.getYear() + "." + (pit.getMonth() + 1) + "." + (pit.getDay() + 1);
                    }
                }
                catch (Exception pit) {
                    // empty catch block
                }
            }
            this.calcAge(indi, property);
            this.time = this.getTimeOfEvent();
            this.place = (PropertyPlace)this.dummyProperty.addProperty("PLAC", "");
            PropertyPlace tmpPlace = (PropertyPlace)property.getProperty("PLAC");
            if (tmpPlace != null) {
                this.place.setValue(tmpPlace.getValue());
                this.setCoordinates(tmpPlace, this.place);
            }
        }
        String string = this.label = this.isGeneral ? this.eventLabel.getLongLabel() : this.eventLabel.getShortLabel();
        if (this.eventMediaSet != null) {
            this.eventMediaSet.clear();
            this.eventMediaSet = null;
        }
        if (this.eventMediaRemovedSet != null) {
            this.eventMediaRemovedSet.clear();
            this.eventMediaRemovedSet = null;
        }
        this.eventMediaSet = this.getEventMedia(this.eventProperty);
        this.eventMediaRemovedSet = new ArrayList<MediaWrapper>();
        this.eventMediaIndex = 0;
        if (this.eventNoteSet != null) {
            this.eventNoteSet.clear();
            this.eventNoteSet = null;
        }
        if (this.eventNoteRemovedSet != null) {
            this.eventNoteRemovedSet.clear();
            this.eventNoteRemovedSet = null;
        }
        this.eventNoteSet = this.getEventNotes(this.eventProperty);
        this.eventNoteRemovedSet = new ArrayList<NoteWrapper>();
        this.eventNoteIndex = 0;
        if (this.eventSourceSet != null) {
            this.eventSourceSet.clear();
            this.eventSourceSet = null;
        }
        if (this.eventSourceRemovedSet != null) {
            this.eventSourceRemovedSet.clear();
            this.eventSourceRemovedSet = null;
        }
        this.eventSourceSet = this.getEventSources(this.eventProperty);
        this.eventSourceRemovedSet = new ArrayList<SourceWrapper>();
        this.eventSourceIndex = 0;
    }

    public EventWrapper(Entity entity) {
        this.hostingEntity = entity;
        this.eventProperty = entity;
        this.eventLabel = new EventLabel((Property)entity);
        this.eventLabel.setIcon((Icon)entity.getImage());
        this.label = this.eventLabel.getShortLabel();
    }

    public void setTime(String text) {
        this.time = text;
    }

    public void setPlace(String text) {
        this.place.setValue(text);
        this.place.setCoordinates();
    }

    public void setDate(DateBean dateBean) {
        dateBean.setValueToProperty(this.date);
    }

    public void calcAge(Indi indi, Property property) {
        PointInTime end;
        PointInTime endTmp;
        PointInTime start;
        this.ageAsDouble = 0.0;
        this.age = "";
        this.eventAge = "-";
        Property pFoundAge = null;
        if (property.getEntity() instanceof Fam) {
            Fam fam = (Fam)property.getEntity();
            String spouseTag = indi.equals(fam.getHusband()) ? "HUSB" : "WIFE";
            Property spouse = property.getProperty(spouseTag, false);
            if (spouse != null) {
                pFoundAge = spouse.getProperty("AGE");
            }
        } else {
            pFoundAge = property.getProperty("AGE");
        }
        String foundAge = null;
        String foundAgeLabel = NbBundle.getMessage(this.getClass(), (String)"Found_Age");
        if (pFoundAge != null) {
            PropertyAge pAge = (PropertyAge)pFoundAge;
            this.age = foundAge = pAge.getDisplayValue();
            this.eventAge = this.calcEventAge(pAge.getAge(), false);
        }
        if ((start = indi.getStartPITOfAge()) == null) {
            this.age = this.age.isEmpty() ? "" : "(" + PropertyAge.getLabelForAge().toLowerCase() + " " + foundAgeLabel + ": " + this.age + ")";
            return;
        }
        PointInTime startTmp = new PointInTime(start.getDay(), start.getMonth(), start.getYear(), start.getCalendar());
        if (startTmp.getMonth() == Integer.MAX_VALUE) {
            startTmp.set(startTmp.getDay(), 0, startTmp.getYear());
        }
        if (startTmp.getDay() == Integer.MAX_VALUE) {
            startTmp.set(0, startTmp.getMonth(), startTmp.getYear());
        }
        if ((endTmp = new PointInTime((end = this.date != null ? this.date.getStart() : null).getDay(), end.getMonth(), end.getYear(), end.getCalendar())).getMonth() == Integer.MAX_VALUE) {
            endTmp.set(endTmp.getDay(), 0, endTmp.getYear());
        }
        if (endTmp.getDay() == Integer.MAX_VALUE) {
            endTmp.set(0, endTmp.getMonth(), endTmp.getYear());
        }
        Delta delta = Delta.get((PointInTime)startTmp, (PointInTime)endTmp);
        if (this.date == null || delta == null || delta.isZero()) {
            this.age = this.age.isEmpty() ? "" : "(" + PropertyAge.getLabelForAge().toLowerCase() + " " + foundAgeLabel + ": " + this.age + ")";
            return;
        }
        boolean direction = start.compareTo(end) > 0;
        this.eventAge = this.calcEventAge(delta, direction);
        String calculatedAge = (direction ? "-" : "") + delta.toString();
        this.age = calculatedAge.equals(this.age) || this.age.isEmpty() ? "(" + PropertyAge.getLabelForAge().toLowerCase() + ": " + calculatedAge + ")" : "(" + PropertyAge.getLabelForAge().toLowerCase() + ": " + calculatedAge + "; " + foundAgeLabel + ": " + this.age + ")";
    }

    private String calcEventAge(Delta delta, boolean direction) {
        double d = delta.getYears();
        d += (double)delta.getMonths() / 12.0;
        d += (double)delta.getDays() / 365.0;
        if (direction) {
            d *= -1.0;
        }
        this.ageAsDouble = d;
        DecimalFormat df = new DecimalFormat(AGE_FORMAT);
        df.setRoundingMode(RoundingMode.FLOOR);
        return df.format(d);
    }

    public boolean isAgeNegative() {
        return this.ageAsDouble < 0.0;
    }

    public Fam getFamilyEntity() {
        return this.hostingEntity != null && this.hostingEntity instanceof Fam ? (Fam)this.hostingEntity : null;
    }

    private List<MediaWrapper> getEventMedia(Property event) {
        Property[] mediaProps;
        ArrayList<MediaWrapper> ret = new ArrayList<MediaWrapper>();
        if (event == null) {
            return ret;
        }
        for (Property prop : mediaProps = event.getProperties("OBJE", true)) {
            ret.add(new MediaWrapper(prop));
        }
        return ret;
    }

    public boolean addMedia(String mediaTitle) {
        MediaWrapper media = new MediaWrapper(mediaTitle);
        this.eventMediaSet.add(media);
        this.eventMediaIndex = this.eventMediaSet.size() - 1;
        return true;
    }

    public boolean setMedia(String mediaTitle) {
        this.eventMediaSet.get(this.eventMediaIndex).setTitle(mediaTitle);
        return true;
    }

    private List<NoteWrapper> getEventNotes(Property event) {
        ArrayList<NoteWrapper> ret = new ArrayList<NoteWrapper>();
        if (event == null) {
            return ret;
        }
        ArrayList<Property> noteProps = new ArrayList<Property>();
        noteProps.addAll(Arrays.asList(event.getProperties("NOTE")));
        noteProps.addAll(Arrays.asList(event.getProperties("SNOTE")));
        for (Property prop : noteProps) {
            NoteWrapper note;
            if (prop == null || !prop.isValid() || prop.getDisplayValue().trim().isEmpty()) continue;
            if (prop instanceof PropertyNote) {
                note = new NoteWrapper(((PropertyNote)prop).getTargetEntity().orElse(null));
                if (note == null) continue;
                note.setHostingProperty(prop);
                ret.add(note);
                continue;
            }
            if (prop instanceof PropertySharedNote) {
                note = new NoteWrapper(((PropertySharedNote)prop).getTargetEntity().orElse(null));
                if (note == null) continue;
                note.setHostingProperty(prop);
                ret.add(note);
                continue;
            }
            note = new NoteWrapper(prop);
            ret.add(note);
        }
        return ret;
    }

    public boolean addNote(AbstractNote entity, String noteText) {
        NoteWrapper note = new NoteWrapper(entity);
        note.setText(noteText);
        this.eventNoteSet.add(note);
        this.eventNoteIndex = this.eventNoteSet.size() - 1;
        return true;
    }

    public boolean addNote(String noteText) {
        NoteWrapper note = new NoteWrapper(noteText);
        this.eventNoteSet.add(note);
        this.eventNoteIndex = this.eventNoteSet.size() - 1;
        return true;
    }

    public boolean setNote(AbstractNote entity, String noteText, int index) {
        this.eventNoteSet.get(index).setTargetEntity(entity);
        this.eventNoteSet.get(index).setText(noteText);
        this.eventNoteIndex = index;
        return true;
    }

    public boolean setNote(String noteText, int index) {
        this.eventNoteSet.get(index).setText(noteText);
        this.eventNoteIndex = index;
        return true;
    }

    public boolean setNote(String noteText) {
        this.eventNoteSet.get(this.eventNoteIndex).setText(noteText);
        return true;
    }

    private List<SourceWrapper> getEventSources(Property event) {
        Property[] sourceProps;
        ArrayList<SourceWrapper> ret = new ArrayList<SourceWrapper>();
        if (event == null) {
            return ret;
        }
        for (Property prop : sourceProps = event.getProperties("SOUR", true)) {
            if (prop == null || prop.getDisplayValue().trim().isEmpty()) continue;
            SourceWrapper source = new SourceWrapper(prop);
            ret.add(source);
        }
        return ret;
    }

    public boolean addSource(Source entity) {
        SourceWrapper source = new SourceWrapper((Property)entity);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSource(String title, String text, String mediaTitle) {
        SourceWrapper source = new SourceWrapper(title);
        source.setText(text);
        source.setMediaTitle(mediaTitle);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSourceMedia(MediaWrapper media) {
        SourceWrapper source = new SourceWrapper(media);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSourceFile(InputSource file) {
        SourceWrapper source = new SourceWrapper(file);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSourceRepository(Repository repo) {
        SourceWrapper source = new SourceWrapper(repo);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean setSource(Source entity, int index) {
        this.eventSourceSet.get(index).setSourceFromEntity(entity);
        this.eventSourceIndex = index;
        return true;
    }

    public boolean setSource(String title, String text, String mediaTitle) {
        SourceWrapper source = this.eventSourceSet.get(this.eventSourceIndex);
        source.setTitle(title);
        source.setText(text);
        if (mediaTitle != null) {
            source.setMediaTitle(mediaTitle);
        }
        return true;
    }

    public boolean setSourceMedia(MediaWrapper media, boolean addMedia) {
        this.eventSourceSet.get(this.eventSourceIndex).setMedia(media, addMedia);
        return true;
    }

    public boolean setSourceFile(InputSource file, boolean addMedia) {
        this.eventSourceSet.get(this.eventSourceIndex).setMediaFile(file, addMedia);
        return true;
    }

    public boolean setSourceRepository(Repository repo) {
        this.eventSourceSet.get(this.eventSourceIndex).setRepo(repo);
        return true;
    }

    public SourceWrapper getEventSource() {
        if (this.eventSourceSet != null && !this.eventSourceSet.isEmpty() && this.eventSourceIndex >= 0 && this.eventSourceIndex < this.eventSourceSet.size()) {
            return this.eventSourceSet.get(this.eventSourceIndex);
        }
        return null;
    }

    public void update(Indi indi) {
        boolean modified = false;
        if (this.eventProperty.getGedcom() == null || this.eventProperty.getGedcom().getOrigin() == null) {
            if (this.hostingEntity instanceof Indi) {
                this.eventProperty = indi.addProperty(this.eventProperty.getTag(), "");
                modified = true;
            } else if (this.hostingEntity instanceof Fam) {
                Fam fam = (Fam)this.hostingEntity;
                if ((fam.getGedcom() == null || fam.getGedcom().getOrigin() == null) && (fam = this.createFamForIndi(indi)) == null) {
                    return;
                }
                this.eventProperty = fam.addProperty(this.eventProperty.getTag(), "");
                modified = true;
            }
        }
        if (!this.isGeneral) {
            Property tmpTime;
            String val;
            if (this.hasAttribute) {
                this.attribute = this.attribute.trim();
                Utils.setDistinctValue(this.eventProperty, this.attribute);
            }
            this.type = this.type.trim();
            Property typeProp = this.eventProperty.getProperty("TYPE");
            if (typeProp == null) {
                if (!this.type.isEmpty()) {
                    this.eventProperty.addProperty("TYPE", this.type);
                }
            } else {
                Utils.setDistinctValue(typeProp, this.type);
            }
            boolean nodate = false;
            PropertyDate tmpDate = (PropertyDate)this.eventProperty.getProperty("DATE", false);
            if (tmpDate == null) {
                val = this.date.getValue().trim();
                phrase = this.date.getPhrase();
                if (!val.isEmpty() || !phrase.isEmpty()) {
                    tmpDate = (PropertyDate)this.eventProperty.addProperty("DATE", "");
                    tmpDate.setValue(this.date.getFormat(), this.date.getStart(), this.date.getEnd(), this.date.getPhrase());
                    modified = true;
                } else {
                    nodate = true;
                }
            } else {
                val = this.date.getValue().trim();
                phrase = this.date.getPhrase();
                if (!val.isEmpty() || !phrase.isEmpty()) {
                    if (!val.equals(tmpDate.getValue().trim()) || !phrase.equals(tmpDate.getPhrase())) {
                        tmpDate.setValue(this.date.getFormat(), this.date.getStart(), this.date.getEnd(), this.date.getPhrase());
                        modified = true;
                    }
                } else {
                    if (this.time.trim().isEmpty()) {
                        this.eventProperty.delProperty((Property)tmpDate);
                        tmpDate = null;
                    } else {
                        tmpDate.setValue("");
                    }
                    nodate = true;
                    modified = true;
                }
            }
            val = this.time.trim();
            Property property = tmpTime = tmpDate != null ? tmpDate.getProperty(this.getTimeTag(), false) : null;
            if (tmpTime == null) {
                if (!val.isEmpty()) {
                    Property oldpTime = this.eventProperty.getProperty("_TIME", false);
                    if (oldpTime != null) {
                        if (!val.equals(oldpTime.getValue())) {
                            oldpTime.getParent().delProperty(oldpTime);
                            if (tmpDate == null) {
                                tmpDate = (PropertyDate)this.eventProperty.addProperty("DATE", "");
                            }
                            tmpDate.addProperty(this.getTimeTag(), val);
                        }
                    } else {
                        if (tmpDate == null) {
                            tmpDate = (PropertyDate)this.eventProperty.addProperty("DATE", "");
                        }
                        tmpDate.addProperty(this.getTimeTag(), val);
                    }
                }
            } else if (!val.isEmpty()) {
                Utils.setDistinctValue(tmpTime, val);
                nodate = false;
            } else {
                tmpDate.delProperty(tmpTime);
                if (tmpDate.getValue().isEmpty() && tmpDate.getPhrase().trim().isEmpty()) {
                    this.eventProperty.delProperty((Property)tmpDate);
                }
                nodate = true;
            }
            boolean noplace = false;
            PropertyPlace tmpPlace = (PropertyPlace)this.eventProperty.getProperty("PLAC", false);
            if (tmpPlace == null) {
                val = this.place.getValue().trim();
                if (!val.isEmpty()) {
                    tmpPlace = (PropertyPlace)this.eventProperty.addProperty("PLAC", this.place.getValue());
                    this.setCoordinates(this.place, tmpPlace);
                    modified = true;
                } else {
                    noplace = true;
                }
            } else {
                val = this.place.getValue().trim();
                if (!val.isEmpty()) {
                    Utils.setDistinctValue((Property)tmpPlace, this.place.getValue());
                    this.setCoordinates(this.place, tmpPlace);
                } else {
                    this.eventProperty.delProperty((Property)tmpPlace);
                    noplace = true;
                    modified = true;
                }
            }
            if (modified && GedcomConstants.TAG_YES_EVENTS.contains(this.eventProperty.getTag())) {
                Utils.setDistinctValue(this.eventProperty, nodate && noplace ? "Y" : "");
            }
        }
        for (MediaWrapper media : this.eventMediaSet) {
            media.update(this.eventProperty);
        }
        if (this.eventMediaSet.size() > 1) {
            int index = 0;
            for (MediaWrapper media : this.eventMediaSet) {
                media.reposition(index);
                ++index;
            }
        }
        for (MediaWrapper media : this.eventMediaRemovedSet) {
            media.remove();
        }
        for (NoteWrapper note : this.eventNoteSet) {
            note.update(this.eventProperty);
        }
        for (NoteWrapper note : this.eventNoteRemovedSet) {
            note.remove();
        }
        for (SourceWrapper source : this.eventSourceSet) {
            source.update(this.eventProperty);
        }
        if (this.eventSourceSet.size() > 1) {
            int index = 0;
            for (SourceWrapper source : this.eventSourceSet) {
                source.reposition(index);
                ++index;
            }
        }
        for (SourceWrapper source : this.eventSourceRemovedSet) {
            source.remove();
        }
        if (this.newTag != null && !this.newTag.isBlank() && this.newParent != null) {
            try {
                Property parent = this.eventProperty.getParent();
                int pos = parent.getPropertyPosition(this.eventProperty);
                if (this.newParent != parent) {
                    pos = this.newParent.getNoOfProperties();
                }
                Property destProperty = this.newParent.addProperty(this.newTag, this.eventProperty.getValue(), pos);
                GedcomUtilities.copyPropertiesRecursively((Property)this.eventProperty, (Property)destProperty, (boolean)false);
                parent.delProperty(this.eventProperty);
                this.eventProperty = destProperty;
                this.newTag = null;
                this.newParent = null;
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void remove(Indi indi) {
        if (this.hostingEntity == null) {
            return;
        }
        this.hostingEntity.delProperty(this.eventProperty);
    }

    private Fam createFamForIndi(Indi indi) {
        Fam fam = null;
        Gedcom gedcom = indi.getGedcom();
        try {
            fam = (Fam)gedcom.createEntity("FAM");
            int sex = indi.getSex();
            if (sex == 0) {
                sex = 1;
            }
            if (sex == 1) {
                fam.setHusband(indi);
            } else {
                fam.setWife(indi);
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fam;
    }

    public String getEventKey() {
        return this.getEventKey(false);
    }

    public String getEventKey(boolean force) {
        Property property;
        Object ret = "";
        if (this.eventProperty == null) {
            return "-1";
        }
        ret = (String)ret + this.eventProperty.getTag() + "|";
        if (force && (property = this.eventProperty.getProperty("DATE")) instanceof PropertyDate) {
            PropertyDate tmpDate = (PropertyDate)property;
            ret = (String)ret + (tmpDate == null || tmpDate.getValue().isEmpty() ? "" : tmpDate.getValue());
            ret = (String)ret + this.getAttribute();
        } else {
            ret = (String)ret + (this.date == null || this.date.getValue().isEmpty() ? "" : this.date.getValue());
            ret = (String)ret + this.attribute;
        }
        return ret;
    }

    public String getTag() {
        return this.eventProperty.getTag();
    }

    public String getReferenceKey(String tag) {
        if ("EVEN".equals(tag) || "TYPE".equals(tag)) {
            tag = this.eventProperty.getTag() + "-" + (String)tag;
        }
        return tag;
    }

    private String getAttribute() {
        if (this.eventProperty.getGedcom() == null) {
            return "";
        }
        this.hasAttribute = ((Set)GedcomConstants.TAG_ATTR_EVENTS_MAP.get(this.eventProperty.getGedcom().getGrammar())).contains(this.eventProperty.getTag());
        return this.hasAttribute ? this.eventProperty.getDisplayValue().trim() : "";
    }

    public void setAttribute(String text) {
        this.attribute = text;
    }

    public String getTypeTag() {
        return "TYPE";
    }

    private String getType() {
        Property tmpType = this.eventProperty.getProperty("TYPE");
        return tmpType != null ? tmpType.getDisplayValue() : "";
    }

    public void setType(String text) {
        this.type = text;
    }

    private boolean calcYFlag() {
        boolean hasPDChild = this.eventProperty.getProperty("PLAC", true) != null || this.eventProperty.getProperty("DATE", true) != null;
        return GedcomConstants.TAG_YES_EVENTS.contains(this.eventProperty.getTag()) && !hasPDChild;
    }

    private String getTimeOfEvent() {
        Property parent;
        Property localTime = null;
        Property pDate = this.eventProperty.getProperty("DATE");
        if (pDate != null) {
            localTime = pDate.getProperty(this.getTimeTag());
        }
        if (localTime == null && pDate != null && (parent = pDate.getParent()) != null) {
            localTime = parent.getProperty(this.getTimeTag());
        }
        return localTime != null ? localTime.getDisplayValue() : "";
    }

    private void createDummyProperty(Gedcom gedcom) {
        Gedcom tmpGedcom = new Gedcom();
        tmpGedcom.setGrammar(gedcom.getGrammar());
        try {
            Indi indi = (Indi)tmpGedcom.createEntity("INDI");
            this.dummyProperty = indi.addProperty("BIRT", "");
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private void setCoordinates(PropertyPlace fromPlace, PropertyPlace toPlace) {
        PropertyLatitude pLatitude = fromPlace.getLatitude(true);
        PropertyLongitude pLongitude = fromPlace.getLongitude(true);
        if (this.isSame((Property)pLatitude, (Property)toPlace.getLatitude(true)) && this.isSame((Property)pLongitude, (Property)toPlace.getLongitude(true))) {
            return;
        }
        if (pLatitude != null && pLongitude != null) {
            String strLat = pLatitude.getValue();
            String strLong = pLongitude.getValue();
            if (toPlace.getLatitude(false) == null || toPlace.getLongitude(false) == null) {
                if (!strLat.isEmpty() || !strLong.isEmpty()) {
                    toPlace.setCoordinates(strLat, strLong);
                }
                return;
            }
            if (!toPlace.getLatitude(false).getValue().equals(strLat) || !toPlace.getLongitude(false).getValue().equals(strLong)) {
                toPlace.setCoordinates(strLat, strLong);
            }
        } else if (toPlace != null) {
            toPlace.setCoordinates();
        }
    }

    private String getTimeTag() {
        return this.eventProperty.isGrammar7() ? "TIME" : "_TIME";
    }

    private boolean isSame(Property fromProp, Property toProp) {
        if (fromProp == null && toProp == null) {
            return false;
        }
        if (fromProp == null && toProp != null) {
            return false;
        }
        if (fromProp != null && toProp == null) {
            return false;
        }
        return fromProp.compareTo(toProp) == 0;
    }
}

