/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.UserFunctionObject;

public class FunctionConstructor
extends ObjectConstructor {
    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Function")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (xmlTag.hasParam("f")) {
            if (!xmlTag.hasParam("var")) {
                throw new ConstructionException("Function invalid!");
            }
            try {
                String string = xmlTag.getValue("f");
                String string2 = xmlTag.getValue("var");
                UserFunctionObject userFunctionObject = new UserFunctionObject(construction);
                userFunctionObject.setDefaults();
                this.setName(xmlTag, userFunctionObject);
                this.set(xmlTree, userFunctionObject);
                construction.add(userFunctionObject);
                try {
                    if (xmlTag.hasParam("fixed")) {
                        userFunctionObject.setFixed(xmlTag.getValue("x"), xmlTag.getValue("y"));
                    } else {
                        double d2 = new Expression(xmlTag.getValue("x"), construction, userFunctionObject).getValue();
                        double d3 = new Expression(xmlTag.getValue("y"), construction, userFunctionObject).getValue();
                        userFunctionObject.move(d2, d3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (xmlTag.hasParam("filled")) {
                    userFunctionObject.setFilled(true);
                }
                userFunctionObject.setExpressions(string2, string);
                this.setConditionals(xmlTree, construction, userFunctionObject);
                userFunctionObject.updateText();
                return true;
            }
            catch (Exception exception) {
                throw new ConstructionException("Function invalid!");
            }
        }
        if (!(xmlTag.hasParam("min") || xmlTag.hasParam("max") || xmlTag.hasParam("d") || xmlTag.hasParam("var") || xmlTag.hasParam("x") || xmlTag.hasParam("y"))) {
            throw new ConstructionException("Function invalid!");
        }
        try {
            String string = xmlTag.getValue("x");
            String string3 = xmlTag.getValue("y");
            String string4 = xmlTag.getValue("var");
            String string5 = xmlTag.getValue("d");
            String string6 = xmlTag.getValue("min");
            String string7 = xmlTag.getValue("max");
            FunctionObject functionObject = new FunctionObject(construction);
            functionObject.setDefaults();
            FunctionConstructor.setType(xmlTag, functionObject);
            this.setName(xmlTag, functionObject);
            this.set(xmlTree, functionObject);
            construction.add(functionObject);
            if (xmlTag.hasParam("filled")) {
                functionObject.setFilled(true);
            }
            functionObject.setExpressions(string4, string, string3);
            functionObject.setRange(string6, string7, string5);
            functionObject.setSpecial(xmlTag.hasTrueParam("special"));
            this.setConditionals(xmlTree, construction, functionObject);
            if (xmlTag.hasParam("center")) {
                functionObject.setCenter(xmlTag.getValue("center"));
            }
            functionObject.updateText();
            return true;
        }
        catch (Exception exception) {
            throw new ConstructionException("Function invalid!");
        }
    }

    public static void setType(XmlTag xmlTag, FunctionObject functionObject) {
        if (xmlTag.hasParam("shape")) {
            String string = xmlTag.getValue("shape");
            if (string.equals("square")) {
                functionObject.setType(0);
            }
            if (string.equals("diamond")) {
                functionObject.setType(1);
            }
            if (string.equals("circle")) {
                functionObject.setType(2);
            }
            if (string.equals("dot")) {
                functionObject.setType(3);
            }
            if (string.equals("cross")) {
                functionObject.setType(4);
            }
            if (string.equals("dcross")) {
                functionObject.setType(5);
            }
        }
    }

    public String getTag() {
        return "Function";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 6) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        boolean bl = false;
        try {
            FunctionObject functionObject = new FunctionObject(construction);
            construction.add(functionObject);
            bl = true;
            if (!string.equals("")) {
                functionObject.setNameCheck(string);
            }
            functionObject.setRange(stringArray[0], stringArray[1], stringArray[2]);
            functionObject.setExpressions(stringArray[3], stringArray[4], stringArray[5]);
            functionObject.setDefaults();
        }
        catch (ConstructionException constructionException) {
            if (bl) {
                construction.back();
            }
            throw constructionException;
        }
        catch (Exception exception) {
            if (bl) {
                construction.back();
            }
            throw new ConstructionException("Function Invalid!");
        }
    }
}

