/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim;

import fr.ove.openmath.jome.ctrlview.bidim.DisplayableImpl;
import fr.ove.openmath.jome.ctrlview.bidim.GraphicContext;
import fr.ove.openmath.jome.ctrlview.bidim.images.ImageLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class BracketSymbol
extends DisplayableImpl {
    private Image topInit;
    private Image middleInit;
    private Image bottomInit;
    private Image top;
    private Image middle;
    private Image bottom;
    private int heightExtremities;
    ImageObserver observer;

    public BracketSymbol(boolean bl, int n, ImageObserver imageObserver) {
        if (bl) {
            this.topInit = ImageLoader.getImage("LeftTopPar");
            this.middleInit = ImageLoader.getImage("LeftMiddlePar");
            this.bottomInit = ImageLoader.getImage("LeftBottomPar");
        } else {
            this.topInit = ImageLoader.getImage("RightTopPar");
            this.middleInit = ImageLoader.getImage("RightMiddlePar");
            this.bottomInit = ImageLoader.getImage("RightBottomPar");
        }
        this.heightExtremities = n;
        this.observer = imageObserver;
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getHeight();
        graphics.drawImage(this.top, 0, 0, this.observer);
        for (int i = this.heightExtremities; i < n - this.heightExtremities; i += this.heightExtremities) {
            graphics.drawImage(this.middle, 0, i, this.observer);
        }
        graphics.drawImage(this.bottom, 0, n - this.heightExtremities, this.observer);
    }

    @Override
    public Dimension getPreferredSize() {
        MediaTracker mediaTracker = new MediaTracker((Component)this.observer);
        this.top = this.topInit.getScaledInstance(-1, this.heightExtremities, 4);
        mediaTracker.addImage(this.top, 0);
        this.bottom = this.bottomInit.getScaledInstance(-1, this.heightExtremities, 4);
        mediaTracker.addImage(this.bottom, 0);
        this.middle = this.middleInit.getScaledInstance(-1, this.heightExtremities, 4);
        mediaTracker.addImage(this.middle, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.print(interruptedException.toString());
        }
        mediaTracker.removeImage(this.top);
        mediaTracker.removeImage(this.middle);
        mediaTracker.removeImage(this.bottom);
        return new Dimension(this.top.getWidth(this.observer), this.getHeight());
    }

    @Override
    public void setGraphicContext(GraphicContext graphicContext) {
        super.setGraphicContext(graphicContext);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphicContext.getFont());
        this.heightExtremities = fontMetrics.getHeight() / 2;
    }
}

