'''OpenGL extension INTEL.blackhole_render

This module customises the behaviour of the 
OpenGL.raw.GL.INTEL.blackhole_render to provide a more 
Python-friendly API

Overview (from the spec)
	
	The purpose of this extension is to allow an application to disable all
	rendering operations emitted to the GPU through the OpenGL rendering
	commands (Draw*, DispatchCompute*, BlitFramebuffer, etc...). Changes to the
	OpenGL pipeline are not affected.
	
	New preprocessor #defines are added to the OpenGL Shading Language:
	
	  #define GL_INTEL_blackhole_render 1

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/INTEL/blackhole_render.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.INTEL.blackhole_render import *
from OpenGL.raw.GL.INTEL.blackhole_render import _EXTENSION_NAME

def glInitBlackholeRenderINTEL():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION