#!/bin/sh

: "${SED:=sed}"

source2setup() {
    # input: .c file
    # output: the entry-function within the .c file (if any)
    local f="$1"
    f="${f##*/}"
    f="${f%.c}"
    # filter out any files that have a '.' in the name (e.g. because they are not .c files)
    # or start with iemmatrix
    f=$(echo "$f" | "${SED}" -e 's/[^[:alnum:].]/_/g')
    test "$f" != "${f%.*}" || test "${f}" != "${f#iemmatrix}" || echo "ie${f}_setup"
}

make_boilerplate() {
    local s
    cat <<EOF
    /* iemmatrix-setup autogenerated setup-file
     * generated by "./makesource.sh"
     * !! DO NOT MANUALLY EDIT  !!
     */

     /* prototypes */
EOF

    for s in "$@"; do
        echo "void $s(void);"
    done

    cat <<EOF

    /* wrapper to call all the prototypes */
static void iemmatrix_sources_setup(void)
{
EOF
    for s in "$@"; do
        echo "  $s();"
    done

    cat <<EOF
}
EOF
}

make_boilerplate $(for s in "$@"; do source2setup "${s}"; done)
