/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _nbio_7_11_0_OFFSET_HEADER
#define _nbio_7_11_0_OFFSET_HEADER



// addressBlock: nbio_iohub_nb_nbcfg_nb_cfgdec
// base address: 0x0
#define cfgNBCFG_SCRATCH_0                                                                              0x0068
#define cfgNBCFG_SCRATCH_1                                                                              0x006c
#define cfgNBCFG_SCRATCH_2                                                                              0x0070
#define cfgNBCFG_SCRATCH_3                                                                              0x0074
#define cfgNBCFG_SCRATCH_4                                                                              0x0078


// addressBlock: nbio_iohub_iommu_l2_iommul2cfg
// base address: 0x0


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x0
#define cfgPCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV                                                     0x0580


// addressBlock: nbio_iohub_nb_nbcfg_nb_cfgdec
// base address: 0x13b00000
#define regNB_NBCFG0_NB_VENDOR_ID                                                                       0xe80000
#define regNB_NBCFG0_NB_VENDOR_ID_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_DEVICE_ID                                                                       0xe80000
#define regNB_NBCFG0_NB_DEVICE_ID_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_COMMAND                                                                         0xe80001
#define regNB_NBCFG0_NB_COMMAND_BASE_IDX                                                                5
#define regNB_NBCFG0_NB_STATUS                                                                          0xe80001
#define regNB_NBCFG0_NB_STATUS_BASE_IDX                                                                 5
#define regNB_NBCFG0_NB_SUB_CLASS                                                                       0xe80002
#define regNB_NBCFG0_NB_SUB_CLASS_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_BASE_CODE                                                                       0xe80002
#define regNB_NBCFG0_NB_BASE_CODE_BASE_IDX                                                              5
#define regNB_NBCFG0_NB_CACHE_LINE                                                                      0xe80003
#define regNB_NBCFG0_NB_CACHE_LINE_BASE_IDX                                                             5
#define regNB_NBCFG0_NB_LATENCY                                                                         0xe80003
#define regNB_NBCFG0_NB_LATENCY_BASE_IDX                                                                5
#define regNB_NBCFG0_NB_HEADER                                                                          0xe80003
#define regNB_NBCFG0_NB_HEADER_BASE_IDX                                                                 5
#define regNB_NBCFG0_NB_ADAPTER_ID                                                                      0xe8000b
#define regNB_NBCFG0_NB_ADAPTER_ID_BASE_IDX                                                             5
#define regNB_NBCFG0_NB_CAPABILITIES_PTR                                                                0xe8000d
#define regNB_NBCFG0_NB_CAPABILITIES_PTR_BASE_IDX                                                       5
#define regNB_NBCFG0_NB_HEADER_W                                                                        0xe80012
#define regNB_NBCFG0_NB_HEADER_W_BASE_IDX                                                               5
#define regNB_NBCFG0_NB_PCI_CTRL                                                                        0xe80013
#define regNB_NBCFG0_NB_PCI_CTRL_BASE_IDX                                                               5
#define regNB_NBCFG0_NB_ADAPTER_ID_W                                                                    0xe80014
#define regNB_NBCFG0_NB_ADAPTER_ID_W_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_0                                                                    0xe8001a
#define regNB_NBCFG0_NBCFG_SCRATCH_0_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_1                                                                    0xe8001b
#define regNB_NBCFG0_NBCFG_SCRATCH_1_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_2                                                                    0xe8001c
#define regNB_NBCFG0_NBCFG_SCRATCH_2_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_3                                                                    0xe8001d
#define regNB_NBCFG0_NBCFG_SCRATCH_3_BASE_IDX                                                           5
#define regNB_NBCFG0_NBCFG_SCRATCH_4                                                                    0xe8001e
#define regNB_NBCFG0_NBCFG_SCRATCH_4_BASE_IDX                                                           5
#define regNB_NBCFG0_NB_PCI_ARB                                                                         0xe80021
#define regNB_NBCFG0_NB_PCI_ARB_BASE_IDX                                                                5
#define regNB_NBCFG0_NB_DRAM_SLOT1_BASE                                                                 0xe80022
#define regNB_NBCFG0_NB_DRAM_SLOT1_BASE_BASE_IDX                                                        5
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX0                                                               0xe8002a
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX0_BASE_IDX                                                      5
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX1                                                               0xe8002b
#define regNB_NBCFG0_NB_INDEX_DATA_MUTEX1_BASE_IDX                                                      5
#define regNB_NBCFG0_NB_VENDOR_ID_W                                                                     0xe80040
#define regNB_NBCFG0_NB_VENDOR_ID_W_BASE_IDX                                                            5
#define regNB_NBCFG0_NB_DEVICE_ID_W                                                                     0xe80040
#define regNB_NBCFG0_NB_DEVICE_ID_W_BASE_IDX                                                            5


// addressBlock: nbio_iohub_nb_fastreg_fastreg_cfgdec
// base address: 0x13b07000
#define regFASTREG_APERTURE                                                                             0xe81c00
#define regFASTREG_APERTURE_BASE_IDX                                                                    5


// addressBlock: nbio_iohub_nb_misc_misc_cfgdec
// base address: 0x13b10000
#define regNB_CNTL                                                                                      0xe84000
#define regNB_CNTL_BASE_IDX                                                                             5
#define regNB_SPARE1                                                                                    0xe84003
#define regNB_SPARE1_BASE_IDX                                                                           5
#define regNB_SPARE2                                                                                    0xe84004
#define regNB_SPARE2_BASE_IDX                                                                           5
#define regNB_REVID                                                                                     0xe84005
#define regNB_REVID_BASE_IDX                                                                            5
#define regNBIO_LCLK_DS_MASK                                                                            0xe84009
#define regNBIO_LCLK_DS_MASK_BASE_IDX                                                                   5
#define regNB_BUS_NUM_CNTL                                                                              0xe84015
#define regNB_BUS_NUM_CNTL_BASE_IDX                                                                     5
#define regNB_MMIOBASE                                                                                  0xe84019
#define regNB_MMIOBASE_BASE_IDX                                                                         5
#define regNB_MMIOLIMIT                                                                                 0xe8401a
#define regNB_MMIOLIMIT_BASE_IDX                                                                        5
#define regNB_LOWER_TOP_OF_DRAM2                                                                        0xe8401b
#define regNB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                               5
#define regNB_UPPER_TOP_OF_DRAM2                                                                        0xe8401c
#define regNB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                               5
#define regNB_LOWER_DRAM2_BASE                                                                          0xe8401d
#define regNB_LOWER_DRAM2_BASE_BASE_IDX                                                                 5
#define regNB_UPPER_DRAM2_BASE                                                                          0xe8401e
#define regNB_UPPER_DRAM2_BASE_BASE_IDX                                                                 5
#define regSB_LOCATION                                                                                  0xe8401f
#define regSB_LOCATION_BASE_IDX                                                                         5
#define regSW_US_LOCATION                                                                               0xe84020
#define regSW_US_LOCATION_BASE_IDX                                                                      5
#define regSW_NMI_CNTL                                                                                  0xe84042
#define regSW_NMI_CNTL_BASE_IDX                                                                         5
#define regSW_SMI_CNTL                                                                                  0xe84043
#define regSW_SMI_CNTL_BASE_IDX                                                                         5
#define regSW_SCI_CNTL                                                                                  0xe84044
#define regSW_SCI_CNTL_BASE_IDX                                                                         5
#define regAPML_SW_STATUS                                                                               0xe84045
#define regAPML_SW_STATUS_BASE_IDX                                                                      5
#define regSW_GIC_SPI_CNTL                                                                              0xe84047
#define regSW_GIC_SPI_CNTL_BASE_IDX                                                                     5
#define regSW_SYNCFLOOD_CNTL                                                                            0xe84049
#define regSW_SYNCFLOOD_CNTL_BASE_IDX                                                                   5
#define regNB_TOP_OF_DRAM3                                                                              0xe8404e
#define regNB_TOP_OF_DRAM3_BASE_IDX                                                                     5
#define regCAM_CONTROL                                                                                  0xe84052
#define regCAM_CONTROL_BASE_IDX                                                                         5
#define regCAM_TARGET_INDEX_ADDR_BOTTOM                                                                 0xe84053
#define regCAM_TARGET_INDEX_ADDR_BOTTOM_BASE_IDX                                                        5
#define regCAM_TARGET_INDEX_ADDR_TOP                                                                    0xe84054
#define regCAM_TARGET_INDEX_ADDR_TOP_BASE_IDX                                                           5
#define regCAM_TARGET_INDEX_DATA                                                                        0xe84055
#define regCAM_TARGET_INDEX_DATA_BASE_IDX                                                               5
#define regCAM_TARGET_INDEX_DATA_MASK                                                                   0xe84056
#define regCAM_TARGET_INDEX_DATA_MASK_BASE_IDX                                                          5
#define regCAM_TARGET_DATA_ADDR_BOTTOM                                                                  0xe84057
#define regCAM_TARGET_DATA_ADDR_BOTTOM_BASE_IDX                                                         5
#define regCAM_TARGET_DATA_ADDR_TOP                                                                     0xe84059
#define regCAM_TARGET_DATA_ADDR_TOP_BASE_IDX                                                            5
#define regCAM_TARGET_DATA                                                                              0xe8405a
#define regCAM_TARGET_DATA_BASE_IDX                                                                     5
#define regCAM_TARGET_DATA_MASK                                                                         0xe8405b
#define regCAM_TARGET_DATA_MASK_BASE_IDX                                                                5
#define regPCIE_VDM_NODE0_CTRL4                                                                         0xe84064
#define regPCIE_VDM_NODE0_CTRL4_BASE_IDX                                                                5
#define regPCIE_VDM_CNTL2                                                                               0xe8408c
#define regPCIE_VDM_CNTL2_BASE_IDX                                                                      5
#define regPCIE_VDM_CNTL3                                                                               0xe8408d
#define regPCIE_VDM_CNTL3_BASE_IDX                                                                      5
#define regSTALL_CONTROL_XBARPORT0_0                                                                    0xe84090
#define regSTALL_CONTROL_XBARPORT0_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT0_1                                                                    0xe84091
#define regSTALL_CONTROL_XBARPORT0_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT1_0                                                                    0xe84093
#define regSTALL_CONTROL_XBARPORT1_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT1_1                                                                    0xe84094
#define regSTALL_CONTROL_XBARPORT1_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT2_0                                                                    0xe84096
#define regSTALL_CONTROL_XBARPORT2_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT2_1                                                                    0xe84097
#define regSTALL_CONTROL_XBARPORT2_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT3_0                                                                    0xe84099
#define regSTALL_CONTROL_XBARPORT3_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT3_1                                                                    0xe8409a
#define regSTALL_CONTROL_XBARPORT3_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT4_0                                                                    0xe8409c
#define regSTALL_CONTROL_XBARPORT4_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT4_1                                                                    0xe8409d
#define regSTALL_CONTROL_XBARPORT4_1_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT5_0                                                                    0xe8409f
#define regSTALL_CONTROL_XBARPORT5_0_BASE_IDX                                                           5
#define regSTALL_CONTROL_XBARPORT5_1                                                                    0xe840a0
#define regSTALL_CONTROL_XBARPORT5_1_BASE_IDX                                                           5
#define regNB_DRAM3_BASE                                                                                0xe840b1
#define regNB_DRAM3_BASE_BASE_IDX                                                                       5
#define regPSP_BASE_ADDR_LO                                                                             0xe840b8
#define regPSP_BASE_ADDR_LO_BASE_IDX                                                                    5
#define regPSP_BASE_ADDR_HI                                                                             0xe840b9
#define regPSP_BASE_ADDR_HI_BASE_IDX                                                                    5
#define regSMU_BASE_ADDR_LO                                                                             0xe840ba
#define regSMU_BASE_ADDR_LO_BASE_IDX                                                                    5
#define regSMU_BASE_ADDR_HI                                                                             0xe840bb
#define regSMU_BASE_ADDR_HI_BASE_IDX                                                                    5
#define regFASTREG_BASE_ADDR_LO                                                                         0xe840c0
#define regFASTREG_BASE_ADDR_LO_BASE_IDX                                                                5
#define regFASTREG_BASE_ADDR_HI                                                                         0xe840c1
#define regFASTREG_BASE_ADDR_HI_BASE_IDX                                                                5
#define regFASTREGCNTL_BASE_ADDR_LO                                                                     0xe840c2
#define regFASTREGCNTL_BASE_ADDR_LO_BASE_IDX                                                            5
#define regFASTREGCNTL_BASE_ADDR_HI                                                                     0xe840c3
#define regFASTREGCNTL_BASE_ADDR_HI_BASE_IDX                                                            5
#define regMISC0_BASE_ADDR_LO                                                                           0xe840d8
#define regMISC0_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC0_BASE_ADDR_HI                                                                           0xe840d9
#define regMISC0_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regMISC1_BASE_ADDR_LO                                                                           0xe840da
#define regMISC1_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC1_BASE_ADDR_HI                                                                           0xe840db
#define regMISC1_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regMISC2_BASE_ADDR_LO                                                                           0xe840dc
#define regMISC2_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC2_BASE_ADDR_HI                                                                           0xe840dd
#define regMISC2_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regMISC3_BASE_ADDR_LO                                                                           0xe840de
#define regMISC3_BASE_ADDR_LO_BASE_IDX                                                                  5
#define regMISC3_BASE_ADDR_HI                                                                           0xe840df
#define regMISC3_BASE_ADDR_HI_BASE_IDX                                                                  5
#define regSCRATCH_4                                                                                    0xe840fc
#define regSCRATCH_4_BASE_IDX                                                                           5
#define regSCRATCH_5                                                                                    0xe840fd
#define regSCRATCH_5_BASE_IDX                                                                           5
#define regSMU_BLOCK_CPU                                                                                0xe840fe
#define regSMU_BLOCK_CPU_BASE_IDX                                                                       5
#define regSMU_BLOCK_CPU_STATUS                                                                         0xe840ff
#define regSMU_BLOCK_CPU_STATUS_BASE_IDX                                                                5
#define regTRAP_STATUS                                                                                  0xe84100
#define regTRAP_STATUS_BASE_IDX                                                                         5
#define regTRAP_REQUEST0                                                                                0xe84101
#define regTRAP_REQUEST0_BASE_IDX                                                                       5
#define regTRAP_REQUEST1                                                                                0xe84102
#define regTRAP_REQUEST1_BASE_IDX                                                                       5
#define regTRAP_REQUEST2                                                                                0xe84103
#define regTRAP_REQUEST2_BASE_IDX                                                                       5
#define regTRAP_REQUEST3                                                                                0xe84104
#define regTRAP_REQUEST3_BASE_IDX                                                                       5
#define regTRAP_REQUEST4                                                                                0xe84105
#define regTRAP_REQUEST4_BASE_IDX                                                                       5
#define regTRAP_REQUEST5                                                                                0xe84106
#define regTRAP_REQUEST5_BASE_IDX                                                                       5
#define regTRAP_REQUEST_DATASTRB0                                                                       0xe84108
#define regTRAP_REQUEST_DATASTRB0_BASE_IDX                                                              5
#define regTRAP_REQUEST_DATASTRB1                                                                       0xe84109
#define regTRAP_REQUEST_DATASTRB1_BASE_IDX                                                              5
#define regTRAP_REQUEST_DATA0                                                                           0xe84110
#define regTRAP_REQUEST_DATA0_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA1                                                                           0xe84111
#define regTRAP_REQUEST_DATA1_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA2                                                                           0xe84112
#define regTRAP_REQUEST_DATA2_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA3                                                                           0xe84113
#define regTRAP_REQUEST_DATA3_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA4                                                                           0xe84114
#define regTRAP_REQUEST_DATA4_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA5                                                                           0xe84115
#define regTRAP_REQUEST_DATA5_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA6                                                                           0xe84116
#define regTRAP_REQUEST_DATA6_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA7                                                                           0xe84117
#define regTRAP_REQUEST_DATA7_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA8                                                                           0xe84118
#define regTRAP_REQUEST_DATA8_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA9                                                                           0xe84119
#define regTRAP_REQUEST_DATA9_BASE_IDX                                                                  5
#define regTRAP_REQUEST_DATA10                                                                          0xe8411a
#define regTRAP_REQUEST_DATA10_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA11                                                                          0xe8411b
#define regTRAP_REQUEST_DATA11_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA12                                                                          0xe8411c
#define regTRAP_REQUEST_DATA12_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA13                                                                          0xe8411d
#define regTRAP_REQUEST_DATA13_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA14                                                                          0xe8411e
#define regTRAP_REQUEST_DATA14_BASE_IDX                                                                 5
#define regTRAP_REQUEST_DATA15                                                                          0xe8411f
#define regTRAP_REQUEST_DATA15_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_CONTROL                                                                        0xe84130
#define regTRAP_RESPONSE_CONTROL_BASE_IDX                                                               5
#define regTRAP_RESPONSE0                                                                               0xe84131
#define regTRAP_RESPONSE0_BASE_IDX                                                                      5
#define regTRAP_RESPONSE_DATA0                                                                          0xe84140
#define regTRAP_RESPONSE_DATA0_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA1                                                                          0xe84141
#define regTRAP_RESPONSE_DATA1_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA2                                                                          0xe84142
#define regTRAP_RESPONSE_DATA2_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA3                                                                          0xe84143
#define regTRAP_RESPONSE_DATA3_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA4                                                                          0xe84144
#define regTRAP_RESPONSE_DATA4_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA5                                                                          0xe84145
#define regTRAP_RESPONSE_DATA5_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA6                                                                          0xe84146
#define regTRAP_RESPONSE_DATA6_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA7                                                                          0xe84147
#define regTRAP_RESPONSE_DATA7_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA8                                                                          0xe84148
#define regTRAP_RESPONSE_DATA8_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA9                                                                          0xe84149
#define regTRAP_RESPONSE_DATA9_BASE_IDX                                                                 5
#define regTRAP_RESPONSE_DATA10                                                                         0xe8414a
#define regTRAP_RESPONSE_DATA10_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA11                                                                         0xe8414b
#define regTRAP_RESPONSE_DATA11_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA12                                                                         0xe8414c
#define regTRAP_RESPONSE_DATA12_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA13                                                                         0xe8414d
#define regTRAP_RESPONSE_DATA13_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA14                                                                         0xe8414e
#define regTRAP_RESPONSE_DATA14_BASE_IDX                                                                5
#define regTRAP_RESPONSE_DATA15                                                                         0xe8414f
#define regTRAP_RESPONSE_DATA15_BASE_IDX                                                                5
#define regTRAP0_CONTROL0                                                                               0xe84200
#define regTRAP0_CONTROL0_BASE_IDX                                                                      5
#define regTRAP0_ADDRESS_LO                                                                             0xe84202
#define regTRAP0_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP0_ADDRESS_HI                                                                             0xe84203
#define regTRAP0_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP0_COMMAND                                                                                0xe84204
#define regTRAP0_COMMAND_BASE_IDX                                                                       5
#define regTRAP0_ADDRESS_LO_MASK                                                                        0xe84206
#define regTRAP0_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP0_ADDRESS_HI_MASK                                                                        0xe84207
#define regTRAP0_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP0_COMMAND_MASK                                                                           0xe84208
#define regTRAP0_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP1_CONTROL0                                                                               0xe84210
#define regTRAP1_CONTROL0_BASE_IDX                                                                      5
#define regTRAP1_ADDRESS_LO                                                                             0xe84212
#define regTRAP1_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP1_ADDRESS_HI                                                                             0xe84213
#define regTRAP1_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP1_COMMAND                                                                                0xe84214
#define regTRAP1_COMMAND_BASE_IDX                                                                       5
#define regTRAP1_ADDRESS_LO_MASK                                                                        0xe84216
#define regTRAP1_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP1_ADDRESS_HI_MASK                                                                        0xe84217
#define regTRAP1_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP1_COMMAND_MASK                                                                           0xe84218
#define regTRAP1_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP2_CONTROL0                                                                               0xe84220
#define regTRAP2_CONTROL0_BASE_IDX                                                                      5
#define regTRAP2_ADDRESS_LO                                                                             0xe84222
#define regTRAP2_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP2_ADDRESS_HI                                                                             0xe84223
#define regTRAP2_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP2_COMMAND                                                                                0xe84224
#define regTRAP2_COMMAND_BASE_IDX                                                                       5
#define regTRAP2_ADDRESS_LO_MASK                                                                        0xe84226
#define regTRAP2_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP2_ADDRESS_HI_MASK                                                                        0xe84227
#define regTRAP2_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP2_COMMAND_MASK                                                                           0xe84228
#define regTRAP2_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP3_CONTROL0                                                                               0xe84230
#define regTRAP3_CONTROL0_BASE_IDX                                                                      5
#define regTRAP3_ADDRESS_LO                                                                             0xe84232
#define regTRAP3_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP3_ADDRESS_HI                                                                             0xe84233
#define regTRAP3_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP3_COMMAND                                                                                0xe84234
#define regTRAP3_COMMAND_BASE_IDX                                                                       5
#define regTRAP3_ADDRESS_LO_MASK                                                                        0xe84236
#define regTRAP3_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP3_ADDRESS_HI_MASK                                                                        0xe84237
#define regTRAP3_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP3_COMMAND_MASK                                                                           0xe84238
#define regTRAP3_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP4_CONTROL0                                                                               0xe84240
#define regTRAP4_CONTROL0_BASE_IDX                                                                      5
#define regTRAP4_ADDRESS_LO                                                                             0xe84242
#define regTRAP4_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP4_ADDRESS_HI                                                                             0xe84243
#define regTRAP4_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP4_COMMAND                                                                                0xe84244
#define regTRAP4_COMMAND_BASE_IDX                                                                       5
#define regTRAP4_ADDRESS_LO_MASK                                                                        0xe84246
#define regTRAP4_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP4_ADDRESS_HI_MASK                                                                        0xe84247
#define regTRAP4_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP4_COMMAND_MASK                                                                           0xe84248
#define regTRAP4_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP5_CONTROL0                                                                               0xe84250
#define regTRAP5_CONTROL0_BASE_IDX                                                                      5
#define regTRAP5_ADDRESS_LO                                                                             0xe84252
#define regTRAP5_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP5_ADDRESS_HI                                                                             0xe84253
#define regTRAP5_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP5_COMMAND                                                                                0xe84254
#define regTRAP5_COMMAND_BASE_IDX                                                                       5
#define regTRAP5_ADDRESS_LO_MASK                                                                        0xe84256
#define regTRAP5_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP5_ADDRESS_HI_MASK                                                                        0xe84257
#define regTRAP5_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP5_COMMAND_MASK                                                                           0xe84258
#define regTRAP5_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP6_CONTROL0                                                                               0xe84260
#define regTRAP6_CONTROL0_BASE_IDX                                                                      5
#define regTRAP6_ADDRESS_LO                                                                             0xe84262
#define regTRAP6_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP6_ADDRESS_HI                                                                             0xe84263
#define regTRAP6_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP6_COMMAND                                                                                0xe84264
#define regTRAP6_COMMAND_BASE_IDX                                                                       5
#define regTRAP6_ADDRESS_LO_MASK                                                                        0xe84266
#define regTRAP6_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP6_ADDRESS_HI_MASK                                                                        0xe84267
#define regTRAP6_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP6_COMMAND_MASK                                                                           0xe84268
#define regTRAP6_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP7_CONTROL0                                                                               0xe84270
#define regTRAP7_CONTROL0_BASE_IDX                                                                      5
#define regTRAP7_ADDRESS_LO                                                                             0xe84272
#define regTRAP7_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP7_ADDRESS_HI                                                                             0xe84273
#define regTRAP7_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP7_COMMAND                                                                                0xe84274
#define regTRAP7_COMMAND_BASE_IDX                                                                       5
#define regTRAP7_ADDRESS_LO_MASK                                                                        0xe84276
#define regTRAP7_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP7_ADDRESS_HI_MASK                                                                        0xe84277
#define regTRAP7_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP7_COMMAND_MASK                                                                           0xe84278
#define regTRAP7_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP8_CONTROL0                                                                               0xe84280
#define regTRAP8_CONTROL0_BASE_IDX                                                                      5
#define regTRAP8_ADDRESS_LO                                                                             0xe84282
#define regTRAP8_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP8_ADDRESS_HI                                                                             0xe84283
#define regTRAP8_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP8_COMMAND                                                                                0xe84284
#define regTRAP8_COMMAND_BASE_IDX                                                                       5
#define regTRAP8_ADDRESS_LO_MASK                                                                        0xe84286
#define regTRAP8_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP8_ADDRESS_HI_MASK                                                                        0xe84287
#define regTRAP8_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP8_COMMAND_MASK                                                                           0xe84288
#define regTRAP8_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP9_CONTROL0                                                                               0xe84290
#define regTRAP9_CONTROL0_BASE_IDX                                                                      5
#define regTRAP9_ADDRESS_LO                                                                             0xe84292
#define regTRAP9_ADDRESS_LO_BASE_IDX                                                                    5
#define regTRAP9_ADDRESS_HI                                                                             0xe84293
#define regTRAP9_ADDRESS_HI_BASE_IDX                                                                    5
#define regTRAP9_COMMAND                                                                                0xe84294
#define regTRAP9_COMMAND_BASE_IDX                                                                       5
#define regTRAP9_ADDRESS_LO_MASK                                                                        0xe84296
#define regTRAP9_ADDRESS_LO_MASK_BASE_IDX                                                               5
#define regTRAP9_ADDRESS_HI_MASK                                                                        0xe84297
#define regTRAP9_ADDRESS_HI_MASK_BASE_IDX                                                               5
#define regTRAP9_COMMAND_MASK                                                                           0xe84298
#define regTRAP9_COMMAND_MASK_BASE_IDX                                                                  5
#define regTRAP10_CONTROL0                                                                              0xe842a0
#define regTRAP10_CONTROL0_BASE_IDX                                                                     5
#define regTRAP10_ADDRESS_LO                                                                            0xe842a2
#define regTRAP10_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP10_ADDRESS_HI                                                                            0xe842a3
#define regTRAP10_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP10_COMMAND                                                                               0xe842a4
#define regTRAP10_COMMAND_BASE_IDX                                                                      5
#define regTRAP10_ADDRESS_LO_MASK                                                                       0xe842a6
#define regTRAP10_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP10_ADDRESS_HI_MASK                                                                       0xe842a7
#define regTRAP10_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP10_COMMAND_MASK                                                                          0xe842a8
#define regTRAP10_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP11_CONTROL0                                                                              0xe842b0
#define regTRAP11_CONTROL0_BASE_IDX                                                                     5
#define regTRAP11_ADDRESS_LO                                                                            0xe842b2
#define regTRAP11_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP11_ADDRESS_HI                                                                            0xe842b3
#define regTRAP11_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP11_COMMAND                                                                               0xe842b4
#define regTRAP11_COMMAND_BASE_IDX                                                                      5
#define regTRAP11_ADDRESS_LO_MASK                                                                       0xe842b6
#define regTRAP11_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP11_ADDRESS_HI_MASK                                                                       0xe842b7
#define regTRAP11_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP11_COMMAND_MASK                                                                          0xe842b8
#define regTRAP11_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP12_CONTROL0                                                                              0xe842c0
#define regTRAP12_CONTROL0_BASE_IDX                                                                     5
#define regTRAP12_ADDRESS_LO                                                                            0xe842c2
#define regTRAP12_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP12_ADDRESS_HI                                                                            0xe842c3
#define regTRAP12_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP12_COMMAND                                                                               0xe842c4
#define regTRAP12_COMMAND_BASE_IDX                                                                      5
#define regTRAP12_ADDRESS_LO_MASK                                                                       0xe842c6
#define regTRAP12_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP12_ADDRESS_HI_MASK                                                                       0xe842c7
#define regTRAP12_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP12_COMMAND_MASK                                                                          0xe842c8
#define regTRAP12_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP13_CONTROL0                                                                              0xe842d0
#define regTRAP13_CONTROL0_BASE_IDX                                                                     5
#define regTRAP13_ADDRESS_LO                                                                            0xe842d2
#define regTRAP13_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP13_ADDRESS_HI                                                                            0xe842d3
#define regTRAP13_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP13_COMMAND                                                                               0xe842d4
#define regTRAP13_COMMAND_BASE_IDX                                                                      5
#define regTRAP13_ADDRESS_LO_MASK                                                                       0xe842d6
#define regTRAP13_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP13_ADDRESS_HI_MASK                                                                       0xe842d7
#define regTRAP13_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP13_COMMAND_MASK                                                                          0xe842d8
#define regTRAP13_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP14_CONTROL0                                                                              0xe842e0
#define regTRAP14_CONTROL0_BASE_IDX                                                                     5
#define regTRAP14_ADDRESS_LO                                                                            0xe842e2
#define regTRAP14_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP14_ADDRESS_HI                                                                            0xe842e3
#define regTRAP14_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP14_COMMAND                                                                               0xe842e4
#define regTRAP14_COMMAND_BASE_IDX                                                                      5
#define regTRAP14_ADDRESS_LO_MASK                                                                       0xe842e6
#define regTRAP14_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP14_ADDRESS_HI_MASK                                                                       0xe842e7
#define regTRAP14_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP14_COMMAND_MASK                                                                          0xe842e8
#define regTRAP14_COMMAND_MASK_BASE_IDX                                                                 5
#define regTRAP15_CONTROL0                                                                              0xe842f0
#define regTRAP15_CONTROL0_BASE_IDX                                                                     5
#define regTRAP15_ADDRESS_LO                                                                            0xe842f2
#define regTRAP15_ADDRESS_LO_BASE_IDX                                                                   5
#define regTRAP15_ADDRESS_HI                                                                            0xe842f3
#define regTRAP15_ADDRESS_HI_BASE_IDX                                                                   5
#define regTRAP15_COMMAND                                                                               0xe842f4
#define regTRAP15_COMMAND_BASE_IDX                                                                      5
#define regTRAP15_ADDRESS_LO_MASK                                                                       0xe842f6
#define regTRAP15_ADDRESS_LO_MASK_BASE_IDX                                                              5
#define regTRAP15_ADDRESS_HI_MASK                                                                       0xe842f7
#define regTRAP15_ADDRESS_HI_MASK_BASE_IDX                                                              5
#define regTRAP15_COMMAND_MASK                                                                          0xe842f8
#define regTRAP15_COMMAND_MASK_BASE_IDX                                                                 5
#define regSB_COMMAND                                                                                   0xe85000
#define regSB_COMMAND_BASE_IDX                                                                          5
#define regSB_SUB_BUS_NUMBER_LATENCY                                                                    0xe85001
#define regSB_SUB_BUS_NUMBER_LATENCY_BASE_IDX                                                           5
#define regSB_IO_BASE_LIMIT                                                                             0xe85002
#define regSB_IO_BASE_LIMIT_BASE_IDX                                                                    5
#define regSB_MEM_BASE_LIMIT                                                                            0xe85003
#define regSB_MEM_BASE_LIMIT_BASE_IDX                                                                   5
#define regSB_PREF_BASE_LIMIT                                                                           0xe85004
#define regSB_PREF_BASE_LIMIT_BASE_IDX                                                                  5
#define regSB_PREF_BASE_UPPER                                                                           0xe85005
#define regSB_PREF_BASE_UPPER_BASE_IDX                                                                  5
#define regSB_PREF_LIMIT_UPPER                                                                          0xe85006
#define regSB_PREF_LIMIT_UPPER_BASE_IDX                                                                 5
#define regSB_IO_BASE_LIMIT_HI                                                                          0xe85007
#define regSB_IO_BASE_LIMIT_HI_BASE_IDX                                                                 5
#define regSB_IRQ_BRIDGE_CNTL                                                                           0xe85008
#define regSB_IRQ_BRIDGE_CNTL_BASE_IDX                                                                  5
#define regSB_EXT_BRIDGE_CNTL                                                                           0xe85009
#define regSB_EXT_BRIDGE_CNTL_BASE_IDX                                                                  5
#define regSB_PMI_STATUS_CNTL                                                                           0xe8500a
#define regSB_PMI_STATUS_CNTL_BASE_IDX                                                                  5
#define regSB_SLOT_CAP                                                                                  0xe8500b
#define regSB_SLOT_CAP_BASE_IDX                                                                         5
#define regSB_ROOT_CNTL                                                                                 0xe8500c
#define regSB_ROOT_CNTL_BASE_IDX                                                                        5
#define regSB_DEVICE_CNTL2                                                                              0xe8500d
#define regSB_DEVICE_CNTL2_BASE_IDX                                                                     5
#define regUSB_QoS_CNTL                                                                                 0xe85011
#define regUSB_QoS_CNTL_BASE_IDX                                                                        5
#define regMCA_SMN_INT_REQ_ADDR                                                                         0xe85020
#define regMCA_SMN_INT_REQ_ADDR_BASE_IDX                                                                5
#define regMCA_SMN_INT_MCM_ADDR                                                                         0xe85021
#define regMCA_SMN_INT_MCM_ADDR_BASE_IDX                                                                5
#define regMCA_SMN_INT_APERTUREID                                                                       0xe85022
#define regMCA_SMN_INT_APERTUREID_BASE_IDX                                                              5
#define regMCA_SMN_INT_CONTROL                                                                          0xe85023
#define regMCA_SMN_INT_CONTROL_BASE_IDX                                                                 5


// addressBlock: nbio_iohub_nb_rascfg_ras_cfgdec
// base address: 0x13b20000
#define regPARITY_CONTROL_0                                                                             0xe88000
#define regPARITY_CONTROL_0_BASE_IDX                                                                    5
#define regPARITY_CONTROL_1                                                                             0xe88001
#define regPARITY_CONTROL_1_BASE_IDX                                                                    5
#define regPARITY_SEVERITY_CONTROL_UNCORR_0                                                             0xe88002
#define regPARITY_SEVERITY_CONTROL_UNCORR_0_BASE_IDX                                                    5
#define regPARITY_SEVERITY_CONTROL_CORR_0                                                               0xe88004
#define regPARITY_SEVERITY_CONTROL_CORR_0_BASE_IDX                                                      5
#define regPARITY_SEVERITY_CONTROL_UCP_0                                                                0xe88006
#define regPARITY_SEVERITY_CONTROL_UCP_0_BASE_IDX                                                       5
#define regMISC_SEVERITY_CONTROL                                                                        0xe88037
#define regMISC_SEVERITY_CONTROL_BASE_IDX                                                               5
#define regMISC_RAS_CONTROL                                                                             0xe88038
#define regMISC_RAS_CONTROL_BASE_IDX                                                                    5
#define regRAS_SCRATCH_0                                                                                0xe88039
#define regRAS_SCRATCH_0_BASE_IDX                                                                       5
#define regRAS_SCRATCH_1                                                                                0xe8803a
#define regRAS_SCRATCH_1_BASE_IDX                                                                       5
#define regSYNCFLOOD_STATUS                                                                             0xe88200
#define regSYNCFLOOD_STATUS_BASE_IDX                                                                    5
#define regNMI_STATUS                                                                                   0xe88201
#define regNMI_STATUS_BASE_IDX                                                                          5
#define regINTERNAL_POISON_STATUS                                                                       0xe88206
#define regINTERNAL_POISON_STATUS_BASE_IDX                                                              5
#define regINTERNAL_POISON_MASK                                                                         0xe88207
#define regINTERNAL_POISON_MASK_BASE_IDX                                                                5
#define regEGRESS_POISON_STATUS_LO                                                                      0xe88208
#define regEGRESS_POISON_STATUS_LO_BASE_IDX                                                             5
#define regEGRESS_POISON_STATUS_HI                                                                      0xe88209
#define regEGRESS_POISON_STATUS_HI_BASE_IDX                                                             5
#define regEGRESS_POISON_MASK_LO                                                                        0xe8820a
#define regEGRESS_POISON_MASK_LO_BASE_IDX                                                               5
#define regEGRESS_POISON_MASK_HI                                                                        0xe8820b
#define regEGRESS_POISON_MASK_HI_BASE_IDX                                                               5
#define regEGRESS_POISON_SEVERITY_DOWN                                                                  0xe8820c
#define regEGRESS_POISON_SEVERITY_DOWN_BASE_IDX                                                         5
#define regEGRESS_POISON_SEVERITY_UPPER                                                                 0xe8820d
#define regEGRESS_POISON_SEVERITY_UPPER_BASE_IDX                                                        5
#define regAPML_STATUS                                                                                  0xe88370
#define regAPML_STATUS_BASE_IDX                                                                         5
#define regAPML_CONTROL                                                                                 0xe88371
#define regAPML_CONTROL_BASE_IDX                                                                        5
#define regAPML_TRIGGER                                                                                 0xe88372
#define regAPML_TRIGGER_BASE_IDX                                                                        5


// addressBlock: nbio_iohub_nb_psprascfg_pspras_cfgdec
// base address: 0x13b23000
#define regPSP_INTERNAL_POISON_STATUS                                                                   0xe88c02
#define regPSP_INTERNAL_POISON_STATUS_BASE_IDX                                                          5
#define regPSP_EGRESS_POISON_STATUS_LO                                                                  0xe88c04
#define regPSP_EGRESS_POISON_STATUS_LO_BASE_IDX                                                         5
#define regPSP_EGRESS_POISON_STATUS_HI                                                                  0xe88c05
#define regPSP_EGRESS_POISON_STATUS_HI_BASE_IDX                                                         5


// addressBlock: nbio_iohub_nb_intSBdevindcfg0_devind_cfgdecp
// base address: 0x13b3c000
#define regNB_INTSBDEVINDCFG0_STEERING_CNTL                                                             0xe8f003
#define regNB_INTSBDEVINDCFG0_STEERING_CNTL_BASE_IDX                                                    5
#define regNB_INTSBDEVINDCFG0_SW_LATENCY                                                                0xe8f004
#define regNB_INTSBDEVINDCFG0_SW_LATENCY_BASE_IDX                                                       5


// addressBlock: nbio_iohub_nb_PCIE0rcbdg_indcfg0_pciercbdgind_cfgdec
// base address: 0x13b7d600
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_INDEX                                                           0xe9f5b8
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_INDEX_BASE_IDX                                                  5
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_DATA                                                            0xe9f5b9
#define regNB_PCIE0RCBDG_INDCFG0_RC_SMN_DATA_BASE_IDX                                                   5


// addressBlock: nbio_iohub_nb_PCIE0rcbdg_indcfg1_pciercbdgind_cfgdec
// base address: 0x13b7d700
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_INDEX                                                           0xe9f5f8
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_INDEX_BASE_IDX                                                  5
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_DATA                                                            0xe9f5f9
#define regNB_PCIE0RCBDG_INDCFG1_RC_SMN_DATA_BASE_IDX                                                   5


// addressBlock: nbio_iohub_nb_PCIE0rcbdg_indcfg2_pciercbdgind_cfgdec
// base address: 0x13b7d800
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_INDEX                                                           0xe9f638
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_INDEX_BASE_IDX                                                  5
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_DATA                                                            0xe9f639
#define regNB_PCIE0RCBDG_INDCFG2_RC_SMN_DATA_BASE_IDX                                                   5


// addressBlock: nbio_iohub_iommu_l2a_l2acfg
// base address: 0x15700000
#define regL2_PERF_CNTL_0                                                                               0x1580000
#define regL2_PERF_CNTL_0_BASE_IDX                                                                      5
#define regL2_PERF_COUNT_0                                                                              0x1580001
#define regL2_PERF_COUNT_0_BASE_IDX                                                                     5
#define regL2_PERF_COUNT_1                                                                              0x1580002
#define regL2_PERF_COUNT_1_BASE_IDX                                                                     5
#define regL2_PERF_CNTL_1                                                                               0x1580003
#define regL2_PERF_CNTL_1_BASE_IDX                                                                      5
#define regL2_PERF_COUNT_2                                                                              0x1580004
#define regL2_PERF_COUNT_2_BASE_IDX                                                                     5
#define regL2_PERF_COUNT_3                                                                              0x1580005
#define regL2_PERF_COUNT_3_BASE_IDX                                                                     5
#define regL2_STATUS_0                                                                                  0x1580008
#define regL2_STATUS_0_BASE_IDX                                                                         5
#define regL2_CONTROL_0                                                                                 0x158000c
#define regL2_CONTROL_0_BASE_IDX                                                                        5
#define regL2_CONTROL_1                                                                                 0x158000d
#define regL2_CONTROL_1_BASE_IDX                                                                        5
#define regL2_DTC_CONTROL                                                                               0x1580010
#define regL2_DTC_CONTROL_BASE_IDX                                                                      5
#define regL2_DTC_HASH_CONTROL                                                                          0x1580011
#define regL2_DTC_HASH_CONTROL_BASE_IDX                                                                 5
#define regL2_DTC_WAY_CONTROL                                                                           0x1580012
#define regL2_DTC_WAY_CONTROL_BASE_IDX                                                                  5
#define regL2_ITC_CONTROL                                                                               0x1580014
#define regL2_ITC_CONTROL_BASE_IDX                                                                      5
#define regL2_ITC_HASH_CONTROL                                                                          0x1580015
#define regL2_ITC_HASH_CONTROL_BASE_IDX                                                                 5
#define regL2_ITC_WAY_CONTROL                                                                           0x1580016
#define regL2_ITC_WAY_CONTROL_BASE_IDX                                                                  5
#define regL2_PTC_A_CONTROL                                                                             0x1580018
#define regL2_PTC_A_CONTROL_BASE_IDX                                                                    5
#define regL2_PTC_A_HASH_CONTROL                                                                        0x1580019
#define regL2_PTC_A_HASH_CONTROL_BASE_IDX                                                               5
#define regL2_PTC_A_WAY_CONTROL                                                                         0x158001a
#define regL2_PTC_A_WAY_CONTROL_BASE_IDX                                                                5
#define regL2_CREDIT_CONTROL_2                                                                          0x1580020
#define regL2_CREDIT_CONTROL_2_BASE_IDX                                                                 5
#define regL2A_UPDATE_FILTER_CNTL                                                                       0x1580022
#define regL2A_UPDATE_FILTER_CNTL_BASE_IDX                                                              5
#define regL2_ERR_RULE_CONTROL_3                                                                        0x1580030
#define regL2_ERR_RULE_CONTROL_3_BASE_IDX                                                               5
#define regL2_ERR_RULE_CONTROL_4                                                                        0x1580031
#define regL2_ERR_RULE_CONTROL_4_BASE_IDX                                                               5
#define regL2_ERR_RULE_CONTROL_5                                                                        0x1580032
#define regL2_ERR_RULE_CONTROL_5_BASE_IDX                                                               5
#define regL2_L2A_PGSIZE_CONTROL                                                                        0x1580034
#define regL2_L2A_PGSIZE_CONTROL_BASE_IDX                                                               5
#define regL2_L2A_MEMPWR_GATE_1                                                                         0x1580035
#define regL2_L2A_MEMPWR_GATE_1_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_2                                                                         0x1580036
#define regL2_L2A_MEMPWR_GATE_2_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_3                                                                         0x1580037
#define regL2_L2A_MEMPWR_GATE_3_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_4                                                                         0x1580038
#define regL2_L2A_MEMPWR_GATE_4_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_5                                                                         0x1580039
#define regL2_L2A_MEMPWR_GATE_5_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_6                                                                         0x158003a
#define regL2_L2A_MEMPWR_GATE_6_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_7                                                                         0x158003b
#define regL2_L2A_MEMPWR_GATE_7_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_8                                                                         0x158003c
#define regL2_L2A_MEMPWR_GATE_8_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_9                                                                         0x158003d
#define regL2_L2A_MEMPWR_GATE_9_BASE_IDX                                                                5
#define regL2_L2A_MEMPWR_GATE_10                                                                        0x158003f
#define regL2_L2A_MEMPWR_GATE_10_BASE_IDX                                                               5
#define regL2_ECO_CNTRL_0                                                                               0x1580042
#define regL2_ECO_CNTRL_0_BASE_IDX                                                                      5


// addressBlock: nbio_iohub_nb_ioapiccfg_ioapic_cfgdec
// base address: 0x14300000
#define regFEATURES_ENABLE                                                                              0x1080000
#define regFEATURES_ENABLE_BASE_IDX                                                                     5


// addressBlock: nbio_pcie0_pciedir
// base address: 0x11180000
#define regPCIE_USB4_TXAL_CNTL1                                                                         0x420160
#define regPCIE_USB4_TXAL_CNTL1_BASE_IDX                                                                5
#define regPCIE_USB4_RXAL_CNTL1                                                                         0x420168
#define regPCIE_USB4_RXAL_CNTL1_BASE_IDX                                                                5
#define regPCIE_USB4_AL_CNTL1                                                                           0x420170
#define regPCIE_USB4_AL_CNTL1_BASE_IDX                                                                  5
#define regPCIE_USB4_AL_CNTL2                                                                           0x420171
#define regPCIE_USB4_AL_CNTL2_BASE_IDX                                                                  5
#define regPCIE_USB4_AL_HYSTERESIS                                                                      0x420172
#define regPCIE_USB4_AL_HYSTERESIS_BASE_IDX                                                             5
#define regPCIE_USB4_AL_HYSTERESIS_2                                                                    0x420173
#define regPCIE_USB4_AL_HYSTERESIS_2_BASE_IDX                                                           5
#define regPCIE_USB4_ERR_CNTL5                                                                          0x420178
#define regPCIE_USB4_ERR_CNTL5_BASE_IDX                                                                 5
#define regPCIE_USB4_LC_CNTL1                                                                           0x420179
#define regPCIE_USB4_LC_CNTL1_BASE_IDX                                                                  5
#define regBIF_BIF256_CI256_RC3X4_USB4_CPM_CONTROL                                                      0x420118
#define regBIF_BIF256_CI256_RC3X4_USB4_CPM_CONTROL_BASE_IDX                                             5
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_CNTL2                                                       0x42001c
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_CNTL2_BASE_IDX                                              5
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_TX_POWER_CTRL_1                                             0x420187
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_TX_POWER_CTRL_1_BASE_IDX                                    5
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_MST_CTRL_3                                                  0x4201c6
#define regBIF_BIF256_CI256_RC3X4_USB4_PCIE_MST_CTRL_3_BASE_IDX                                         5


// addressBlock: nbio_nbif0_bif_cfg_dev0_rc_bifcfgdecp
// base address: 0x10100000
#define regBIF_CFG_DEV0_RC0_VENDOR_ID                                                                   0x0000
#define regBIF_CFG_DEV0_RC0_VENDOR_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_DEVICE_ID                                                                   0x0000
#define regBIF_CFG_DEV0_RC0_DEVICE_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_COMMAND                                                                     0x0001
#define regBIF_CFG_DEV0_RC0_COMMAND_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_STATUS                                                                      0x0001
#define regBIF_CFG_DEV0_RC0_STATUS_BASE_IDX                                                             5
#define regBIF_CFG_DEV0_RC0_REVISION_ID                                                                 0x0002
#define regBIF_CFG_DEV0_RC0_REVISION_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_PROG_INTERFACE                                                              0x0002
#define regBIF_CFG_DEV0_RC0_PROG_INTERFACE_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_SUB_CLASS                                                                   0x0002
#define regBIF_CFG_DEV0_RC0_SUB_CLASS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_BASE_CLASS                                                                  0x0002
#define regBIF_CFG_DEV0_RC0_BASE_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_CACHE_LINE                                                                  0x0003
#define regBIF_CFG_DEV0_RC0_CACHE_LINE_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_LATENCY                                                                     0x0003
#define regBIF_CFG_DEV0_RC0_LATENCY_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_HEADER                                                                      0x0003
#define regBIF_CFG_DEV0_RC0_HEADER_BASE_IDX                                                             5
#define regBIF_CFG_DEV0_RC0_BIST                                                                        0x0003
#define regBIF_CFG_DEV0_RC0_BIST_BASE_IDX                                                               5
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_1                                                                 0x0004
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_1_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_2                                                                 0x0005
#define regBIF_CFG_DEV0_RC0_BASE_ADDR_2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY                                                      0x0006
#define regBIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT                                                               0x0007
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_SECONDARY_STATUS                                                            0x0007
#define regBIF_CFG_DEV0_RC0_SECONDARY_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_MEM_BASE_LIMIT                                                              0x0008
#define regBIF_CFG_DEV0_RC0_MEM_BASE_LIMIT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_PREF_BASE_LIMIT                                                             0x0009
#define regBIF_CFG_DEV0_RC0_PREF_BASE_LIMIT_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PREF_BASE_UPPER                                                             0x000a
#define regBIF_CFG_DEV0_RC0_PREF_BASE_UPPER_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER                                                            0x000b
#define regBIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI                                                            0x000c
#define regBIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_CAP_PTR                                                                     0x000d
#define regBIF_CFG_DEV0_RC0_CAP_PTR_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_ROM_BASE_ADDR                                                               0x000e
#define regBIF_CFG_DEV0_RC0_ROM_BASE_ADDR_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_INTERRUPT_LINE                                                              0x000f
#define regBIF_CFG_DEV0_RC0_INTERRUPT_LINE_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_INTERRUPT_PIN                                                               0x000f
#define regBIF_CFG_DEV0_RC0_INTERRUPT_PIN_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL                                                             0x000f
#define regBIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL                                                             0x0010
#define regBIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PMI_CAP_LIST                                                                0x0014
#define regBIF_CFG_DEV0_RC0_PMI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_PMI_CAP                                                                     0x0014
#define regBIF_CFG_DEV0_RC0_PMI_CAP_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_RC0_PMI_STATUS_CNTL                                                             0x0015
#define regBIF_CFG_DEV0_RC0_PMI_STATUS_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PCIE_CAP_LIST                                                               0x0016
#define regBIF_CFG_DEV0_RC0_PCIE_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_CAP                                                                    0x0016
#define regBIF_CFG_DEV0_RC0_PCIE_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP                                                                  0x0017
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL                                                                 0x0018
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS                                                               0x0018
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_LINK_CAP                                                                    0x0019
#define regBIF_CFG_DEV0_RC0_LINK_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_LINK_CNTL                                                                   0x001a
#define regBIF_CFG_DEV0_RC0_LINK_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_LINK_STATUS                                                                 0x001a
#define regBIF_CFG_DEV0_RC0_LINK_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_SLOT_CAP                                                                    0x001b
#define regBIF_CFG_DEV0_RC0_SLOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL                                                                   0x001c
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS                                                                 0x001c
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_ROOT_CNTL                                                                   0x001d
#define regBIF_CFG_DEV0_RC0_ROOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_ROOT_CAP                                                                    0x001d
#define regBIF_CFG_DEV0_RC0_ROOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_ROOT_STATUS                                                                 0x001e
#define regBIF_CFG_DEV0_RC0_ROOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP2                                                                 0x001f
#define regBIF_CFG_DEV0_RC0_DEVICE_CAP2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL2                                                                0x0020
#define regBIF_CFG_DEV0_RC0_DEVICE_CNTL2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS2                                                              0x0020
#define regBIF_CFG_DEV0_RC0_DEVICE_STATUS2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_LINK_CAP2                                                                   0x0021
#define regBIF_CFG_DEV0_RC0_LINK_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_LINK_CNTL2                                                                  0x0022
#define regBIF_CFG_DEV0_RC0_LINK_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_LINK_STATUS2                                                                0x0022
#define regBIF_CFG_DEV0_RC0_LINK_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_SLOT_CAP2                                                                   0x0023
#define regBIF_CFG_DEV0_RC0_SLOT_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL2                                                                  0x0024
#define regBIF_CFG_DEV0_RC0_SLOT_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS2                                                                0x0024
#define regBIF_CFG_DEV0_RC0_SLOT_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_CAP_LIST                                                                0x0028
#define regBIF_CFG_DEV0_RC0_MSI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_CNTL                                                                0x0028
#define regBIF_CFG_DEV0_RC0_MSI_MSG_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO                                                             0x0029
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI                                                             0x002a
#define regBIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA                                                                0x002a
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA                                                            0x002a
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA_64                                                             0x002b
#define regBIF_CFG_DEV0_RC0_MSI_MSG_DATA_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA_64                                                         0x002b
#define regBIF_CFG_DEV0_RC0_MSI_EXT_MSG_DATA_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_RC0_SSID_CAP_LIST                                                               0x0030
#define regBIF_CFG_DEV0_RC0_SSID_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_SSID_CAP                                                                    0x0031
#define regBIF_CFG_DEV0_RC0_SSID_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST                                                            0x0032
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP                                                                 0x0032
#define regBIF_CFG_DEV0_RC0_MSI_MAP_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                           0x0040
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                  5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR                                                    0x0041
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1                                                       0x0042
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2                                                       0x0043
#define regBIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST                                                        0x0044
#define regBIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1                                                       0x0045
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2                                                       0x0046
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL                                                           0x0047
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS                                                         0x0047
#define regBIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS_BASE_IDX                                                5
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP                                                       0x0048
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL                                                      0x0049
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS                                                    0x004a
#define regBIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP                                                       0x004b
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL                                                      0x004c
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS                                                    0x004d
#define regBIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                            0x0050
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1                                                     0x0051
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2                                                     0x0052
#define regBIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                               0x0054
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS                                                      0x0055
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK                                                        0x0056
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY                                                    0x0057
#define regBIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS                                                        0x0058
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK                                                          0x0059
#define regBIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL                                                       0x005a
#define regBIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG0                                                               0x005b
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG1                                                               0x005c
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG2                                                               0x005d
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG3                                                               0x005e
#define regBIF_CFG_DEV0_RC0_PCIE_HDR_LOG3_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD                                                           0x005f
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS                                                        0x0060
#define regBIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID                                                             0x0061
#define regBIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0                                                        0x0062
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1                                                        0x0063
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2                                                        0x0064
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3                                                        0x0065
#define regBIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                               5
#define regBIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST                                                 0x009c
#define regBIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3                                                             0x009d
#define regBIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS                                                      0x009e
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL                                               0x009f
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL                                               0x009f
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL                                               0x00a0
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL                                               0x00a0
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL                                               0x00a1
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL                                               0x00a1
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL                                               0x00a2
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL                                               0x00a2
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL                                               0x00a3
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL                                               0x00a3
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL                                              0x00a4
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL                                              0x00a4
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL                                              0x00a5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL                                              0x00a5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL                                              0x00a6
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL                                              0x00a6
#define regBIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST                                                       0x00a8
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CAP                                                                0x00a9
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CAP_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CNTL                                                               0x00a9
#define regBIF_CFG_DEV0_RC0_PCIE_ACS_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_DLF_ENH_CAP_LIST                                                       0x0100
#define regBIF_CFG_DEV0_RC0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_CAP                                                       0x0101
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_STATUS                                                    0x0102
#define regBIF_CFG_DEV0_RC0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_RC0_PCIE_PHY_16GT_ENH_CAP_LIST                                                  0x0104
#define regBIF_CFG_DEV0_RC0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LINK_CAP_16GT                                                               0x0105
#define regBIF_CFG_DEV0_RC0_LINK_CAP_16GT_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_RC0_LINK_CNTL_16GT                                                              0x0106
#define regBIF_CFG_DEV0_RC0_LINK_CNTL_16GT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_RC0_LINK_STATUS_16GT                                                            0x0107
#define regBIF_CFG_DEV0_RC0_LINK_STATUS_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                           0x0108
#define regBIF_CFG_DEV0_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT                                            0x0109
#define regBIF_CFG_DEV0_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT                                            0x010a
#define regBIF_CFG_DEV0_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_RC0_LANE_0_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_1_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_2_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_3_EQUALIZATION_CNTL_16GT                                               0x010c
#define regBIF_CFG_DEV0_RC0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_4_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_5_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_6_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_7_EQUALIZATION_CNTL_16GT                                               0x010d
#define regBIF_CFG_DEV0_RC0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_8_EQUALIZATION_CNTL_16GT                                               0x010e
#define regBIF_CFG_DEV0_RC0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_9_EQUALIZATION_CNTL_16GT                                               0x010e
#define regBIF_CFG_DEV0_RC0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_10_EQUALIZATION_CNTL_16GT                                              0x010e
#define regBIF_CFG_DEV0_RC0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_11_EQUALIZATION_CNTL_16GT                                              0x010e
#define regBIF_CFG_DEV0_RC0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_12_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_13_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_14_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_LANE_15_EQUALIZATION_CNTL_16GT                                              0x010f
#define regBIF_CFG_DEV0_RC0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_RC0_PCIE_MARGINING_ENH_CAP_LIST                                                 0x0114
#define regBIF_CFG_DEV0_RC0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_CAP                                                          0x0115
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_CAP_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_STATUS                                                       0x0115
#define regBIF_CFG_DEV0_RC0_MARGINING_PORT_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_CNTL                                                  0x0116
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_STATUS                                                0x0116
#define regBIF_CFG_DEV0_RC0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_CNTL                                                  0x0117
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_STATUS                                                0x0117
#define regBIF_CFG_DEV0_RC0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_CNTL                                                  0x0118
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_STATUS                                                0x0118
#define regBIF_CFG_DEV0_RC0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_CNTL                                                  0x0119
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_STATUS                                                0x0119
#define regBIF_CFG_DEV0_RC0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_CNTL                                                  0x011a
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_STATUS                                                0x011a
#define regBIF_CFG_DEV0_RC0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_CNTL                                                  0x011b
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_STATUS                                                0x011b
#define regBIF_CFG_DEV0_RC0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_CNTL                                                  0x011c
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_STATUS                                                0x011c
#define regBIF_CFG_DEV0_RC0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_CNTL                                                  0x011d
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_STATUS                                                0x011d
#define regBIF_CFG_DEV0_RC0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_CNTL                                                  0x011e
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_STATUS                                                0x011e
#define regBIF_CFG_DEV0_RC0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_CNTL                                                  0x011f
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_STATUS                                                0x011f
#define regBIF_CFG_DEV0_RC0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_CNTL                                                 0x0120
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_STATUS                                               0x0120
#define regBIF_CFG_DEV0_RC0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_CNTL                                                 0x0121
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_STATUS                                               0x0121
#define regBIF_CFG_DEV0_RC0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_CNTL                                                 0x0122
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_STATUS                                               0x0122
#define regBIF_CFG_DEV0_RC0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_CNTL                                                 0x0123
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_STATUS                                               0x0123
#define regBIF_CFG_DEV0_RC0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_CNTL                                                 0x0124
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_STATUS                                               0x0124
#define regBIF_CFG_DEV0_RC0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_CNTL                                                 0x0125
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_STATUS                                               0x0125
#define regBIF_CFG_DEV0_RC0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_RC0_PCIE_RTR_ENH_CAP_LIST                                                       0x015c
#define regBIF_CFG_DEV0_RC0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_RC0_RTR_DATA1                                                                   0x015d
#define regBIF_CFG_DEV0_RC0_RTR_DATA1_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_RC0_RTR_DATA2                                                                   0x015e
#define regBIF_CFG_DEV0_RC0_RTR_DATA2_BASE_IDX                                                          5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x10140000
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_ID                                                                0x10000
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_ID                                                                0x10000
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_COMMAND                                                                  0x10001
#define regBIF_CFG_DEV0_EPF0_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_STATUS                                                                   0x10001
#define regBIF_CFG_DEV0_EPF0_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_0_REVISION_ID                                                              0x10002
#define regBIF_CFG_DEV0_EPF0_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_PROG_INTERFACE                                                           0x10002
#define regBIF_CFG_DEV0_EPF0_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_SUB_CLASS                                                                0x10002
#define regBIF_CFG_DEV0_EPF0_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_BASE_CLASS                                                               0x10002
#define regBIF_CFG_DEV0_EPF0_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_CACHE_LINE                                                               0x10003
#define regBIF_CFG_DEV0_EPF0_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_LATENCY                                                                  0x10003
#define regBIF_CFG_DEV0_EPF0_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_HEADER                                                                   0x10003
#define regBIF_CFG_DEV0_EPF0_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_0_BIST                                                                     0x10003
#define regBIF_CFG_DEV0_EPF0_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_1                                                              0x10004
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_2                                                              0x10005
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_3                                                              0x10006
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_4                                                              0x10007
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_5                                                              0x10008
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_6                                                              0x10009
#define regBIF_CFG_DEV0_EPF0_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID                                                               0x1000b
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_ROM_BASE_ADDR                                                            0x1000c
#define regBIF_CFG_DEV0_EPF0_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_CAP_PTR                                                                  0x1000d
#define regBIF_CFG_DEV0_EPF0_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_LINE                                                           0x1000f
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_PIN                                                            0x1000f
#define regBIF_CFG_DEV0_EPF0_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_MIN_GRANT                                                                0x1000f
#define regBIF_CFG_DEV0_EPF0_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_MAX_LATENCY                                                              0x1000f
#define regBIF_CFG_DEV0_EPF0_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_CAP_LIST                                                          0x10012
#define regBIF_CFG_DEV0_EPF0_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_W                                                             0x10013
#define regBIF_CFG_DEV0_EPF0_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP_LIST                                                             0x10014
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP                                                                  0x10014
#define regBIF_CFG_DEV0_EPF0_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_0_PMI_STATUS_CNTL                                                          0x10015
#define regBIF_CFG_DEV0_EPF0_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP_LIST                                                            0x10019
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP                                                                 0x10019
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP                                                               0x1001a
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL                                                              0x1001b
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS                                                            0x1001b
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP                                                                 0x1001c
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL                                                                0x1001d
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS                                                              0x1001d
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP2                                                              0x10022
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL2                                                             0x10023
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS2                                                           0x10023
#define regBIF_CFG_DEV0_EPF0_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP2                                                                0x10024
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL2                                                               0x10025
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS2                                                             0x10025
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_CAP_LIST                                                             0x10028
#define regBIF_CFG_DEV0_EPF0_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_CNTL                                                             0x10028
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_LO                                                          0x10029
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_HI                                                          0x1002a
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA                                                             0x1002a
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA                                                         0x1002a
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK                                                                 0x1002b
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_64                                                          0x1002b
#define regBIF_CFG_DEV0_EPF0_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA_64                                                      0x1002b
#define regBIF_CFG_DEV0_EPF0_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK_64                                                              0x1002c
#define regBIF_CFG_DEV0_EPF0_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING                                                              0x1002c
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING_64                                                           0x1002d
#define regBIF_CFG_DEV0_EPF0_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_CAP_LIST                                                            0x10030
#define regBIF_CFG_DEV0_EPF0_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_MSG_CNTL                                                            0x10030
#define regBIF_CFG_DEV0_EPF0_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_TABLE                                                               0x10031
#define regBIF_CFG_DEV0_EPF0_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_0_MSIX_PBA                                                                 0x10032
#define regBIF_CFG_DEV0_EPF0_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x10040
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x10041
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC1                                                    0x10042
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC2                                                    0x10043
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC_ENH_CAP_LIST                                                     0x10044
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG1                                                    0x10045
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG2                                                    0x10046
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CNTL                                                        0x10047
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_CNTL_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_STATUS                                                      0x10047
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PORT_VC_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CAP                                                    0x10048
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CNTL                                                   0x10049
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_STATUS                                                 0x1004a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CAP                                                    0x1004b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CNTL                                                   0x1004c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_STATUS                                                 0x1004d
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                         0x10050
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW1                                                  0x10051
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW2                                                  0x10052
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x10054
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_STATUS                                                   0x10055
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_MASK                                                     0x10056
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x10057
#define regBIF_CFG_DEV0_EPF0_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_STATUS                                                     0x10058
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_MASK                                                       0x10059
#define regBIF_CFG_DEV0_EPF0_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1005a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG0                                                            0x1005b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG1                                                            0x1005c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG2                                                            0x1005d
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG3                                                            0x1005e
#define regBIF_CFG_DEV0_EPF0_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG0                                                     0x10062
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG1                                                     0x10063
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG2                                                     0x10064
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG3                                                     0x10065
#define regBIF_CFG_DEV0_EPF0_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR_ENH_CAP_LIST                                                    0x10080
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CAP                                                            0x10081
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CNTL                                                           0x10082
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CAP                                                            0x10083
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CNTL                                                           0x10084
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CAP                                                            0x10085
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CNTL                                                           0x10086
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CAP                                                            0x10087
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CNTL                                                           0x10088
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CAP                                                            0x10089
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CNTL                                                           0x1008a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CAP                                                            0x1008b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CNTL                                                           0x1008c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x10090
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x10091
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA                                                     0x10092
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_CAP                                                      0x10093
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_ENH_CAP_LIST                                                    0x10094
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CAP                                                             0x10095
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_LATENCY_INDICATOR                                               0x10096
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_STATUS                                                          0x10097
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CNTL                                                            0x10097
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x10098
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x10098
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x10098
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x10098
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x10099
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x10099
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x10099
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x10099
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST                                              0x1009c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LINK_CNTL3                                                          0x1009d
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LINK_CNTL3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_ERROR_STATUS                                                   0x1009e
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL                                            0x1009f
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL                                            0x1009f
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL                                            0x100a0
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL                                            0x100a0
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL                                            0x100a1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL                                            0x100a1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL                                            0x100a2
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL                                            0x100a2
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL                                            0x100a3
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL                                            0x100a3
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL                                           0x100a4
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL                                           0x100a4
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL                                           0x100a5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL                                           0x100a5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL                                           0x100a6
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL                                           0x100a6
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ACS_ENH_CAP_LIST                                                    0x100a8
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ACS_CAP                                                             0x100a9
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ACS_CNTL                                                            0x100a9
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ATS_ENH_CAP_LIST                                                    0x100ac
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ATS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ATS_CAP                                                             0x100ad
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ATS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ATS_CNTL                                                            0x100ad
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ATS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_ENH_CAP_LIST                                               0x100b0
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_CNTL                                                       0x100b1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_CNTL_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_STATUS                                                     0x100b1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PAGE_REQ_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY                                          0x100b2
#define regBIF_CFG_DEV0_EPF0_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC                                             0x100b3
#define regBIF_CFG_DEV0_EPF0_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PASID_ENH_CAP_LIST                                                  0x100b4
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PASID_CAP                                                           0x100b5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PASID_CNTL                                                          0x100b5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_ENH_CAP_LIST                                                     0x100bc
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_ENH_CAP_LIST_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_CAP                                                              0x100bd
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_CNTL                                                             0x100bd
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_ADDR0                                                            0x100be
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_ADDR0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_ADDR1                                                            0x100bf
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_ADDR1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_RCV0                                                             0x100c0
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_RCV0_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_RCV1                                                             0x100c1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_RCV1_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_ALL0                                                       0x100c2
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_ALL0_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_ALL1                                                       0x100c3
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_ALL1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_UNTRANSLATED_0                                             0x100c4
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_UNTRANSLATED_0_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_UNTRANSLATED_1                                             0x100c5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MC_BLOCK_UNTRANSLATED_1_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LTR_ENH_CAP_LIST                                                    0x100c8
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LTR_CAP                                                             0x100c9
#define regBIF_CFG_DEV0_EPF0_0_PCIE_LTR_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ARI_ENH_CAP_LIST                                                    0x100ca
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ARI_CAP                                                             0x100cb
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ARI_CNTL                                                            0x100cb
#define regBIF_CFG_DEV0_EPF0_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_ENH_CAP_LIST                                                  0x100cc
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_CAP                                                           0x100cd
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_CONTROL                                                       0x100ce
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_CONTROL_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_STATUS                                                        0x100ce
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_INITIAL_VFS                                                   0x100cf
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_INITIAL_VFS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_TOTAL_VFS                                                     0x100cf
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_TOTAL_VFS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_NUM_VFS                                                       0x100d0
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_NUM_VFS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_FUNC_DEP_LINK                                                 0x100d0
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_FUNC_DEP_LINK_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_FIRST_VF_OFFSET                                               0x100d1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_FIRST_VF_OFFSET_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_STRIDE                                                     0x100d1
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_STRIDE_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_DEVICE_ID                                                  0x100d2
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_DEVICE_ID_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                           0x100d3
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                              0x100d4
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_0                                                0x100d5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_0_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_1                                                0x100d6
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_1_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_2                                                0x100d7
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_2_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_3                                                0x100d8
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_3_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_4                                                0x100d9
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_4_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_5                                                0x100da
#define regBIF_CFG_DEV0_EPF0_0_PCIE_SRIOV_VF_BASE_ADDR_5_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DLF_ENH_CAP_LIST                                                    0x10100
#define regBIF_CFG_DEV0_EPF0_0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_DATA_LINK_FEATURE_CAP                                                    0x10101
#define regBIF_CFG_DEV0_EPF0_0_DATA_LINK_FEATURE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_DATA_LINK_FEATURE_STATUS                                                 0x10102
#define regBIF_CFG_DEV0_EPF0_0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PHY_16GT_ENH_CAP_LIST                                               0x10104
#define regBIF_CFG_DEV0_EPF0_0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP_16GT                                                            0x10105
#define regBIF_CFG_DEV0_EPF0_0_LINK_CAP_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL_16GT                                                           0x10106
#define regBIF_CFG_DEV0_EPF0_0_LINK_CNTL_16GT_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS_16GT                                                         0x10107
#define regBIF_CFG_DEV0_EPF0_0_LINK_STATUS_16GT_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                        0x10108
#define regBIF_CFG_DEV0_EPF0_0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF0_0_RTM1_PARITY_MISMATCH_STATUS_16GT                                         0x10109
#define regBIF_CFG_DEV0_EPF0_0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF0_0_RTM2_PARITY_MISMATCH_STATUS_16GT                                         0x1010a
#define regBIF_CFG_DEV0_EPF0_0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF0_0_LANE_0_EQUALIZATION_CNTL_16GT                                            0x1010c
#define regBIF_CFG_DEV0_EPF0_0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_1_EQUALIZATION_CNTL_16GT                                            0x1010c
#define regBIF_CFG_DEV0_EPF0_0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_2_EQUALIZATION_CNTL_16GT                                            0x1010c
#define regBIF_CFG_DEV0_EPF0_0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_3_EQUALIZATION_CNTL_16GT                                            0x1010c
#define regBIF_CFG_DEV0_EPF0_0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_4_EQUALIZATION_CNTL_16GT                                            0x1010d
#define regBIF_CFG_DEV0_EPF0_0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_5_EQUALIZATION_CNTL_16GT                                            0x1010d
#define regBIF_CFG_DEV0_EPF0_0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_6_EQUALIZATION_CNTL_16GT                                            0x1010d
#define regBIF_CFG_DEV0_EPF0_0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_7_EQUALIZATION_CNTL_16GT                                            0x1010d
#define regBIF_CFG_DEV0_EPF0_0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_8_EQUALIZATION_CNTL_16GT                                            0x1010e
#define regBIF_CFG_DEV0_EPF0_0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_9_EQUALIZATION_CNTL_16GT                                            0x1010e
#define regBIF_CFG_DEV0_EPF0_0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_10_EQUALIZATION_CNTL_16GT                                           0x1010e
#define regBIF_CFG_DEV0_EPF0_0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_LANE_11_EQUALIZATION_CNTL_16GT                                           0x1010e
#define regBIF_CFG_DEV0_EPF0_0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_LANE_12_EQUALIZATION_CNTL_16GT                                           0x1010f
#define regBIF_CFG_DEV0_EPF0_0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_LANE_13_EQUALIZATION_CNTL_16GT                                           0x1010f
#define regBIF_CFG_DEV0_EPF0_0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_LANE_14_EQUALIZATION_CNTL_16GT                                           0x1010f
#define regBIF_CFG_DEV0_EPF0_0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_LANE_15_EQUALIZATION_CNTL_16GT                                           0x1010f
#define regBIF_CFG_DEV0_EPF0_0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MARGINING_ENH_CAP_LIST                                              0x10114
#define regBIF_CFG_DEV0_EPF0_0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_MARGINING_PORT_CAP                                                       0x10115
#define regBIF_CFG_DEV0_EPF0_0_MARGINING_PORT_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_0_MARGINING_PORT_STATUS                                                    0x10115
#define regBIF_CFG_DEV0_EPF0_0_MARGINING_PORT_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_LANE_0_MARGINING_LANE_CNTL                                               0x10116
#define regBIF_CFG_DEV0_EPF0_0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_0_MARGINING_LANE_STATUS                                             0x10116
#define regBIF_CFG_DEV0_EPF0_0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_1_MARGINING_LANE_CNTL                                               0x10117
#define regBIF_CFG_DEV0_EPF0_0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_1_MARGINING_LANE_STATUS                                             0x10117
#define regBIF_CFG_DEV0_EPF0_0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_2_MARGINING_LANE_CNTL                                               0x10118
#define regBIF_CFG_DEV0_EPF0_0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_2_MARGINING_LANE_STATUS                                             0x10118
#define regBIF_CFG_DEV0_EPF0_0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_3_MARGINING_LANE_CNTL                                               0x10119
#define regBIF_CFG_DEV0_EPF0_0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_3_MARGINING_LANE_STATUS                                             0x10119
#define regBIF_CFG_DEV0_EPF0_0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_4_MARGINING_LANE_CNTL                                               0x1011a
#define regBIF_CFG_DEV0_EPF0_0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_4_MARGINING_LANE_STATUS                                             0x1011a
#define regBIF_CFG_DEV0_EPF0_0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_5_MARGINING_LANE_CNTL                                               0x1011b
#define regBIF_CFG_DEV0_EPF0_0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_5_MARGINING_LANE_STATUS                                             0x1011b
#define regBIF_CFG_DEV0_EPF0_0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_6_MARGINING_LANE_CNTL                                               0x1011c
#define regBIF_CFG_DEV0_EPF0_0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_6_MARGINING_LANE_STATUS                                             0x1011c
#define regBIF_CFG_DEV0_EPF0_0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_7_MARGINING_LANE_CNTL                                               0x1011d
#define regBIF_CFG_DEV0_EPF0_0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_7_MARGINING_LANE_STATUS                                             0x1011d
#define regBIF_CFG_DEV0_EPF0_0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_8_MARGINING_LANE_CNTL                                               0x1011e
#define regBIF_CFG_DEV0_EPF0_0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_8_MARGINING_LANE_STATUS                                             0x1011e
#define regBIF_CFG_DEV0_EPF0_0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_9_MARGINING_LANE_CNTL                                               0x1011f
#define regBIF_CFG_DEV0_EPF0_0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_0_LANE_9_MARGINING_LANE_STATUS                                             0x1011f
#define regBIF_CFG_DEV0_EPF0_0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_0_LANE_10_MARGINING_LANE_CNTL                                              0x10120
#define regBIF_CFG_DEV0_EPF0_0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_LANE_10_MARGINING_LANE_STATUS                                            0x10120
#define regBIF_CFG_DEV0_EPF0_0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_11_MARGINING_LANE_CNTL                                              0x10121
#define regBIF_CFG_DEV0_EPF0_0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_LANE_11_MARGINING_LANE_STATUS                                            0x10121
#define regBIF_CFG_DEV0_EPF0_0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_12_MARGINING_LANE_CNTL                                              0x10122
#define regBIF_CFG_DEV0_EPF0_0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_LANE_12_MARGINING_LANE_STATUS                                            0x10122
#define regBIF_CFG_DEV0_EPF0_0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_13_MARGINING_LANE_CNTL                                              0x10123
#define regBIF_CFG_DEV0_EPF0_0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_LANE_13_MARGINING_LANE_STATUS                                            0x10123
#define regBIF_CFG_DEV0_EPF0_0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_14_MARGINING_LANE_CNTL                                              0x10124
#define regBIF_CFG_DEV0_EPF0_0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_LANE_14_MARGINING_LANE_STATUS                                            0x10124
#define regBIF_CFG_DEV0_EPF0_0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_LANE_15_MARGINING_LANE_CNTL                                              0x10125
#define regBIF_CFG_DEV0_EPF0_0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_0_LANE_15_MARGINING_LANE_STATUS                                            0x10125
#define regBIF_CFG_DEV0_EPF0_0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                          0x10130
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR1_CAP                                                  0x10131
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR1_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR1_CNTL                                                 0x10132
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR1_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR2_CAP                                                  0x10133
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR2_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR2_CNTL                                                 0x10134
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR2_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR3_CAP                                                  0x10135
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR3_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR3_CNTL                                                 0x10136
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR3_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR4_CAP                                                  0x10137
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR4_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR4_CNTL                                                 0x10138
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR4_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR5_CAP                                                  0x10139
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR5_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR5_CNTL                                                 0x1013a
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR5_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR6_CAP                                                  0x1013b
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR6_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR6_CNTL                                                 0x1013c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VF_RESIZE_BAR6_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1015c
#define regBIF_CFG_DEV0_EPF0_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_0_RTR_DATA1                                                                0x1015d
#define regBIF_CFG_DEV0_EPF0_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_RTR_DATA2                                                                0x1015e
#define regBIF_CFG_DEV0_EPF0_0_RTR_DATA2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV                                 0x10160
#define regBIF_CFG_DEV0_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV_BASE_IDX                        5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf1_bifcfgdecp
// base address: 0x10141000
#define regBIF_CFG_DEV0_EPF1_0_VENDOR_ID                                                                0x10400
#define regBIF_CFG_DEV0_EPF1_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_ID                                                                0x10400
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_COMMAND                                                                  0x10401
#define regBIF_CFG_DEV0_EPF1_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_0_STATUS                                                                   0x10401
#define regBIF_CFG_DEV0_EPF1_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF1_0_REVISION_ID                                                              0x10402
#define regBIF_CFG_DEV0_EPF1_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_PROG_INTERFACE                                                           0x10402
#define regBIF_CFG_DEV0_EPF1_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_SUB_CLASS                                                                0x10402
#define regBIF_CFG_DEV0_EPF1_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_BASE_CLASS                                                               0x10402
#define regBIF_CFG_DEV0_EPF1_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_0_CACHE_LINE                                                               0x10403
#define regBIF_CFG_DEV0_EPF1_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_0_LATENCY                                                                  0x10403
#define regBIF_CFG_DEV0_EPF1_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_0_HEADER                                                                   0x10403
#define regBIF_CFG_DEV0_EPF1_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF1_0_BIST                                                                     0x10403
#define regBIF_CFG_DEV0_EPF1_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_1                                                              0x10404
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_2                                                              0x10405
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_3                                                              0x10406
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_4                                                              0x10407
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_5                                                              0x10408
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_6                                                              0x10409
#define regBIF_CFG_DEV0_EPF1_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_ADAPTER_ID                                                               0x1040b
#define regBIF_CFG_DEV0_EPF1_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_0_ROM_BASE_ADDR                                                            0x1040c
#define regBIF_CFG_DEV0_EPF1_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_CAP_PTR                                                                  0x1040d
#define regBIF_CFG_DEV0_EPF1_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_0_INTERRUPT_LINE                                                           0x1040f
#define regBIF_CFG_DEV0_EPF1_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_INTERRUPT_PIN                                                            0x1040f
#define regBIF_CFG_DEV0_EPF1_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_MIN_GRANT                                                                0x1040f
#define regBIF_CFG_DEV0_EPF1_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_MAX_LATENCY                                                              0x1040f
#define regBIF_CFG_DEV0_EPF1_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST                                                          0x10412
#define regBIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W                                                             0x10413
#define regBIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST                                                             0x10414
#define regBIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PMI_CAP                                                                  0x10414
#define regBIF_CFG_DEV0_EPF1_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL                                                          0x10415
#define regBIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST                                                            0x10419
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CAP                                                                 0x10419
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CAP                                                               0x1041a
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CNTL                                                              0x1041b
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_STATUS                                                            0x1041b
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_LINK_CAP                                                                 0x1041c
#define regBIF_CFG_DEV0_EPF1_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_0_LINK_CNTL                                                                0x1041d
#define regBIF_CFG_DEV0_EPF1_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_LINK_STATUS                                                              0x1041d
#define regBIF_CFG_DEV0_EPF1_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CAP2                                                              0x10422
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2                                                             0x10423
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_STATUS2                                                           0x10423
#define regBIF_CFG_DEV0_EPF1_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_LINK_CAP2                                                                0x10424
#define regBIF_CFG_DEV0_EPF1_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_LINK_CNTL2                                                               0x10425
#define regBIF_CFG_DEV0_EPF1_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_0_LINK_STATUS2                                                             0x10425
#define regBIF_CFG_DEV0_EPF1_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST                                                             0x10428
#define regBIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL                                                             0x10428
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_LO                                                          0x10429
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_HI                                                          0x1042a
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA                                                             0x1042a
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_MSI_EXT_MSG_DATA                                                         0x1042a
#define regBIF_CFG_DEV0_EPF1_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MASK                                                                 0x1042b
#define regBIF_CFG_DEV0_EPF1_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_64                                                          0x1042b
#define regBIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_MSI_EXT_MSG_DATA_64                                                      0x1042b
#define regBIF_CFG_DEV0_EPF1_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_0_MSI_MASK_64                                                              0x1042c
#define regBIF_CFG_DEV0_EPF1_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_MSI_PENDING                                                              0x1042c
#define regBIF_CFG_DEV0_EPF1_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_MSI_PENDING_64                                                           0x1042d
#define regBIF_CFG_DEV0_EPF1_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST                                                            0x10430
#define regBIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL                                                            0x10430
#define regBIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_MSIX_TABLE                                                               0x10431
#define regBIF_CFG_DEV0_EPF1_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_0_MSIX_PBA                                                                 0x10432
#define regBIF_CFG_DEV0_EPF1_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x10440
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x10441
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC1                                                    0x10442
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC2                                                    0x10443
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                         0x10450
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW1                                                  0x10451
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW2                                                  0x10452
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x10454
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS                                                   0x10455
#define regBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK                                                     0x10456
#define regBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x10457
#define regBIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS                                                     0x10458
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK                                                       0x10459
#define regBIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1045a
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG0                                                            0x1045b
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG1                                                            0x1045c
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG2                                                            0x1045d
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG3                                                            0x1045e
#define regBIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG0                                                     0x10462
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG1                                                     0x10463
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG2                                                     0x10464
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG3                                                     0x10465
#define regBIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST                                                    0x10480
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CAP                                                            0x10481
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL                                                           0x10482
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CAP                                                            0x10483
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL                                                           0x10484
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CAP                                                            0x10485
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL                                                           0x10486
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CAP                                                            0x10487
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL                                                           0x10488
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CAP                                                            0x10489
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL                                                           0x1048a
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CAP                                                            0x1048b
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL                                                           0x1048c
#define regBIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x10490
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x10491
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA                                                     0x10492
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_CAP                                                      0x10493
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST                                                    0x10494
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP                                                             0x10495
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_LATENCY_INDICATOR                                               0x10496
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS                                                          0x10497
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_CNTL                                                            0x10497
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x10498
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x10498
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x10498
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x10498
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x10499
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x10499
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x10499
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x10499
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST                                              0x1049c
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3                                                          0x1049d
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS                                                   0x1049e
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL                                            0x1049f
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL                                            0x1049f
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL                                            0x104a0
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL                                            0x104a0
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL                                            0x104a1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL                                            0x104a1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL                                            0x104a2
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL                                            0x104a2
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL                                            0x104a3
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL                                            0x104a3
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL                                           0x104a4
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL                                           0x104a4
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL                                           0x104a5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL                                           0x104a5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL                                           0x104a6
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL                                           0x104a6
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST                                                    0x104a8
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP                                                             0x104a9
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL                                                            0x104a9
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST                                                    0x104ac
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP                                                             0x104ad
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL                                                            0x104ad
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST                                               0x104b0
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL                                                       0x104b1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS                                                     0x104b1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY                                          0x104b2
#define regBIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC                                             0x104b3
#define regBIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST                                                  0x104b4
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP                                                           0x104b5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL                                                          0x104b5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST                                                     0x104bc
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP                                                              0x104bd
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL                                                             0x104bd
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0                                                            0x104be
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR1                                                            0x104bf
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV0                                                             0x104c0
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV0_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV1                                                             0x104c1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV1_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL0                                                       0x104c2
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL0_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL1                                                       0x104c3
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_0                                             0x104c4
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_0_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_1                                             0x104c5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_1_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST                                                    0x104c8
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP                                                             0x104c9
#define regBIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST                                                    0x104ca
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP                                                             0x104cb
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL                                                            0x104cb
#define regBIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST                                                  0x104cc
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP                                                           0x104cd
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL                                                       0x104ce
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_STATUS                                                        0x104ce
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_INITIAL_VFS                                                   0x104cf
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_INITIAL_VFS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_TOTAL_VFS                                                     0x104cf
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_TOTAL_VFS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_NUM_VFS                                                       0x104d0
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_NUM_VFS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK                                                 0x104d0
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET                                               0x104d1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_STRIDE                                                     0x104d1
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_STRIDE_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID                                                  0x104d2
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                           0x104d3
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                              0x104d4
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0                                                0x104d5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1                                                0x104d6
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2                                                0x104d7
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3                                                0x104d8
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4                                                0x104d9
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5                                                0x104da
#define regBIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DLF_ENH_CAP_LIST                                                    0x10500
#define regBIF_CFG_DEV0_EPF1_0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_DATA_LINK_FEATURE_CAP                                                    0x10501
#define regBIF_CFG_DEV0_EPF1_0_DATA_LINK_FEATURE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_DATA_LINK_FEATURE_STATUS                                                 0x10502
#define regBIF_CFG_DEV0_EPF1_0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PHY_16GT_ENH_CAP_LIST                                               0x10504
#define regBIF_CFG_DEV0_EPF1_0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LINK_CAP_16GT                                                            0x10505
#define regBIF_CFG_DEV0_EPF1_0_LINK_CAP_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_0_LINK_CNTL_16GT                                                           0x10506
#define regBIF_CFG_DEV0_EPF1_0_LINK_CNTL_16GT_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_0_LINK_STATUS_16GT                                                         0x10507
#define regBIF_CFG_DEV0_EPF1_0_LINK_STATUS_16GT_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF1_0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                        0x10508
#define regBIF_CFG_DEV0_EPF1_0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF1_0_RTM1_PARITY_MISMATCH_STATUS_16GT                                         0x10509
#define regBIF_CFG_DEV0_EPF1_0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF1_0_RTM2_PARITY_MISMATCH_STATUS_16GT                                         0x1050a
#define regBIF_CFG_DEV0_EPF1_0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV0_EPF1_0_LANE_0_EQUALIZATION_CNTL_16GT                                            0x1050c
#define regBIF_CFG_DEV0_EPF1_0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_1_EQUALIZATION_CNTL_16GT                                            0x1050c
#define regBIF_CFG_DEV0_EPF1_0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_2_EQUALIZATION_CNTL_16GT                                            0x1050c
#define regBIF_CFG_DEV0_EPF1_0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_3_EQUALIZATION_CNTL_16GT                                            0x1050c
#define regBIF_CFG_DEV0_EPF1_0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_4_EQUALIZATION_CNTL_16GT                                            0x1050d
#define regBIF_CFG_DEV0_EPF1_0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_5_EQUALIZATION_CNTL_16GT                                            0x1050d
#define regBIF_CFG_DEV0_EPF1_0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_6_EQUALIZATION_CNTL_16GT                                            0x1050d
#define regBIF_CFG_DEV0_EPF1_0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_7_EQUALIZATION_CNTL_16GT                                            0x1050d
#define regBIF_CFG_DEV0_EPF1_0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_8_EQUALIZATION_CNTL_16GT                                            0x1050e
#define regBIF_CFG_DEV0_EPF1_0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_9_EQUALIZATION_CNTL_16GT                                            0x1050e
#define regBIF_CFG_DEV0_EPF1_0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_10_EQUALIZATION_CNTL_16GT                                           0x1050e
#define regBIF_CFG_DEV0_EPF1_0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_LANE_11_EQUALIZATION_CNTL_16GT                                           0x1050e
#define regBIF_CFG_DEV0_EPF1_0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_LANE_12_EQUALIZATION_CNTL_16GT                                           0x1050f
#define regBIF_CFG_DEV0_EPF1_0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_LANE_13_EQUALIZATION_CNTL_16GT                                           0x1050f
#define regBIF_CFG_DEV0_EPF1_0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_LANE_14_EQUALIZATION_CNTL_16GT                                           0x1050f
#define regBIF_CFG_DEV0_EPF1_0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_LANE_15_EQUALIZATION_CNTL_16GT                                           0x1050f
#define regBIF_CFG_DEV0_EPF1_0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MARGINING_ENH_CAP_LIST                                              0x10514
#define regBIF_CFG_DEV0_EPF1_0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_MARGINING_PORT_CAP                                                       0x10515
#define regBIF_CFG_DEV0_EPF1_0_MARGINING_PORT_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_0_MARGINING_PORT_STATUS                                                    0x10515
#define regBIF_CFG_DEV0_EPF1_0_MARGINING_PORT_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_LANE_0_MARGINING_LANE_CNTL                                               0x10516
#define regBIF_CFG_DEV0_EPF1_0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_0_MARGINING_LANE_STATUS                                             0x10516
#define regBIF_CFG_DEV0_EPF1_0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_1_MARGINING_LANE_CNTL                                               0x10517
#define regBIF_CFG_DEV0_EPF1_0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_1_MARGINING_LANE_STATUS                                             0x10517
#define regBIF_CFG_DEV0_EPF1_0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_2_MARGINING_LANE_CNTL                                               0x10518
#define regBIF_CFG_DEV0_EPF1_0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_2_MARGINING_LANE_STATUS                                             0x10518
#define regBIF_CFG_DEV0_EPF1_0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_3_MARGINING_LANE_CNTL                                               0x10519
#define regBIF_CFG_DEV0_EPF1_0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_3_MARGINING_LANE_STATUS                                             0x10519
#define regBIF_CFG_DEV0_EPF1_0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_4_MARGINING_LANE_CNTL                                               0x1051a
#define regBIF_CFG_DEV0_EPF1_0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_4_MARGINING_LANE_STATUS                                             0x1051a
#define regBIF_CFG_DEV0_EPF1_0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_5_MARGINING_LANE_CNTL                                               0x1051b
#define regBIF_CFG_DEV0_EPF1_0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_5_MARGINING_LANE_STATUS                                             0x1051b
#define regBIF_CFG_DEV0_EPF1_0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_6_MARGINING_LANE_CNTL                                               0x1051c
#define regBIF_CFG_DEV0_EPF1_0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_6_MARGINING_LANE_STATUS                                             0x1051c
#define regBIF_CFG_DEV0_EPF1_0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_7_MARGINING_LANE_CNTL                                               0x1051d
#define regBIF_CFG_DEV0_EPF1_0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_7_MARGINING_LANE_STATUS                                             0x1051d
#define regBIF_CFG_DEV0_EPF1_0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_8_MARGINING_LANE_CNTL                                               0x1051e
#define regBIF_CFG_DEV0_EPF1_0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_8_MARGINING_LANE_STATUS                                             0x1051e
#define regBIF_CFG_DEV0_EPF1_0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_9_MARGINING_LANE_CNTL                                               0x1051f
#define regBIF_CFG_DEV0_EPF1_0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_0_LANE_9_MARGINING_LANE_STATUS                                             0x1051f
#define regBIF_CFG_DEV0_EPF1_0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_0_LANE_10_MARGINING_LANE_CNTL                                              0x10520
#define regBIF_CFG_DEV0_EPF1_0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_LANE_10_MARGINING_LANE_STATUS                                            0x10520
#define regBIF_CFG_DEV0_EPF1_0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_11_MARGINING_LANE_CNTL                                              0x10521
#define regBIF_CFG_DEV0_EPF1_0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_LANE_11_MARGINING_LANE_STATUS                                            0x10521
#define regBIF_CFG_DEV0_EPF1_0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_12_MARGINING_LANE_CNTL                                              0x10522
#define regBIF_CFG_DEV0_EPF1_0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_LANE_12_MARGINING_LANE_STATUS                                            0x10522
#define regBIF_CFG_DEV0_EPF1_0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_13_MARGINING_LANE_CNTL                                              0x10523
#define regBIF_CFG_DEV0_EPF1_0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_LANE_13_MARGINING_LANE_STATUS                                            0x10523
#define regBIF_CFG_DEV0_EPF1_0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_14_MARGINING_LANE_CNTL                                              0x10524
#define regBIF_CFG_DEV0_EPF1_0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_LANE_14_MARGINING_LANE_STATUS                                            0x10524
#define regBIF_CFG_DEV0_EPF1_0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_LANE_15_MARGINING_LANE_CNTL                                              0x10525
#define regBIF_CFG_DEV0_EPF1_0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_0_LANE_15_MARGINING_LANE_STATUS                                            0x10525
#define regBIF_CFG_DEV0_EPF1_0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                          0x10530
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR1_CAP                                                  0x10531
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR1_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR1_CNTL                                                 0x10532
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR1_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR2_CAP                                                  0x10533
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR2_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR2_CNTL                                                 0x10534
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR2_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR3_CAP                                                  0x10535
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR3_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR3_CNTL                                                 0x10536
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR3_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR4_CAP                                                  0x10537
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR4_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR4_CNTL                                                 0x10538
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR4_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR5_CAP                                                  0x10539
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR5_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR5_CNTL                                                 0x1053a
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR5_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR6_CAP                                                  0x1053b
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR6_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR6_CNTL                                                 0x1053c
#define regBIF_CFG_DEV0_EPF1_0_PCIE_VF_RESIZE_BAR6_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1055c
#define regBIF_CFG_DEV0_EPF1_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_0_RTR_DATA1                                                                0x1055d
#define regBIF_CFG_DEV0_EPF1_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_0_RTR_DATA2                                                                0x1055e
#define regBIF_CFG_DEV0_EPF1_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf2_bifcfgdecp
// base address: 0x10142000
#define regBIF_CFG_DEV0_EPF2_0_VENDOR_ID                                                                0x10800
#define regBIF_CFG_DEV0_EPF2_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_ID                                                                0x10800
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_COMMAND                                                                  0x10801
#define regBIF_CFG_DEV0_EPF2_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_0_STATUS                                                                   0x10801
#define regBIF_CFG_DEV0_EPF2_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF2_0_REVISION_ID                                                              0x10802
#define regBIF_CFG_DEV0_EPF2_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_PROG_INTERFACE                                                           0x10802
#define regBIF_CFG_DEV0_EPF2_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_SUB_CLASS                                                                0x10802
#define regBIF_CFG_DEV0_EPF2_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_BASE_CLASS                                                               0x10802
#define regBIF_CFG_DEV0_EPF2_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_CACHE_LINE                                                               0x10803
#define regBIF_CFG_DEV0_EPF2_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_LATENCY                                                                  0x10803
#define regBIF_CFG_DEV0_EPF2_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_0_HEADER                                                                   0x10803
#define regBIF_CFG_DEV0_EPF2_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF2_0_BIST                                                                     0x10803
#define regBIF_CFG_DEV0_EPF2_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_1                                                              0x10804
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_2                                                              0x10805
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_3                                                              0x10806
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_4                                                              0x10807
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_5                                                              0x10808
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_6                                                              0x10809
#define regBIF_CFG_DEV0_EPF2_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_ADAPTER_ID                                                               0x1080b
#define regBIF_CFG_DEV0_EPF2_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_ROM_BASE_ADDR                                                            0x1080c
#define regBIF_CFG_DEV0_EPF2_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_CAP_PTR                                                                  0x1080d
#define regBIF_CFG_DEV0_EPF2_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_0_INTERRUPT_LINE                                                           0x1080f
#define regBIF_CFG_DEV0_EPF2_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_INTERRUPT_PIN                                                            0x1080f
#define regBIF_CFG_DEV0_EPF2_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_MIN_GRANT                                                                0x1080f
#define regBIF_CFG_DEV0_EPF2_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_MAX_LATENCY                                                              0x1080f
#define regBIF_CFG_DEV0_EPF2_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST                                                          0x10812
#define regBIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W                                                             0x10813
#define regBIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST                                                             0x10814
#define regBIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_PMI_CAP                                                                  0x10814
#define regBIF_CFG_DEV0_EPF2_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL                                                          0x10815
#define regBIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_SBRN                                                                     0x10818
#define regBIF_CFG_DEV0_EPF2_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF2_0_FLADJ                                                                    0x10818
#define regBIF_CFG_DEV0_EPF2_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF2_0_DBESL_DBESLD                                                             0x10818
#define regBIF_CFG_DEV0_EPF2_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST                                                            0x10819
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CAP                                                                 0x10819
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CAP                                                               0x1081a
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CNTL                                                              0x1081b
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_STATUS                                                            0x1081b
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_LINK_CAP                                                                 0x1081c
#define regBIF_CFG_DEV0_EPF2_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_0_LINK_CNTL                                                                0x1081d
#define regBIF_CFG_DEV0_EPF2_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_LINK_STATUS                                                              0x1081d
#define regBIF_CFG_DEV0_EPF2_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CAP2                                                              0x10822
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2                                                             0x10823
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_STATUS2                                                           0x10823
#define regBIF_CFG_DEV0_EPF2_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_LINK_CAP2                                                                0x10824
#define regBIF_CFG_DEV0_EPF2_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_LINK_CNTL2                                                               0x10825
#define regBIF_CFG_DEV0_EPF2_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_LINK_STATUS2                                                             0x10825
#define regBIF_CFG_DEV0_EPF2_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST                                                             0x10828
#define regBIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL                                                             0x10828
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_LO                                                          0x10829
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_HI                                                          0x1082a
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA                                                             0x1082a
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_MSI_EXT_MSG_DATA                                                         0x1082a
#define regBIF_CFG_DEV0_EPF2_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MASK                                                                 0x1082b
#define regBIF_CFG_DEV0_EPF2_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA_64                                                          0x1082b
#define regBIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_MSI_EXT_MSG_DATA_64                                                      0x1082b
#define regBIF_CFG_DEV0_EPF2_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_0_MSI_MASK_64                                                              0x1082c
#define regBIF_CFG_DEV0_EPF2_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_MSI_PENDING                                                              0x1082c
#define regBIF_CFG_DEV0_EPF2_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_0_MSI_PENDING_64                                                           0x1082d
#define regBIF_CFG_DEV0_EPF2_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST                                                            0x10830
#define regBIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL                                                            0x10830
#define regBIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_MSIX_TABLE                                                               0x10831
#define regBIF_CFG_DEV0_EPF2_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_MSIX_PBA                                                                 0x10832
#define regBIF_CFG_DEV0_EPF2_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_0_SATA_CAP_0                                                               0x10834
#define regBIF_CFG_DEV0_EPF2_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_SATA_CAP_1                                                               0x10835
#define regBIF_CFG_DEV0_EPF2_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX                                                           0x10836
#define regBIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_SATA_IDP_DATA                                                            0x10837
#define regBIF_CFG_DEV0_EPF2_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x10840
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x10841
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC1                                                    0x10842
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC2                                                    0x10843
#define regBIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x10854
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS                                                   0x10855
#define regBIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK                                                     0x10856
#define regBIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x10857
#define regBIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS                                                     0x10858
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK                                                       0x10859
#define regBIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1085a
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG0                                                            0x1085b
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG1                                                            0x1085c
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG2                                                            0x1085d
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG3                                                            0x1085e
#define regBIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG0                                                     0x10862
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG1                                                     0x10863
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG2                                                     0x10864
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG3                                                     0x10865
#define regBIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST                                                    0x10880
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CAP                                                            0x10881
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL                                                           0x10882
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CAP                                                            0x10883
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL                                                           0x10884
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CAP                                                            0x10885
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL                                                           0x10886
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CAP                                                            0x10887
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL                                                           0x10888
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CAP                                                            0x10889
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL                                                           0x1088a
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CAP                                                            0x1088b
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL                                                           0x1088c
#define regBIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x10890
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x10891
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA                                                     0x10892
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_CAP                                                      0x10893
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST                                                    0x10894
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP                                                             0x10895
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_LATENCY_INDICATOR                                               0x10896
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS                                                          0x10897
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_CNTL                                                            0x10897
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x10898
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x10898
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x10898
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x10898
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x10899
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x10899
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x10899
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x10899
#define regBIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST                                                    0x108a8
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP                                                             0x108a9
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL                                                            0x108a9
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PASID_ENH_CAP_LIST                                                  0x108b4
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PASID_CAP                                                           0x108b5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PASID_CNTL                                                          0x108b5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST                                                    0x108ca
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP                                                             0x108cb
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL                                                            0x108cb
#define regBIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1095c
#define regBIF_CFG_DEV0_EPF2_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_0_RTR_DATA1                                                                0x1095d
#define regBIF_CFG_DEV0_EPF2_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_0_RTR_DATA2                                                                0x1095e
#define regBIF_CFG_DEV0_EPF2_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf3_bifcfgdecp
// base address: 0x10143000
#define regBIF_CFG_DEV0_EPF3_0_VENDOR_ID                                                                0x10c00
#define regBIF_CFG_DEV0_EPF3_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_ID                                                                0x10c00
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_COMMAND                                                                  0x10c01
#define regBIF_CFG_DEV0_EPF3_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_0_STATUS                                                                   0x10c01
#define regBIF_CFG_DEV0_EPF3_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF3_0_REVISION_ID                                                              0x10c02
#define regBIF_CFG_DEV0_EPF3_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_PROG_INTERFACE                                                           0x10c02
#define regBIF_CFG_DEV0_EPF3_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_SUB_CLASS                                                                0x10c02
#define regBIF_CFG_DEV0_EPF3_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_BASE_CLASS                                                               0x10c02
#define regBIF_CFG_DEV0_EPF3_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_CACHE_LINE                                                               0x10c03
#define regBIF_CFG_DEV0_EPF3_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_LATENCY                                                                  0x10c03
#define regBIF_CFG_DEV0_EPF3_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_0_HEADER                                                                   0x10c03
#define regBIF_CFG_DEV0_EPF3_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF3_0_BIST                                                                     0x10c03
#define regBIF_CFG_DEV0_EPF3_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_1                                                              0x10c04
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_2                                                              0x10c05
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_3                                                              0x10c06
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_4                                                              0x10c07
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_5                                                              0x10c08
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_6                                                              0x10c09
#define regBIF_CFG_DEV0_EPF3_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_ADAPTER_ID                                                               0x10c0b
#define regBIF_CFG_DEV0_EPF3_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_ROM_BASE_ADDR                                                            0x10c0c
#define regBIF_CFG_DEV0_EPF3_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_CAP_PTR                                                                  0x10c0d
#define regBIF_CFG_DEV0_EPF3_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_0_INTERRUPT_LINE                                                           0x10c0f
#define regBIF_CFG_DEV0_EPF3_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_INTERRUPT_PIN                                                            0x10c0f
#define regBIF_CFG_DEV0_EPF3_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_MIN_GRANT                                                                0x10c0f
#define regBIF_CFG_DEV0_EPF3_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_MAX_LATENCY                                                              0x10c0f
#define regBIF_CFG_DEV0_EPF3_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST                                                          0x10c12
#define regBIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W                                                             0x10c13
#define regBIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST                                                             0x10c14
#define regBIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_PMI_CAP                                                                  0x10c14
#define regBIF_CFG_DEV0_EPF3_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL                                                          0x10c15
#define regBIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_SBRN                                                                     0x10c18
#define regBIF_CFG_DEV0_EPF3_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF3_0_FLADJ                                                                    0x10c18
#define regBIF_CFG_DEV0_EPF3_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF3_0_DBESL_DBESLD                                                             0x10c18
#define regBIF_CFG_DEV0_EPF3_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST                                                            0x10c19
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CAP                                                                 0x10c19
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CAP                                                               0x10c1a
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CNTL                                                              0x10c1b
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_STATUS                                                            0x10c1b
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_LINK_CAP                                                                 0x10c1c
#define regBIF_CFG_DEV0_EPF3_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_0_LINK_CNTL                                                                0x10c1d
#define regBIF_CFG_DEV0_EPF3_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_LINK_STATUS                                                              0x10c1d
#define regBIF_CFG_DEV0_EPF3_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CAP2                                                              0x10c22
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2                                                             0x10c23
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_STATUS2                                                           0x10c23
#define regBIF_CFG_DEV0_EPF3_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_LINK_CAP2                                                                0x10c24
#define regBIF_CFG_DEV0_EPF3_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_LINK_CNTL2                                                               0x10c25
#define regBIF_CFG_DEV0_EPF3_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_LINK_STATUS2                                                             0x10c25
#define regBIF_CFG_DEV0_EPF3_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST                                                             0x10c28
#define regBIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL                                                             0x10c28
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_LO                                                          0x10c29
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_HI                                                          0x10c2a
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA                                                             0x10c2a
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_MSI_EXT_MSG_DATA                                                         0x10c2a
#define regBIF_CFG_DEV0_EPF3_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MASK                                                                 0x10c2b
#define regBIF_CFG_DEV0_EPF3_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA_64                                                          0x10c2b
#define regBIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_MSI_EXT_MSG_DATA_64                                                      0x10c2b
#define regBIF_CFG_DEV0_EPF3_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_0_MSI_MASK_64                                                              0x10c2c
#define regBIF_CFG_DEV0_EPF3_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_MSI_PENDING                                                              0x10c2c
#define regBIF_CFG_DEV0_EPF3_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_0_MSI_PENDING_64                                                           0x10c2d
#define regBIF_CFG_DEV0_EPF3_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST                                                            0x10c30
#define regBIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL                                                            0x10c30
#define regBIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_MSIX_TABLE                                                               0x10c31
#define regBIF_CFG_DEV0_EPF3_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_MSIX_PBA                                                                 0x10c32
#define regBIF_CFG_DEV0_EPF3_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_0_SATA_CAP_0                                                               0x10c34
#define regBIF_CFG_DEV0_EPF3_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_SATA_CAP_1                                                               0x10c35
#define regBIF_CFG_DEV0_EPF3_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX                                                           0x10c36
#define regBIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_SATA_IDP_DATA                                                            0x10c37
#define regBIF_CFG_DEV0_EPF3_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x10c40
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x10c41
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC1                                                    0x10c42
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC2                                                    0x10c43
#define regBIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x10c54
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS                                                   0x10c55
#define regBIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK                                                     0x10c56
#define regBIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x10c57
#define regBIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS                                                     0x10c58
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK                                                       0x10c59
#define regBIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x10c5a
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG0                                                            0x10c5b
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG1                                                            0x10c5c
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG2                                                            0x10c5d
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG3                                                            0x10c5e
#define regBIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG0                                                     0x10c62
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG1                                                     0x10c63
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG2                                                     0x10c64
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG3                                                     0x10c65
#define regBIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST                                                    0x10c80
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CAP                                                            0x10c81
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL                                                           0x10c82
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CAP                                                            0x10c83
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL                                                           0x10c84
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CAP                                                            0x10c85
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL                                                           0x10c86
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CAP                                                            0x10c87
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL                                                           0x10c88
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CAP                                                            0x10c89
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL                                                           0x10c8a
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CAP                                                            0x10c8b
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL                                                           0x10c8c
#define regBIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x10c90
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x10c91
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA                                                     0x10c92
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_CAP                                                      0x10c93
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST                                                    0x10c94
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP                                                             0x10c95
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_LATENCY_INDICATOR                                               0x10c96
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS                                                          0x10c97
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_CNTL                                                            0x10c97
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x10c98
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x10c98
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x10c98
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x10c98
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x10c99
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x10c99
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x10c99
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x10c99
#define regBIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST                                                    0x10ca8
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP                                                             0x10ca9
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL                                                            0x10ca9
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PASID_ENH_CAP_LIST                                                  0x10cb4
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PASID_CAP                                                           0x10cb5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PASID_CNTL                                                          0x10cb5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST                                                    0x10cca
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP                                                             0x10ccb
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL                                                            0x10ccb
#define regBIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_0_PCIE_RTR_ENH_CAP_LIST                                                    0x10d5c
#define regBIF_CFG_DEV0_EPF3_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_0_RTR_DATA1                                                                0x10d5d
#define regBIF_CFG_DEV0_EPF3_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_0_RTR_DATA2                                                                0x10d5e
#define regBIF_CFG_DEV0_EPF3_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf4_bifcfgdecp
// base address: 0x10144000
#define regBIF_CFG_DEV0_EPF4_0_VENDOR_ID                                                                0x11000
#define regBIF_CFG_DEV0_EPF4_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_ID                                                                0x11000
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_COMMAND                                                                  0x11001
#define regBIF_CFG_DEV0_EPF4_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF4_0_STATUS                                                                   0x11001
#define regBIF_CFG_DEV0_EPF4_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF4_0_REVISION_ID                                                              0x11002
#define regBIF_CFG_DEV0_EPF4_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_PROG_INTERFACE                                                           0x11002
#define regBIF_CFG_DEV0_EPF4_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_SUB_CLASS                                                                0x11002
#define regBIF_CFG_DEV0_EPF4_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_BASE_CLASS                                                               0x11002
#define regBIF_CFG_DEV0_EPF4_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_CACHE_LINE                                                               0x11003
#define regBIF_CFG_DEV0_EPF4_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_LATENCY                                                                  0x11003
#define regBIF_CFG_DEV0_EPF4_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF4_0_HEADER                                                                   0x11003
#define regBIF_CFG_DEV0_EPF4_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF4_0_BIST                                                                     0x11003
#define regBIF_CFG_DEV0_EPF4_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_1                                                              0x11004
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_2                                                              0x11005
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_3                                                              0x11006
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_4                                                              0x11007
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_5                                                              0x11008
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_6                                                              0x11009
#define regBIF_CFG_DEV0_EPF4_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_ADAPTER_ID                                                               0x1100b
#define regBIF_CFG_DEV0_EPF4_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_ROM_BASE_ADDR                                                            0x1100c
#define regBIF_CFG_DEV0_EPF4_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_CAP_PTR                                                                  0x1100d
#define regBIF_CFG_DEV0_EPF4_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF4_0_INTERRUPT_LINE                                                           0x1100f
#define regBIF_CFG_DEV0_EPF4_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_INTERRUPT_PIN                                                            0x1100f
#define regBIF_CFG_DEV0_EPF4_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_MIN_GRANT                                                                0x1100f
#define regBIF_CFG_DEV0_EPF4_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_MAX_LATENCY                                                              0x1100f
#define regBIF_CFG_DEV0_EPF4_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST                                                          0x11012
#define regBIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W                                                             0x11013
#define regBIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST                                                             0x11014
#define regBIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_PMI_CAP                                                                  0x11014
#define regBIF_CFG_DEV0_EPF4_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL                                                          0x11015
#define regBIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_SBRN                                                                     0x11018
#define regBIF_CFG_DEV0_EPF4_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF4_0_FLADJ                                                                    0x11018
#define regBIF_CFG_DEV0_EPF4_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF4_0_DBESL_DBESLD                                                             0x11018
#define regBIF_CFG_DEV0_EPF4_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST                                                            0x11019
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CAP                                                                 0x11019
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CAP                                                               0x1101a
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CNTL                                                              0x1101b
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_STATUS                                                            0x1101b
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_LINK_CAP                                                                 0x1101c
#define regBIF_CFG_DEV0_EPF4_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF4_0_LINK_CNTL                                                                0x1101d
#define regBIF_CFG_DEV0_EPF4_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_LINK_STATUS                                                              0x1101d
#define regBIF_CFG_DEV0_EPF4_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CAP2                                                              0x11022
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2                                                             0x11023
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_STATUS2                                                           0x11023
#define regBIF_CFG_DEV0_EPF4_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_LINK_CAP2                                                                0x11024
#define regBIF_CFG_DEV0_EPF4_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_LINK_CNTL2                                                               0x11025
#define regBIF_CFG_DEV0_EPF4_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_LINK_STATUS2                                                             0x11025
#define regBIF_CFG_DEV0_EPF4_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST                                                             0x11028
#define regBIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL                                                             0x11028
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_LO                                                          0x11029
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_HI                                                          0x1102a
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA                                                             0x1102a
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_MSI_EXT_MSG_DATA                                                         0x1102a
#define regBIF_CFG_DEV0_EPF4_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MASK                                                                 0x1102b
#define regBIF_CFG_DEV0_EPF4_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA_64                                                          0x1102b
#define regBIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_MSI_EXT_MSG_DATA_64                                                      0x1102b
#define regBIF_CFG_DEV0_EPF4_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF4_0_MSI_MASK_64                                                              0x1102c
#define regBIF_CFG_DEV0_EPF4_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_MSI_PENDING                                                              0x1102c
#define regBIF_CFG_DEV0_EPF4_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF4_0_MSI_PENDING_64                                                           0x1102d
#define regBIF_CFG_DEV0_EPF4_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST                                                            0x11030
#define regBIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL                                                            0x11030
#define regBIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_MSIX_TABLE                                                               0x11031
#define regBIF_CFG_DEV0_EPF4_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_MSIX_PBA                                                                 0x11032
#define regBIF_CFG_DEV0_EPF4_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF4_0_SATA_CAP_0                                                               0x11034
#define regBIF_CFG_DEV0_EPF4_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_SATA_CAP_1                                                               0x11035
#define regBIF_CFG_DEV0_EPF4_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX                                                           0x11036
#define regBIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_SATA_IDP_DATA                                                            0x11037
#define regBIF_CFG_DEV0_EPF4_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x11040
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x11041
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC1                                                    0x11042
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC2                                                    0x11043
#define regBIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x11054
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS                                                   0x11055
#define regBIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK                                                     0x11056
#define regBIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x11057
#define regBIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS                                                     0x11058
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK                                                       0x11059
#define regBIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1105a
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG0                                                            0x1105b
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG1                                                            0x1105c
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG2                                                            0x1105d
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG3                                                            0x1105e
#define regBIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG0                                                     0x11062
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG1                                                     0x11063
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG2                                                     0x11064
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG3                                                     0x11065
#define regBIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST                                                    0x11080
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CAP                                                            0x11081
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL                                                           0x11082
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CAP                                                            0x11083
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL                                                           0x11084
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CAP                                                            0x11085
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL                                                           0x11086
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CAP                                                            0x11087
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL                                                           0x11088
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CAP                                                            0x11089
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL                                                           0x1108a
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CAP                                                            0x1108b
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL                                                           0x1108c
#define regBIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x11090
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x11091
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA                                                     0x11092
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_CAP                                                      0x11093
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST                                                    0x11094
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP                                                             0x11095
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_LATENCY_INDICATOR                                               0x11096
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS                                                          0x11097
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_CNTL                                                            0x11097
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x11098
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x11098
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x11098
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x11098
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x11099
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x11099
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x11099
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x11099
#define regBIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST                                                    0x110a8
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP                                                             0x110a9
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL                                                            0x110a9
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PASID_ENH_CAP_LIST                                                  0x110b4
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PASID_CAP                                                           0x110b5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PASID_CNTL                                                          0x110b5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST                                                    0x110ca
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP                                                             0x110cb
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL                                                            0x110cb
#define regBIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF4_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1115c
#define regBIF_CFG_DEV0_EPF4_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF4_0_RTR_DATA1                                                                0x1115d
#define regBIF_CFG_DEV0_EPF4_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF4_0_RTR_DATA2                                                                0x1115e
#define regBIF_CFG_DEV0_EPF4_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf5_bifcfgdecp
// base address: 0x10145000
#define regBIF_CFG_DEV0_EPF5_0_VENDOR_ID                                                                0x11400
#define regBIF_CFG_DEV0_EPF5_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_ID                                                                0x11400
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_COMMAND                                                                  0x11401
#define regBIF_CFG_DEV0_EPF5_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF5_0_STATUS                                                                   0x11401
#define regBIF_CFG_DEV0_EPF5_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF5_0_REVISION_ID                                                              0x11402
#define regBIF_CFG_DEV0_EPF5_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_PROG_INTERFACE                                                           0x11402
#define regBIF_CFG_DEV0_EPF5_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_SUB_CLASS                                                                0x11402
#define regBIF_CFG_DEV0_EPF5_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_BASE_CLASS                                                               0x11402
#define regBIF_CFG_DEV0_EPF5_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_CACHE_LINE                                                               0x11403
#define regBIF_CFG_DEV0_EPF5_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_LATENCY                                                                  0x11403
#define regBIF_CFG_DEV0_EPF5_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF5_0_HEADER                                                                   0x11403
#define regBIF_CFG_DEV0_EPF5_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF5_0_BIST                                                                     0x11403
#define regBIF_CFG_DEV0_EPF5_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_1                                                              0x11404
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_2                                                              0x11405
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_3                                                              0x11406
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_4                                                              0x11407
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_5                                                              0x11408
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_6                                                              0x11409
#define regBIF_CFG_DEV0_EPF5_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_ADAPTER_ID                                                               0x1140b
#define regBIF_CFG_DEV0_EPF5_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_ROM_BASE_ADDR                                                            0x1140c
#define regBIF_CFG_DEV0_EPF5_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_CAP_PTR                                                                  0x1140d
#define regBIF_CFG_DEV0_EPF5_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF5_0_INTERRUPT_LINE                                                           0x1140f
#define regBIF_CFG_DEV0_EPF5_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_INTERRUPT_PIN                                                            0x1140f
#define regBIF_CFG_DEV0_EPF5_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_MIN_GRANT                                                                0x1140f
#define regBIF_CFG_DEV0_EPF5_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_MAX_LATENCY                                                              0x1140f
#define regBIF_CFG_DEV0_EPF5_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST                                                          0x11412
#define regBIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W                                                             0x11413
#define regBIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST                                                             0x11414
#define regBIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_PMI_CAP                                                                  0x11414
#define regBIF_CFG_DEV0_EPF5_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL                                                          0x11415
#define regBIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_SBRN                                                                     0x11418
#define regBIF_CFG_DEV0_EPF5_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF5_0_FLADJ                                                                    0x11418
#define regBIF_CFG_DEV0_EPF5_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF5_0_DBESL_DBESLD                                                             0x11418
#define regBIF_CFG_DEV0_EPF5_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CAP_LIST                                                            0x11419
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CAP                                                                 0x11419
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CAP                                                               0x1141a
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CNTL                                                              0x1141b
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_STATUS                                                            0x1141b
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_LINK_CAP                                                                 0x1141c
#define regBIF_CFG_DEV0_EPF5_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF5_0_LINK_CNTL                                                                0x1141d
#define regBIF_CFG_DEV0_EPF5_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_LINK_STATUS                                                              0x1141d
#define regBIF_CFG_DEV0_EPF5_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CAP2                                                              0x11422
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CNTL2                                                             0x11423
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_STATUS2                                                           0x11423
#define regBIF_CFG_DEV0_EPF5_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_LINK_CAP2                                                                0x11424
#define regBIF_CFG_DEV0_EPF5_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_LINK_CNTL2                                                               0x11425
#define regBIF_CFG_DEV0_EPF5_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_LINK_STATUS2                                                             0x11425
#define regBIF_CFG_DEV0_EPF5_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_MSI_CAP_LIST                                                             0x11428
#define regBIF_CFG_DEV0_EPF5_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_CNTL                                                             0x11428
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_ADDR_LO                                                          0x11429
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_ADDR_HI                                                          0x1142a
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_DATA                                                             0x1142a
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_MSI_EXT_MSG_DATA                                                         0x1142a
#define regBIF_CFG_DEV0_EPF5_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MASK                                                                 0x1142b
#define regBIF_CFG_DEV0_EPF5_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_DATA_64                                                          0x1142b
#define regBIF_CFG_DEV0_EPF5_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_MSI_EXT_MSG_DATA_64                                                      0x1142b
#define regBIF_CFG_DEV0_EPF5_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF5_0_MSI_MASK_64                                                              0x1142c
#define regBIF_CFG_DEV0_EPF5_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_MSI_PENDING                                                              0x1142c
#define regBIF_CFG_DEV0_EPF5_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF5_0_MSI_PENDING_64                                                           0x1142d
#define regBIF_CFG_DEV0_EPF5_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_MSIX_CAP_LIST                                                            0x11430
#define regBIF_CFG_DEV0_EPF5_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_MSIX_MSG_CNTL                                                            0x11430
#define regBIF_CFG_DEV0_EPF5_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_MSIX_TABLE                                                               0x11431
#define regBIF_CFG_DEV0_EPF5_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_MSIX_PBA                                                                 0x11432
#define regBIF_CFG_DEV0_EPF5_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF5_0_SATA_CAP_0                                                               0x11434
#define regBIF_CFG_DEV0_EPF5_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_SATA_CAP_1                                                               0x11435
#define regBIF_CFG_DEV0_EPF5_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF5_0_SATA_IDP_INDEX                                                           0x11436
#define regBIF_CFG_DEV0_EPF5_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_SATA_IDP_DATA                                                            0x11437
#define regBIF_CFG_DEV0_EPF5_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x11440
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x11441
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC1                                                    0x11442
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC2                                                    0x11443
#define regBIF_CFG_DEV0_EPF5_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x11454
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_UNCORR_ERR_STATUS                                                   0x11455
#define regBIF_CFG_DEV0_EPF5_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_UNCORR_ERR_MASK                                                     0x11456
#define regBIF_CFG_DEV0_EPF5_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x11457
#define regBIF_CFG_DEV0_EPF5_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CORR_ERR_STATUS                                                     0x11458
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CORR_ERR_MASK                                                       0x11459
#define regBIF_CFG_DEV0_EPF5_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1145a
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG0                                                            0x1145b
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG1                                                            0x1145c
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG2                                                            0x1145d
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG3                                                            0x1145e
#define regBIF_CFG_DEV0_EPF5_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG0                                                     0x11462
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG1                                                     0x11463
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG2                                                     0x11464
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG3                                                     0x11465
#define regBIF_CFG_DEV0_EPF5_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR_ENH_CAP_LIST                                                    0x11480
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR1_CAP                                                            0x11481
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR1_CNTL                                                           0x11482
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR2_CAP                                                            0x11483
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR2_CNTL                                                           0x11484
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR3_CAP                                                            0x11485
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR3_CNTL                                                           0x11486
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR4_CAP                                                            0x11487
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR4_CNTL                                                           0x11488
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR5_CAP                                                            0x11489
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR5_CNTL                                                           0x1148a
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR6_CAP                                                            0x1148b
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR6_CNTL                                                           0x1148c
#define regBIF_CFG_DEV0_EPF5_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x11490
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x11491
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_DATA                                                     0x11492
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_CAP                                                      0x11493
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_ENH_CAP_LIST                                                    0x11494
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_CAP                                                             0x11495
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_LATENCY_INDICATOR                                               0x11496
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_STATUS                                                          0x11497
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_CNTL                                                            0x11497
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x11498
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x11498
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x11498
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x11498
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x11499
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x11499
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x11499
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x11499
#define regBIF_CFG_DEV0_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ACS_ENH_CAP_LIST                                                    0x114a8
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ACS_CAP                                                             0x114a9
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ACS_CNTL                                                            0x114a9
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PASID_ENH_CAP_LIST                                                  0x114b4
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PASID_CAP                                                           0x114b5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PASID_CNTL                                                          0x114b5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ARI_ENH_CAP_LIST                                                    0x114ca
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ARI_CAP                                                             0x114cb
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ARI_CNTL                                                            0x114cb
#define regBIF_CFG_DEV0_EPF5_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF5_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1155c
#define regBIF_CFG_DEV0_EPF5_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF5_0_RTR_DATA1                                                                0x1155d
#define regBIF_CFG_DEV0_EPF5_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF5_0_RTR_DATA2                                                                0x1155e
#define regBIF_CFG_DEV0_EPF5_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf6_bifcfgdecp
// base address: 0x10146000
#define regBIF_CFG_DEV0_EPF6_0_VENDOR_ID                                                                0x11800
#define regBIF_CFG_DEV0_EPF6_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_ID                                                                0x11800
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_COMMAND                                                                  0x11801
#define regBIF_CFG_DEV0_EPF6_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF6_0_STATUS                                                                   0x11801
#define regBIF_CFG_DEV0_EPF6_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF6_0_REVISION_ID                                                              0x11802
#define regBIF_CFG_DEV0_EPF6_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_PROG_INTERFACE                                                           0x11802
#define regBIF_CFG_DEV0_EPF6_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_SUB_CLASS                                                                0x11802
#define regBIF_CFG_DEV0_EPF6_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_BASE_CLASS                                                               0x11802
#define regBIF_CFG_DEV0_EPF6_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_CACHE_LINE                                                               0x11803
#define regBIF_CFG_DEV0_EPF6_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_LATENCY                                                                  0x11803
#define regBIF_CFG_DEV0_EPF6_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF6_0_HEADER                                                                   0x11803
#define regBIF_CFG_DEV0_EPF6_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF6_0_BIST                                                                     0x11803
#define regBIF_CFG_DEV0_EPF6_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_1                                                              0x11804
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_2                                                              0x11805
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_3                                                              0x11806
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_4                                                              0x11807
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_5                                                              0x11808
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_6                                                              0x11809
#define regBIF_CFG_DEV0_EPF6_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_ADAPTER_ID                                                               0x1180b
#define regBIF_CFG_DEV0_EPF6_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_ROM_BASE_ADDR                                                            0x1180c
#define regBIF_CFG_DEV0_EPF6_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_CAP_PTR                                                                  0x1180d
#define regBIF_CFG_DEV0_EPF6_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF6_0_INTERRUPT_LINE                                                           0x1180f
#define regBIF_CFG_DEV0_EPF6_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_INTERRUPT_PIN                                                            0x1180f
#define regBIF_CFG_DEV0_EPF6_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_MIN_GRANT                                                                0x1180f
#define regBIF_CFG_DEV0_EPF6_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_MAX_LATENCY                                                              0x1180f
#define regBIF_CFG_DEV0_EPF6_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_VENDOR_CAP_LIST                                                          0x11812
#define regBIF_CFG_DEV0_EPF6_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_ADAPTER_ID_W                                                             0x11813
#define regBIF_CFG_DEV0_EPF6_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_PMI_CAP_LIST                                                             0x11814
#define regBIF_CFG_DEV0_EPF6_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_PMI_CAP                                                                  0x11814
#define regBIF_CFG_DEV0_EPF6_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF6_0_PMI_STATUS_CNTL                                                          0x11815
#define regBIF_CFG_DEV0_EPF6_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_SBRN                                                                     0x11818
#define regBIF_CFG_DEV0_EPF6_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF6_0_FLADJ                                                                    0x11818
#define regBIF_CFG_DEV0_EPF6_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF6_0_DBESL_DBESLD                                                             0x11818
#define regBIF_CFG_DEV0_EPF6_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CAP_LIST                                                            0x11819
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CAP                                                                 0x11819
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CAP                                                               0x1181a
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CNTL                                                              0x1181b
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_STATUS                                                            0x1181b
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_LINK_CAP                                                                 0x1181c
#define regBIF_CFG_DEV0_EPF6_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF6_0_LINK_CNTL                                                                0x1181d
#define regBIF_CFG_DEV0_EPF6_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_LINK_STATUS                                                              0x1181d
#define regBIF_CFG_DEV0_EPF6_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CAP2                                                              0x11822
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CNTL2                                                             0x11823
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_STATUS2                                                           0x11823
#define regBIF_CFG_DEV0_EPF6_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_LINK_CAP2                                                                0x11824
#define regBIF_CFG_DEV0_EPF6_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_LINK_CNTL2                                                               0x11825
#define regBIF_CFG_DEV0_EPF6_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_LINK_STATUS2                                                             0x11825
#define regBIF_CFG_DEV0_EPF6_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_MSI_CAP_LIST                                                             0x11828
#define regBIF_CFG_DEV0_EPF6_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_CNTL                                                             0x11828
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_ADDR_LO                                                          0x11829
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_ADDR_HI                                                          0x1182a
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_DATA                                                             0x1182a
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_MSI_EXT_MSG_DATA                                                         0x1182a
#define regBIF_CFG_DEV0_EPF6_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MASK                                                                 0x1182b
#define regBIF_CFG_DEV0_EPF6_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_DATA_64                                                          0x1182b
#define regBIF_CFG_DEV0_EPF6_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_MSI_EXT_MSG_DATA_64                                                      0x1182b
#define regBIF_CFG_DEV0_EPF6_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF6_0_MSI_MASK_64                                                              0x1182c
#define regBIF_CFG_DEV0_EPF6_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_MSI_PENDING                                                              0x1182c
#define regBIF_CFG_DEV0_EPF6_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF6_0_MSI_PENDING_64                                                           0x1182d
#define regBIF_CFG_DEV0_EPF6_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_MSIX_CAP_LIST                                                            0x11830
#define regBIF_CFG_DEV0_EPF6_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_MSIX_MSG_CNTL                                                            0x11830
#define regBIF_CFG_DEV0_EPF6_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_MSIX_TABLE                                                               0x11831
#define regBIF_CFG_DEV0_EPF6_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_MSIX_PBA                                                                 0x11832
#define regBIF_CFG_DEV0_EPF6_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF6_0_SATA_CAP_0                                                               0x11834
#define regBIF_CFG_DEV0_EPF6_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_SATA_CAP_1                                                               0x11835
#define regBIF_CFG_DEV0_EPF6_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF6_0_SATA_IDP_INDEX                                                           0x11836
#define regBIF_CFG_DEV0_EPF6_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_SATA_IDP_DATA                                                            0x11837
#define regBIF_CFG_DEV0_EPF6_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x11840
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x11841
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC1                                                    0x11842
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC2                                                    0x11843
#define regBIF_CFG_DEV0_EPF6_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x11854
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_UNCORR_ERR_STATUS                                                   0x11855
#define regBIF_CFG_DEV0_EPF6_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_UNCORR_ERR_MASK                                                     0x11856
#define regBIF_CFG_DEV0_EPF6_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x11857
#define regBIF_CFG_DEV0_EPF6_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CORR_ERR_STATUS                                                     0x11858
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CORR_ERR_MASK                                                       0x11859
#define regBIF_CFG_DEV0_EPF6_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1185a
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG0                                                            0x1185b
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG1                                                            0x1185c
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG2                                                            0x1185d
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG3                                                            0x1185e
#define regBIF_CFG_DEV0_EPF6_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG0                                                     0x11862
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG1                                                     0x11863
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG2                                                     0x11864
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG3                                                     0x11865
#define regBIF_CFG_DEV0_EPF6_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR_ENH_CAP_LIST                                                    0x11880
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR1_CAP                                                            0x11881
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR1_CNTL                                                           0x11882
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR2_CAP                                                            0x11883
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR2_CNTL                                                           0x11884
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR3_CAP                                                            0x11885
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR3_CNTL                                                           0x11886
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR4_CAP                                                            0x11887
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR4_CNTL                                                           0x11888
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR5_CAP                                                            0x11889
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR5_CNTL                                                           0x1188a
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR6_CAP                                                            0x1188b
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR6_CNTL                                                           0x1188c
#define regBIF_CFG_DEV0_EPF6_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x11890
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x11891
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_DATA                                                     0x11892
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_CAP                                                      0x11893
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_ENH_CAP_LIST                                                    0x11894
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_CAP                                                             0x11895
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_LATENCY_INDICATOR                                               0x11896
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_STATUS                                                          0x11897
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_CNTL                                                            0x11897
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x11898
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x11898
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x11898
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x11898
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x11899
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x11899
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x11899
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x11899
#define regBIF_CFG_DEV0_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ACS_ENH_CAP_LIST                                                    0x118a8
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ACS_CAP                                                             0x118a9
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ACS_CNTL                                                            0x118a9
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PASID_ENH_CAP_LIST                                                  0x118b4
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PASID_CAP                                                           0x118b5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PASID_CNTL                                                          0x118b5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ARI_ENH_CAP_LIST                                                    0x118ca
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ARI_CAP                                                             0x118cb
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ARI_CNTL                                                            0x118cb
#define regBIF_CFG_DEV0_EPF6_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF6_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1195c
#define regBIF_CFG_DEV0_EPF6_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF6_0_RTR_DATA1                                                                0x1195d
#define regBIF_CFG_DEV0_EPF6_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF6_0_RTR_DATA2                                                                0x1195e
#define regBIF_CFG_DEV0_EPF6_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf7_bifcfgdecp
// base address: 0x10147000
#define regBIF_CFG_DEV0_EPF7_0_VENDOR_ID                                                                0x11c00
#define regBIF_CFG_DEV0_EPF7_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_ID                                                                0x11c00
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_COMMAND                                                                  0x11c01
#define regBIF_CFG_DEV0_EPF7_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF7_0_STATUS                                                                   0x11c01
#define regBIF_CFG_DEV0_EPF7_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF7_0_REVISION_ID                                                              0x11c02
#define regBIF_CFG_DEV0_EPF7_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_PROG_INTERFACE                                                           0x11c02
#define regBIF_CFG_DEV0_EPF7_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_SUB_CLASS                                                                0x11c02
#define regBIF_CFG_DEV0_EPF7_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_BASE_CLASS                                                               0x11c02
#define regBIF_CFG_DEV0_EPF7_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_CACHE_LINE                                                               0x11c03
#define regBIF_CFG_DEV0_EPF7_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_LATENCY                                                                  0x11c03
#define regBIF_CFG_DEV0_EPF7_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF7_0_HEADER                                                                   0x11c03
#define regBIF_CFG_DEV0_EPF7_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF7_0_BIST                                                                     0x11c03
#define regBIF_CFG_DEV0_EPF7_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_1                                                              0x11c04
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_2                                                              0x11c05
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_3                                                              0x11c06
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_4                                                              0x11c07
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_5                                                              0x11c08
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_6                                                              0x11c09
#define regBIF_CFG_DEV0_EPF7_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_ADAPTER_ID                                                               0x11c0b
#define regBIF_CFG_DEV0_EPF7_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_ROM_BASE_ADDR                                                            0x11c0c
#define regBIF_CFG_DEV0_EPF7_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_CAP_PTR                                                                  0x11c0d
#define regBIF_CFG_DEV0_EPF7_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF7_0_INTERRUPT_LINE                                                           0x11c0f
#define regBIF_CFG_DEV0_EPF7_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_INTERRUPT_PIN                                                            0x11c0f
#define regBIF_CFG_DEV0_EPF7_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_MIN_GRANT                                                                0x11c0f
#define regBIF_CFG_DEV0_EPF7_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_MAX_LATENCY                                                              0x11c0f
#define regBIF_CFG_DEV0_EPF7_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_VENDOR_CAP_LIST                                                          0x11c12
#define regBIF_CFG_DEV0_EPF7_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_ADAPTER_ID_W                                                             0x11c13
#define regBIF_CFG_DEV0_EPF7_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_PMI_CAP_LIST                                                             0x11c14
#define regBIF_CFG_DEV0_EPF7_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_PMI_CAP                                                                  0x11c14
#define regBIF_CFG_DEV0_EPF7_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF7_0_PMI_STATUS_CNTL                                                          0x11c15
#define regBIF_CFG_DEV0_EPF7_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_SBRN                                                                     0x11c18
#define regBIF_CFG_DEV0_EPF7_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF7_0_FLADJ                                                                    0x11c18
#define regBIF_CFG_DEV0_EPF7_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF7_0_DBESL_DBESLD                                                             0x11c18
#define regBIF_CFG_DEV0_EPF7_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CAP_LIST                                                            0x11c19
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CAP                                                                 0x11c19
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CAP                                                               0x11c1a
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CNTL                                                              0x11c1b
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_STATUS                                                            0x11c1b
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_LINK_CAP                                                                 0x11c1c
#define regBIF_CFG_DEV0_EPF7_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF7_0_LINK_CNTL                                                                0x11c1d
#define regBIF_CFG_DEV0_EPF7_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_LINK_STATUS                                                              0x11c1d
#define regBIF_CFG_DEV0_EPF7_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CAP2                                                              0x11c22
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CNTL2                                                             0x11c23
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_STATUS2                                                           0x11c23
#define regBIF_CFG_DEV0_EPF7_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_LINK_CAP2                                                                0x11c24
#define regBIF_CFG_DEV0_EPF7_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_LINK_CNTL2                                                               0x11c25
#define regBIF_CFG_DEV0_EPF7_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_LINK_STATUS2                                                             0x11c25
#define regBIF_CFG_DEV0_EPF7_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_MSI_CAP_LIST                                                             0x11c28
#define regBIF_CFG_DEV0_EPF7_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_CNTL                                                             0x11c28
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_ADDR_LO                                                          0x11c29
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_ADDR_HI                                                          0x11c2a
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_DATA                                                             0x11c2a
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_MSI_EXT_MSG_DATA                                                         0x11c2a
#define regBIF_CFG_DEV0_EPF7_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MASK                                                                 0x11c2b
#define regBIF_CFG_DEV0_EPF7_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_DATA_64                                                          0x11c2b
#define regBIF_CFG_DEV0_EPF7_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_MSI_EXT_MSG_DATA_64                                                      0x11c2b
#define regBIF_CFG_DEV0_EPF7_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF7_0_MSI_MASK_64                                                              0x11c2c
#define regBIF_CFG_DEV0_EPF7_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_MSI_PENDING                                                              0x11c2c
#define regBIF_CFG_DEV0_EPF7_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF7_0_MSI_PENDING_64                                                           0x11c2d
#define regBIF_CFG_DEV0_EPF7_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_MSIX_CAP_LIST                                                            0x11c30
#define regBIF_CFG_DEV0_EPF7_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_MSIX_MSG_CNTL                                                            0x11c30
#define regBIF_CFG_DEV0_EPF7_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_MSIX_TABLE                                                               0x11c31
#define regBIF_CFG_DEV0_EPF7_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_MSIX_PBA                                                                 0x11c32
#define regBIF_CFG_DEV0_EPF7_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF7_0_SATA_CAP_0                                                               0x11c34
#define regBIF_CFG_DEV0_EPF7_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_SATA_CAP_1                                                               0x11c35
#define regBIF_CFG_DEV0_EPF7_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF7_0_SATA_IDP_INDEX                                                           0x11c36
#define regBIF_CFG_DEV0_EPF7_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_SATA_IDP_DATA                                                            0x11c37
#define regBIF_CFG_DEV0_EPF7_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x11c40
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x11c41
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC1                                                    0x11c42
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC2                                                    0x11c43
#define regBIF_CFG_DEV0_EPF7_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x11c54
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_UNCORR_ERR_STATUS                                                   0x11c55
#define regBIF_CFG_DEV0_EPF7_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_UNCORR_ERR_MASK                                                     0x11c56
#define regBIF_CFG_DEV0_EPF7_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x11c57
#define regBIF_CFG_DEV0_EPF7_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CORR_ERR_STATUS                                                     0x11c58
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CORR_ERR_MASK                                                       0x11c59
#define regBIF_CFG_DEV0_EPF7_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x11c5a
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG0                                                            0x11c5b
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG1                                                            0x11c5c
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG2                                                            0x11c5d
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG3                                                            0x11c5e
#define regBIF_CFG_DEV0_EPF7_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG0                                                     0x11c62
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG1                                                     0x11c63
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG2                                                     0x11c64
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG3                                                     0x11c65
#define regBIF_CFG_DEV0_EPF7_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR_ENH_CAP_LIST                                                    0x11c80
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR1_CAP                                                            0x11c81
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR1_CNTL                                                           0x11c82
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR2_CAP                                                            0x11c83
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR2_CNTL                                                           0x11c84
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR3_CAP                                                            0x11c85
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR3_CNTL                                                           0x11c86
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR4_CAP                                                            0x11c87
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR4_CNTL                                                           0x11c88
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR5_CAP                                                            0x11c89
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR5_CNTL                                                           0x11c8a
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR6_CAP                                                            0x11c8b
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR6_CNTL                                                           0x11c8c
#define regBIF_CFG_DEV0_EPF7_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x11c90
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x11c91
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_DATA                                                     0x11c92
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_CAP                                                      0x11c93
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_ENH_CAP_LIST                                                    0x11c94
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_CAP                                                             0x11c95
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_LATENCY_INDICATOR                                               0x11c96
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_STATUS                                                          0x11c97
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_CNTL                                                            0x11c97
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x11c98
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x11c98
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x11c98
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x11c98
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x11c99
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x11c99
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x11c99
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x11c99
#define regBIF_CFG_DEV0_EPF7_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ACS_ENH_CAP_LIST                                                    0x11ca8
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ACS_CAP                                                             0x11ca9
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ACS_CNTL                                                            0x11ca9
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PASID_ENH_CAP_LIST                                                  0x11cb4
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PASID_CAP                                                           0x11cb5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PASID_CNTL                                                          0x11cb5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ARI_ENH_CAP_LIST                                                    0x11cca
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ARI_CAP                                                             0x11ccb
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ARI_CNTL                                                            0x11ccb
#define regBIF_CFG_DEV0_EPF7_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF7_0_PCIE_RTR_ENH_CAP_LIST                                                    0x11d5c
#define regBIF_CFG_DEV0_EPF7_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF7_0_RTR_DATA1                                                                0x11d5d
#define regBIF_CFG_DEV0_EPF7_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF7_0_RTR_DATA2                                                                0x11d5e
#define regBIF_CFG_DEV0_EPF7_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev1_rc_bifcfgdecp
// base address: 0x10101000
#define regBIF_CFG_DEV1_RC0_VENDOR_ID                                                                   0x0400
#define regBIF_CFG_DEV1_RC0_VENDOR_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_DEVICE_ID                                                                   0x0400
#define regBIF_CFG_DEV1_RC0_DEVICE_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_COMMAND                                                                     0x0401
#define regBIF_CFG_DEV1_RC0_COMMAND_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_RC0_STATUS                                                                      0x0401
#define regBIF_CFG_DEV1_RC0_STATUS_BASE_IDX                                                             5
#define regBIF_CFG_DEV1_RC0_REVISION_ID                                                                 0x0402
#define regBIF_CFG_DEV1_RC0_REVISION_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_PROG_INTERFACE                                                              0x0402
#define regBIF_CFG_DEV1_RC0_PROG_INTERFACE_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_RC0_SUB_CLASS                                                                   0x0402
#define regBIF_CFG_DEV1_RC0_SUB_CLASS_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_BASE_CLASS                                                                  0x0402
#define regBIF_CFG_DEV1_RC0_BASE_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_RC0_CACHE_LINE                                                                  0x0403
#define regBIF_CFG_DEV1_RC0_CACHE_LINE_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_RC0_LATENCY                                                                     0x0403
#define regBIF_CFG_DEV1_RC0_LATENCY_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_RC0_HEADER                                                                      0x0403
#define regBIF_CFG_DEV1_RC0_HEADER_BASE_IDX                                                             5
#define regBIF_CFG_DEV1_RC0_BIST                                                                        0x0403
#define regBIF_CFG_DEV1_RC0_BIST_BASE_IDX                                                               5
#define regBIF_CFG_DEV1_RC0_BASE_ADDR_1                                                                 0x0404
#define regBIF_CFG_DEV1_RC0_BASE_ADDR_1_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_BASE_ADDR_2                                                                 0x0405
#define regBIF_CFG_DEV1_RC0_BASE_ADDR_2_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY                                                      0x0406
#define regBIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY_BASE_IDX                                             5
#define regBIF_CFG_DEV1_RC0_IO_BASE_LIMIT                                                               0x0407
#define regBIF_CFG_DEV1_RC0_IO_BASE_LIMIT_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_SECONDARY_STATUS                                                            0x0407
#define regBIF_CFG_DEV1_RC0_SECONDARY_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_RC0_MEM_BASE_LIMIT                                                              0x0408
#define regBIF_CFG_DEV1_RC0_MEM_BASE_LIMIT_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_RC0_PREF_BASE_LIMIT                                                             0x0409
#define regBIF_CFG_DEV1_RC0_PREF_BASE_LIMIT_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_PREF_BASE_UPPER                                                             0x040a
#define regBIF_CFG_DEV1_RC0_PREF_BASE_UPPER_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_PREF_LIMIT_UPPER                                                            0x040b
#define regBIF_CFG_DEV1_RC0_PREF_LIMIT_UPPER_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI                                                            0x040c
#define regBIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_RC0_CAP_PTR                                                                     0x040d
#define regBIF_CFG_DEV1_RC0_CAP_PTR_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_RC0_ROM_BASE_ADDR                                                               0x040e
#define regBIF_CFG_DEV1_RC0_ROM_BASE_ADDR_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_INTERRUPT_LINE                                                              0x040f
#define regBIF_CFG_DEV1_RC0_INTERRUPT_LINE_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_RC0_INTERRUPT_PIN                                                               0x040f
#define regBIF_CFG_DEV1_RC0_INTERRUPT_PIN_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL                                                             0x040f
#define regBIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_EXT_BRIDGE_CNTL                                                             0x0410
#define regBIF_CFG_DEV1_RC0_EXT_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_PMI_CAP_LIST                                                                0x0414
#define regBIF_CFG_DEV1_RC0_PMI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_PMI_CAP                                                                     0x0414
#define regBIF_CFG_DEV1_RC0_PMI_CAP_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_RC0_PMI_STATUS_CNTL                                                             0x0415
#define regBIF_CFG_DEV1_RC0_PMI_STATUS_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_PCIE_CAP_LIST                                                               0x0416
#define regBIF_CFG_DEV1_RC0_PCIE_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_CAP                                                                    0x0416
#define regBIF_CFG_DEV1_RC0_PCIE_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_RC0_DEVICE_CAP                                                                  0x0417
#define regBIF_CFG_DEV1_RC0_DEVICE_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_RC0_DEVICE_CNTL                                                                 0x0418
#define regBIF_CFG_DEV1_RC0_DEVICE_CNTL_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_DEVICE_STATUS                                                               0x0418
#define regBIF_CFG_DEV1_RC0_DEVICE_STATUS_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_LINK_CAP                                                                    0x0419
#define regBIF_CFG_DEV1_RC0_LINK_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_RC0_LINK_CNTL                                                                   0x041a
#define regBIF_CFG_DEV1_RC0_LINK_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_LINK_STATUS                                                                 0x041a
#define regBIF_CFG_DEV1_RC0_LINK_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_SLOT_CAP                                                                    0x041b
#define regBIF_CFG_DEV1_RC0_SLOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_RC0_SLOT_CNTL                                                                   0x041c
#define regBIF_CFG_DEV1_RC0_SLOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_SLOT_STATUS                                                                 0x041c
#define regBIF_CFG_DEV1_RC0_SLOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_ROOT_CNTL                                                                   0x041d
#define regBIF_CFG_DEV1_RC0_ROOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_ROOT_CAP                                                                    0x041d
#define regBIF_CFG_DEV1_RC0_ROOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_RC0_ROOT_STATUS                                                                 0x041e
#define regBIF_CFG_DEV1_RC0_ROOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_DEVICE_CAP2                                                                 0x041f
#define regBIF_CFG_DEV1_RC0_DEVICE_CAP2_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_DEVICE_CNTL2                                                                0x0420
#define regBIF_CFG_DEV1_RC0_DEVICE_CNTL2_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_DEVICE_STATUS2                                                              0x0420
#define regBIF_CFG_DEV1_RC0_DEVICE_STATUS2_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_RC0_LINK_CAP2                                                                   0x0421
#define regBIF_CFG_DEV1_RC0_LINK_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_LINK_CNTL2                                                                  0x0422
#define regBIF_CFG_DEV1_RC0_LINK_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_RC0_LINK_STATUS2                                                                0x0422
#define regBIF_CFG_DEV1_RC0_LINK_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_SLOT_CAP2                                                                   0x0423
#define regBIF_CFG_DEV1_RC0_SLOT_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_SLOT_CNTL2                                                                  0x0424
#define regBIF_CFG_DEV1_RC0_SLOT_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_RC0_SLOT_STATUS2                                                                0x0424
#define regBIF_CFG_DEV1_RC0_SLOT_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_MSI_CAP_LIST                                                                0x0428
#define regBIF_CFG_DEV1_RC0_MSI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_MSI_MSG_CNTL                                                                0x0428
#define regBIF_CFG_DEV1_RC0_MSI_MSG_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_MSI_MSG_ADDR_LO                                                             0x0429
#define regBIF_CFG_DEV1_RC0_MSI_MSG_ADDR_LO_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_MSI_MSG_ADDR_HI                                                             0x042a
#define regBIF_CFG_DEV1_RC0_MSI_MSG_ADDR_HI_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_MSI_MSG_DATA                                                                0x042a
#define regBIF_CFG_DEV1_RC0_MSI_MSG_DATA_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_MSI_EXT_MSG_DATA                                                            0x042a
#define regBIF_CFG_DEV1_RC0_MSI_EXT_MSG_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_RC0_MSI_MSG_DATA_64                                                             0x042b
#define regBIF_CFG_DEV1_RC0_MSI_MSG_DATA_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_MSI_EXT_MSG_DATA_64                                                         0x042b
#define regBIF_CFG_DEV1_RC0_MSI_EXT_MSG_DATA_64_BASE_IDX                                                5
#define regBIF_CFG_DEV1_RC0_SSID_CAP_LIST                                                               0x0430
#define regBIF_CFG_DEV1_RC0_SSID_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_SSID_CAP                                                                    0x0431
#define regBIF_CFG_DEV1_RC0_SSID_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST                                                            0x0432
#define regBIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_RC0_MSI_MAP_CAP                                                                 0x0432
#define regBIF_CFG_DEV1_RC0_MSI_MAP_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                           0x0440
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                  5
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR                                                    0x0441
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                           5
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC1                                                       0x0442
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC2                                                       0x0443
#define regBIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST                                                        0x0444
#define regBIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1                                                       0x0445
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2                                                       0x0446
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL                                                           0x0447
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_STATUS                                                         0x0447
#define regBIF_CFG_DEV1_RC0_PCIE_PORT_VC_STATUS_BASE_IDX                                                5
#define regBIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP                                                       0x0448
#define regBIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL                                                      0x0449
#define regBIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS                                                    0x044a
#define regBIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP                                                       0x044b
#define regBIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL                                                      0x044c
#define regBIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS                                                    0x044d
#define regBIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                            0x0450
#define regBIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW1                                                     0x0451
#define regBIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                            5
#define regBIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW2                                                     0x0452
#define regBIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                            5
#define regBIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                               0x0454
#define regBIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS                                                      0x0455
#define regBIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK                                                        0x0456
#define regBIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY                                                    0x0457
#define regBIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                           5
#define regBIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS                                                        0x0458
#define regBIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK                                                          0x0459
#define regBIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL                                                       0x045a
#define regBIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG0                                                               0x045b
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG0_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG1                                                               0x045c
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG1_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG2                                                               0x045d
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG2_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG3                                                               0x045e
#define regBIF_CFG_DEV1_RC0_PCIE_HDR_LOG3_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD                                                           0x045f
#define regBIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS                                                        0x0460
#define regBIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID                                                             0x0461
#define regBIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG0                                                        0x0462
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG1                                                        0x0463
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG2                                                        0x0464
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG3                                                        0x0465
#define regBIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                               5
#define regBIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST                                                 0x049c
#define regBIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3                                                             0x049d
#define regBIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS                                                      0x049e
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL                                               0x049f
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL                                               0x049f
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL                                               0x04a0
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL                                               0x04a0
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL                                               0x04a1
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL                                               0x04a1
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL                                               0x04a2
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL                                               0x04a2
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL                                               0x04a3
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL                                               0x04a3
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL                                              0x04a4
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL                                              0x04a4
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL                                              0x04a5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL                                              0x04a5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL                                              0x04a6
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL                                              0x04a6
#define regBIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST                                                       0x04a8
#define regBIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_PCIE_ACS_CAP                                                                0x04a9
#define regBIF_CFG_DEV1_RC0_PCIE_ACS_CAP_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_RC0_PCIE_ACS_CNTL                                                               0x04a9
#define regBIF_CFG_DEV1_RC0_PCIE_ACS_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_DLF_ENH_CAP_LIST                                                       0x0500
#define regBIF_CFG_DEV1_RC0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_DATA_LINK_FEATURE_CAP                                                       0x0501
#define regBIF_CFG_DEV1_RC0_DATA_LINK_FEATURE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_DATA_LINK_FEATURE_STATUS                                                    0x0502
#define regBIF_CFG_DEV1_RC0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV1_RC0_PCIE_PHY_16GT_ENH_CAP_LIST                                                  0x0504
#define regBIF_CFG_DEV1_RC0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LINK_CAP_16GT                                                               0x0505
#define regBIF_CFG_DEV1_RC0_LINK_CAP_16GT_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_RC0_LINK_CNTL_16GT                                                              0x0506
#define regBIF_CFG_DEV1_RC0_LINK_CNTL_16GT_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_RC0_LINK_STATUS_16GT                                                            0x0507
#define regBIF_CFG_DEV1_RC0_LINK_STATUS_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                           0x0508
#define regBIF_CFG_DEV1_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT                                            0x0509
#define regBIF_CFG_DEV1_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT                                            0x050a
#define regBIF_CFG_DEV1_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_RC0_LANE_0_EQUALIZATION_CNTL_16GT                                               0x050c
#define regBIF_CFG_DEV1_RC0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_1_EQUALIZATION_CNTL_16GT                                               0x050c
#define regBIF_CFG_DEV1_RC0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_2_EQUALIZATION_CNTL_16GT                                               0x050c
#define regBIF_CFG_DEV1_RC0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_3_EQUALIZATION_CNTL_16GT                                               0x050c
#define regBIF_CFG_DEV1_RC0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_4_EQUALIZATION_CNTL_16GT                                               0x050d
#define regBIF_CFG_DEV1_RC0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_5_EQUALIZATION_CNTL_16GT                                               0x050d
#define regBIF_CFG_DEV1_RC0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_6_EQUALIZATION_CNTL_16GT                                               0x050d
#define regBIF_CFG_DEV1_RC0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_7_EQUALIZATION_CNTL_16GT                                               0x050d
#define regBIF_CFG_DEV1_RC0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_8_EQUALIZATION_CNTL_16GT                                               0x050e
#define regBIF_CFG_DEV1_RC0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_9_EQUALIZATION_CNTL_16GT                                               0x050e
#define regBIF_CFG_DEV1_RC0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_10_EQUALIZATION_CNTL_16GT                                              0x050e
#define regBIF_CFG_DEV1_RC0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_LANE_11_EQUALIZATION_CNTL_16GT                                              0x050e
#define regBIF_CFG_DEV1_RC0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_LANE_12_EQUALIZATION_CNTL_16GT                                              0x050f
#define regBIF_CFG_DEV1_RC0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_LANE_13_EQUALIZATION_CNTL_16GT                                              0x050f
#define regBIF_CFG_DEV1_RC0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_LANE_14_EQUALIZATION_CNTL_16GT                                              0x050f
#define regBIF_CFG_DEV1_RC0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_LANE_15_EQUALIZATION_CNTL_16GT                                              0x050f
#define regBIF_CFG_DEV1_RC0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_RC0_PCIE_MARGINING_ENH_CAP_LIST                                                 0x0514
#define regBIF_CFG_DEV1_RC0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_MARGINING_PORT_CAP                                                          0x0515
#define regBIF_CFG_DEV1_RC0_MARGINING_PORT_CAP_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_RC0_MARGINING_PORT_STATUS                                                       0x0515
#define regBIF_CFG_DEV1_RC0_MARGINING_PORT_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_LANE_0_MARGINING_LANE_CNTL                                                  0x0516
#define regBIF_CFG_DEV1_RC0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_0_MARGINING_LANE_STATUS                                                0x0516
#define regBIF_CFG_DEV1_RC0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_1_MARGINING_LANE_CNTL                                                  0x0517
#define regBIF_CFG_DEV1_RC0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_1_MARGINING_LANE_STATUS                                                0x0517
#define regBIF_CFG_DEV1_RC0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_2_MARGINING_LANE_CNTL                                                  0x0518
#define regBIF_CFG_DEV1_RC0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_2_MARGINING_LANE_STATUS                                                0x0518
#define regBIF_CFG_DEV1_RC0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_3_MARGINING_LANE_CNTL                                                  0x0519
#define regBIF_CFG_DEV1_RC0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_3_MARGINING_LANE_STATUS                                                0x0519
#define regBIF_CFG_DEV1_RC0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_4_MARGINING_LANE_CNTL                                                  0x051a
#define regBIF_CFG_DEV1_RC0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_4_MARGINING_LANE_STATUS                                                0x051a
#define regBIF_CFG_DEV1_RC0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_5_MARGINING_LANE_CNTL                                                  0x051b
#define regBIF_CFG_DEV1_RC0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_5_MARGINING_LANE_STATUS                                                0x051b
#define regBIF_CFG_DEV1_RC0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_6_MARGINING_LANE_CNTL                                                  0x051c
#define regBIF_CFG_DEV1_RC0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_6_MARGINING_LANE_STATUS                                                0x051c
#define regBIF_CFG_DEV1_RC0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_7_MARGINING_LANE_CNTL                                                  0x051d
#define regBIF_CFG_DEV1_RC0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_7_MARGINING_LANE_STATUS                                                0x051d
#define regBIF_CFG_DEV1_RC0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_8_MARGINING_LANE_CNTL                                                  0x051e
#define regBIF_CFG_DEV1_RC0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_8_MARGINING_LANE_STATUS                                                0x051e
#define regBIF_CFG_DEV1_RC0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_9_MARGINING_LANE_CNTL                                                  0x051f
#define regBIF_CFG_DEV1_RC0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV1_RC0_LANE_9_MARGINING_LANE_STATUS                                                0x051f
#define regBIF_CFG_DEV1_RC0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV1_RC0_LANE_10_MARGINING_LANE_CNTL                                                 0x0520
#define regBIF_CFG_DEV1_RC0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_LANE_10_MARGINING_LANE_STATUS                                               0x0520
#define regBIF_CFG_DEV1_RC0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_11_MARGINING_LANE_CNTL                                                 0x0521
#define regBIF_CFG_DEV1_RC0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_LANE_11_MARGINING_LANE_STATUS                                               0x0521
#define regBIF_CFG_DEV1_RC0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_12_MARGINING_LANE_CNTL                                                 0x0522
#define regBIF_CFG_DEV1_RC0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_LANE_12_MARGINING_LANE_STATUS                                               0x0522
#define regBIF_CFG_DEV1_RC0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_13_MARGINING_LANE_CNTL                                                 0x0523
#define regBIF_CFG_DEV1_RC0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_LANE_13_MARGINING_LANE_STATUS                                               0x0523
#define regBIF_CFG_DEV1_RC0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_14_MARGINING_LANE_CNTL                                                 0x0524
#define regBIF_CFG_DEV1_RC0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_LANE_14_MARGINING_LANE_STATUS                                               0x0524
#define regBIF_CFG_DEV1_RC0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_LANE_15_MARGINING_LANE_CNTL                                                 0x0525
#define regBIF_CFG_DEV1_RC0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_RC0_LANE_15_MARGINING_LANE_STATUS                                               0x0525
#define regBIF_CFG_DEV1_RC0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV1_RC0_PCIE_RTR_ENH_CAP_LIST                                                       0x055c
#define regBIF_CFG_DEV1_RC0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV1_RC0_RTR_DATA1                                                                   0x055d
#define regBIF_CFG_DEV1_RC0_RTR_DATA1_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_RC0_RTR_DATA2                                                                   0x055e
#define regBIF_CFG_DEV1_RC0_RTR_DATA2_BASE_IDX                                                          5


// addressBlock: nbio_nbif0_bif_cfg_dev1_epf0_bifcfgdecp
// base address: 0x10148000
#define regBIF_CFG_DEV1_EPF0_0_VENDOR_ID                                                                0x12000
#define regBIF_CFG_DEV1_EPF0_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_ID                                                                0x12000
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_COMMAND                                                                  0x12001
#define regBIF_CFG_DEV1_EPF0_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF0_0_STATUS                                                                   0x12001
#define regBIF_CFG_DEV1_EPF0_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_EPF0_0_REVISION_ID                                                              0x12002
#define regBIF_CFG_DEV1_EPF0_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_PROG_INTERFACE                                                           0x12002
#define regBIF_CFG_DEV1_EPF0_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_SUB_CLASS                                                                0x12002
#define regBIF_CFG_DEV1_EPF0_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_BASE_CLASS                                                               0x12002
#define regBIF_CFG_DEV1_EPF0_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_CACHE_LINE                                                               0x12003
#define regBIF_CFG_DEV1_EPF0_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_LATENCY                                                                  0x12003
#define regBIF_CFG_DEV1_EPF0_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF0_0_HEADER                                                                   0x12003
#define regBIF_CFG_DEV1_EPF0_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_EPF0_0_BIST                                                                     0x12003
#define regBIF_CFG_DEV1_EPF0_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_1                                                              0x12004
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_2                                                              0x12005
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_3                                                              0x12006
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_4                                                              0x12007
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_5                                                              0x12008
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_6                                                              0x12009
#define regBIF_CFG_DEV1_EPF0_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_ADAPTER_ID                                                               0x1200b
#define regBIF_CFG_DEV1_EPF0_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_ROM_BASE_ADDR                                                            0x1200c
#define regBIF_CFG_DEV1_EPF0_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_CAP_PTR                                                                  0x1200d
#define regBIF_CFG_DEV1_EPF0_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF0_0_INTERRUPT_LINE                                                           0x1200f
#define regBIF_CFG_DEV1_EPF0_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_INTERRUPT_PIN                                                            0x1200f
#define regBIF_CFG_DEV1_EPF0_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_MIN_GRANT                                                                0x1200f
#define regBIF_CFG_DEV1_EPF0_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_MAX_LATENCY                                                              0x1200f
#define regBIF_CFG_DEV1_EPF0_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_VENDOR_CAP_LIST                                                          0x12012
#define regBIF_CFG_DEV1_EPF0_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_ADAPTER_ID_W                                                             0x12013
#define regBIF_CFG_DEV1_EPF0_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PMI_CAP_LIST                                                             0x12014
#define regBIF_CFG_DEV1_EPF0_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PMI_CAP                                                                  0x12014
#define regBIF_CFG_DEV1_EPF0_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF0_0_PMI_STATUS_CNTL                                                          0x12015
#define regBIF_CFG_DEV1_EPF0_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_SBRN                                                                     0x12018
#define regBIF_CFG_DEV1_EPF0_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_EPF0_0_FLADJ                                                                    0x12018
#define regBIF_CFG_DEV1_EPF0_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_EPF0_0_DBESL_DBESLD                                                             0x12018
#define regBIF_CFG_DEV1_EPF0_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CAP_LIST                                                            0x12019
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CAP                                                                 0x12019
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CAP                                                               0x1201a
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CNTL                                                              0x1201b
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_STATUS                                                            0x1201b
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_LINK_CAP                                                                 0x1201c
#define regBIF_CFG_DEV1_EPF0_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF0_0_LINK_CNTL                                                                0x1201d
#define regBIF_CFG_DEV1_EPF0_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_LINK_STATUS                                                              0x1201d
#define regBIF_CFG_DEV1_EPF0_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CAP2                                                              0x12022
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CNTL2                                                             0x12023
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_STATUS2                                                           0x12023
#define regBIF_CFG_DEV1_EPF0_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_LINK_CAP2                                                                0x12024
#define regBIF_CFG_DEV1_EPF0_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_LINK_CNTL2                                                               0x12025
#define regBIF_CFG_DEV1_EPF0_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_LINK_STATUS2                                                             0x12025
#define regBIF_CFG_DEV1_EPF0_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_MSI_CAP_LIST                                                             0x12028
#define regBIF_CFG_DEV1_EPF0_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_CNTL                                                             0x12028
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_ADDR_LO                                                          0x12029
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_ADDR_HI                                                          0x1202a
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_DATA                                                             0x1202a
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_MSI_EXT_MSG_DATA                                                         0x1202a
#define regBIF_CFG_DEV1_EPF0_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MASK                                                                 0x1202b
#define regBIF_CFG_DEV1_EPF0_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_DATA_64                                                          0x1202b
#define regBIF_CFG_DEV1_EPF0_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_MSI_EXT_MSG_DATA_64                                                      0x1202b
#define regBIF_CFG_DEV1_EPF0_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV1_EPF0_0_MSI_MASK_64                                                              0x1202c
#define regBIF_CFG_DEV1_EPF0_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_MSI_PENDING                                                              0x1202c
#define regBIF_CFG_DEV1_EPF0_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF0_0_MSI_PENDING_64                                                           0x1202d
#define regBIF_CFG_DEV1_EPF0_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_MSIX_CAP_LIST                                                            0x12030
#define regBIF_CFG_DEV1_EPF0_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_MSIX_MSG_CNTL                                                            0x12030
#define regBIF_CFG_DEV1_EPF0_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_MSIX_TABLE                                                               0x12031
#define regBIF_CFG_DEV1_EPF0_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_MSIX_PBA                                                                 0x12032
#define regBIF_CFG_DEV1_EPF0_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF0_0_SATA_CAP_0                                                               0x12034
#define regBIF_CFG_DEV1_EPF0_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_SATA_CAP_1                                                               0x12035
#define regBIF_CFG_DEV1_EPF0_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF0_0_SATA_IDP_INDEX                                                           0x12036
#define regBIF_CFG_DEV1_EPF0_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_SATA_IDP_DATA                                                            0x12037
#define regBIF_CFG_DEV1_EPF0_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x12040
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x12041
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC1                                                    0x12042
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC2                                                    0x12043
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC_ENH_CAP_LIST                                                     0x12044
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_CAP_REG1                                                    0x12045
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_CAP_REG2                                                    0x12046
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_CNTL                                                        0x12047
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_CNTL_BASE_IDX                                               5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_STATUS                                                      0x12047
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PORT_VC_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC0_RESOURCE_CAP                                                    0x12048
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC0_RESOURCE_CNTL                                                   0x12049
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC0_RESOURCE_STATUS                                                 0x1204a
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC1_RESOURCE_CAP                                                    0x1204b
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC1_RESOURCE_CNTL                                                   0x1204c
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC1_RESOURCE_STATUS                                                 0x1204d
#define regBIF_CFG_DEV1_EPF0_0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x12054
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_UNCORR_ERR_STATUS                                                   0x12055
#define regBIF_CFG_DEV1_EPF0_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_UNCORR_ERR_MASK                                                     0x12056
#define regBIF_CFG_DEV1_EPF0_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x12057
#define regBIF_CFG_DEV1_EPF0_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CORR_ERR_STATUS                                                     0x12058
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CORR_ERR_MASK                                                       0x12059
#define regBIF_CFG_DEV1_EPF0_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1205a
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG0                                                            0x1205b
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG1                                                            0x1205c
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG2                                                            0x1205d
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG3                                                            0x1205e
#define regBIF_CFG_DEV1_EPF0_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG0                                                     0x12062
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG1                                                     0x12063
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG2                                                     0x12064
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG3                                                     0x12065
#define regBIF_CFG_DEV1_EPF0_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR_ENH_CAP_LIST                                                    0x12080
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR1_CAP                                                            0x12081
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR1_CNTL                                                           0x12082
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR2_CAP                                                            0x12083
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR2_CNTL                                                           0x12084
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR3_CAP                                                            0x12085
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR3_CNTL                                                           0x12086
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR4_CAP                                                            0x12087
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR4_CNTL                                                           0x12088
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR5_CAP                                                            0x12089
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR5_CNTL                                                           0x1208a
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR6_CAP                                                            0x1208b
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR6_CNTL                                                           0x1208c
#define regBIF_CFG_DEV1_EPF0_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x12090
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x12091
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_DATA                                                     0x12092
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_CAP                                                      0x12093
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_ENH_CAP_LIST                                                    0x12094
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_CAP                                                             0x12095
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_LATENCY_INDICATOR                                               0x12096
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_STATUS                                                          0x12097
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_CNTL                                                            0x12097
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x12098
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x12098
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x12098
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x12098
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x12099
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x12099
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x12099
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x12099
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST                                              0x1209c
#define regBIF_CFG_DEV1_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LINK_CNTL3                                                          0x1209d
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LINK_CNTL3_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_ERROR_STATUS                                                   0x1209e
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL                                            0x1209f
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL                                            0x1209f
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL                                            0x120a0
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL                                            0x120a0
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL                                            0x120a1
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL                                            0x120a1
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL                                            0x120a2
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL                                            0x120a2
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL                                            0x120a3
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL                                            0x120a3
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL                                           0x120a4
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL                                           0x120a4
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL                                           0x120a5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL                                           0x120a5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL                                           0x120a6
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL                                           0x120a6
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ACS_ENH_CAP_LIST                                                    0x120a8
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ACS_CAP                                                             0x120a9
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ACS_CNTL                                                            0x120a9
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PASID_ENH_CAP_LIST                                                  0x120b4
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PASID_CAP                                                           0x120b5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PASID_CNTL                                                          0x120b5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LTR_ENH_CAP_LIST                                                    0x120c8
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LTR_CAP                                                             0x120c9
#define regBIF_CFG_DEV1_EPF0_0_PCIE_LTR_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ARI_ENH_CAP_LIST                                                    0x120ca
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ARI_CAP                                                             0x120cb
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ARI_CNTL                                                            0x120cb
#define regBIF_CFG_DEV1_EPF0_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DLF_ENH_CAP_LIST                                                    0x12100
#define regBIF_CFG_DEV1_EPF0_0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_DATA_LINK_FEATURE_CAP                                                    0x12101
#define regBIF_CFG_DEV1_EPF0_0_DATA_LINK_FEATURE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_DATA_LINK_FEATURE_STATUS                                                 0x12102
#define regBIF_CFG_DEV1_EPF0_0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PHY_16GT_ENH_CAP_LIST                                               0x12104
#define regBIF_CFG_DEV1_EPF0_0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LINK_CAP_16GT                                                            0x12105
#define regBIF_CFG_DEV1_EPF0_0_LINK_CAP_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF0_0_LINK_CNTL_16GT                                                           0x12106
#define regBIF_CFG_DEV1_EPF0_0_LINK_CNTL_16GT_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF0_0_LINK_STATUS_16GT                                                         0x12107
#define regBIF_CFG_DEV1_EPF0_0_LINK_STATUS_16GT_BASE_IDX                                                5
#define regBIF_CFG_DEV1_EPF0_0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                        0x12108
#define regBIF_CFG_DEV1_EPF0_0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                               5
#define regBIF_CFG_DEV1_EPF0_0_RTM1_PARITY_MISMATCH_STATUS_16GT                                         0x12109
#define regBIF_CFG_DEV1_EPF0_0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV1_EPF0_0_RTM2_PARITY_MISMATCH_STATUS_16GT                                         0x1210a
#define regBIF_CFG_DEV1_EPF0_0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV1_EPF0_0_LANE_0_EQUALIZATION_CNTL_16GT                                            0x1210c
#define regBIF_CFG_DEV1_EPF0_0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_1_EQUALIZATION_CNTL_16GT                                            0x1210c
#define regBIF_CFG_DEV1_EPF0_0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_2_EQUALIZATION_CNTL_16GT                                            0x1210c
#define regBIF_CFG_DEV1_EPF0_0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_3_EQUALIZATION_CNTL_16GT                                            0x1210c
#define regBIF_CFG_DEV1_EPF0_0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_4_EQUALIZATION_CNTL_16GT                                            0x1210d
#define regBIF_CFG_DEV1_EPF0_0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_5_EQUALIZATION_CNTL_16GT                                            0x1210d
#define regBIF_CFG_DEV1_EPF0_0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_6_EQUALIZATION_CNTL_16GT                                            0x1210d
#define regBIF_CFG_DEV1_EPF0_0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_7_EQUALIZATION_CNTL_16GT                                            0x1210d
#define regBIF_CFG_DEV1_EPF0_0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_8_EQUALIZATION_CNTL_16GT                                            0x1210e
#define regBIF_CFG_DEV1_EPF0_0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_9_EQUALIZATION_CNTL_16GT                                            0x1210e
#define regBIF_CFG_DEV1_EPF0_0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_10_EQUALIZATION_CNTL_16GT                                           0x1210e
#define regBIF_CFG_DEV1_EPF0_0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_LANE_11_EQUALIZATION_CNTL_16GT                                           0x1210e
#define regBIF_CFG_DEV1_EPF0_0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_LANE_12_EQUALIZATION_CNTL_16GT                                           0x1210f
#define regBIF_CFG_DEV1_EPF0_0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_LANE_13_EQUALIZATION_CNTL_16GT                                           0x1210f
#define regBIF_CFG_DEV1_EPF0_0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_LANE_14_EQUALIZATION_CNTL_16GT                                           0x1210f
#define regBIF_CFG_DEV1_EPF0_0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_LANE_15_EQUALIZATION_CNTL_16GT                                           0x1210f
#define regBIF_CFG_DEV1_EPF0_0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_MARGINING_ENH_CAP_LIST                                              0x12114
#define regBIF_CFG_DEV1_EPF0_0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_MARGINING_PORT_CAP                                                       0x12115
#define regBIF_CFG_DEV1_EPF0_0_MARGINING_PORT_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV1_EPF0_0_MARGINING_PORT_STATUS                                                    0x12115
#define regBIF_CFG_DEV1_EPF0_0_MARGINING_PORT_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_LANE_0_MARGINING_LANE_CNTL                                               0x12116
#define regBIF_CFG_DEV1_EPF0_0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_0_MARGINING_LANE_STATUS                                             0x12116
#define regBIF_CFG_DEV1_EPF0_0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_1_MARGINING_LANE_CNTL                                               0x12117
#define regBIF_CFG_DEV1_EPF0_0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_1_MARGINING_LANE_STATUS                                             0x12117
#define regBIF_CFG_DEV1_EPF0_0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_2_MARGINING_LANE_CNTL                                               0x12118
#define regBIF_CFG_DEV1_EPF0_0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_2_MARGINING_LANE_STATUS                                             0x12118
#define regBIF_CFG_DEV1_EPF0_0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_3_MARGINING_LANE_CNTL                                               0x12119
#define regBIF_CFG_DEV1_EPF0_0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_3_MARGINING_LANE_STATUS                                             0x12119
#define regBIF_CFG_DEV1_EPF0_0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_4_MARGINING_LANE_CNTL                                               0x1211a
#define regBIF_CFG_DEV1_EPF0_0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_4_MARGINING_LANE_STATUS                                             0x1211a
#define regBIF_CFG_DEV1_EPF0_0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_5_MARGINING_LANE_CNTL                                               0x1211b
#define regBIF_CFG_DEV1_EPF0_0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_5_MARGINING_LANE_STATUS                                             0x1211b
#define regBIF_CFG_DEV1_EPF0_0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_6_MARGINING_LANE_CNTL                                               0x1211c
#define regBIF_CFG_DEV1_EPF0_0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_6_MARGINING_LANE_STATUS                                             0x1211c
#define regBIF_CFG_DEV1_EPF0_0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_7_MARGINING_LANE_CNTL                                               0x1211d
#define regBIF_CFG_DEV1_EPF0_0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_7_MARGINING_LANE_STATUS                                             0x1211d
#define regBIF_CFG_DEV1_EPF0_0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_8_MARGINING_LANE_CNTL                                               0x1211e
#define regBIF_CFG_DEV1_EPF0_0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_8_MARGINING_LANE_STATUS                                             0x1211e
#define regBIF_CFG_DEV1_EPF0_0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_9_MARGINING_LANE_CNTL                                               0x1211f
#define regBIF_CFG_DEV1_EPF0_0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF0_0_LANE_9_MARGINING_LANE_STATUS                                             0x1211f
#define regBIF_CFG_DEV1_EPF0_0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF0_0_LANE_10_MARGINING_LANE_CNTL                                              0x12120
#define regBIF_CFG_DEV1_EPF0_0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_LANE_10_MARGINING_LANE_STATUS                                            0x12120
#define regBIF_CFG_DEV1_EPF0_0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_11_MARGINING_LANE_CNTL                                              0x12121
#define regBIF_CFG_DEV1_EPF0_0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_LANE_11_MARGINING_LANE_STATUS                                            0x12121
#define regBIF_CFG_DEV1_EPF0_0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_12_MARGINING_LANE_CNTL                                              0x12122
#define regBIF_CFG_DEV1_EPF0_0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_LANE_12_MARGINING_LANE_STATUS                                            0x12122
#define regBIF_CFG_DEV1_EPF0_0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_13_MARGINING_LANE_CNTL                                              0x12123
#define regBIF_CFG_DEV1_EPF0_0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_LANE_13_MARGINING_LANE_STATUS                                            0x12123
#define regBIF_CFG_DEV1_EPF0_0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_14_MARGINING_LANE_CNTL                                              0x12124
#define regBIF_CFG_DEV1_EPF0_0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_LANE_14_MARGINING_LANE_STATUS                                            0x12124
#define regBIF_CFG_DEV1_EPF0_0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_LANE_15_MARGINING_LANE_CNTL                                              0x12125
#define regBIF_CFG_DEV1_EPF0_0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF0_0_LANE_15_MARGINING_LANE_STATUS                                            0x12125
#define regBIF_CFG_DEV1_EPF0_0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF0_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1215c
#define regBIF_CFG_DEV1_EPF0_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF0_0_RTR_DATA1                                                                0x1215d
#define regBIF_CFG_DEV1_EPF0_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF0_0_RTR_DATA2                                                                0x1215e
#define regBIF_CFG_DEV1_EPF0_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev1_epf1_bifcfgdecp
// base address: 0x10149000
#define regBIF_CFG_DEV1_EPF1_0_VENDOR_ID                                                                0x12400
#define regBIF_CFG_DEV1_EPF1_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_ID                                                                0x12400
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_COMMAND                                                                  0x12401
#define regBIF_CFG_DEV1_EPF1_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF1_0_STATUS                                                                   0x12401
#define regBIF_CFG_DEV1_EPF1_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_EPF1_0_REVISION_ID                                                              0x12402
#define regBIF_CFG_DEV1_EPF1_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_PROG_INTERFACE                                                           0x12402
#define regBIF_CFG_DEV1_EPF1_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_SUB_CLASS                                                                0x12402
#define regBIF_CFG_DEV1_EPF1_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_BASE_CLASS                                                               0x12402
#define regBIF_CFG_DEV1_EPF1_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_CACHE_LINE                                                               0x12403
#define regBIF_CFG_DEV1_EPF1_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_LATENCY                                                                  0x12403
#define regBIF_CFG_DEV1_EPF1_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF1_0_HEADER                                                                   0x12403
#define regBIF_CFG_DEV1_EPF1_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV1_EPF1_0_BIST                                                                     0x12403
#define regBIF_CFG_DEV1_EPF1_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_1                                                              0x12404
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_2                                                              0x12405
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_3                                                              0x12406
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_4                                                              0x12407
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_5                                                              0x12408
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_6                                                              0x12409
#define regBIF_CFG_DEV1_EPF1_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_ADAPTER_ID                                                               0x1240b
#define regBIF_CFG_DEV1_EPF1_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_ROM_BASE_ADDR                                                            0x1240c
#define regBIF_CFG_DEV1_EPF1_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_CAP_PTR                                                                  0x1240d
#define regBIF_CFG_DEV1_EPF1_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF1_0_INTERRUPT_LINE                                                           0x1240f
#define regBIF_CFG_DEV1_EPF1_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_INTERRUPT_PIN                                                            0x1240f
#define regBIF_CFG_DEV1_EPF1_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_MIN_GRANT                                                                0x1240f
#define regBIF_CFG_DEV1_EPF1_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_MAX_LATENCY                                                              0x1240f
#define regBIF_CFG_DEV1_EPF1_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_VENDOR_CAP_LIST                                                          0x12412
#define regBIF_CFG_DEV1_EPF1_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_ADAPTER_ID_W                                                             0x12413
#define regBIF_CFG_DEV1_EPF1_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_PMI_CAP_LIST                                                             0x12414
#define regBIF_CFG_DEV1_EPF1_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_PMI_CAP                                                                  0x12414
#define regBIF_CFG_DEV1_EPF1_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV1_EPF1_0_PMI_STATUS_CNTL                                                          0x12415
#define regBIF_CFG_DEV1_EPF1_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_SBRN                                                                     0x12418
#define regBIF_CFG_DEV1_EPF1_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV1_EPF1_0_FLADJ                                                                    0x12418
#define regBIF_CFG_DEV1_EPF1_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV1_EPF1_0_DBESL_DBESLD                                                             0x12418
#define regBIF_CFG_DEV1_EPF1_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CAP_LIST                                                            0x12419
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CAP                                                                 0x12419
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CAP                                                               0x1241a
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CNTL                                                              0x1241b
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_STATUS                                                            0x1241b
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_LINK_CAP                                                                 0x1241c
#define regBIF_CFG_DEV1_EPF1_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF1_0_LINK_CNTL                                                                0x1241d
#define regBIF_CFG_DEV1_EPF1_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_LINK_STATUS                                                              0x1241d
#define regBIF_CFG_DEV1_EPF1_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CAP2                                                              0x12422
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CNTL2                                                             0x12423
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_STATUS2                                                           0x12423
#define regBIF_CFG_DEV1_EPF1_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_LINK_CAP2                                                                0x12424
#define regBIF_CFG_DEV1_EPF1_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_LINK_CNTL2                                                               0x12425
#define regBIF_CFG_DEV1_EPF1_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_LINK_STATUS2                                                             0x12425
#define regBIF_CFG_DEV1_EPF1_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_MSI_CAP_LIST                                                             0x12428
#define regBIF_CFG_DEV1_EPF1_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_CNTL                                                             0x12428
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_ADDR_LO                                                          0x12429
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_ADDR_HI                                                          0x1242a
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_DATA                                                             0x1242a
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_MSI_EXT_MSG_DATA                                                         0x1242a
#define regBIF_CFG_DEV1_EPF1_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MASK                                                                 0x1242b
#define regBIF_CFG_DEV1_EPF1_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_DATA_64                                                          0x1242b
#define regBIF_CFG_DEV1_EPF1_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_MSI_EXT_MSG_DATA_64                                                      0x1242b
#define regBIF_CFG_DEV1_EPF1_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV1_EPF1_0_MSI_MASK_64                                                              0x1242c
#define regBIF_CFG_DEV1_EPF1_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_MSI_PENDING                                                              0x1242c
#define regBIF_CFG_DEV1_EPF1_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV1_EPF1_0_MSI_PENDING_64                                                           0x1242d
#define regBIF_CFG_DEV1_EPF1_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_MSIX_CAP_LIST                                                            0x12430
#define regBIF_CFG_DEV1_EPF1_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_MSIX_MSG_CNTL                                                            0x12430
#define regBIF_CFG_DEV1_EPF1_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_MSIX_TABLE                                                               0x12431
#define regBIF_CFG_DEV1_EPF1_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_MSIX_PBA                                                                 0x12432
#define regBIF_CFG_DEV1_EPF1_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV1_EPF1_0_SATA_CAP_0                                                               0x12434
#define regBIF_CFG_DEV1_EPF1_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_SATA_CAP_1                                                               0x12435
#define regBIF_CFG_DEV1_EPF1_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV1_EPF1_0_SATA_IDP_INDEX                                                           0x12436
#define regBIF_CFG_DEV1_EPF1_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_SATA_IDP_DATA                                                            0x12437
#define regBIF_CFG_DEV1_EPF1_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x12440
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x12441
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC1                                                    0x12442
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC2                                                    0x12443
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x12454
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_UNCORR_ERR_STATUS                                                   0x12455
#define regBIF_CFG_DEV1_EPF1_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_UNCORR_ERR_MASK                                                     0x12456
#define regBIF_CFG_DEV1_EPF1_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x12457
#define regBIF_CFG_DEV1_EPF1_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CORR_ERR_STATUS                                                     0x12458
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CORR_ERR_MASK                                                       0x12459
#define regBIF_CFG_DEV1_EPF1_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1245a
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG0                                                            0x1245b
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG1                                                            0x1245c
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG2                                                            0x1245d
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG3                                                            0x1245e
#define regBIF_CFG_DEV1_EPF1_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG0                                                     0x12462
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG1                                                     0x12463
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG2                                                     0x12464
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG3                                                     0x12465
#define regBIF_CFG_DEV1_EPF1_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR_ENH_CAP_LIST                                                    0x12480
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR1_CAP                                                            0x12481
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR1_CNTL                                                           0x12482
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR2_CAP                                                            0x12483
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR2_CNTL                                                           0x12484
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR3_CAP                                                            0x12485
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR3_CNTL                                                           0x12486
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR4_CAP                                                            0x12487
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR4_CNTL                                                           0x12488
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR5_CAP                                                            0x12489
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR5_CNTL                                                           0x1248a
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR6_CAP                                                            0x1248b
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR6_CNTL                                                           0x1248c
#define regBIF_CFG_DEV1_EPF1_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x12490
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x12491
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_DATA                                                     0x12492
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_CAP                                                      0x12493
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_ENH_CAP_LIST                                                    0x12494
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_CAP                                                             0x12495
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_LATENCY_INDICATOR                                               0x12496
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_STATUS                                                          0x12497
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_CNTL                                                            0x12497
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x12498
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x12498
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x12498
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x12498
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x12499
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x12499
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x12499
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x12499
#define regBIF_CFG_DEV1_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ACS_ENH_CAP_LIST                                                    0x124a8
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ACS_CAP                                                             0x124a9
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ACS_CNTL                                                            0x124a9
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PASID_ENH_CAP_LIST                                                  0x124b4
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PASID_CAP                                                           0x124b5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PASID_CNTL                                                          0x124b5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ARI_ENH_CAP_LIST                                                    0x124ca
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ARI_CAP                                                             0x124cb
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ARI_CNTL                                                            0x124cb
#define regBIF_CFG_DEV1_EPF1_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST                                                  0x124cc
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_CAP                                                           0x124cd
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_CONTROL                                                       0x124ce
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_CONTROL_BASE_IDX                                              5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_STATUS                                                        0x124ce
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_INITIAL_VFS                                                   0x124cf
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_INITIAL_VFS_BASE_IDX                                          5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_TOTAL_VFS                                                     0x124cf
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_TOTAL_VFS_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_NUM_VFS                                                       0x124d0
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_NUM_VFS_BASE_IDX                                              5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK                                                 0x124d0
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET                                               0x124d1
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET_BASE_IDX                                      5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_STRIDE                                                     0x124d1
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_STRIDE_BASE_IDX                                            5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID                                                  0x124d2
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                           0x124d3
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE_BASE_IDX                                  5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                              0x124d4
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE_BASE_IDX                                     5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0                                                0x124d5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0_BASE_IDX                                       5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1                                                0x124d6
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1_BASE_IDX                                       5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2                                                0x124d7
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2_BASE_IDX                                       5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3                                                0x124d8
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3_BASE_IDX                                       5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4                                                0x124d9
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4_BASE_IDX                                       5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5                                                0x124da
#define regBIF_CFG_DEV1_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5_BASE_IDX                                       5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                          0x12530
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR1_CAP                                                  0x12531
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR1_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR1_CNTL                                                 0x12532
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR1_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR2_CAP                                                  0x12533
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR2_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR2_CNTL                                                 0x12534
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR2_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR3_CAP                                                  0x12535
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR3_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR3_CNTL                                                 0x12536
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR3_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR4_CAP                                                  0x12537
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR4_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR4_CNTL                                                 0x12538
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR4_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR5_CAP                                                  0x12539
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR5_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR5_CNTL                                                 0x1253a
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR5_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR6_CAP                                                  0x1253b
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR6_CAP_BASE_IDX                                         5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR6_CNTL                                                 0x1253c
#define regBIF_CFG_DEV1_EPF1_0_PCIE_VF_RESIZE_BAR6_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV1_EPF1_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1255c
#define regBIF_CFG_DEV1_EPF1_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV1_EPF1_0_RTR_DATA1                                                                0x1255d
#define regBIF_CFG_DEV1_EPF1_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV1_EPF1_0_RTR_DATA2                                                                0x1255e
#define regBIF_CFG_DEV1_EPF1_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_rc_bifcfgdecp
// base address: 0x10102000
#define regBIF_CFG_DEV2_RC0_VENDOR_ID                                                                   0x0800
#define regBIF_CFG_DEV2_RC0_VENDOR_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_DEVICE_ID                                                                   0x0800
#define regBIF_CFG_DEV2_RC0_DEVICE_ID_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_COMMAND                                                                     0x0801
#define regBIF_CFG_DEV2_RC0_COMMAND_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_RC0_STATUS                                                                      0x0801
#define regBIF_CFG_DEV2_RC0_STATUS_BASE_IDX                                                             5
#define regBIF_CFG_DEV2_RC0_REVISION_ID                                                                 0x0802
#define regBIF_CFG_DEV2_RC0_REVISION_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_PROG_INTERFACE                                                              0x0802
#define regBIF_CFG_DEV2_RC0_PROG_INTERFACE_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_RC0_SUB_CLASS                                                                   0x0802
#define regBIF_CFG_DEV2_RC0_SUB_CLASS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_BASE_CLASS                                                                  0x0802
#define regBIF_CFG_DEV2_RC0_BASE_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_RC0_CACHE_LINE                                                                  0x0803
#define regBIF_CFG_DEV2_RC0_CACHE_LINE_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_RC0_LATENCY                                                                     0x0803
#define regBIF_CFG_DEV2_RC0_LATENCY_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_RC0_HEADER                                                                      0x0803
#define regBIF_CFG_DEV2_RC0_HEADER_BASE_IDX                                                             5
#define regBIF_CFG_DEV2_RC0_BIST                                                                        0x0803
#define regBIF_CFG_DEV2_RC0_BIST_BASE_IDX                                                               5
#define regBIF_CFG_DEV2_RC0_BASE_ADDR_1                                                                 0x0804
#define regBIF_CFG_DEV2_RC0_BASE_ADDR_1_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_BASE_ADDR_2                                                                 0x0805
#define regBIF_CFG_DEV2_RC0_BASE_ADDR_2_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_SUB_BUS_NUMBER_LATENCY                                                      0x0806
#define regBIF_CFG_DEV2_RC0_SUB_BUS_NUMBER_LATENCY_BASE_IDX                                             5
#define regBIF_CFG_DEV2_RC0_IO_BASE_LIMIT                                                               0x0807
#define regBIF_CFG_DEV2_RC0_IO_BASE_LIMIT_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_SECONDARY_STATUS                                                            0x0807
#define regBIF_CFG_DEV2_RC0_SECONDARY_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_RC0_MEM_BASE_LIMIT                                                              0x0808
#define regBIF_CFG_DEV2_RC0_MEM_BASE_LIMIT_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_RC0_PREF_BASE_LIMIT                                                             0x0809
#define regBIF_CFG_DEV2_RC0_PREF_BASE_LIMIT_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_PREF_BASE_UPPER                                                             0x080a
#define regBIF_CFG_DEV2_RC0_PREF_BASE_UPPER_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_PREF_LIMIT_UPPER                                                            0x080b
#define regBIF_CFG_DEV2_RC0_PREF_LIMIT_UPPER_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_RC0_IO_BASE_LIMIT_HI                                                            0x080c
#define regBIF_CFG_DEV2_RC0_IO_BASE_LIMIT_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_RC0_CAP_PTR                                                                     0x080d
#define regBIF_CFG_DEV2_RC0_CAP_PTR_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_RC0_ROM_BASE_ADDR                                                               0x080e
#define regBIF_CFG_DEV2_RC0_ROM_BASE_ADDR_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_INTERRUPT_LINE                                                              0x080f
#define regBIF_CFG_DEV2_RC0_INTERRUPT_LINE_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_RC0_INTERRUPT_PIN                                                               0x080f
#define regBIF_CFG_DEV2_RC0_INTERRUPT_PIN_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_IRQ_BRIDGE_CNTL                                                             0x080f
#define regBIF_CFG_DEV2_RC0_IRQ_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_EXT_BRIDGE_CNTL                                                             0x0810
#define regBIF_CFG_DEV2_RC0_EXT_BRIDGE_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_PMI_CAP_LIST                                                                0x0814
#define regBIF_CFG_DEV2_RC0_PMI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_PMI_CAP                                                                     0x0814
#define regBIF_CFG_DEV2_RC0_PMI_CAP_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_RC0_PMI_STATUS_CNTL                                                             0x0815
#define regBIF_CFG_DEV2_RC0_PMI_STATUS_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_PCIE_CAP_LIST                                                               0x0816
#define regBIF_CFG_DEV2_RC0_PCIE_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_CAP                                                                    0x0816
#define regBIF_CFG_DEV2_RC0_PCIE_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_RC0_DEVICE_CAP                                                                  0x0817
#define regBIF_CFG_DEV2_RC0_DEVICE_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_RC0_DEVICE_CNTL                                                                 0x0818
#define regBIF_CFG_DEV2_RC0_DEVICE_CNTL_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_DEVICE_STATUS                                                               0x0818
#define regBIF_CFG_DEV2_RC0_DEVICE_STATUS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_LINK_CAP                                                                    0x0819
#define regBIF_CFG_DEV2_RC0_LINK_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_RC0_LINK_CNTL                                                                   0x081a
#define regBIF_CFG_DEV2_RC0_LINK_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_LINK_STATUS                                                                 0x081a
#define regBIF_CFG_DEV2_RC0_LINK_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_SLOT_CAP                                                                    0x081b
#define regBIF_CFG_DEV2_RC0_SLOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_RC0_SLOT_CNTL                                                                   0x081c
#define regBIF_CFG_DEV2_RC0_SLOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_SLOT_STATUS                                                                 0x081c
#define regBIF_CFG_DEV2_RC0_SLOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_ROOT_CNTL                                                                   0x081d
#define regBIF_CFG_DEV2_RC0_ROOT_CNTL_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_ROOT_CAP                                                                    0x081d
#define regBIF_CFG_DEV2_RC0_ROOT_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_RC0_ROOT_STATUS                                                                 0x081e
#define regBIF_CFG_DEV2_RC0_ROOT_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_DEVICE_CAP2                                                                 0x081f
#define regBIF_CFG_DEV2_RC0_DEVICE_CAP2_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_DEVICE_CNTL2                                                                0x0820
#define regBIF_CFG_DEV2_RC0_DEVICE_CNTL2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_DEVICE_STATUS2                                                              0x0820
#define regBIF_CFG_DEV2_RC0_DEVICE_STATUS2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_RC0_LINK_CAP2                                                                   0x0821
#define regBIF_CFG_DEV2_RC0_LINK_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_LINK_CNTL2                                                                  0x0822
#define regBIF_CFG_DEV2_RC0_LINK_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_RC0_LINK_STATUS2                                                                0x0822
#define regBIF_CFG_DEV2_RC0_LINK_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_SLOT_CAP2                                                                   0x0823
#define regBIF_CFG_DEV2_RC0_SLOT_CAP2_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_SLOT_CNTL2                                                                  0x0824
#define regBIF_CFG_DEV2_RC0_SLOT_CNTL2_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_RC0_SLOT_STATUS2                                                                0x0824
#define regBIF_CFG_DEV2_RC0_SLOT_STATUS2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_MSI_CAP_LIST                                                                0x0828
#define regBIF_CFG_DEV2_RC0_MSI_CAP_LIST_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_MSI_MSG_CNTL                                                                0x0828
#define regBIF_CFG_DEV2_RC0_MSI_MSG_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_MSI_MSG_ADDR_LO                                                             0x0829
#define regBIF_CFG_DEV2_RC0_MSI_MSG_ADDR_LO_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_MSI_MSG_ADDR_HI                                                             0x082a
#define regBIF_CFG_DEV2_RC0_MSI_MSG_ADDR_HI_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_MSI_MSG_DATA                                                                0x082a
#define regBIF_CFG_DEV2_RC0_MSI_MSG_DATA_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_MSI_EXT_MSG_DATA                                                            0x082a
#define regBIF_CFG_DEV2_RC0_MSI_EXT_MSG_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_RC0_MSI_MSG_DATA_64                                                             0x082b
#define regBIF_CFG_DEV2_RC0_MSI_MSG_DATA_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_MSI_EXT_MSG_DATA_64                                                         0x082b
#define regBIF_CFG_DEV2_RC0_MSI_EXT_MSG_DATA_64_BASE_IDX                                                5
#define regBIF_CFG_DEV2_RC0_SSID_CAP_LIST                                                               0x0830
#define regBIF_CFG_DEV2_RC0_SSID_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_SSID_CAP                                                                    0x0831
#define regBIF_CFG_DEV2_RC0_SSID_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_RC0_MSI_MAP_CAP_LIST                                                            0x0832
#define regBIF_CFG_DEV2_RC0_MSI_MAP_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_RC0_MSI_MAP_CAP                                                                 0x0832
#define regBIF_CFG_DEV2_RC0_MSI_MAP_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                           0x0840
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                  5
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC_HDR                                                    0x0841
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                           5
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC1                                                       0x0842
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC2                                                       0x0843
#define regBIF_CFG_DEV2_RC0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_VC_ENH_CAP_LIST                                                        0x0844
#define regBIF_CFG_DEV2_RC0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_CAP_REG1                                                       0x0845
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_CAP_REG2                                                       0x0846
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_CNTL                                                           0x0847
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_STATUS                                                         0x0847
#define regBIF_CFG_DEV2_RC0_PCIE_PORT_VC_STATUS_BASE_IDX                                                5
#define regBIF_CFG_DEV2_RC0_PCIE_VC0_RESOURCE_CAP                                                       0x0848
#define regBIF_CFG_DEV2_RC0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_VC0_RESOURCE_CNTL                                                      0x0849
#define regBIF_CFG_DEV2_RC0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV2_RC0_PCIE_VC0_RESOURCE_STATUS                                                    0x084a
#define regBIF_CFG_DEV2_RC0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV2_RC0_PCIE_VC1_RESOURCE_CAP                                                       0x084b
#define regBIF_CFG_DEV2_RC0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_VC1_RESOURCE_CNTL                                                      0x084c
#define regBIF_CFG_DEV2_RC0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV2_RC0_PCIE_VC1_RESOURCE_STATUS                                                    0x084d
#define regBIF_CFG_DEV2_RC0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV2_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                            0x0850
#define regBIF_CFG_DEV2_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_RC0_PCIE_DEV_SERIAL_NUM_DW1                                                     0x0851
#define regBIF_CFG_DEV2_RC0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_RC0_PCIE_DEV_SERIAL_NUM_DW2                                                     0x0852
#define regBIF_CFG_DEV2_RC0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                               0x0854
#define regBIF_CFG_DEV2_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_UNCORR_ERR_STATUS                                                      0x0855
#define regBIF_CFG_DEV2_RC0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV2_RC0_PCIE_UNCORR_ERR_MASK                                                        0x0856
#define regBIF_CFG_DEV2_RC0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_UNCORR_ERR_SEVERITY                                                    0x0857
#define regBIF_CFG_DEV2_RC0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                           5
#define regBIF_CFG_DEV2_RC0_PCIE_CORR_ERR_STATUS                                                        0x0858
#define regBIF_CFG_DEV2_RC0_PCIE_CORR_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_CORR_ERR_MASK                                                          0x0859
#define regBIF_CFG_DEV2_RC0_PCIE_CORR_ERR_MASK_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_RC0_PCIE_ADV_ERR_CAP_CNTL                                                       0x085a
#define regBIF_CFG_DEV2_RC0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG0                                                               0x085b
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG1                                                               0x085c
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG2                                                               0x085d
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG3                                                               0x085e
#define regBIF_CFG_DEV2_RC0_PCIE_HDR_LOG3_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_ROOT_ERR_CMD                                                           0x085f
#define regBIF_CFG_DEV2_RC0_PCIE_ROOT_ERR_CMD_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_RC0_PCIE_ROOT_ERR_STATUS                                                        0x0860
#define regBIF_CFG_DEV2_RC0_PCIE_ROOT_ERR_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_ERR_SRC_ID                                                             0x0861
#define regBIF_CFG_DEV2_RC0_PCIE_ERR_SRC_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG0                                                        0x0862
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG1                                                        0x0863
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG2                                                        0x0864
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG3                                                        0x0865
#define regBIF_CFG_DEV2_RC0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                               5
#define regBIF_CFG_DEV2_RC0_PCIE_SECONDARY_ENH_CAP_LIST                                                 0x089c
#define regBIF_CFG_DEV2_RC0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_PCIE_LINK_CNTL3                                                             0x089d
#define regBIF_CFG_DEV2_RC0_PCIE_LINK_CNTL3_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_ERROR_STATUS                                                      0x089e
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_0_EQUALIZATION_CNTL                                               0x089f
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_1_EQUALIZATION_CNTL                                               0x089f
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_2_EQUALIZATION_CNTL                                               0x08a0
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_3_EQUALIZATION_CNTL                                               0x08a0
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_4_EQUALIZATION_CNTL                                               0x08a1
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_5_EQUALIZATION_CNTL                                               0x08a1
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_6_EQUALIZATION_CNTL                                               0x08a2
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_7_EQUALIZATION_CNTL                                               0x08a2
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_8_EQUALIZATION_CNTL                                               0x08a3
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_9_EQUALIZATION_CNTL                                               0x08a3
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_10_EQUALIZATION_CNTL                                              0x08a4
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_11_EQUALIZATION_CNTL                                              0x08a4
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_12_EQUALIZATION_CNTL                                              0x08a5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_13_EQUALIZATION_CNTL                                              0x08a5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_14_EQUALIZATION_CNTL                                              0x08a6
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_15_EQUALIZATION_CNTL                                              0x08a6
#define regBIF_CFG_DEV2_RC0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_ACS_ENH_CAP_LIST                                                       0x08a8
#define regBIF_CFG_DEV2_RC0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_PCIE_ACS_CAP                                                                0x08a9
#define regBIF_CFG_DEV2_RC0_PCIE_ACS_CAP_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_RC0_PCIE_ACS_CNTL                                                               0x08a9
#define regBIF_CFG_DEV2_RC0_PCIE_ACS_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_DLF_ENH_CAP_LIST                                                       0x0900
#define regBIF_CFG_DEV2_RC0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_DATA_LINK_FEATURE_CAP                                                       0x0901
#define regBIF_CFG_DEV2_RC0_DATA_LINK_FEATURE_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_DATA_LINK_FEATURE_STATUS                                                    0x0902
#define regBIF_CFG_DEV2_RC0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV2_RC0_PCIE_PHY_16GT_ENH_CAP_LIST                                                  0x0904
#define regBIF_CFG_DEV2_RC0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LINK_CAP_16GT                                                               0x0905
#define regBIF_CFG_DEV2_RC0_LINK_CAP_16GT_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_RC0_LINK_CNTL_16GT                                                              0x0906
#define regBIF_CFG_DEV2_RC0_LINK_CNTL_16GT_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_RC0_LINK_STATUS_16GT                                                            0x0907
#define regBIF_CFG_DEV2_RC0_LINK_STATUS_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                           0x0908
#define regBIF_CFG_DEV2_RC0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT                                            0x0909
#define regBIF_CFG_DEV2_RC0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT                                            0x090a
#define regBIF_CFG_DEV2_RC0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_RC0_LANE_0_EQUALIZATION_CNTL_16GT                                               0x090c
#define regBIF_CFG_DEV2_RC0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_1_EQUALIZATION_CNTL_16GT                                               0x090c
#define regBIF_CFG_DEV2_RC0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_2_EQUALIZATION_CNTL_16GT                                               0x090c
#define regBIF_CFG_DEV2_RC0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_3_EQUALIZATION_CNTL_16GT                                               0x090c
#define regBIF_CFG_DEV2_RC0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_4_EQUALIZATION_CNTL_16GT                                               0x090d
#define regBIF_CFG_DEV2_RC0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_5_EQUALIZATION_CNTL_16GT                                               0x090d
#define regBIF_CFG_DEV2_RC0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_6_EQUALIZATION_CNTL_16GT                                               0x090d
#define regBIF_CFG_DEV2_RC0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_7_EQUALIZATION_CNTL_16GT                                               0x090d
#define regBIF_CFG_DEV2_RC0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_8_EQUALIZATION_CNTL_16GT                                               0x090e
#define regBIF_CFG_DEV2_RC0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_9_EQUALIZATION_CNTL_16GT                                               0x090e
#define regBIF_CFG_DEV2_RC0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_10_EQUALIZATION_CNTL_16GT                                              0x090e
#define regBIF_CFG_DEV2_RC0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_LANE_11_EQUALIZATION_CNTL_16GT                                              0x090e
#define regBIF_CFG_DEV2_RC0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_LANE_12_EQUALIZATION_CNTL_16GT                                              0x090f
#define regBIF_CFG_DEV2_RC0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_LANE_13_EQUALIZATION_CNTL_16GT                                              0x090f
#define regBIF_CFG_DEV2_RC0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_LANE_14_EQUALIZATION_CNTL_16GT                                              0x090f
#define regBIF_CFG_DEV2_RC0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_LANE_15_EQUALIZATION_CNTL_16GT                                              0x090f
#define regBIF_CFG_DEV2_RC0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_RC0_PCIE_MARGINING_ENH_CAP_LIST                                                 0x0914
#define regBIF_CFG_DEV2_RC0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_MARGINING_PORT_CAP                                                          0x0915
#define regBIF_CFG_DEV2_RC0_MARGINING_PORT_CAP_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_RC0_MARGINING_PORT_STATUS                                                       0x0915
#define regBIF_CFG_DEV2_RC0_MARGINING_PORT_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_LANE_0_MARGINING_LANE_CNTL                                                  0x0916
#define regBIF_CFG_DEV2_RC0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_0_MARGINING_LANE_STATUS                                                0x0916
#define regBIF_CFG_DEV2_RC0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_1_MARGINING_LANE_CNTL                                                  0x0917
#define regBIF_CFG_DEV2_RC0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_1_MARGINING_LANE_STATUS                                                0x0917
#define regBIF_CFG_DEV2_RC0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_2_MARGINING_LANE_CNTL                                                  0x0918
#define regBIF_CFG_DEV2_RC0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_2_MARGINING_LANE_STATUS                                                0x0918
#define regBIF_CFG_DEV2_RC0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_3_MARGINING_LANE_CNTL                                                  0x0919
#define regBIF_CFG_DEV2_RC0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_3_MARGINING_LANE_STATUS                                                0x0919
#define regBIF_CFG_DEV2_RC0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_4_MARGINING_LANE_CNTL                                                  0x091a
#define regBIF_CFG_DEV2_RC0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_4_MARGINING_LANE_STATUS                                                0x091a
#define regBIF_CFG_DEV2_RC0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_5_MARGINING_LANE_CNTL                                                  0x091b
#define regBIF_CFG_DEV2_RC0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_5_MARGINING_LANE_STATUS                                                0x091b
#define regBIF_CFG_DEV2_RC0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_6_MARGINING_LANE_CNTL                                                  0x091c
#define regBIF_CFG_DEV2_RC0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_6_MARGINING_LANE_STATUS                                                0x091c
#define regBIF_CFG_DEV2_RC0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_7_MARGINING_LANE_CNTL                                                  0x091d
#define regBIF_CFG_DEV2_RC0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_7_MARGINING_LANE_STATUS                                                0x091d
#define regBIF_CFG_DEV2_RC0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_8_MARGINING_LANE_CNTL                                                  0x091e
#define regBIF_CFG_DEV2_RC0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_8_MARGINING_LANE_STATUS                                                0x091e
#define regBIF_CFG_DEV2_RC0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_9_MARGINING_LANE_CNTL                                                  0x091f
#define regBIF_CFG_DEV2_RC0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV2_RC0_LANE_9_MARGINING_LANE_STATUS                                                0x091f
#define regBIF_CFG_DEV2_RC0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                       5
#define regBIF_CFG_DEV2_RC0_LANE_10_MARGINING_LANE_CNTL                                                 0x0920
#define regBIF_CFG_DEV2_RC0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_LANE_10_MARGINING_LANE_STATUS                                               0x0920
#define regBIF_CFG_DEV2_RC0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_11_MARGINING_LANE_CNTL                                                 0x0921
#define regBIF_CFG_DEV2_RC0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_LANE_11_MARGINING_LANE_STATUS                                               0x0921
#define regBIF_CFG_DEV2_RC0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_12_MARGINING_LANE_CNTL                                                 0x0922
#define regBIF_CFG_DEV2_RC0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_LANE_12_MARGINING_LANE_STATUS                                               0x0922
#define regBIF_CFG_DEV2_RC0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_13_MARGINING_LANE_CNTL                                                 0x0923
#define regBIF_CFG_DEV2_RC0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_LANE_13_MARGINING_LANE_STATUS                                               0x0923
#define regBIF_CFG_DEV2_RC0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_14_MARGINING_LANE_CNTL                                                 0x0924
#define regBIF_CFG_DEV2_RC0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_LANE_14_MARGINING_LANE_STATUS                                               0x0924
#define regBIF_CFG_DEV2_RC0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_LANE_15_MARGINING_LANE_CNTL                                                 0x0925
#define regBIF_CFG_DEV2_RC0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV2_RC0_LANE_15_MARGINING_LANE_STATUS                                               0x0925
#define regBIF_CFG_DEV2_RC0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV2_RC0_PCIE_RTR_ENH_CAP_LIST                                                       0x095c
#define regBIF_CFG_DEV2_RC0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV2_RC0_RTR_DATA1                                                                   0x095d
#define regBIF_CFG_DEV2_RC0_RTR_DATA1_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_RC0_RTR_DATA2                                                                   0x095e
#define regBIF_CFG_DEV2_RC0_RTR_DATA2_BASE_IDX                                                          5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf0_bifcfgdecp
// base address: 0x10150000
#define regBIF_CFG_DEV2_EPF0_0_VENDOR_ID                                                                0x14000
#define regBIF_CFG_DEV2_EPF0_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_ID                                                                0x14000
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_COMMAND                                                                  0x14001
#define regBIF_CFG_DEV2_EPF0_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF0_0_STATUS                                                                   0x14001
#define regBIF_CFG_DEV2_EPF0_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF0_0_REVISION_ID                                                              0x14002
#define regBIF_CFG_DEV2_EPF0_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_PROG_INTERFACE                                                           0x14002
#define regBIF_CFG_DEV2_EPF0_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_SUB_CLASS                                                                0x14002
#define regBIF_CFG_DEV2_EPF0_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_BASE_CLASS                                                               0x14002
#define regBIF_CFG_DEV2_EPF0_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_CACHE_LINE                                                               0x14003
#define regBIF_CFG_DEV2_EPF0_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_LATENCY                                                                  0x14003
#define regBIF_CFG_DEV2_EPF0_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF0_0_HEADER                                                                   0x14003
#define regBIF_CFG_DEV2_EPF0_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF0_0_BIST                                                                     0x14003
#define regBIF_CFG_DEV2_EPF0_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_1                                                              0x14004
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_2                                                              0x14005
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_3                                                              0x14006
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_4                                                              0x14007
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_5                                                              0x14008
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_6                                                              0x14009
#define regBIF_CFG_DEV2_EPF0_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_ADAPTER_ID                                                               0x1400b
#define regBIF_CFG_DEV2_EPF0_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_ROM_BASE_ADDR                                                            0x1400c
#define regBIF_CFG_DEV2_EPF0_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_CAP_PTR                                                                  0x1400d
#define regBIF_CFG_DEV2_EPF0_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF0_0_INTERRUPT_LINE                                                           0x1400f
#define regBIF_CFG_DEV2_EPF0_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_INTERRUPT_PIN                                                            0x1400f
#define regBIF_CFG_DEV2_EPF0_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_MIN_GRANT                                                                0x1400f
#define regBIF_CFG_DEV2_EPF0_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_MAX_LATENCY                                                              0x1400f
#define regBIF_CFG_DEV2_EPF0_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_VENDOR_CAP_LIST                                                          0x14012
#define regBIF_CFG_DEV2_EPF0_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_ADAPTER_ID_W                                                             0x14013
#define regBIF_CFG_DEV2_EPF0_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PMI_CAP_LIST                                                             0x14014
#define regBIF_CFG_DEV2_EPF0_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PMI_CAP                                                                  0x14014
#define regBIF_CFG_DEV2_EPF0_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF0_0_PMI_STATUS_CNTL                                                          0x14015
#define regBIF_CFG_DEV2_EPF0_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_SBRN                                                                     0x14018
#define regBIF_CFG_DEV2_EPF0_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF0_0_FLADJ                                                                    0x14018
#define regBIF_CFG_DEV2_EPF0_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_EPF0_0_DBESL_DBESLD                                                             0x14018
#define regBIF_CFG_DEV2_EPF0_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CAP_LIST                                                            0x14019
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CAP                                                                 0x14019
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CAP                                                               0x1401a
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CNTL                                                              0x1401b
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_STATUS                                                            0x1401b
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_LINK_CAP                                                                 0x1401c
#define regBIF_CFG_DEV2_EPF0_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF0_0_LINK_CNTL                                                                0x1401d
#define regBIF_CFG_DEV2_EPF0_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_LINK_STATUS                                                              0x1401d
#define regBIF_CFG_DEV2_EPF0_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CAP2                                                              0x14022
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CNTL2                                                             0x14023
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_STATUS2                                                           0x14023
#define regBIF_CFG_DEV2_EPF0_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_LINK_CAP2                                                                0x14024
#define regBIF_CFG_DEV2_EPF0_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_LINK_CNTL2                                                               0x14025
#define regBIF_CFG_DEV2_EPF0_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_LINK_STATUS2                                                             0x14025
#define regBIF_CFG_DEV2_EPF0_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_MSI_CAP_LIST                                                             0x14028
#define regBIF_CFG_DEV2_EPF0_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_CNTL                                                             0x14028
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_ADDR_LO                                                          0x14029
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_ADDR_HI                                                          0x1402a
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_DATA                                                             0x1402a
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_MSI_EXT_MSG_DATA                                                         0x1402a
#define regBIF_CFG_DEV2_EPF0_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MASK                                                                 0x1402b
#define regBIF_CFG_DEV2_EPF0_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_DATA_64                                                          0x1402b
#define regBIF_CFG_DEV2_EPF0_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_MSI_EXT_MSG_DATA_64                                                      0x1402b
#define regBIF_CFG_DEV2_EPF0_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF0_0_MSI_MASK_64                                                              0x1402c
#define regBIF_CFG_DEV2_EPF0_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_MSI_PENDING                                                              0x1402c
#define regBIF_CFG_DEV2_EPF0_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF0_0_MSI_PENDING_64                                                           0x1402d
#define regBIF_CFG_DEV2_EPF0_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_MSIX_CAP_LIST                                                            0x14030
#define regBIF_CFG_DEV2_EPF0_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_MSIX_MSG_CNTL                                                            0x14030
#define regBIF_CFG_DEV2_EPF0_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_MSIX_TABLE                                                               0x14031
#define regBIF_CFG_DEV2_EPF0_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_MSIX_PBA                                                                 0x14032
#define regBIF_CFG_DEV2_EPF0_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF0_0_SATA_CAP_0                                                               0x14034
#define regBIF_CFG_DEV2_EPF0_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_SATA_CAP_1                                                               0x14035
#define regBIF_CFG_DEV2_EPF0_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF0_0_SATA_IDP_INDEX                                                           0x14036
#define regBIF_CFG_DEV2_EPF0_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_SATA_IDP_DATA                                                            0x14037
#define regBIF_CFG_DEV2_EPF0_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x14040
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x14041
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC1                                                    0x14042
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC2                                                    0x14043
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC_ENH_CAP_LIST                                                     0x14044
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_CAP_REG1                                                    0x14045
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_CAP_REG2                                                    0x14046
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_CNTL                                                        0x14047
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_CNTL_BASE_IDX                                               5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_STATUS                                                      0x14047
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PORT_VC_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC0_RESOURCE_CAP                                                    0x14048
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC0_RESOURCE_CNTL                                                   0x14049
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC0_RESOURCE_STATUS                                                 0x1404a
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC1_RESOURCE_CAP                                                    0x1404b
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC1_RESOURCE_CNTL                                                   0x1404c
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC1_RESOURCE_STATUS                                                 0x1404d
#define regBIF_CFG_DEV2_EPF0_0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x14054
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_UNCORR_ERR_STATUS                                                   0x14055
#define regBIF_CFG_DEV2_EPF0_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_UNCORR_ERR_MASK                                                     0x14056
#define regBIF_CFG_DEV2_EPF0_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x14057
#define regBIF_CFG_DEV2_EPF0_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CORR_ERR_STATUS                                                     0x14058
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CORR_ERR_MASK                                                       0x14059
#define regBIF_CFG_DEV2_EPF0_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1405a
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG0                                                            0x1405b
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG1                                                            0x1405c
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG2                                                            0x1405d
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG3                                                            0x1405e
#define regBIF_CFG_DEV2_EPF0_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG0                                                     0x14062
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG1                                                     0x14063
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG2                                                     0x14064
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG3                                                     0x14065
#define regBIF_CFG_DEV2_EPF0_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR_ENH_CAP_LIST                                                    0x14080
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR1_CAP                                                            0x14081
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR1_CNTL                                                           0x14082
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR2_CAP                                                            0x14083
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR2_CNTL                                                           0x14084
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR3_CAP                                                            0x14085
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR3_CNTL                                                           0x14086
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR4_CAP                                                            0x14087
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR4_CNTL                                                           0x14088
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR5_CAP                                                            0x14089
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR5_CNTL                                                           0x1408a
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR6_CAP                                                            0x1408b
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR6_CNTL                                                           0x1408c
#define regBIF_CFG_DEV2_EPF0_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x14090
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x14091
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_DATA                                                     0x14092
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_CAP                                                      0x14093
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_ENH_CAP_LIST                                                    0x14094
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_CAP                                                             0x14095
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_LATENCY_INDICATOR                                               0x14096
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_STATUS                                                          0x14097
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_CNTL                                                            0x14097
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x14098
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x14098
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x14098
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x14098
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x14099
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x14099
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x14099
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x14099
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST                                              0x1409c
#define regBIF_CFG_DEV2_EPF0_0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LINK_CNTL3                                                          0x1409d
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LINK_CNTL3_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_ERROR_STATUS                                                   0x1409e
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL                                            0x1409f
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL                                            0x1409f
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL                                            0x140a0
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL                                            0x140a0
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL                                            0x140a1
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL                                            0x140a1
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL                                            0x140a2
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL                                            0x140a2
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL                                            0x140a3
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL                                            0x140a3
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL                                           0x140a4
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL                                           0x140a4
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL                                           0x140a5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL                                           0x140a5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL                                           0x140a6
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL                                           0x140a6
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ACS_ENH_CAP_LIST                                                    0x140a8
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ACS_CAP                                                             0x140a9
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ACS_CNTL                                                            0x140a9
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PASID_ENH_CAP_LIST                                                  0x140b4
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PASID_CAP                                                           0x140b5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PASID_CNTL                                                          0x140b5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LTR_ENH_CAP_LIST                                                    0x140c8
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LTR_CAP                                                             0x140c9
#define regBIF_CFG_DEV2_EPF0_0_PCIE_LTR_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ARI_ENH_CAP_LIST                                                    0x140ca
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ARI_CAP                                                             0x140cb
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ARI_CNTL                                                            0x140cb
#define regBIF_CFG_DEV2_EPF0_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DLF_ENH_CAP_LIST                                                    0x14100
#define regBIF_CFG_DEV2_EPF0_0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_DATA_LINK_FEATURE_CAP                                                    0x14101
#define regBIF_CFG_DEV2_EPF0_0_DATA_LINK_FEATURE_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_DATA_LINK_FEATURE_STATUS                                                 0x14102
#define regBIF_CFG_DEV2_EPF0_0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PHY_16GT_ENH_CAP_LIST                                               0x14104
#define regBIF_CFG_DEV2_EPF0_0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LINK_CAP_16GT                                                            0x14105
#define regBIF_CFG_DEV2_EPF0_0_LINK_CAP_16GT_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF0_0_LINK_CNTL_16GT                                                           0x14106
#define regBIF_CFG_DEV2_EPF0_0_LINK_CNTL_16GT_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF0_0_LINK_STATUS_16GT                                                         0x14107
#define regBIF_CFG_DEV2_EPF0_0_LINK_STATUS_16GT_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF0_0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                        0x14108
#define regBIF_CFG_DEV2_EPF0_0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF0_0_RTM1_PARITY_MISMATCH_STATUS_16GT                                         0x14109
#define regBIF_CFG_DEV2_EPF0_0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV2_EPF0_0_RTM2_PARITY_MISMATCH_STATUS_16GT                                         0x1410a
#define regBIF_CFG_DEV2_EPF0_0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                5
#define regBIF_CFG_DEV2_EPF0_0_LANE_0_EQUALIZATION_CNTL_16GT                                            0x1410c
#define regBIF_CFG_DEV2_EPF0_0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_1_EQUALIZATION_CNTL_16GT                                            0x1410c
#define regBIF_CFG_DEV2_EPF0_0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_2_EQUALIZATION_CNTL_16GT                                            0x1410c
#define regBIF_CFG_DEV2_EPF0_0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_3_EQUALIZATION_CNTL_16GT                                            0x1410c
#define regBIF_CFG_DEV2_EPF0_0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_4_EQUALIZATION_CNTL_16GT                                            0x1410d
#define regBIF_CFG_DEV2_EPF0_0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_5_EQUALIZATION_CNTL_16GT                                            0x1410d
#define regBIF_CFG_DEV2_EPF0_0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_6_EQUALIZATION_CNTL_16GT                                            0x1410d
#define regBIF_CFG_DEV2_EPF0_0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_7_EQUALIZATION_CNTL_16GT                                            0x1410d
#define regBIF_CFG_DEV2_EPF0_0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_8_EQUALIZATION_CNTL_16GT                                            0x1410e
#define regBIF_CFG_DEV2_EPF0_0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_9_EQUALIZATION_CNTL_16GT                                            0x1410e
#define regBIF_CFG_DEV2_EPF0_0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_10_EQUALIZATION_CNTL_16GT                                           0x1410e
#define regBIF_CFG_DEV2_EPF0_0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_LANE_11_EQUALIZATION_CNTL_16GT                                           0x1410e
#define regBIF_CFG_DEV2_EPF0_0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_LANE_12_EQUALIZATION_CNTL_16GT                                           0x1410f
#define regBIF_CFG_DEV2_EPF0_0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_LANE_13_EQUALIZATION_CNTL_16GT                                           0x1410f
#define regBIF_CFG_DEV2_EPF0_0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_LANE_14_EQUALIZATION_CNTL_16GT                                           0x1410f
#define regBIF_CFG_DEV2_EPF0_0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_LANE_15_EQUALIZATION_CNTL_16GT                                           0x1410f
#define regBIF_CFG_DEV2_EPF0_0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_MARGINING_ENH_CAP_LIST                                              0x14114
#define regBIF_CFG_DEV2_EPF0_0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_MARGINING_PORT_CAP                                                       0x14115
#define regBIF_CFG_DEV2_EPF0_0_MARGINING_PORT_CAP_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF0_0_MARGINING_PORT_STATUS                                                    0x14115
#define regBIF_CFG_DEV2_EPF0_0_MARGINING_PORT_STATUS_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_LANE_0_MARGINING_LANE_CNTL                                               0x14116
#define regBIF_CFG_DEV2_EPF0_0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_0_MARGINING_LANE_STATUS                                             0x14116
#define regBIF_CFG_DEV2_EPF0_0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_1_MARGINING_LANE_CNTL                                               0x14117
#define regBIF_CFG_DEV2_EPF0_0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_1_MARGINING_LANE_STATUS                                             0x14117
#define regBIF_CFG_DEV2_EPF0_0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_2_MARGINING_LANE_CNTL                                               0x14118
#define regBIF_CFG_DEV2_EPF0_0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_2_MARGINING_LANE_STATUS                                             0x14118
#define regBIF_CFG_DEV2_EPF0_0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_3_MARGINING_LANE_CNTL                                               0x14119
#define regBIF_CFG_DEV2_EPF0_0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_3_MARGINING_LANE_STATUS                                             0x14119
#define regBIF_CFG_DEV2_EPF0_0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_4_MARGINING_LANE_CNTL                                               0x1411a
#define regBIF_CFG_DEV2_EPF0_0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_4_MARGINING_LANE_STATUS                                             0x1411a
#define regBIF_CFG_DEV2_EPF0_0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_5_MARGINING_LANE_CNTL                                               0x1411b
#define regBIF_CFG_DEV2_EPF0_0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_5_MARGINING_LANE_STATUS                                             0x1411b
#define regBIF_CFG_DEV2_EPF0_0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_6_MARGINING_LANE_CNTL                                               0x1411c
#define regBIF_CFG_DEV2_EPF0_0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_6_MARGINING_LANE_STATUS                                             0x1411c
#define regBIF_CFG_DEV2_EPF0_0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_7_MARGINING_LANE_CNTL                                               0x1411d
#define regBIF_CFG_DEV2_EPF0_0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_7_MARGINING_LANE_STATUS                                             0x1411d
#define regBIF_CFG_DEV2_EPF0_0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_8_MARGINING_LANE_CNTL                                               0x1411e
#define regBIF_CFG_DEV2_EPF0_0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_8_MARGINING_LANE_STATUS                                             0x1411e
#define regBIF_CFG_DEV2_EPF0_0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_9_MARGINING_LANE_CNTL                                               0x1411f
#define regBIF_CFG_DEV2_EPF0_0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF0_0_LANE_9_MARGINING_LANE_STATUS                                             0x1411f
#define regBIF_CFG_DEV2_EPF0_0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF0_0_LANE_10_MARGINING_LANE_CNTL                                              0x14120
#define regBIF_CFG_DEV2_EPF0_0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_LANE_10_MARGINING_LANE_STATUS                                            0x14120
#define regBIF_CFG_DEV2_EPF0_0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_11_MARGINING_LANE_CNTL                                              0x14121
#define regBIF_CFG_DEV2_EPF0_0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_LANE_11_MARGINING_LANE_STATUS                                            0x14121
#define regBIF_CFG_DEV2_EPF0_0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_12_MARGINING_LANE_CNTL                                              0x14122
#define regBIF_CFG_DEV2_EPF0_0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_LANE_12_MARGINING_LANE_STATUS                                            0x14122
#define regBIF_CFG_DEV2_EPF0_0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_13_MARGINING_LANE_CNTL                                              0x14123
#define regBIF_CFG_DEV2_EPF0_0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_LANE_13_MARGINING_LANE_STATUS                                            0x14123
#define regBIF_CFG_DEV2_EPF0_0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_14_MARGINING_LANE_CNTL                                              0x14124
#define regBIF_CFG_DEV2_EPF0_0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_LANE_14_MARGINING_LANE_STATUS                                            0x14124
#define regBIF_CFG_DEV2_EPF0_0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_LANE_15_MARGINING_LANE_CNTL                                              0x14125
#define regBIF_CFG_DEV2_EPF0_0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF0_0_LANE_15_MARGINING_LANE_STATUS                                            0x14125
#define regBIF_CFG_DEV2_EPF0_0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF0_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1415c
#define regBIF_CFG_DEV2_EPF0_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF0_0_RTR_DATA1                                                                0x1415d
#define regBIF_CFG_DEV2_EPF0_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF0_0_RTR_DATA2                                                                0x1415e
#define regBIF_CFG_DEV2_EPF0_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf1_bifcfgdecp
// base address: 0x10151000
#define regBIF_CFG_DEV2_EPF1_0_VENDOR_ID                                                                0x14400
#define regBIF_CFG_DEV2_EPF1_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_ID                                                                0x14400
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_COMMAND                                                                  0x14401
#define regBIF_CFG_DEV2_EPF1_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF1_0_STATUS                                                                   0x14401
#define regBIF_CFG_DEV2_EPF1_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF1_0_REVISION_ID                                                              0x14402
#define regBIF_CFG_DEV2_EPF1_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_PROG_INTERFACE                                                           0x14402
#define regBIF_CFG_DEV2_EPF1_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_SUB_CLASS                                                                0x14402
#define regBIF_CFG_DEV2_EPF1_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_BASE_CLASS                                                               0x14402
#define regBIF_CFG_DEV2_EPF1_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_CACHE_LINE                                                               0x14403
#define regBIF_CFG_DEV2_EPF1_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_LATENCY                                                                  0x14403
#define regBIF_CFG_DEV2_EPF1_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF1_0_HEADER                                                                   0x14403
#define regBIF_CFG_DEV2_EPF1_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF1_0_BIST                                                                     0x14403
#define regBIF_CFG_DEV2_EPF1_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_1                                                              0x14404
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_2                                                              0x14405
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_3                                                              0x14406
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_4                                                              0x14407
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_5                                                              0x14408
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_6                                                              0x14409
#define regBIF_CFG_DEV2_EPF1_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_ADAPTER_ID                                                               0x1440b
#define regBIF_CFG_DEV2_EPF1_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_ROM_BASE_ADDR                                                            0x1440c
#define regBIF_CFG_DEV2_EPF1_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_CAP_PTR                                                                  0x1440d
#define regBIF_CFG_DEV2_EPF1_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF1_0_INTERRUPT_LINE                                                           0x1440f
#define regBIF_CFG_DEV2_EPF1_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_INTERRUPT_PIN                                                            0x1440f
#define regBIF_CFG_DEV2_EPF1_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_MIN_GRANT                                                                0x1440f
#define regBIF_CFG_DEV2_EPF1_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_MAX_LATENCY                                                              0x1440f
#define regBIF_CFG_DEV2_EPF1_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_VENDOR_CAP_LIST                                                          0x14412
#define regBIF_CFG_DEV2_EPF1_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_ADAPTER_ID_W                                                             0x14413
#define regBIF_CFG_DEV2_EPF1_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_PMI_CAP_LIST                                                             0x14414
#define regBIF_CFG_DEV2_EPF1_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_PMI_CAP                                                                  0x14414
#define regBIF_CFG_DEV2_EPF1_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF1_0_PMI_STATUS_CNTL                                                          0x14415
#define regBIF_CFG_DEV2_EPF1_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_SBRN                                                                     0x14418
#define regBIF_CFG_DEV2_EPF1_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF1_0_FLADJ                                                                    0x14418
#define regBIF_CFG_DEV2_EPF1_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_EPF1_0_DBESL_DBESLD                                                             0x14418
#define regBIF_CFG_DEV2_EPF1_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CAP_LIST                                                            0x14419
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CAP                                                                 0x14419
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CAP                                                               0x1441a
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CNTL                                                              0x1441b
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_STATUS                                                            0x1441b
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_LINK_CAP                                                                 0x1441c
#define regBIF_CFG_DEV2_EPF1_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF1_0_LINK_CNTL                                                                0x1441d
#define regBIF_CFG_DEV2_EPF1_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_LINK_STATUS                                                              0x1441d
#define regBIF_CFG_DEV2_EPF1_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CAP2                                                              0x14422
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CNTL2                                                             0x14423
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_STATUS2                                                           0x14423
#define regBIF_CFG_DEV2_EPF1_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_LINK_CAP2                                                                0x14424
#define regBIF_CFG_DEV2_EPF1_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_LINK_CNTL2                                                               0x14425
#define regBIF_CFG_DEV2_EPF1_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_LINK_STATUS2                                                             0x14425
#define regBIF_CFG_DEV2_EPF1_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_MSI_CAP_LIST                                                             0x14428
#define regBIF_CFG_DEV2_EPF1_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_CNTL                                                             0x14428
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_ADDR_LO                                                          0x14429
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_ADDR_HI                                                          0x1442a
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_DATA                                                             0x1442a
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_MSI_EXT_MSG_DATA                                                         0x1442a
#define regBIF_CFG_DEV2_EPF1_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MASK                                                                 0x1442b
#define regBIF_CFG_DEV2_EPF1_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_DATA_64                                                          0x1442b
#define regBIF_CFG_DEV2_EPF1_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_MSI_EXT_MSG_DATA_64                                                      0x1442b
#define regBIF_CFG_DEV2_EPF1_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF1_0_MSI_MASK_64                                                              0x1442c
#define regBIF_CFG_DEV2_EPF1_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_MSI_PENDING                                                              0x1442c
#define regBIF_CFG_DEV2_EPF1_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF1_0_MSI_PENDING_64                                                           0x1442d
#define regBIF_CFG_DEV2_EPF1_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_MSIX_CAP_LIST                                                            0x14430
#define regBIF_CFG_DEV2_EPF1_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_MSIX_MSG_CNTL                                                            0x14430
#define regBIF_CFG_DEV2_EPF1_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_MSIX_TABLE                                                               0x14431
#define regBIF_CFG_DEV2_EPF1_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_MSIX_PBA                                                                 0x14432
#define regBIF_CFG_DEV2_EPF1_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF1_0_SATA_CAP_0                                                               0x14434
#define regBIF_CFG_DEV2_EPF1_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_SATA_CAP_1                                                               0x14435
#define regBIF_CFG_DEV2_EPF1_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF1_0_SATA_IDP_INDEX                                                           0x14436
#define regBIF_CFG_DEV2_EPF1_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_SATA_IDP_DATA                                                            0x14437
#define regBIF_CFG_DEV2_EPF1_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x14440
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x14441
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC1                                                    0x14442
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC2                                                    0x14443
#define regBIF_CFG_DEV2_EPF1_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x14454
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_UNCORR_ERR_STATUS                                                   0x14455
#define regBIF_CFG_DEV2_EPF1_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_UNCORR_ERR_MASK                                                     0x14456
#define regBIF_CFG_DEV2_EPF1_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x14457
#define regBIF_CFG_DEV2_EPF1_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CORR_ERR_STATUS                                                     0x14458
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CORR_ERR_MASK                                                       0x14459
#define regBIF_CFG_DEV2_EPF1_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1445a
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG0                                                            0x1445b
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG1                                                            0x1445c
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG2                                                            0x1445d
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG3                                                            0x1445e
#define regBIF_CFG_DEV2_EPF1_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG0                                                     0x14462
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG1                                                     0x14463
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG2                                                     0x14464
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG3                                                     0x14465
#define regBIF_CFG_DEV2_EPF1_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR_ENH_CAP_LIST                                                    0x14480
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR1_CAP                                                            0x14481
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR1_CNTL                                                           0x14482
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR2_CAP                                                            0x14483
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR2_CNTL                                                           0x14484
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR3_CAP                                                            0x14485
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR3_CNTL                                                           0x14486
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR4_CAP                                                            0x14487
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR4_CNTL                                                           0x14488
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR5_CAP                                                            0x14489
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR5_CNTL                                                           0x1448a
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR6_CAP                                                            0x1448b
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR6_CNTL                                                           0x1448c
#define regBIF_CFG_DEV2_EPF1_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x14490
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x14491
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_DATA                                                     0x14492
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_CAP                                                      0x14493
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_ENH_CAP_LIST                                                    0x14494
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_CAP                                                             0x14495
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_LATENCY_INDICATOR                                               0x14496
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_STATUS                                                          0x14497
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_CNTL                                                            0x14497
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x14498
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x14498
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x14498
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x14498
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x14499
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x14499
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x14499
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x14499
#define regBIF_CFG_DEV2_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ACS_ENH_CAP_LIST                                                    0x144a8
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ACS_CAP                                                             0x144a9
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ACS_CNTL                                                            0x144a9
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PASID_ENH_CAP_LIST                                                  0x144b4
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PASID_CAP                                                           0x144b5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PASID_CNTL                                                          0x144b5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ARI_ENH_CAP_LIST                                                    0x144ca
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ARI_CAP                                                             0x144cb
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ARI_CNTL                                                            0x144cb
#define regBIF_CFG_DEV2_EPF1_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF1_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1455c
#define regBIF_CFG_DEV2_EPF1_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF1_0_RTR_DATA1                                                                0x1455d
#define regBIF_CFG_DEV2_EPF1_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF1_0_RTR_DATA2                                                                0x1455e
#define regBIF_CFG_DEV2_EPF1_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf2_bifcfgdecp
// base address: 0x10152000
#define regBIF_CFG_DEV2_EPF2_0_VENDOR_ID                                                                0x14800
#define regBIF_CFG_DEV2_EPF2_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_ID                                                                0x14800
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_COMMAND                                                                  0x14801
#define regBIF_CFG_DEV2_EPF2_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF2_0_STATUS                                                                   0x14801
#define regBIF_CFG_DEV2_EPF2_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF2_0_REVISION_ID                                                              0x14802
#define regBIF_CFG_DEV2_EPF2_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_PROG_INTERFACE                                                           0x14802
#define regBIF_CFG_DEV2_EPF2_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_SUB_CLASS                                                                0x14802
#define regBIF_CFG_DEV2_EPF2_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_BASE_CLASS                                                               0x14802
#define regBIF_CFG_DEV2_EPF2_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_CACHE_LINE                                                               0x14803
#define regBIF_CFG_DEV2_EPF2_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_LATENCY                                                                  0x14803
#define regBIF_CFG_DEV2_EPF2_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF2_0_HEADER                                                                   0x14803
#define regBIF_CFG_DEV2_EPF2_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF2_0_BIST                                                                     0x14803
#define regBIF_CFG_DEV2_EPF2_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_1                                                              0x14804
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_2                                                              0x14805
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_3                                                              0x14806
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_4                                                              0x14807
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_5                                                              0x14808
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_6                                                              0x14809
#define regBIF_CFG_DEV2_EPF2_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_ADAPTER_ID                                                               0x1480b
#define regBIF_CFG_DEV2_EPF2_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_ROM_BASE_ADDR                                                            0x1480c
#define regBIF_CFG_DEV2_EPF2_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_CAP_PTR                                                                  0x1480d
#define regBIF_CFG_DEV2_EPF2_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF2_0_INTERRUPT_LINE                                                           0x1480f
#define regBIF_CFG_DEV2_EPF2_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_INTERRUPT_PIN                                                            0x1480f
#define regBIF_CFG_DEV2_EPF2_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_MIN_GRANT                                                                0x1480f
#define regBIF_CFG_DEV2_EPF2_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_MAX_LATENCY                                                              0x1480f
#define regBIF_CFG_DEV2_EPF2_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_VENDOR_CAP_LIST                                                          0x14812
#define regBIF_CFG_DEV2_EPF2_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_ADAPTER_ID_W                                                             0x14813
#define regBIF_CFG_DEV2_EPF2_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_PMI_CAP_LIST                                                             0x14814
#define regBIF_CFG_DEV2_EPF2_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_PMI_CAP                                                                  0x14814
#define regBIF_CFG_DEV2_EPF2_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF2_0_PMI_STATUS_CNTL                                                          0x14815
#define regBIF_CFG_DEV2_EPF2_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CAP_LIST                                                            0x14819
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CAP                                                                 0x14819
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CAP                                                               0x1481a
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CNTL                                                              0x1481b
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_STATUS                                                            0x1481b
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_LINK_CAP                                                                 0x1481c
#define regBIF_CFG_DEV2_EPF2_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF2_0_LINK_CNTL                                                                0x1481d
#define regBIF_CFG_DEV2_EPF2_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_LINK_STATUS                                                              0x1481d
#define regBIF_CFG_DEV2_EPF2_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CAP2                                                              0x14822
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CNTL2                                                             0x14823
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_STATUS2                                                           0x14823
#define regBIF_CFG_DEV2_EPF2_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_LINK_CAP2                                                                0x14824
#define regBIF_CFG_DEV2_EPF2_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_LINK_CNTL2                                                               0x14825
#define regBIF_CFG_DEV2_EPF2_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_LINK_STATUS2                                                             0x14825
#define regBIF_CFG_DEV2_EPF2_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_MSI_CAP_LIST                                                             0x14828
#define regBIF_CFG_DEV2_EPF2_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_CNTL                                                             0x14828
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_ADDR_LO                                                          0x14829
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_ADDR_HI                                                          0x1482a
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_DATA                                                             0x1482a
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_MSI_EXT_MSG_DATA                                                         0x1482a
#define regBIF_CFG_DEV2_EPF2_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MASK                                                                 0x1482b
#define regBIF_CFG_DEV2_EPF2_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_DATA_64                                                          0x1482b
#define regBIF_CFG_DEV2_EPF2_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_MSI_EXT_MSG_DATA_64                                                      0x1482b
#define regBIF_CFG_DEV2_EPF2_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF2_0_MSI_MASK_64                                                              0x1482c
#define regBIF_CFG_DEV2_EPF2_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_MSI_PENDING                                                              0x1482c
#define regBIF_CFG_DEV2_EPF2_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF2_0_MSI_PENDING_64                                                           0x1482d
#define regBIF_CFG_DEV2_EPF2_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_MSIX_CAP_LIST                                                            0x14830
#define regBIF_CFG_DEV2_EPF2_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_MSIX_MSG_CNTL                                                            0x14830
#define regBIF_CFG_DEV2_EPF2_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_MSIX_TABLE                                                               0x14831
#define regBIF_CFG_DEV2_EPF2_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_MSIX_PBA                                                                 0x14832
#define regBIF_CFG_DEV2_EPF2_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF2_0_SATA_CAP_0                                                               0x14834
#define regBIF_CFG_DEV2_EPF2_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_SATA_CAP_1                                                               0x14835
#define regBIF_CFG_DEV2_EPF2_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF2_0_SATA_IDP_INDEX                                                           0x14836
#define regBIF_CFG_DEV2_EPF2_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_SATA_IDP_DATA                                                            0x14837
#define regBIF_CFG_DEV2_EPF2_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x14840
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x14841
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC1                                                    0x14842
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC2                                                    0x14843
#define regBIF_CFG_DEV2_EPF2_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x14854
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_UNCORR_ERR_STATUS                                                   0x14855
#define regBIF_CFG_DEV2_EPF2_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_UNCORR_ERR_MASK                                                     0x14856
#define regBIF_CFG_DEV2_EPF2_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x14857
#define regBIF_CFG_DEV2_EPF2_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CORR_ERR_STATUS                                                     0x14858
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CORR_ERR_MASK                                                       0x14859
#define regBIF_CFG_DEV2_EPF2_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1485a
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG0                                                            0x1485b
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG1                                                            0x1485c
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG2                                                            0x1485d
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG3                                                            0x1485e
#define regBIF_CFG_DEV2_EPF2_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG0                                                     0x14862
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG1                                                     0x14863
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG2                                                     0x14864
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG3                                                     0x14865
#define regBIF_CFG_DEV2_EPF2_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR_ENH_CAP_LIST                                                    0x14880
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR1_CAP                                                            0x14881
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR1_CNTL                                                           0x14882
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR2_CAP                                                            0x14883
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR2_CNTL                                                           0x14884
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR3_CAP                                                            0x14885
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR3_CNTL                                                           0x14886
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR4_CAP                                                            0x14887
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR4_CNTL                                                           0x14888
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR5_CAP                                                            0x14889
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR5_CNTL                                                           0x1488a
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR6_CAP                                                            0x1488b
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR6_CNTL                                                           0x1488c
#define regBIF_CFG_DEV2_EPF2_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x14890
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x14891
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_DATA                                                     0x14892
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_CAP                                                      0x14893
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_ENH_CAP_LIST                                                    0x14894
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_CAP                                                             0x14895
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_LATENCY_INDICATOR                                               0x14896
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_STATUS                                                          0x14897
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_CNTL                                                            0x14897
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x14898
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x14898
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x14898
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x14898
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x14899
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x14899
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x14899
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x14899
#define regBIF_CFG_DEV2_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ACS_ENH_CAP_LIST                                                    0x148a8
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ACS_CAP                                                             0x148a9
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ACS_CNTL                                                            0x148a9
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PASID_ENH_CAP_LIST                                                  0x148b4
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PASID_CAP                                                           0x148b5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PASID_CNTL                                                          0x148b5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ARI_ENH_CAP_LIST                                                    0x148ca
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ARI_CAP                                                             0x148cb
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ARI_CNTL                                                            0x148cb
#define regBIF_CFG_DEV2_EPF2_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF2_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1495c
#define regBIF_CFG_DEV2_EPF2_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF2_0_RTR_DATA1                                                                0x1495d
#define regBIF_CFG_DEV2_EPF2_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF2_0_RTR_DATA2                                                                0x1495e
#define regBIF_CFG_DEV2_EPF2_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf3_bifcfgdecp
// base address: 0x10153000
#define regBIF_CFG_DEV2_EPF3_0_VENDOR_ID                                                                0x14c00
#define regBIF_CFG_DEV2_EPF3_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_ID                                                                0x14c00
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_COMMAND                                                                  0x14c01
#define regBIF_CFG_DEV2_EPF3_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF3_0_STATUS                                                                   0x14c01
#define regBIF_CFG_DEV2_EPF3_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF3_0_REVISION_ID                                                              0x14c02
#define regBIF_CFG_DEV2_EPF3_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_PROG_INTERFACE                                                           0x14c02
#define regBIF_CFG_DEV2_EPF3_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_SUB_CLASS                                                                0x14c02
#define regBIF_CFG_DEV2_EPF3_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_BASE_CLASS                                                               0x14c02
#define regBIF_CFG_DEV2_EPF3_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_CACHE_LINE                                                               0x14c03
#define regBIF_CFG_DEV2_EPF3_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_LATENCY                                                                  0x14c03
#define regBIF_CFG_DEV2_EPF3_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF3_0_HEADER                                                                   0x14c03
#define regBIF_CFG_DEV2_EPF3_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF3_0_BIST                                                                     0x14c03
#define regBIF_CFG_DEV2_EPF3_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_1                                                              0x14c04
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_2                                                              0x14c05
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_3                                                              0x14c06
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_4                                                              0x14c07
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_5                                                              0x14c08
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_6                                                              0x14c09
#define regBIF_CFG_DEV2_EPF3_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_ADAPTER_ID                                                               0x14c0b
#define regBIF_CFG_DEV2_EPF3_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_ROM_BASE_ADDR                                                            0x14c0c
#define regBIF_CFG_DEV2_EPF3_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_CAP_PTR                                                                  0x14c0d
#define regBIF_CFG_DEV2_EPF3_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF3_0_INTERRUPT_LINE                                                           0x14c0f
#define regBIF_CFG_DEV2_EPF3_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_INTERRUPT_PIN                                                            0x14c0f
#define regBIF_CFG_DEV2_EPF3_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_MIN_GRANT                                                                0x14c0f
#define regBIF_CFG_DEV2_EPF3_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_MAX_LATENCY                                                              0x14c0f
#define regBIF_CFG_DEV2_EPF3_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_VENDOR_CAP_LIST                                                          0x14c12
#define regBIF_CFG_DEV2_EPF3_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_ADAPTER_ID_W                                                             0x14c13
#define regBIF_CFG_DEV2_EPF3_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_PMI_CAP_LIST                                                             0x14c14
#define regBIF_CFG_DEV2_EPF3_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_PMI_CAP                                                                  0x14c14
#define regBIF_CFG_DEV2_EPF3_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF3_0_PMI_STATUS_CNTL                                                          0x14c15
#define regBIF_CFG_DEV2_EPF3_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_SBRN                                                                     0x14c18
#define regBIF_CFG_DEV2_EPF3_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF3_0_FLADJ                                                                    0x14c18
#define regBIF_CFG_DEV2_EPF3_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_EPF3_0_DBESL_DBESLD                                                             0x14c18
#define regBIF_CFG_DEV2_EPF3_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CAP_LIST                                                            0x14c19
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CAP                                                                 0x14c19
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CAP                                                               0x14c1a
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CNTL                                                              0x14c1b
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_STATUS                                                            0x14c1b
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_LINK_CAP                                                                 0x14c1c
#define regBIF_CFG_DEV2_EPF3_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF3_0_LINK_CNTL                                                                0x14c1d
#define regBIF_CFG_DEV2_EPF3_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_LINK_STATUS                                                              0x14c1d
#define regBIF_CFG_DEV2_EPF3_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CAP2                                                              0x14c22
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CNTL2                                                             0x14c23
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_STATUS2                                                           0x14c23
#define regBIF_CFG_DEV2_EPF3_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_LINK_CAP2                                                                0x14c24
#define regBIF_CFG_DEV2_EPF3_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_LINK_CNTL2                                                               0x14c25
#define regBIF_CFG_DEV2_EPF3_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_LINK_STATUS2                                                             0x14c25
#define regBIF_CFG_DEV2_EPF3_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_MSI_CAP_LIST                                                             0x14c28
#define regBIF_CFG_DEV2_EPF3_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_CNTL                                                             0x14c28
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_ADDR_LO                                                          0x14c29
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_ADDR_HI                                                          0x14c2a
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_DATA                                                             0x14c2a
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_MSI_EXT_MSG_DATA                                                         0x14c2a
#define regBIF_CFG_DEV2_EPF3_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MASK                                                                 0x14c2b
#define regBIF_CFG_DEV2_EPF3_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_DATA_64                                                          0x14c2b
#define regBIF_CFG_DEV2_EPF3_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_MSI_EXT_MSG_DATA_64                                                      0x14c2b
#define regBIF_CFG_DEV2_EPF3_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF3_0_MSI_MASK_64                                                              0x14c2c
#define regBIF_CFG_DEV2_EPF3_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_MSI_PENDING                                                              0x14c2c
#define regBIF_CFG_DEV2_EPF3_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF3_0_MSI_PENDING_64                                                           0x14c2d
#define regBIF_CFG_DEV2_EPF3_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_MSIX_CAP_LIST                                                            0x14c30
#define regBIF_CFG_DEV2_EPF3_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_MSIX_MSG_CNTL                                                            0x14c30
#define regBIF_CFG_DEV2_EPF3_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_MSIX_TABLE                                                               0x14c31
#define regBIF_CFG_DEV2_EPF3_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_MSIX_PBA                                                                 0x14c32
#define regBIF_CFG_DEV2_EPF3_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF3_0_SATA_CAP_0                                                               0x14c34
#define regBIF_CFG_DEV2_EPF3_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_SATA_CAP_1                                                               0x14c35
#define regBIF_CFG_DEV2_EPF3_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF3_0_SATA_IDP_INDEX                                                           0x14c36
#define regBIF_CFG_DEV2_EPF3_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_SATA_IDP_DATA                                                            0x14c37
#define regBIF_CFG_DEV2_EPF3_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x14c40
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x14c41
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC1                                                    0x14c42
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC2                                                    0x14c43
#define regBIF_CFG_DEV2_EPF3_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x14c54
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_UNCORR_ERR_STATUS                                                   0x14c55
#define regBIF_CFG_DEV2_EPF3_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_UNCORR_ERR_MASK                                                     0x14c56
#define regBIF_CFG_DEV2_EPF3_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x14c57
#define regBIF_CFG_DEV2_EPF3_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CORR_ERR_STATUS                                                     0x14c58
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CORR_ERR_MASK                                                       0x14c59
#define regBIF_CFG_DEV2_EPF3_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x14c5a
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG0                                                            0x14c5b
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG1                                                            0x14c5c
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG2                                                            0x14c5d
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG3                                                            0x14c5e
#define regBIF_CFG_DEV2_EPF3_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG0                                                     0x14c62
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG1                                                     0x14c63
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG2                                                     0x14c64
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG3                                                     0x14c65
#define regBIF_CFG_DEV2_EPF3_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR_ENH_CAP_LIST                                                    0x14c80
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR1_CAP                                                            0x14c81
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR1_CNTL                                                           0x14c82
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR2_CAP                                                            0x14c83
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR2_CNTL                                                           0x14c84
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR3_CAP                                                            0x14c85
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR3_CNTL                                                           0x14c86
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR4_CAP                                                            0x14c87
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR4_CNTL                                                           0x14c88
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR5_CAP                                                            0x14c89
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR5_CNTL                                                           0x14c8a
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR6_CAP                                                            0x14c8b
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR6_CNTL                                                           0x14c8c
#define regBIF_CFG_DEV2_EPF3_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x14c90
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x14c91
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_DATA                                                     0x14c92
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_CAP                                                      0x14c93
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_ENH_CAP_LIST                                                    0x14c94
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_CAP                                                             0x14c95
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_LATENCY_INDICATOR                                               0x14c96
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_STATUS                                                          0x14c97
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_CNTL                                                            0x14c97
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x14c98
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x14c98
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x14c98
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x14c98
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x14c99
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x14c99
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x14c99
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x14c99
#define regBIF_CFG_DEV2_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ACS_ENH_CAP_LIST                                                    0x14ca8
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ACS_CAP                                                             0x14ca9
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ACS_CNTL                                                            0x14ca9
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PASID_ENH_CAP_LIST                                                  0x14cb4
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PASID_CAP                                                           0x14cb5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PASID_CNTL                                                          0x14cb5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ARI_ENH_CAP_LIST                                                    0x14cca
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ARI_CAP                                                             0x14ccb
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ARI_CNTL                                                            0x14ccb
#define regBIF_CFG_DEV2_EPF3_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF3_0_PCIE_RTR_ENH_CAP_LIST                                                    0x14d5c
#define regBIF_CFG_DEV2_EPF3_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF3_0_RTR_DATA1                                                                0x14d5d
#define regBIF_CFG_DEV2_EPF3_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF3_0_RTR_DATA2                                                                0x14d5e
#define regBIF_CFG_DEV2_EPF3_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf4_bifcfgdecp
// base address: 0x10154000
#define regBIF_CFG_DEV2_EPF4_0_VENDOR_ID                                                                0x15000
#define regBIF_CFG_DEV2_EPF4_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_ID                                                                0x15000
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_COMMAND                                                                  0x15001
#define regBIF_CFG_DEV2_EPF4_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF4_0_STATUS                                                                   0x15001
#define regBIF_CFG_DEV2_EPF4_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF4_0_REVISION_ID                                                              0x15002
#define regBIF_CFG_DEV2_EPF4_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_PROG_INTERFACE                                                           0x15002
#define regBIF_CFG_DEV2_EPF4_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_SUB_CLASS                                                                0x15002
#define regBIF_CFG_DEV2_EPF4_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_BASE_CLASS                                                               0x15002
#define regBIF_CFG_DEV2_EPF4_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_CACHE_LINE                                                               0x15003
#define regBIF_CFG_DEV2_EPF4_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_LATENCY                                                                  0x15003
#define regBIF_CFG_DEV2_EPF4_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF4_0_HEADER                                                                   0x15003
#define regBIF_CFG_DEV2_EPF4_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF4_0_BIST                                                                     0x15003
#define regBIF_CFG_DEV2_EPF4_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_1                                                              0x15004
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_2                                                              0x15005
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_3                                                              0x15006
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_4                                                              0x15007
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_5                                                              0x15008
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_6                                                              0x15009
#define regBIF_CFG_DEV2_EPF4_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_ADAPTER_ID                                                               0x1500b
#define regBIF_CFG_DEV2_EPF4_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_ROM_BASE_ADDR                                                            0x1500c
#define regBIF_CFG_DEV2_EPF4_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_CAP_PTR                                                                  0x1500d
#define regBIF_CFG_DEV2_EPF4_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF4_0_INTERRUPT_LINE                                                           0x1500f
#define regBIF_CFG_DEV2_EPF4_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_INTERRUPT_PIN                                                            0x1500f
#define regBIF_CFG_DEV2_EPF4_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_MIN_GRANT                                                                0x1500f
#define regBIF_CFG_DEV2_EPF4_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_MAX_LATENCY                                                              0x1500f
#define regBIF_CFG_DEV2_EPF4_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_VENDOR_CAP_LIST                                                          0x15012
#define regBIF_CFG_DEV2_EPF4_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_ADAPTER_ID_W                                                             0x15013
#define regBIF_CFG_DEV2_EPF4_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_PMI_CAP_LIST                                                             0x15014
#define regBIF_CFG_DEV2_EPF4_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_PMI_CAP                                                                  0x15014
#define regBIF_CFG_DEV2_EPF4_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF4_0_PMI_STATUS_CNTL                                                          0x15015
#define regBIF_CFG_DEV2_EPF4_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_SBRN                                                                     0x15018
#define regBIF_CFG_DEV2_EPF4_0_SBRN_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF4_0_FLADJ                                                                    0x15018
#define regBIF_CFG_DEV2_EPF4_0_FLADJ_BASE_IDX                                                           5
#define regBIF_CFG_DEV2_EPF4_0_DBESL_DBESLD                                                             0x15018
#define regBIF_CFG_DEV2_EPF4_0_DBESL_DBESLD_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CAP_LIST                                                            0x15019
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CAP                                                                 0x15019
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CAP                                                               0x1501a
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CNTL                                                              0x1501b
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_STATUS                                                            0x1501b
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_LINK_CAP                                                                 0x1501c
#define regBIF_CFG_DEV2_EPF4_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF4_0_LINK_CNTL                                                                0x1501d
#define regBIF_CFG_DEV2_EPF4_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_LINK_STATUS                                                              0x1501d
#define regBIF_CFG_DEV2_EPF4_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CAP2                                                              0x15022
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CNTL2                                                             0x15023
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_STATUS2                                                           0x15023
#define regBIF_CFG_DEV2_EPF4_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_LINK_CAP2                                                                0x15024
#define regBIF_CFG_DEV2_EPF4_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_LINK_CNTL2                                                               0x15025
#define regBIF_CFG_DEV2_EPF4_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_LINK_STATUS2                                                             0x15025
#define regBIF_CFG_DEV2_EPF4_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_MSI_CAP_LIST                                                             0x15028
#define regBIF_CFG_DEV2_EPF4_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_CNTL                                                             0x15028
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_ADDR_LO                                                          0x15029
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_ADDR_HI                                                          0x1502a
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_DATA                                                             0x1502a
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_MSI_EXT_MSG_DATA                                                         0x1502a
#define regBIF_CFG_DEV2_EPF4_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MASK                                                                 0x1502b
#define regBIF_CFG_DEV2_EPF4_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_DATA_64                                                          0x1502b
#define regBIF_CFG_DEV2_EPF4_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_MSI_EXT_MSG_DATA_64                                                      0x1502b
#define regBIF_CFG_DEV2_EPF4_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF4_0_MSI_MASK_64                                                              0x1502c
#define regBIF_CFG_DEV2_EPF4_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_MSI_PENDING                                                              0x1502c
#define regBIF_CFG_DEV2_EPF4_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF4_0_MSI_PENDING_64                                                           0x1502d
#define regBIF_CFG_DEV2_EPF4_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_MSIX_CAP_LIST                                                            0x15030
#define regBIF_CFG_DEV2_EPF4_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_MSIX_MSG_CNTL                                                            0x15030
#define regBIF_CFG_DEV2_EPF4_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_MSIX_TABLE                                                               0x15031
#define regBIF_CFG_DEV2_EPF4_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_MSIX_PBA                                                                 0x15032
#define regBIF_CFG_DEV2_EPF4_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF4_0_SATA_CAP_0                                                               0x15034
#define regBIF_CFG_DEV2_EPF4_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_SATA_CAP_1                                                               0x15035
#define regBIF_CFG_DEV2_EPF4_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF4_0_SATA_IDP_INDEX                                                           0x15036
#define regBIF_CFG_DEV2_EPF4_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_SATA_IDP_DATA                                                            0x15037
#define regBIF_CFG_DEV2_EPF4_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x15040
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x15041
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC1                                                    0x15042
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC2                                                    0x15043
#define regBIF_CFG_DEV2_EPF4_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x15054
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_UNCORR_ERR_STATUS                                                   0x15055
#define regBIF_CFG_DEV2_EPF4_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_UNCORR_ERR_MASK                                                     0x15056
#define regBIF_CFG_DEV2_EPF4_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x15057
#define regBIF_CFG_DEV2_EPF4_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CORR_ERR_STATUS                                                     0x15058
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CORR_ERR_MASK                                                       0x15059
#define regBIF_CFG_DEV2_EPF4_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1505a
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG0                                                            0x1505b
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG1                                                            0x1505c
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG2                                                            0x1505d
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG3                                                            0x1505e
#define regBIF_CFG_DEV2_EPF4_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG0                                                     0x15062
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG1                                                     0x15063
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG2                                                     0x15064
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG3                                                     0x15065
#define regBIF_CFG_DEV2_EPF4_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR_ENH_CAP_LIST                                                    0x15080
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR1_CAP                                                            0x15081
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR1_CNTL                                                           0x15082
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR2_CAP                                                            0x15083
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR2_CNTL                                                           0x15084
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR3_CAP                                                            0x15085
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR3_CNTL                                                           0x15086
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR4_CAP                                                            0x15087
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR4_CNTL                                                           0x15088
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR5_CAP                                                            0x15089
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR5_CNTL                                                           0x1508a
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR6_CAP                                                            0x1508b
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR6_CNTL                                                           0x1508c
#define regBIF_CFG_DEV2_EPF4_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x15090
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x15091
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_DATA                                                     0x15092
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_CAP                                                      0x15093
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_ENH_CAP_LIST                                                    0x15094
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_CAP                                                             0x15095
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_LATENCY_INDICATOR                                               0x15096
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_STATUS                                                          0x15097
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_CNTL                                                            0x15097
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x15098
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x15098
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x15098
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x15098
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x15099
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x15099
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x15099
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x15099
#define regBIF_CFG_DEV2_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ACS_ENH_CAP_LIST                                                    0x150a8
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ACS_CAP                                                             0x150a9
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ACS_CNTL                                                            0x150a9
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PASID_ENH_CAP_LIST                                                  0x150b4
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PASID_CAP                                                           0x150b5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PASID_CNTL                                                          0x150b5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ARI_ENH_CAP_LIST                                                    0x150ca
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ARI_CAP                                                             0x150cb
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ARI_CNTL                                                            0x150cb
#define regBIF_CFG_DEV2_EPF4_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF4_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1515c
#define regBIF_CFG_DEV2_EPF4_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF4_0_RTR_DATA1                                                                0x1515d
#define regBIF_CFG_DEV2_EPF4_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF4_0_RTR_DATA2                                                                0x1515e
#define regBIF_CFG_DEV2_EPF4_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf5_bifcfgdecp
// base address: 0x10155000
#define regBIF_CFG_DEV2_EPF5_0_VENDOR_ID                                                                0x15400
#define regBIF_CFG_DEV2_EPF5_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_ID                                                                0x15400
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_COMMAND                                                                  0x15401
#define regBIF_CFG_DEV2_EPF5_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF5_0_STATUS                                                                   0x15401
#define regBIF_CFG_DEV2_EPF5_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF5_0_REVISION_ID                                                              0x15402
#define regBIF_CFG_DEV2_EPF5_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_PROG_INTERFACE                                                           0x15402
#define regBIF_CFG_DEV2_EPF5_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_SUB_CLASS                                                                0x15402
#define regBIF_CFG_DEV2_EPF5_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_BASE_CLASS                                                               0x15402
#define regBIF_CFG_DEV2_EPF5_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_CACHE_LINE                                                               0x15403
#define regBIF_CFG_DEV2_EPF5_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_LATENCY                                                                  0x15403
#define regBIF_CFG_DEV2_EPF5_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF5_0_HEADER                                                                   0x15403
#define regBIF_CFG_DEV2_EPF5_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF5_0_BIST                                                                     0x15403
#define regBIF_CFG_DEV2_EPF5_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_1                                                              0x15404
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_2                                                              0x15405
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_3                                                              0x15406
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_4                                                              0x15407
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_5                                                              0x15408
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_6                                                              0x15409
#define regBIF_CFG_DEV2_EPF5_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_ADAPTER_ID                                                               0x1540b
#define regBIF_CFG_DEV2_EPF5_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_ROM_BASE_ADDR                                                            0x1540c
#define regBIF_CFG_DEV2_EPF5_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_CAP_PTR                                                                  0x1540d
#define regBIF_CFG_DEV2_EPF5_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF5_0_INTERRUPT_LINE                                                           0x1540f
#define regBIF_CFG_DEV2_EPF5_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_INTERRUPT_PIN                                                            0x1540f
#define regBIF_CFG_DEV2_EPF5_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_MIN_GRANT                                                                0x1540f
#define regBIF_CFG_DEV2_EPF5_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_MAX_LATENCY                                                              0x1540f
#define regBIF_CFG_DEV2_EPF5_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_VENDOR_CAP_LIST                                                          0x15412
#define regBIF_CFG_DEV2_EPF5_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_ADAPTER_ID_W                                                             0x15413
#define regBIF_CFG_DEV2_EPF5_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_PMI_CAP_LIST                                                             0x15414
#define regBIF_CFG_DEV2_EPF5_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_PMI_CAP                                                                  0x15414
#define regBIF_CFG_DEV2_EPF5_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF5_0_PMI_STATUS_CNTL                                                          0x15415
#define regBIF_CFG_DEV2_EPF5_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CAP_LIST                                                            0x15419
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CAP                                                                 0x15419
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CAP                                                               0x1541a
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CNTL                                                              0x1541b
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_STATUS                                                            0x1541b
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_LINK_CAP                                                                 0x1541c
#define regBIF_CFG_DEV2_EPF5_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF5_0_LINK_CNTL                                                                0x1541d
#define regBIF_CFG_DEV2_EPF5_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_LINK_STATUS                                                              0x1541d
#define regBIF_CFG_DEV2_EPF5_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CAP2                                                              0x15422
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CNTL2                                                             0x15423
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_STATUS2                                                           0x15423
#define regBIF_CFG_DEV2_EPF5_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_LINK_CAP2                                                                0x15424
#define regBIF_CFG_DEV2_EPF5_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_LINK_CNTL2                                                               0x15425
#define regBIF_CFG_DEV2_EPF5_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_LINK_STATUS2                                                             0x15425
#define regBIF_CFG_DEV2_EPF5_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_MSI_CAP_LIST                                                             0x15428
#define regBIF_CFG_DEV2_EPF5_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_CNTL                                                             0x15428
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_ADDR_LO                                                          0x15429
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_ADDR_HI                                                          0x1542a
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_DATA                                                             0x1542a
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_MSI_EXT_MSG_DATA                                                         0x1542a
#define regBIF_CFG_DEV2_EPF5_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MASK                                                                 0x1542b
#define regBIF_CFG_DEV2_EPF5_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_DATA_64                                                          0x1542b
#define regBIF_CFG_DEV2_EPF5_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_MSI_EXT_MSG_DATA_64                                                      0x1542b
#define regBIF_CFG_DEV2_EPF5_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF5_0_MSI_MASK_64                                                              0x1542c
#define regBIF_CFG_DEV2_EPF5_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_MSI_PENDING                                                              0x1542c
#define regBIF_CFG_DEV2_EPF5_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF5_0_MSI_PENDING_64                                                           0x1542d
#define regBIF_CFG_DEV2_EPF5_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_MSIX_CAP_LIST                                                            0x15430
#define regBIF_CFG_DEV2_EPF5_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_MSIX_MSG_CNTL                                                            0x15430
#define regBIF_CFG_DEV2_EPF5_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_MSIX_TABLE                                                               0x15431
#define regBIF_CFG_DEV2_EPF5_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_MSIX_PBA                                                                 0x15432
#define regBIF_CFG_DEV2_EPF5_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF5_0_SATA_CAP_0                                                               0x15434
#define regBIF_CFG_DEV2_EPF5_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_SATA_CAP_1                                                               0x15435
#define regBIF_CFG_DEV2_EPF5_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF5_0_SATA_IDP_INDEX                                                           0x15436
#define regBIF_CFG_DEV2_EPF5_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_SATA_IDP_DATA                                                            0x15437
#define regBIF_CFG_DEV2_EPF5_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x15440
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x15441
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC1                                                    0x15442
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC2                                                    0x15443
#define regBIF_CFG_DEV2_EPF5_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x15454
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_UNCORR_ERR_STATUS                                                   0x15455
#define regBIF_CFG_DEV2_EPF5_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_UNCORR_ERR_MASK                                                     0x15456
#define regBIF_CFG_DEV2_EPF5_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x15457
#define regBIF_CFG_DEV2_EPF5_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CORR_ERR_STATUS                                                     0x15458
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CORR_ERR_MASK                                                       0x15459
#define regBIF_CFG_DEV2_EPF5_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1545a
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG0                                                            0x1545b
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG1                                                            0x1545c
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG2                                                            0x1545d
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG3                                                            0x1545e
#define regBIF_CFG_DEV2_EPF5_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG0                                                     0x15462
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG1                                                     0x15463
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG2                                                     0x15464
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG3                                                     0x15465
#define regBIF_CFG_DEV2_EPF5_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR_ENH_CAP_LIST                                                    0x15480
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR1_CAP                                                            0x15481
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR1_CNTL                                                           0x15482
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR2_CAP                                                            0x15483
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR2_CNTL                                                           0x15484
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR3_CAP                                                            0x15485
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR3_CNTL                                                           0x15486
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR4_CAP                                                            0x15487
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR4_CNTL                                                           0x15488
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR5_CAP                                                            0x15489
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR5_CNTL                                                           0x1548a
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR6_CAP                                                            0x1548b
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR6_CNTL                                                           0x1548c
#define regBIF_CFG_DEV2_EPF5_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x15490
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x15491
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_DATA                                                     0x15492
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_CAP                                                      0x15493
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_ENH_CAP_LIST                                                    0x15494
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_CAP                                                             0x15495
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_LATENCY_INDICATOR                                               0x15496
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_STATUS                                                          0x15497
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_CNTL                                                            0x15497
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x15498
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x15498
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x15498
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x15498
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x15499
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x15499
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x15499
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x15499
#define regBIF_CFG_DEV2_EPF5_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ACS_ENH_CAP_LIST                                                    0x154a8
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ACS_CAP                                                             0x154a9
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ACS_CNTL                                                            0x154a9
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PASID_ENH_CAP_LIST                                                  0x154b4
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PASID_CAP                                                           0x154b5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PASID_CNTL                                                          0x154b5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ARI_ENH_CAP_LIST                                                    0x154ca
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ARI_CAP                                                             0x154cb
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ARI_CNTL                                                            0x154cb
#define regBIF_CFG_DEV2_EPF5_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF5_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1555c
#define regBIF_CFG_DEV2_EPF5_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF5_0_RTR_DATA1                                                                0x1555d
#define regBIF_CFG_DEV2_EPF5_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF5_0_RTR_DATA2                                                                0x1555e
#define regBIF_CFG_DEV2_EPF5_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_bif_cfg_dev2_epf6_bifcfgdecp
// base address: 0x10156000
#define regBIF_CFG_DEV2_EPF6_0_VENDOR_ID                                                                0x15800
#define regBIF_CFG_DEV2_EPF6_0_VENDOR_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_ID                                                                0x15800
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_COMMAND                                                                  0x15801
#define regBIF_CFG_DEV2_EPF6_0_COMMAND_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF6_0_STATUS                                                                   0x15801
#define regBIF_CFG_DEV2_EPF6_0_STATUS_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF6_0_REVISION_ID                                                              0x15802
#define regBIF_CFG_DEV2_EPF6_0_REVISION_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_PROG_INTERFACE                                                           0x15802
#define regBIF_CFG_DEV2_EPF6_0_PROG_INTERFACE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_SUB_CLASS                                                                0x15802
#define regBIF_CFG_DEV2_EPF6_0_SUB_CLASS_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_BASE_CLASS                                                               0x15802
#define regBIF_CFG_DEV2_EPF6_0_BASE_CLASS_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_CACHE_LINE                                                               0x15803
#define regBIF_CFG_DEV2_EPF6_0_CACHE_LINE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_LATENCY                                                                  0x15803
#define regBIF_CFG_DEV2_EPF6_0_LATENCY_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF6_0_HEADER                                                                   0x15803
#define regBIF_CFG_DEV2_EPF6_0_HEADER_BASE_IDX                                                          5
#define regBIF_CFG_DEV2_EPF6_0_BIST                                                                     0x15803
#define regBIF_CFG_DEV2_EPF6_0_BIST_BASE_IDX                                                            5
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_1                                                              0x15804
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_1_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_2                                                              0x15805
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_3                                                              0x15806
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_3_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_4                                                              0x15807
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_4_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_5                                                              0x15808
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_5_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_6                                                              0x15809
#define regBIF_CFG_DEV2_EPF6_0_BASE_ADDR_6_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_ADAPTER_ID                                                               0x1580b
#define regBIF_CFG_DEV2_EPF6_0_ADAPTER_ID_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_ROM_BASE_ADDR                                                            0x1580c
#define regBIF_CFG_DEV2_EPF6_0_ROM_BASE_ADDR_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_CAP_PTR                                                                  0x1580d
#define regBIF_CFG_DEV2_EPF6_0_CAP_PTR_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF6_0_INTERRUPT_LINE                                                           0x1580f
#define regBIF_CFG_DEV2_EPF6_0_INTERRUPT_LINE_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_INTERRUPT_PIN                                                            0x1580f
#define regBIF_CFG_DEV2_EPF6_0_INTERRUPT_PIN_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_MIN_GRANT                                                                0x1580f
#define regBIF_CFG_DEV2_EPF6_0_MIN_GRANT_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_MAX_LATENCY                                                              0x1580f
#define regBIF_CFG_DEV2_EPF6_0_MAX_LATENCY_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_VENDOR_CAP_LIST                                                          0x15812
#define regBIF_CFG_DEV2_EPF6_0_VENDOR_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_ADAPTER_ID_W                                                             0x15813
#define regBIF_CFG_DEV2_EPF6_0_ADAPTER_ID_W_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_PMI_CAP_LIST                                                             0x15814
#define regBIF_CFG_DEV2_EPF6_0_PMI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_PMI_CAP                                                                  0x15814
#define regBIF_CFG_DEV2_EPF6_0_PMI_CAP_BASE_IDX                                                         5
#define regBIF_CFG_DEV2_EPF6_0_PMI_STATUS_CNTL                                                          0x15815
#define regBIF_CFG_DEV2_EPF6_0_PMI_STATUS_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CAP_LIST                                                            0x15819
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CAP                                                                 0x15819
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CAP                                                               0x1581a
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CNTL                                                              0x1581b
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_STATUS                                                            0x1581b
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_LINK_CAP                                                                 0x1581c
#define regBIF_CFG_DEV2_EPF6_0_LINK_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF6_0_LINK_CNTL                                                                0x1581d
#define regBIF_CFG_DEV2_EPF6_0_LINK_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_LINK_STATUS                                                              0x1581d
#define regBIF_CFG_DEV2_EPF6_0_LINK_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CAP2                                                              0x15822
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CNTL2                                                             0x15823
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_STATUS2                                                           0x15823
#define regBIF_CFG_DEV2_EPF6_0_DEVICE_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_LINK_CAP2                                                                0x15824
#define regBIF_CFG_DEV2_EPF6_0_LINK_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_LINK_CNTL2                                                               0x15825
#define regBIF_CFG_DEV2_EPF6_0_LINK_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_LINK_STATUS2                                                             0x15825
#define regBIF_CFG_DEV2_EPF6_0_LINK_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_MSI_CAP_LIST                                                             0x15828
#define regBIF_CFG_DEV2_EPF6_0_MSI_CAP_LIST_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_CNTL                                                             0x15828
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_ADDR_LO                                                          0x15829
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_ADDR_LO_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_ADDR_HI                                                          0x1582a
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_ADDR_HI_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_DATA                                                             0x1582a
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_DATA_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_MSI_EXT_MSG_DATA                                                         0x1582a
#define regBIF_CFG_DEV2_EPF6_0_MSI_EXT_MSG_DATA_BASE_IDX                                                5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MASK                                                                 0x1582b
#define regBIF_CFG_DEV2_EPF6_0_MSI_MASK_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_DATA_64                                                          0x1582b
#define regBIF_CFG_DEV2_EPF6_0_MSI_MSG_DATA_64_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_MSI_EXT_MSG_DATA_64                                                      0x1582b
#define regBIF_CFG_DEV2_EPF6_0_MSI_EXT_MSG_DATA_64_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF6_0_MSI_MASK_64                                                              0x1582c
#define regBIF_CFG_DEV2_EPF6_0_MSI_MASK_64_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_MSI_PENDING                                                              0x1582c
#define regBIF_CFG_DEV2_EPF6_0_MSI_PENDING_BASE_IDX                                                     5
#define regBIF_CFG_DEV2_EPF6_0_MSI_PENDING_64                                                           0x1582d
#define regBIF_CFG_DEV2_EPF6_0_MSI_PENDING_64_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_MSIX_CAP_LIST                                                            0x15830
#define regBIF_CFG_DEV2_EPF6_0_MSIX_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_MSIX_MSG_CNTL                                                            0x15830
#define regBIF_CFG_DEV2_EPF6_0_MSIX_MSG_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_MSIX_TABLE                                                               0x15831
#define regBIF_CFG_DEV2_EPF6_0_MSIX_TABLE_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_MSIX_PBA                                                                 0x15832
#define regBIF_CFG_DEV2_EPF6_0_MSIX_PBA_BASE_IDX                                                        5
#define regBIF_CFG_DEV2_EPF6_0_SATA_CAP_0                                                               0x15834
#define regBIF_CFG_DEV2_EPF6_0_SATA_CAP_0_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_SATA_CAP_1                                                               0x15835
#define regBIF_CFG_DEV2_EPF6_0_SATA_CAP_1_BASE_IDX                                                      5
#define regBIF_CFG_DEV2_EPF6_0_SATA_IDP_INDEX                                                           0x15836
#define regBIF_CFG_DEV2_EPF6_0_SATA_IDP_INDEX_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_SATA_IDP_DATA                                                            0x15837
#define regBIF_CFG_DEV2_EPF6_0_SATA_IDP_DATA_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                        0x15840
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                               5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC_HDR                                                 0x15841
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC1                                                    0x15842
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC2                                                    0x15843
#define regBIF_CFG_DEV2_EPF6_0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                            0x15854
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_UNCORR_ERR_STATUS                                                   0x15855
#define regBIF_CFG_DEV2_EPF6_0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_UNCORR_ERR_MASK                                                     0x15856
#define regBIF_CFG_DEV2_EPF6_0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_UNCORR_ERR_SEVERITY                                                 0x15857
#define regBIF_CFG_DEV2_EPF6_0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                        5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CORR_ERR_STATUS                                                     0x15858
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CORR_ERR_MASK                                                       0x15859
#define regBIF_CFG_DEV2_EPF6_0_PCIE_CORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ADV_ERR_CAP_CNTL                                                    0x1585a
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG0                                                            0x1585b
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG0_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG1                                                            0x1585c
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG1_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG2                                                            0x1585d
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG2_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG3                                                            0x1585e
#define regBIF_CFG_DEV2_EPF6_0_PCIE_HDR_LOG3_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG0                                                     0x15862
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG1                                                     0x15863
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG2                                                     0x15864
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG3                                                     0x15865
#define regBIF_CFG_DEV2_EPF6_0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR_ENH_CAP_LIST                                                    0x15880
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR1_CAP                                                            0x15881
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR1_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR1_CNTL                                                           0x15882
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR1_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR2_CAP                                                            0x15883
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR2_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR2_CNTL                                                           0x15884
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR2_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR3_CAP                                                            0x15885
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR3_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR3_CNTL                                                           0x15886
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR3_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR4_CAP                                                            0x15887
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR4_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR4_CNTL                                                           0x15888
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR4_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR5_CAP                                                            0x15889
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR5_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR5_CNTL                                                           0x1588a
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR5_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR6_CAP                                                            0x1588b
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR6_CAP_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR6_CNTL                                                           0x1588c
#define regBIF_CFG_DEV2_EPF6_0_PCIE_BAR6_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                             0x15890
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                    5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_DATA_SELECT                                              0x15891
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                     5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_DATA                                                     0x15892
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                            5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_CAP                                                      0x15893
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_ENH_CAP_LIST                                                    0x15894
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_CAP                                                             0x15895
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_LATENCY_INDICATOR                                               0x15896
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_STATUS                                                          0x15897
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_CNTL                                                            0x15897
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                            0x15898
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                            0x15898
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                            0x15898
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                            0x15898
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                            0x15899
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                            0x15899
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                            0x15899
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                            0x15899
#define regBIF_CFG_DEV2_EPF6_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ACS_ENH_CAP_LIST                                                    0x158a8
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ACS_CAP                                                             0x158a9
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ACS_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ACS_CNTL                                                            0x158a9
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ACS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PASID_ENH_CAP_LIST                                                  0x158b4
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PASID_CAP                                                           0x158b5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PASID_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PASID_CNTL                                                          0x158b5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_PASID_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ARI_ENH_CAP_LIST                                                    0x158ca
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ARI_CAP                                                             0x158cb
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ARI_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ARI_CNTL                                                            0x158cb
#define regBIF_CFG_DEV2_EPF6_0_PCIE_ARI_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV2_EPF6_0_PCIE_RTR_ENH_CAP_LIST                                                    0x1595c
#define regBIF_CFG_DEV2_EPF6_0_PCIE_RTR_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV2_EPF6_0_RTR_DATA1                                                                0x1595d
#define regBIF_CFG_DEV2_EPF6_0_RTR_DATA1_BASE_IDX                                                       5
#define regBIF_CFG_DEV2_EPF6_0_RTR_DATA2                                                                0x1595e
#define regBIF_CFG_DEV2_EPF6_0_RTR_DATA2_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_rcc_ep_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_EP_DEV0_0_EP_PCIE_SCRATCH                                                                0xc44c
#define regRCC_EP_DEV0_0_EP_PCIE_SCRATCH_BASE_IDX                                                       5
#define regRCC_EP_DEV0_0_EP_PCIE_CNTL                                                                   0xc44e
#define regRCC_EP_DEV0_0_EP_PCIE_CNTL_BASE_IDX                                                          5
#define regRCC_EP_DEV0_0_EP_PCIE_INT_CNTL                                                               0xc44f
#define regRCC_EP_DEV0_0_EP_PCIE_INT_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_INT_STATUS                                                             0xc450
#define regRCC_EP_DEV0_0_EP_PCIE_INT_STATUS_BASE_IDX                                                    5
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL2                                                               0xc451
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL2_BASE_IDX                                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_BUS_CNTL                                                               0xc452
#define regRCC_EP_DEV0_0_EP_PCIE_BUS_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_CFG_CNTL                                                               0xc453
#define regRCC_EP_DEV0_0_EP_PCIE_CFG_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_TX_LTR_CNTL                                                            0xc454
#define regRCC_EP_DEV0_0_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CAP                                                             0xc457
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    5
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0xc458
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CNTL                                                            0xc458
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0xc458
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0xc459
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0xc459
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0xc459
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0xc459
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0xc45a
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0xc45a
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0xc45a
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_PME_CONTROL                                                            0xc45c
#define regRCC_EP_DEV0_0_EP_PCIE_PME_CONTROL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_0_EP_PCIEP_RESERVED                                                              0xc45d
#define regRCC_EP_DEV0_0_EP_PCIEP_RESERVED_BASE_IDX                                                     5
#define regRCC_EP_DEV0_0_EP_PCIE_TX_CNTL                                                                0xc45f
#define regRCC_EP_DEV0_0_EP_PCIE_TX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_0_EP_PCIE_TX_REQUESTER_ID                                                        0xc460
#define regRCC_EP_DEV0_0_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               5
#define regRCC_EP_DEV0_0_EP_PCIE_ERR_CNTL                                                               0xc461
#define regRCC_EP_DEV0_0_EP_PCIE_ERR_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL                                                                0xc462
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_0_EP_PCIE_LC_SPEED_CNTL                                                          0xc463
#define regRCC_EP_DEV0_0_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 5


// addressBlock: nbio_nbif0_rcc_dwn_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_DWN_DEV0_0_DN_PCIE_RESERVED                                                              0xc468
#define regRCC_DWN_DEV0_0_DN_PCIE_RESERVED_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_0_DN_PCIE_SCRATCH                                                               0xc469
#define regRCC_DWN_DEV0_0_DN_PCIE_SCRATCH_BASE_IDX                                                      5
#define regRCC_DWN_DEV0_0_DN_PCIE_CNTL                                                                  0xc46b
#define regRCC_DWN_DEV0_0_DN_PCIE_CNTL_BASE_IDX                                                         5
#define regRCC_DWN_DEV0_0_DN_PCIE_CONFIG_CNTL                                                           0xc46c
#define regRCC_DWN_DEV0_0_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  5
#define regRCC_DWN_DEV0_0_DN_PCIE_RX_CNTL2                                                              0xc46d
#define regRCC_DWN_DEV0_0_DN_PCIE_RX_CNTL2_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_0_DN_PCIE_BUS_CNTL                                                              0xc46e
#define regRCC_DWN_DEV0_0_DN_PCIE_BUS_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_0_DN_PCIE_CFG_CNTL                                                              0xc46f
#define regRCC_DWN_DEV0_0_DN_PCIE_CFG_CNTL_BASE_IDX                                                     5


// addressBlock: nbio_nbif0_rcc_dwnp_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_DWNP_DEV0_0_PCIE_ERR_CNTL                                                                0xc475
#define regRCC_DWNP_DEV0_0_PCIE_ERR_CNTL_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_0_PCIE_RX_CNTL                                                                 0xc476
#define regRCC_DWNP_DEV0_0_PCIE_RX_CNTL_BASE_IDX                                                        5
#define regRCC_DWNP_DEV0_0_PCIE_LC_SPEED_CNTL                                                           0xc477
#define regRCC_DWNP_DEV0_0_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  5
#define regRCC_DWNP_DEV0_0_PCIE_LC_CNTL2                                                                0xc478
#define regRCC_DWNP_DEV0_0_PCIE_LC_CNTL2_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_0_LTR_MSG_INFO_FROM_EP                                                         0xc47a
#define regRCC_DWNP_DEV0_0_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                5


// addressBlock: nbio_nbif0_rcc_ep_dev1_RCCPORTDEC
// base address: 0x10131200
#define regRCC_EP_DEV1_EP_PCIE_SCRATCH                                                                  0xc4cc
#define regRCC_EP_DEV1_EP_PCIE_SCRATCH_BASE_IDX                                                         5
#define regRCC_EP_DEV1_EP_PCIE_CNTL                                                                     0xc4ce
#define regRCC_EP_DEV1_EP_PCIE_CNTL_BASE_IDX                                                            5
#define regRCC_EP_DEV1_EP_PCIE_INT_CNTL                                                                 0xc4cf
#define regRCC_EP_DEV1_EP_PCIE_INT_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV1_EP_PCIE_INT_STATUS                                                               0xc4d0
#define regRCC_EP_DEV1_EP_PCIE_INT_STATUS_BASE_IDX                                                      5
#define regRCC_EP_DEV1_EP_PCIE_RX_CNTL2                                                                 0xc4d1
#define regRCC_EP_DEV1_EP_PCIE_RX_CNTL2_BASE_IDX                                                        5
#define regRCC_EP_DEV1_EP_PCIE_BUS_CNTL                                                                 0xc4d2
#define regRCC_EP_DEV1_EP_PCIE_BUS_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV1_EP_PCIE_CFG_CNTL                                                                 0xc4d3
#define regRCC_EP_DEV1_EP_PCIE_CFG_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV1_EP_PCIE_TX_LTR_CNTL                                                              0xc4d4
#define regRCC_EP_DEV1_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                     5
#define regRCC_EP_DEV1_EP_PCIE_F0_DPA_CAP                                                               0xc4d7
#define regRCC_EP_DEV1_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                      5
#define regRCC_EP_DEV1_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                                 0xc4d8
#define regRCC_EP_DEV1_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                        5
#define regRCC_EP_DEV1_EP_PCIE_F0_DPA_CNTL                                                              0xc4d8
#define regRCC_EP_DEV1_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                     5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                                 0xc4d8
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                                 0xc4d9
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                                 0xc4d9
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                                 0xc4d9
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                                 0xc4d9
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                                 0xc4da
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                                 0xc4da
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                        5
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                                 0xc4da
#define regRCC_EP_DEV1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                        5
#define regRCC_EP_DEV1_EP_PCIE_PME_CONTROL                                                              0xc4dc
#define regRCC_EP_DEV1_EP_PCIE_PME_CONTROL_BASE_IDX                                                     5
#define regRCC_EP_DEV1_EP_PCIEP_RESERVED                                                                0xc4dd
#define regRCC_EP_DEV1_EP_PCIEP_RESERVED_BASE_IDX                                                       5
#define regRCC_EP_DEV1_EP_PCIE_TX_CNTL                                                                  0xc4df
#define regRCC_EP_DEV1_EP_PCIE_TX_CNTL_BASE_IDX                                                         5
#define regRCC_EP_DEV1_EP_PCIE_TX_REQUESTER_ID                                                          0xc4e0
#define regRCC_EP_DEV1_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                                 5
#define regRCC_EP_DEV1_EP_PCIE_ERR_CNTL                                                                 0xc4e1
#define regRCC_EP_DEV1_EP_PCIE_ERR_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV1_EP_PCIE_RX_CNTL                                                                  0xc4e2
#define regRCC_EP_DEV1_EP_PCIE_RX_CNTL_BASE_IDX                                                         5
#define regRCC_EP_DEV1_EP_PCIE_LC_SPEED_CNTL                                                            0xc4e3
#define regRCC_EP_DEV1_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                   5


// addressBlock: nbio_nbif0_rcc_dwn_dev1_RCCPORTDEC
// base address: 0x10131200
#define regRCC_DWN_DEV1_DN_PCIE_RESERVED                                                                0xc4e8
#define regRCC_DWN_DEV1_DN_PCIE_RESERVED_BASE_IDX                                                       5
#define regRCC_DWN_DEV1_DN_PCIE_SCRATCH                                                                 0xc4e9
#define regRCC_DWN_DEV1_DN_PCIE_SCRATCH_BASE_IDX                                                        5
#define regRCC_DWN_DEV1_DN_PCIE_CNTL                                                                    0xc4eb
#define regRCC_DWN_DEV1_DN_PCIE_CNTL_BASE_IDX                                                           5
#define regRCC_DWN_DEV1_DN_PCIE_CONFIG_CNTL                                                             0xc4ec
#define regRCC_DWN_DEV1_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                    5
#define regRCC_DWN_DEV1_DN_PCIE_RX_CNTL2                                                                0xc4ed
#define regRCC_DWN_DEV1_DN_PCIE_RX_CNTL2_BASE_IDX                                                       5
#define regRCC_DWN_DEV1_DN_PCIE_BUS_CNTL                                                                0xc4ee
#define regRCC_DWN_DEV1_DN_PCIE_BUS_CNTL_BASE_IDX                                                       5
#define regRCC_DWN_DEV1_DN_PCIE_CFG_CNTL                                                                0xc4ef
#define regRCC_DWN_DEV1_DN_PCIE_CFG_CNTL_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_rcc_dwnp_dev1_RCCPORTDEC
// base address: 0x10131200
#define regRCC_DWNP_DEV1_PCIE_ERR_CNTL                                                                  0xc4f5
#define regRCC_DWNP_DEV1_PCIE_ERR_CNTL_BASE_IDX                                                         5
#define regRCC_DWNP_DEV1_PCIE_RX_CNTL                                                                   0xc4f6
#define regRCC_DWNP_DEV1_PCIE_RX_CNTL_BASE_IDX                                                          5
#define regRCC_DWNP_DEV1_PCIE_LC_SPEED_CNTL                                                             0xc4f7
#define regRCC_DWNP_DEV1_PCIE_LC_SPEED_CNTL_BASE_IDX                                                    5
#define regRCC_DWNP_DEV1_PCIE_LC_CNTL2                                                                  0xc4f8
#define regRCC_DWNP_DEV1_PCIE_LC_CNTL2_BASE_IDX                                                         5
#define regRCC_DWNP_DEV1_LTR_MSG_INFO_FROM_EP                                                           0xc4fa
#define regRCC_DWNP_DEV1_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                  5


// addressBlock: nbio_nbif0_rcc_ep_dev2_RCCPORTDEC
// base address: 0x10131400
#define regRCC_EP_DEV2_EP_PCIE_SCRATCH                                                                  0xc54c
#define regRCC_EP_DEV2_EP_PCIE_SCRATCH_BASE_IDX                                                         5
#define regRCC_EP_DEV2_EP_PCIE_CNTL                                                                     0xc54e
#define regRCC_EP_DEV2_EP_PCIE_CNTL_BASE_IDX                                                            5
#define regRCC_EP_DEV2_EP_PCIE_INT_CNTL                                                                 0xc54f
#define regRCC_EP_DEV2_EP_PCIE_INT_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV2_EP_PCIE_INT_STATUS                                                               0xc550
#define regRCC_EP_DEV2_EP_PCIE_INT_STATUS_BASE_IDX                                                      5
#define regRCC_EP_DEV2_EP_PCIE_RX_CNTL2                                                                 0xc551
#define regRCC_EP_DEV2_EP_PCIE_RX_CNTL2_BASE_IDX                                                        5
#define regRCC_EP_DEV2_EP_PCIE_BUS_CNTL                                                                 0xc552
#define regRCC_EP_DEV2_EP_PCIE_BUS_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV2_EP_PCIE_CFG_CNTL                                                                 0xc553
#define regRCC_EP_DEV2_EP_PCIE_CFG_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV2_EP_PCIE_TX_LTR_CNTL                                                              0xc554
#define regRCC_EP_DEV2_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                     5
#define regRCC_EP_DEV2_EP_PCIE_F0_DPA_CAP                                                               0xc557
#define regRCC_EP_DEV2_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                      5
#define regRCC_EP_DEV2_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                                 0xc558
#define regRCC_EP_DEV2_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                        5
#define regRCC_EP_DEV2_EP_PCIE_F0_DPA_CNTL                                                              0xc558
#define regRCC_EP_DEV2_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                     5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                                 0xc558
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                                 0xc559
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                                 0xc559
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                                 0xc559
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                                 0xc559
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                                 0xc55a
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                                 0xc55a
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                        5
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                                 0xc55a
#define regRCC_EP_DEV2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                        5
#define regRCC_EP_DEV2_EP_PCIE_PME_CONTROL                                                              0xc55c
#define regRCC_EP_DEV2_EP_PCIE_PME_CONTROL_BASE_IDX                                                     5
#define regRCC_EP_DEV2_EP_PCIEP_RESERVED                                                                0xc55d
#define regRCC_EP_DEV2_EP_PCIEP_RESERVED_BASE_IDX                                                       5
#define regRCC_EP_DEV2_EP_PCIE_TX_CNTL                                                                  0xc55f
#define regRCC_EP_DEV2_EP_PCIE_TX_CNTL_BASE_IDX                                                         5
#define regRCC_EP_DEV2_EP_PCIE_TX_REQUESTER_ID                                                          0xc560
#define regRCC_EP_DEV2_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                                 5
#define regRCC_EP_DEV2_EP_PCIE_ERR_CNTL                                                                 0xc561
#define regRCC_EP_DEV2_EP_PCIE_ERR_CNTL_BASE_IDX                                                        5
#define regRCC_EP_DEV2_EP_PCIE_RX_CNTL                                                                  0xc562
#define regRCC_EP_DEV2_EP_PCIE_RX_CNTL_BASE_IDX                                                         5
#define regRCC_EP_DEV2_EP_PCIE_LC_SPEED_CNTL                                                            0xc563
#define regRCC_EP_DEV2_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                   5


// addressBlock: nbio_nbif0_rcc_dwn_dev2_RCCPORTDEC
// base address: 0x10131400
#define regRCC_DWN_DEV2_DN_PCIE_RESERVED                                                                0xc568
#define regRCC_DWN_DEV2_DN_PCIE_RESERVED_BASE_IDX                                                       5
#define regRCC_DWN_DEV2_DN_PCIE_SCRATCH                                                                 0xc569
#define regRCC_DWN_DEV2_DN_PCIE_SCRATCH_BASE_IDX                                                        5
#define regRCC_DWN_DEV2_DN_PCIE_CNTL                                                                    0xc56b
#define regRCC_DWN_DEV2_DN_PCIE_CNTL_BASE_IDX                                                           5
#define regRCC_DWN_DEV2_DN_PCIE_CONFIG_CNTL                                                             0xc56c
#define regRCC_DWN_DEV2_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                    5
#define regRCC_DWN_DEV2_DN_PCIE_RX_CNTL2                                                                0xc56d
#define regRCC_DWN_DEV2_DN_PCIE_RX_CNTL2_BASE_IDX                                                       5
#define regRCC_DWN_DEV2_DN_PCIE_BUS_CNTL                                                                0xc56e
#define regRCC_DWN_DEV2_DN_PCIE_BUS_CNTL_BASE_IDX                                                       5
#define regRCC_DWN_DEV2_DN_PCIE_CFG_CNTL                                                                0xc56f
#define regRCC_DWN_DEV2_DN_PCIE_CFG_CNTL_BASE_IDX                                                       5


// addressBlock: nbio_nbif0_rcc_dwnp_dev2_RCCPORTDEC
// base address: 0x10131400
#define regRCC_DWNP_DEV2_PCIE_ERR_CNTL                                                                  0xc575
#define regRCC_DWNP_DEV2_PCIE_ERR_CNTL_BASE_IDX                                                         5
#define regRCC_DWNP_DEV2_PCIE_RX_CNTL                                                                   0xc576
#define regRCC_DWNP_DEV2_PCIE_RX_CNTL_BASE_IDX                                                          5
#define regRCC_DWNP_DEV2_PCIE_LC_SPEED_CNTL                                                             0xc577
#define regRCC_DWNP_DEV2_PCIE_LC_SPEED_CNTL_BASE_IDX                                                    5
#define regRCC_DWNP_DEV2_PCIE_LC_CNTL2                                                                  0xc578
#define regRCC_DWNP_DEV2_PCIE_LC_CNTL2_BASE_IDX                                                         5
#define regRCC_DWNP_DEV2_LTR_MSG_INFO_FROM_EP                                                           0xc57a
#define regRCC_DWNP_DEV2_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                  5


// addressBlock: nbio_nbif0_rcc_strap_rcc_strap_internal
// base address: 0x10100000
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP0                                                              0xd000
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     5


// addressBlock: nbio_nbif0_bif_rst_bif_rst_regblk
// base address: 0x10100000
#define regHARD_RST_CTRL                                                                                0xe000
#define regHARD_RST_CTRL_BASE_IDX                                                                       5
#define regSELF_SOFT_RST                                                                                0xe002
#define regSELF_SOFT_RST_BASE_IDX                                                                       5
#define regBIF_GFX_DRV_VPU_RST                                                                          0xe003
#define regBIF_GFX_DRV_VPU_RST_BASE_IDX                                                                 5
#define regBIF_RST_MISC_CTRL                                                                            0xe004
#define regBIF_RST_MISC_CTRL_BASE_IDX                                                                   5
#define regBIF_RST_MISC_CTRL2                                                                           0xe005
#define regBIF_RST_MISC_CTRL2_BASE_IDX                                                                  5
#define regBIF_RST_MISC_CTRL3                                                                           0xe006
#define regBIF_RST_MISC_CTRL3_BASE_IDX                                                                  5
#define regDEV0_PF0_FLR_RST_CTRL                                                                        0xe008
#define regDEV0_PF0_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF1_FLR_RST_CTRL                                                                        0xe009
#define regDEV0_PF1_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF2_FLR_RST_CTRL                                                                        0xe00a
#define regDEV0_PF2_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF3_FLR_RST_CTRL                                                                        0xe00b
#define regDEV0_PF3_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF4_FLR_RST_CTRL                                                                        0xe00c
#define regDEV0_PF4_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF5_FLR_RST_CTRL                                                                        0xe00d
#define regDEV0_PF5_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF6_FLR_RST_CTRL                                                                        0xe00e
#define regDEV0_PF6_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF7_FLR_RST_CTRL                                                                        0xe00f
#define regDEV0_PF7_FLR_RST_CTRL_BASE_IDX                                                               5
#define regBIF_INST_RESET_INTR_STS                                                                      0xe010
#define regBIF_INST_RESET_INTR_STS_BASE_IDX                                                             5
#define regBIF_PF_FLR_INTR_STS                                                                          0xe011
#define regBIF_PF_FLR_INTR_STS_BASE_IDX                                                                 5
#define regBIF_D3HOTD0_INTR_STS                                                                         0xe012
#define regBIF_D3HOTD0_INTR_STS_BASE_IDX                                                                5
#define regBIF_POWER_INTR_STS                                                                           0xe014
#define regBIF_POWER_INTR_STS_BASE_IDX                                                                  5
#define regBIF_PF_DSTATE_INTR_STS                                                                       0xe015
#define regBIF_PF_DSTATE_INTR_STS_BASE_IDX                                                              5
#define regSELF_SOFT_RST_2                                                                              0xe016
#define regSELF_SOFT_RST_2_BASE_IDX                                                                     5
#define regBIF_INST_RESET_INTR_MASK                                                                     0xe020
#define regBIF_INST_RESET_INTR_MASK_BASE_IDX                                                            5
#define regBIF_PF_FLR_INTR_MASK                                                                         0xe021
#define regBIF_PF_FLR_INTR_MASK_BASE_IDX                                                                5
#define regBIF_D3HOTD0_INTR_MASK                                                                        0xe022
#define regBIF_D3HOTD0_INTR_MASK_BASE_IDX                                                               5
#define regBIF_POWER_INTR_MASK                                                                          0xe024
#define regBIF_POWER_INTR_MASK_BASE_IDX                                                                 5
#define regBIF_PF_DSTATE_INTR_MASK                                                                      0xe025
#define regBIF_PF_DSTATE_INTR_MASK_BASE_IDX                                                             5
#define regBIF_PF_FLR_RST                                                                               0xe040
#define regBIF_PF_FLR_RST_BASE_IDX                                                                      5
#define regBIF_DEV0_PF0_DSTATE_VALUE                                                                    0xe050
#define regBIF_DEV0_PF0_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF1_DSTATE_VALUE                                                                    0xe051
#define regBIF_DEV0_PF1_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF2_DSTATE_VALUE                                                                    0xe052
#define regBIF_DEV0_PF2_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF3_DSTATE_VALUE                                                                    0xe053
#define regBIF_DEV0_PF3_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF4_DSTATE_VALUE                                                                    0xe054
#define regBIF_DEV0_PF4_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF5_DSTATE_VALUE                                                                    0xe055
#define regBIF_DEV0_PF5_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF6_DSTATE_VALUE                                                                    0xe056
#define regBIF_DEV0_PF6_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF7_DSTATE_VALUE                                                                    0xe057
#define regBIF_DEV0_PF7_DSTATE_VALUE_BASE_IDX                                                           5
#define regDEV0_PF0_D3HOTD0_RST_CTRL                                                                    0xe078
#define regDEV0_PF0_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF1_D3HOTD0_RST_CTRL                                                                    0xe079
#define regDEV0_PF1_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF2_D3HOTD0_RST_CTRL                                                                    0xe07a
#define regDEV0_PF2_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF3_D3HOTD0_RST_CTRL                                                                    0xe07b
#define regDEV0_PF3_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF4_D3HOTD0_RST_CTRL                                                                    0xe07c
#define regDEV0_PF4_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF5_D3HOTD0_RST_CTRL                                                                    0xe07d
#define regDEV0_PF5_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF6_D3HOTD0_RST_CTRL                                                                    0xe07e
#define regDEV0_PF6_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF7_D3HOTD0_RST_CTRL                                                                    0xe07f
#define regDEV0_PF7_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV1_PF0_FLR_RST_CTRL                                                                        0xe200
#define regDEV1_PF0_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV1_PF1_FLR_RST_CTRL                                                                        0xe201
#define regDEV1_PF1_FLR_RST_CTRL_BASE_IDX                                                               5
#define regBIF_DEV1_PF0_DSTATE_VALUE                                                                    0xe208
#define regBIF_DEV1_PF0_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV1_PF1_DSTATE_VALUE                                                                    0xe209
#define regBIF_DEV1_PF1_DSTATE_VALUE_BASE_IDX                                                           5
#define regDEV1_PF0_D3HOTD0_RST_CTRL                                                                    0xe210
#define regDEV1_PF0_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV1_PF1_D3HOTD0_RST_CTRL                                                                    0xe211
#define regDEV1_PF1_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF0_FLR_RST_CTRL                                                                        0xe218
#define regDEV2_PF0_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV2_PF1_FLR_RST_CTRL                                                                        0xe219
#define regDEV2_PF1_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV2_PF2_FLR_RST_CTRL                                                                        0xe21a
#define regDEV2_PF2_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV2_PF3_FLR_RST_CTRL                                                                        0xe21b
#define regDEV2_PF3_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV2_PF4_FLR_RST_CTRL                                                                        0xe21c
#define regDEV2_PF4_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV2_PF5_FLR_RST_CTRL                                                                        0xe21d
#define regDEV2_PF5_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV2_PF6_FLR_RST_CTRL                                                                        0xe21e
#define regDEV2_PF6_FLR_RST_CTRL_BASE_IDX                                                               5
#define regBIF_DEV2_PF0_DSTATE_VALUE                                                                    0xe220
#define regBIF_DEV2_PF0_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV2_PF1_DSTATE_VALUE                                                                    0xe221
#define regBIF_DEV2_PF1_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV2_PF2_DSTATE_VALUE                                                                    0xe222
#define regBIF_DEV2_PF2_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV2_PF3_DSTATE_VALUE                                                                    0xe223
#define regBIF_DEV2_PF3_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV2_PF4_DSTATE_VALUE                                                                    0xe224
#define regBIF_DEV2_PF4_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV2_PF5_DSTATE_VALUE                                                                    0xe225
#define regBIF_DEV2_PF5_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV2_PF6_DSTATE_VALUE                                                                    0xe226
#define regBIF_DEV2_PF6_DSTATE_VALUE_BASE_IDX                                                           5
#define regDEV2_PF0_D3HOTD0_RST_CTRL                                                                    0xe228
#define regDEV2_PF0_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF1_D3HOTD0_RST_CTRL                                                                    0xe229
#define regDEV2_PF1_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF2_D3HOTD0_RST_CTRL                                                                    0xe22a
#define regDEV2_PF2_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF3_D3HOTD0_RST_CTRL                                                                    0xe22b
#define regDEV2_PF3_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF4_D3HOTD0_RST_CTRL                                                                    0xe22c
#define regDEV2_PF4_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF5_D3HOTD0_RST_CTRL                                                                    0xe22d
#define regDEV2_PF5_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV2_PF6_D3HOTD0_RST_CTRL                                                                    0xe22e
#define regDEV2_PF6_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regBIF_PORT0_DSTATE_VALUE                                                                       0xe230
#define regBIF_PORT0_DSTATE_VALUE_BASE_IDX                                                              5
#define regBIF_PORT1_DSTATE_VALUE                                                                       0xe231
#define regBIF_PORT1_DSTATE_VALUE_BASE_IDX                                                              5
#define regBIF_PORT2_DSTATE_VALUE                                                                       0xe232
#define regBIF_PORT2_DSTATE_VALUE_BASE_IDX                                                              5


// addressBlock: nbio_nbif0_bif_misc_bif_misc_regblk
// base address: 0x10100000
#define regMISC_SCRATCH                                                                                 0xe800
#define regMISC_SCRATCH_BASE_IDX                                                                        5
#define regINTR_LINE_POLARITY                                                                           0xe801
#define regINTR_LINE_POLARITY_BASE_IDX                                                                  5
#define regINTR_LINE_ENABLE                                                                             0xe802
#define regINTR_LINE_ENABLE_BASE_IDX                                                                    5
#define regOUTSTANDING_VC_ALLOC                                                                         0xe803
#define regOUTSTANDING_VC_ALLOC_BASE_IDX                                                                5
#define regBIFC_MISC_CTRL0                                                                              0xe804
#define regBIFC_MISC_CTRL0_BASE_IDX                                                                     5
#define regBIFC_MISC_CTRL1                                                                              0xe805
#define regBIFC_MISC_CTRL1_BASE_IDX                                                                     5
#define regBIFC_LC_TIMER_CTRL                                                                           0xe807
#define regBIFC_LC_TIMER_CTRL_BASE_IDX                                                                  5
#define regBIFC_RCCBIH_BME_ERR_LOG0                                                                     0xe808
#define regBIFC_RCCBIH_BME_ERR_LOG0_BASE_IDX                                                            5
#define regBIFC_RCCBIH_BME_ERR_LOG1                                                                     0xe809
#define regBIFC_RCCBIH_BME_ERR_LOG1_BASE_IDX                                                            5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F0_F1                                                            0xe80a
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F0_F1_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F2_F3                                                            0xe80b
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F2_F3_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F4_F5                                                            0xe80c
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F4_F5_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F6_F7                                                            0xe80d
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F6_F7_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F0_F1                                                            0xe80e
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F0_F1_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F2_F3                                                            0xe80f
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F2_F3_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F4_F5                                                            0xe810
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F4_F5_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F6_F7                                                            0xe811
#define regBIFC_DMA_ATTR_OVERRIDE_DEV1_F6_F7_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F0_F1                                                            0xe812
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F0_F1_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F2_F3                                                            0xe813
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F2_F3_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F4_F5                                                            0xe814
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F4_F5_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F6_F7                                                            0xe815
#define regBIFC_DMA_ATTR_OVERRIDE_DEV2_F6_F7_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_CNTL2_DEV0                                                                     0xe81a
#define regBIFC_DMA_ATTR_CNTL2_DEV0_BASE_IDX                                                            5
#define regBIFC_DMA_ATTR_CNTL2_DEV1                                                                     0xe81b
#define regBIFC_DMA_ATTR_CNTL2_DEV1_BASE_IDX                                                            5
#define regBIFC_DMA_ATTR_CNTL2_DEV2                                                                     0xe81c
#define regBIFC_DMA_ATTR_CNTL2_DEV2_BASE_IDX                                                            5
#define regBIFC_MISC_CTRL2                                                                              0xe822
#define regBIFC_MISC_CTRL2_BASE_IDX                                                                     5
#define regBME_DUMMY_CNTL_0                                                                             0xe825
#define regBME_DUMMY_CNTL_0_BASE_IDX                                                                    5
#define regBME_DUMMY_CNTL_1                                                                             0xe826
#define regBME_DUMMY_CNTL_1_BASE_IDX                                                                    5
#define regBIFC_THT_CNTL                                                                                0xe827
#define regBIFC_THT_CNTL_BASE_IDX                                                                       5
#define regBIFC_HSTARB_CNTL                                                                             0xe828
#define regBIFC_HSTARB_CNTL_BASE_IDX                                                                    5
#define regBIFC_GSI_CNTL                                                                                0xe829
#define regBIFC_GSI_CNTL_BASE_IDX                                                                       5
#define regBIFC_PCIEFUNC_CNTL                                                                           0xe82a
#define regBIFC_PCIEFUNC_CNTL_BASE_IDX                                                                  5
#define regBIFC_PASID_CHECK_DIS                                                                         0xe82b
#define regBIFC_PASID_CHECK_DIS_BASE_IDX                                                                5
#define regBIFC_SDP_CNTL_0                                                                              0xe82c
#define regBIFC_SDP_CNTL_0_BASE_IDX                                                                     5
#define regBIFC_SDP_CNTL_1                                                                              0xe82d
#define regBIFC_SDP_CNTL_1_BASE_IDX                                                                     5
#define regBIFC_PASID_STS                                                                               0xe82e
#define regBIFC_PASID_STS_BASE_IDX                                                                      5
#define regBIFC_ATHUB_ACT_CNTL                                                                          0xe82f
#define regBIFC_ATHUB_ACT_CNTL_BASE_IDX                                                                 5
#define regBIFC_PERF_CNTL_0                                                                             0xe830
#define regBIFC_PERF_CNTL_0_BASE_IDX                                                                    5
#define regBIFC_PERF_CNTL_1                                                                             0xe831
#define regBIFC_PERF_CNTL_1_BASE_IDX                                                                    5
#define regBIFC_PERF_CNT_MMIO_RD_L32BIT                                                                 0xe832
#define regBIFC_PERF_CNT_MMIO_RD_L32BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_MMIO_WR_L32BIT                                                                 0xe833
#define regBIFC_PERF_CNT_MMIO_WR_L32BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_DMA_RD_L32BIT                                                                  0xe834
#define regBIFC_PERF_CNT_DMA_RD_L32BIT_BASE_IDX                                                         5
#define regBIFC_PERF_CNT_DMA_WR_L32BIT                                                                  0xe835
#define regBIFC_PERF_CNT_DMA_WR_L32BIT_BASE_IDX                                                         5
#define regNBIF_REGIF_ERRSET_CTRL                                                                       0xe836
#define regNBIF_REGIF_ERRSET_CTRL_BASE_IDX                                                              5
#define regBIFC_SDP_CNTL_2                                                                              0xe837
#define regBIFC_SDP_CNTL_2_BASE_IDX                                                                     5
#define regNBIF_PGMST_CTRL                                                                              0xe838
#define regNBIF_PGMST_CTRL_BASE_IDX                                                                     5
#define regNBIF_PGSLV_CTRL                                                                              0xe839
#define regNBIF_PGSLV_CTRL_BASE_IDX                                                                     5
#define regNBIF_PG_MISC_CTRL                                                                            0xe83a
#define regNBIF_PG_MISC_CTRL_BASE_IDX                                                                   5
#define regNBIF_HST_MISC_CTRL                                                                           0xe83b
#define regNBIF_HST_MISC_CTRL_BASE_IDX                                                                  5
#define regSMN_MST_EP_CNTL3                                                                             0xe83c
#define regSMN_MST_EP_CNTL3_BASE_IDX                                                                    5
#define regSMN_MST_EP_CNTL4                                                                             0xe83d
#define regSMN_MST_EP_CNTL4_BASE_IDX                                                                    5
#define regSMN_MST_CNTL1                                                                                0xe83e
#define regSMN_MST_CNTL1_BASE_IDX                                                                       5
#define regSMN_MST_EP_CNTL5                                                                             0xe83f
#define regSMN_MST_EP_CNTL5_BASE_IDX                                                                    5
#define regBIF_SELFRING_BUFFER_VID                                                                      0xe840
#define regBIF_SELFRING_BUFFER_VID_BASE_IDX                                                             5
#define regBIF_SELFRING_VECTOR_CNTL                                                                     0xe841
#define regBIF_SELFRING_VECTOR_CNTL_BASE_IDX                                                            5
#define regNBIF_INTX_DSTATE_MISC_CNTL                                                                   0xe846
#define regNBIF_INTX_DSTATE_MISC_CNTL_BASE_IDX                                                          5
#define regNBIF_PENDING_MISC_CNTL                                                                       0xe847
#define regNBIF_PENDING_MISC_CNTL_BASE_IDX                                                              5
#define regBIF_GMI_WRR_WEIGHT                                                                           0xe848
#define regBIF_GMI_WRR_WEIGHT_BASE_IDX                                                                  5
#define regBIF_GMI_WRR_WEIGHT2                                                                          0xe849
#define regBIF_GMI_WRR_WEIGHT2_BASE_IDX                                                                 5
#define regBIF_GMI_WRR_WEIGHT3                                                                          0xe84a
#define regBIF_GMI_WRR_WEIGHT3_BASE_IDX                                                                 5
#define regNBIF_PWRBRK_REQUEST                                                                          0xe84c
#define regNBIF_PWRBRK_REQUEST_BASE_IDX                                                                 5
#define regBIF_DMA_MP4_ERR_LOG                                                                          0xe870
#define regBIF_PASID_ERR_LOG                                                                            0xe871
#define regBIF_PASID_ERR_CLR                                                                            0xe872
#define regBIF_PASID_ERR_CLR_BASE_IDX                                                                   5
#define regOBFF_EMU_CFG                                                                                 0xe874
#define regOBFF_EMU_CFG_BASE_IDX                                                                        5
#define regEP0_INTR_URGENT_CAP                                                                          0xe875
#define regEP0_INTR_URGENT_CAP_BASE_IDX                                                                 5
#define regEP1_INTR_URGENT_CAP                                                                          0xe876
#define regEP1_INTR_URGENT_CAP_BASE_IDX                                                                 5
#define regEP2_INTR_URGENT_CAP                                                                          0xe877
#define regEP2_INTR_URGENT_CAP_BASE_IDX                                                                 5
#define regEP_PEND_BLOCK_MSK                                                                            0xe87c
#define regEP_PEND_BLOCK_MSK_BASE_IDX                                                                   5
#define regNBIF_VWIRE_CTRL                                                                              0xe880
#define regNBIF_VWIRE_CTRL_BASE_IDX                                                                     5
#define regNBIF_MGCG_CTRL_LCLK                                                                          0xe887
#define regNBIF_MGCG_CTRL_LCLK_BASE_IDX                                                                 5
#define regNBIF_DS_CTRL_LCLK                                                                            0xe888
#define regNBIF_DS_CTRL_LCLK_BASE_IDX                                                                   5
#define regSMN_MST_CNTL0                                                                                0xe889
#define regSMN_MST_CNTL0_BASE_IDX                                                                       5
#define regSMN_MST_EP_CNTL1                                                                             0xe88a
#define regSMN_MST_EP_CNTL1_BASE_IDX                                                                    5
#define regSMN_MST_EP_CNTL2                                                                             0xe88b
#define regSMN_MST_EP_CNTL2_BASE_IDX                                                                    5
#define regNBIF_SDP_VWR_VCHG_DIS_CTRL                                                                   0xe88c
#define regNBIF_SDP_VWR_VCHG_DIS_CTRL_BASE_IDX                                                          5
#define regNBIF_SDP_VWR_VCHG_RST_CTRL0                                                                  0xe88d
#define regNBIF_SDP_VWR_VCHG_RST_CTRL0_BASE_IDX                                                         5
#define regNBIF_SDP_VWR_VCHG_RST_CTRL1                                                                  0xe88e
#define regNBIF_SDP_VWR_VCHG_RST_CTRL1_BASE_IDX                                                         5
#define regNBIF_SDP_VWR_VCHG_TRIG                                                                       0xe88f
#define regNBIF_SDP_VWR_VCHG_TRIG_BASE_IDX                                                              5
#define regNBIF_SHUB_TODET_CTRL                                                                         0xe898
#define regNBIF_SHUB_TODET_CTRL_BASE_IDX                                                                5
#define regNBIF_SHUB_TODET_CLIENT_CTRL                                                                  0xe899
#define regNBIF_SHUB_TODET_CLIENT_CTRL_BASE_IDX                                                         5
#define regNBIF_SHUB_TODET_CLIENT_STATUS                                                                0xe89a
#define regNBIF_SHUB_TODET_CLIENT_STATUS_BASE_IDX                                                       5
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL                                                               0xe89b
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL_BASE_IDX                                                      5
#define regNBIF_SHUB_TODET_CLIENT_CTRL2                                                                 0xe89c
#define regNBIF_SHUB_TODET_CLIENT_CTRL2_BASE_IDX                                                        5
#define regNBIF_SHUB_TODET_CLIENT_STATUS2                                                               0xe89d
#define regNBIF_SHUB_TODET_CLIENT_STATUS2_BASE_IDX                                                      5
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL2                                                              0xe89e
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL2_BASE_IDX                                                     5
#define regBIFC_HRP_SDP_WRRSP_POOLCRED_ALLOC                                                            0xe8c0
#define regBIFC_HRP_SDP_WRRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regBIFC_HRP_SDP_RDRSP_POOLCRED_ALLOC                                                            0xe8c1
#define regBIFC_HRP_SDP_RDRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regBIFC_GMI_SDP_REQ_POOLCRED_ALLOC                                                              0xe8c2
#define regBIFC_GMI_SDP_REQ_POOLCRED_ALLOC_BASE_IDX                                                     5
#define regBIFC_GMI_SDP_DAT_POOLCRED_ALLOC                                                              0xe8c3
#define regBIFC_GMI_SDP_DAT_POOLCRED_ALLOC_BASE_IDX                                                     5
#define regBIFC_GMI_SST_RDRSP_POOLCRED_ALLOC                                                            0xe8c4
#define regBIFC_GMI_SST_RDRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regBIFC_GMI_SST_WRRSP_POOLCRED_ALLOC                                                            0xe8c5
#define regBIFC_GMI_SST_WRRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regDISCON_HYSTERESIS_HEAD_CTRL                                                                  0xe8c6
#define regDISCON_HYSTERESIS_HEAD_CTRL_BASE_IDX                                                         5
#define regBIFC_Z10_CTRL0                                                                               0xe8c9
#define regBIFC_Z10_CTRL0_BASE_IDX                                                                      5
#define regBIFC_Z10_CTRL1                                                                               0xe8ca
#define regBIFC_Z10_CTRL1_BASE_IDX                                                                      5
#define regBIFC_Z10_STATUS                                                                              0xe8cb
#define regBIFC_Z10_STATUS_BASE_IDX                                                                     5
#define regBIFC_PCIE_BDF_CNTL0                                                                          0xe8d0
#define regBIFC_PCIE_BDF_CNTL0_BASE_IDX                                                                 5
#define regBIFC_PCIE_BDF_CNTL1                                                                          0xe8d1
#define regBIFC_PCIE_BDF_CNTL1_BASE_IDX                                                                 5
#define regBIFC_EARLY_WAKEUP_CNTL                                                                       0xe8d2
#define regBIFC_EARLY_WAKEUP_CNTL_BASE_IDX                                                              5
#define regBIFC_PERF_CNT_MMIO_RD_H16BIT                                                                 0xe8f0
#define regBIFC_PERF_CNT_MMIO_RD_H16BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_MMIO_WR_H16BIT                                                                 0xe8f1
#define regBIFC_PERF_CNT_MMIO_WR_H16BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_DMA_RD_H16BIT                                                                  0xe8f2
#define regBIFC_PERF_CNT_DMA_RD_H16BIT_BASE_IDX                                                         5
#define regBIFC_PERF_CNT_DMA_WR_H16BIT                                                                  0xe8f3
#define regBIFC_PERF_CNT_DMA_WR_H16BIT_BASE_IDX                                                         5
#define regNBIF_PERF_COM_COUNT_ENABLE                                                                   0xe8f4
#define regNBIF_PERF_COM_COUNT_ENABLE_BASE_IDX                                                          5
#define regNBIF_BX_PERF_CNT_FSM                                                                         0xe8ff
#define regNBIF_BX_PERF_CNT_FSM_BASE_IDX                                                                5
#define regNBIF_COM_COUNT_VALUE                                                                         0xe97a
#define regNBIF_COM_COUNT_VALUE_BASE_IDX                                                                5


// addressBlock: nbio_nbif0_nbif_sion_SIONDEC
// base address: 0x10100000
#define regSION_CL0_RdRsp_BurstTarget_REG0                                                              0xe900
#define regSION_CL0_RdRsp_BurstTarget_REG0_BASE_IDX                                                     5
#define regSION_CL0_RdRsp_BurstTarget_REG1                                                              0xe901
#define regSION_CL0_RdRsp_BurstTarget_REG1_BASE_IDX                                                     5
#define regSION_CL0_RdRsp_TimeSlot_REG0                                                                 0xe902
#define regSION_CL0_RdRsp_TimeSlot_REG0_BASE_IDX                                                        5
#define regSION_CL0_RdRsp_TimeSlot_REG1                                                                 0xe903
#define regSION_CL0_RdRsp_TimeSlot_REG1_BASE_IDX                                                        5
#define regSION_CL0_WrRsp_BurstTarget_REG0                                                              0xe904
#define regSION_CL0_WrRsp_BurstTarget_REG0_BASE_IDX                                                     5
#define regSION_CL0_WrRsp_BurstTarget_REG1                                                              0xe905
#define regSION_CL0_WrRsp_BurstTarget_REG1_BASE_IDX                                                     5
#define regSION_CL0_WrRsp_TimeSlot_REG0                                                                 0xe906
#define regSION_CL0_WrRsp_TimeSlot_REG0_BASE_IDX                                                        5
#define regSION_CL0_WrRsp_TimeSlot_REG1                                                                 0xe907
#define regSION_CL0_WrRsp_TimeSlot_REG1_BASE_IDX                                                        5
#define regSION_CL0_Req_BurstTarget_REG0                                                                0xe908
#define regSION_CL0_Req_BurstTarget_REG0_BASE_IDX                                                       5
#define regSION_CL0_Req_BurstTarget_REG1                                                                0xe909
#define regSION_CL0_Req_BurstTarget_REG1_BASE_IDX                                                       5
#define regSION_CL0_Req_TimeSlot_REG0                                                                   0xe90a
#define regSION_CL0_Req_TimeSlot_REG0_BASE_IDX                                                          5
#define regSION_CL0_Req_TimeSlot_REG1                                                                   0xe90b
#define regSION_CL0_Req_TimeSlot_REG1_BASE_IDX                                                          5
#define regSION_CL0_ReqPoolCredit_Alloc_REG0                                                            0xe90c
#define regSION_CL0_ReqPoolCredit_Alloc_REG0_BASE_IDX                                                   5
#define regSION_CL0_ReqPoolCredit_Alloc_REG1                                                            0xe90d
#define regSION_CL0_ReqPoolCredit_Alloc_REG1_BASE_IDX                                                   5
#define regSION_CL0_DataPoolCredit_Alloc_REG0                                                           0xe90e
#define regSION_CL0_DataPoolCredit_Alloc_REG0_BASE_IDX                                                  5
#define regSION_CL0_DataPoolCredit_Alloc_REG1                                                           0xe90f
#define regSION_CL0_DataPoolCredit_Alloc_REG1_BASE_IDX                                                  5
#define regSION_CL0_RdRspPoolCredit_Alloc_REG0                                                          0xe910
#define regSION_CL0_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                                 5
#define regSION_CL0_RdRspPoolCredit_Alloc_REG1                                                          0xe911
#define regSION_CL0_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                                 5
#define regSION_CL0_WrRspPoolCredit_Alloc_REG0                                                          0xe912
#define regSION_CL0_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                                 5
#define regSION_CL0_WrRspPoolCredit_Alloc_REG1                                                          0xe913
#define regSION_CL0_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                                 5
#define regSION_CL1_RdRsp_BurstTarget_REG0                                                              0xe914
#define regSION_CL1_RdRsp_BurstTarget_REG0_BASE_IDX                                                     5
#define regSION_CL1_RdRsp_BurstTarget_REG1                                                              0xe915
#define regSION_CL1_RdRsp_BurstTarget_REG1_BASE_IDX                                                     5
#define regSION_CL1_RdRsp_TimeSlot_REG0                                                                 0xe916
#define regSION_CL1_RdRsp_TimeSlot_REG0_BASE_IDX                                                        5
#define regSION_CL1_RdRsp_TimeSlot_REG1                                                                 0xe917
#define regSION_CL1_RdRsp_TimeSlot_REG1_BASE_IDX                                                        5
#define regSION_CL1_WrRsp_BurstTarget_REG0                                                              0xe918
#define regSION_CL1_WrRsp_BurstTarget_REG0_BASE_IDX                                                     5
#define regSION_CL1_WrRsp_BurstTarget_REG1                                                              0xe919
#define regSION_CL1_WrRsp_BurstTarget_REG1_BASE_IDX                                                     5
#define regSION_CL1_WrRsp_TimeSlot_REG0                                                                 0xe91a
#define regSION_CL1_WrRsp_TimeSlot_REG0_BASE_IDX                                                        5
#define regSION_CL1_WrRsp_TimeSlot_REG1                                                                 0xe91b
#define regSION_CL1_WrRsp_TimeSlot_REG1_BASE_IDX                                                        5
#define regSION_CL1_Req_BurstTarget_REG0                                                                0xe91c
#define regSION_CL1_Req_BurstTarget_REG0_BASE_IDX                                                       5
#define regSION_CL1_Req_BurstTarget_REG1                                                                0xe91d
#define regSION_CL1_Req_BurstTarget_REG1_BASE_IDX                                                       5
#define regSION_CL1_Req_TimeSlot_REG0                                                                   0xe91e
#define regSION_CL1_Req_TimeSlot_REG0_BASE_IDX                                                          5
#define regSION_CL1_Req_TimeSlot_REG1                                                                   0xe91f
#define regSION_CL1_Req_TimeSlot_REG1_BASE_IDX                                                          5
#define regSION_CL1_ReqPoolCredit_Alloc_REG0                                                            0xe920
#define regSION_CL1_ReqPoolCredit_Alloc_REG0_BASE_IDX                                                   5
#define regSION_CL1_ReqPoolCredit_Alloc_REG1                                                            0xe921
#define regSION_CL1_ReqPoolCredit_Alloc_REG1_BASE_IDX                                                   5
#define regSION_CL1_DataPoolCredit_Alloc_REG0                                                           0xe922
#define regSION_CL1_DataPoolCredit_Alloc_REG0_BASE_IDX                                                  5
#define regSION_CL1_DataPoolCredit_Alloc_REG1                                                           0xe923
#define regSION_CL1_DataPoolCredit_Alloc_REG1_BASE_IDX                                                  5
#define regSION_CL1_RdRspPoolCredit_Alloc_REG0                                                          0xe924
#define regSION_CL1_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                                 5
#define regSION_CL1_RdRspPoolCredit_Alloc_REG1                                                          0xe925
#define regSION_CL1_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                                 5
#define regSION_CL1_WrRspPoolCredit_Alloc_REG0                                                          0xe926
#define regSION_CL1_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                                 5
#define regSION_CL1_WrRspPoolCredit_Alloc_REG1                                                          0xe927
#define regSION_CL1_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                                 5
#define regSION_CL2_RdRsp_BurstTarget_REG0                                                              0xe928
#define regSION_CL2_RdRsp_BurstTarget_REG0_BASE_IDX                                                     5
#define regSION_CL2_RdRsp_BurstTarget_REG1                                                              0xe929
#define regSION_CL2_RdRsp_BurstTarget_REG1_BASE_IDX                                                     5
#define regSION_CL2_RdRsp_TimeSlot_REG0                                                                 0xe92a
#define regSION_CL2_RdRsp_TimeSlot_REG0_BASE_IDX                                                        5
#define regSION_CL2_RdRsp_TimeSlot_REG1                                                                 0xe92b
#define regSION_CL2_RdRsp_TimeSlot_REG1_BASE_IDX                                                        5
#define regSION_CL2_WrRsp_BurstTarget_REG0                                                              0xe92c
#define regSION_CL2_WrRsp_BurstTarget_REG0_BASE_IDX                                                     5
#define regSION_CL2_WrRsp_BurstTarget_REG1                                                              0xe92d
#define regSION_CL2_WrRsp_BurstTarget_REG1_BASE_IDX                                                     5
#define regSION_CL2_WrRsp_TimeSlot_REG0                                                                 0xe92e
#define regSION_CL2_WrRsp_TimeSlot_REG0_BASE_IDX                                                        5
#define regSION_CL2_WrRsp_TimeSlot_REG1                                                                 0xe92f
#define regSION_CL2_WrRsp_TimeSlot_REG1_BASE_IDX                                                        5
#define regSION_CL2_Req_BurstTarget_REG0                                                                0xe930
#define regSION_CL2_Req_BurstTarget_REG0_BASE_IDX                                                       5
#define regSION_CL2_Req_BurstTarget_REG1                                                                0xe931
#define regSION_CL2_Req_BurstTarget_REG1_BASE_IDX                                                       5
#define regSION_CL2_Req_TimeSlot_REG0                                                                   0xe932
#define regSION_CL2_Req_TimeSlot_REG0_BASE_IDX                                                          5
#define regSION_CL2_Req_TimeSlot_REG1                                                                   0xe933
#define regSION_CL2_Req_TimeSlot_REG1_BASE_IDX                                                          5
#define regSION_CL2_ReqPoolCredit_Alloc_REG0                                                            0xe934
#define regSION_CL2_ReqPoolCredit_Alloc_REG0_BASE_IDX                                                   5
#define regSION_CL2_ReqPoolCredit_Alloc_REG1                                                            0xe935
#define regSION_CL2_ReqPoolCredit_Alloc_REG1_BASE_IDX                                                   5
#define regSION_CL2_DataPoolCredit_Alloc_REG0                                                           0xe936
#define regSION_CL2_DataPoolCredit_Alloc_REG0_BASE_IDX                                                  5
#define regSION_CL2_DataPoolCredit_Alloc_REG1                                                           0xe937
#define regSION_CL2_DataPoolCredit_Alloc_REG1_BASE_IDX                                                  5
#define regSION_CL2_RdRspPoolCredit_Alloc_REG0                                                          0xe938
#define regSION_CL2_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                                 5
#define regSION_CL2_RdRspPoolCredit_Alloc_REG1                                                          0xe939
#define regSION_CL2_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                                 5
#define regSION_CL2_WrRspPoolCredit_Alloc_REG0                                                          0xe93a
#define regSION_CL2_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                                 5
#define regSION_CL2_WrRspPoolCredit_Alloc_REG1                                                          0xe93b
#define regSION_CL2_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                                 5
#define regSION_CNTL_REG0                                                                               0xe93c
#define regSION_CNTL_REG0_BASE_IDX                                                                      5
#define regSION_CNTL_REG1                                                                               0xe93d
#define regSION_CNTL_REG1_BASE_IDX                                                                      5


// addressBlock: nbio_nbif0_bif_ras_bif_ras_regblk
// base address: 0x10100000
#define regBIFL_RAS_CENTRAL_CNTL                                                                        0xe400
#define regBIFL_RAS_CENTRAL_CNTL_BASE_IDX                                                               5
#define regBIFL_RAS_CENTRAL_STATUS                                                                      0xe410
#define regBIFL_RAS_CENTRAL_STATUS_BASE_IDX                                                             5
#define regBIFL_RAS_LEAF0_CTRL                                                                          0xe420
#define regBIFL_RAS_LEAF0_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF1_CTRL                                                                          0xe421
#define regBIFL_RAS_LEAF1_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF2_CTRL                                                                          0xe422
#define regBIFL_RAS_LEAF2_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF0_STATUS                                                                        0xe430
#define regBIFL_RAS_LEAF0_STATUS_BASE_IDX                                                               5
#define regBIFL_RAS_LEAF1_STATUS                                                                        0xe431
#define regBIFL_RAS_LEAF1_STATUS_BASE_IDX                                                               5
#define regBIFL_RAS_LEAF2_STATUS                                                                        0xe432
#define regBIFL_RAS_LEAF2_STATUS_BASE_IDX                                                               5
#define regBIFL_IOHUB_RAS_IH_CNTL                                                                       0xe7fe
#define regBIFL_IOHUB_RAS_IH_CNTL_BASE_IDX                                                              5
#define regBIFL_RAS_VWR_FROM_IOHUB                                                                      0xe7ff
#define regBIFL_RAS_VWR_FROM_IOHUB_BASE_IDX                                                             5


// addressBlock: nbio_nbif0_rcc_dwn_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_DWN_DEV0_1_DN_PCIE_RESERVED                                                              0x8d70
#define regRCC_DWN_DEV0_1_DN_PCIE_RESERVED_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_SCRATCH                                                               0x8d71
#define regRCC_DWN_DEV0_1_DN_PCIE_SCRATCH_BASE_IDX                                                      5
#define regRCC_DWN_DEV0_1_DN_PCIE_CNTL                                                                  0x8d73
#define regRCC_DWN_DEV0_1_DN_PCIE_CNTL_BASE_IDX                                                         5
#define regRCC_DWN_DEV0_1_DN_PCIE_CONFIG_CNTL                                                           0x8d74
#define regRCC_DWN_DEV0_1_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  5
#define regRCC_DWN_DEV0_1_DN_PCIE_RX_CNTL2                                                              0x8d75
#define regRCC_DWN_DEV0_1_DN_PCIE_RX_CNTL2_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_BUS_CNTL                                                              0x8d76
#define regRCC_DWN_DEV0_1_DN_PCIE_BUS_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_CFG_CNTL                                                              0x8d77
#define regRCC_DWN_DEV0_1_DN_PCIE_CFG_CNTL_BASE_IDX                                                     5


// addressBlock: nbio_nbif0_rcc_dwnp_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_DWNP_DEV0_1_PCIE_ERR_CNTL                                                                0x8d7c
#define regRCC_DWNP_DEV0_1_PCIE_ERR_CNTL_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_1_PCIE_RX_CNTL                                                                 0x8d7d
#define regRCC_DWNP_DEV0_1_PCIE_RX_CNTL_BASE_IDX                                                        5
#define regRCC_DWNP_DEV0_1_PCIE_LC_SPEED_CNTL                                                           0x8d7e
#define regRCC_DWNP_DEV0_1_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  5
#define regRCC_DWNP_DEV0_1_PCIE_LC_CNTL2                                                                0x8d7f
#define regRCC_DWNP_DEV0_1_PCIE_LC_CNTL2_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_1_LTR_MSG_INFO_FROM_EP                                                         0x8d81
#define regRCC_DWNP_DEV0_1_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                5


// addressBlock: nbio_nbif0_rcc_ep_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_EP_DEV0_1_EP_PCIE_SCRATCH                                                                0x8d56
#define regRCC_EP_DEV0_1_EP_PCIE_SCRATCH_BASE_IDX                                                       5
#define regRCC_EP_DEV0_1_EP_PCIE_CNTL                                                                   0x8d58
#define regRCC_EP_DEV0_1_EP_PCIE_CNTL_BASE_IDX                                                          5
#define regRCC_EP_DEV0_1_EP_PCIE_INT_CNTL                                                               0x8d59
#define regRCC_EP_DEV0_1_EP_PCIE_INT_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_INT_STATUS                                                             0x8d5a
#define regRCC_EP_DEV0_1_EP_PCIE_INT_STATUS_BASE_IDX                                                    5
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL2                                                               0x8d5b
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL2_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_BUS_CNTL                                                               0x8d5c
#define regRCC_EP_DEV0_1_EP_PCIE_BUS_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_CFG_CNTL                                                               0x8d5d
#define regRCC_EP_DEV0_1_EP_PCIE_CFG_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_TX_LTR_CNTL                                                            0x8d5f
#define regRCC_EP_DEV0_1_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0                                               0x8d60
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1                                               0x8d60
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2                                               0x8d60
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3                                               0x8d60
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4                                               0x8d61
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5                                               0x8d61
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6                                               0x8d61
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7                                               0x8d61
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CAP                                                             0x8d65
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    5
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0x8d66
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CNTL                                                            0x8d66
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0x8d66
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0x8d67
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0x8d67
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0x8d67
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0x8d67
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0x8d68
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0x8d68
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0x8d68
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_PME_CONTROL                                                            0x8d68
#define regRCC_EP_DEV0_1_EP_PCIE_PME_CONTROL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_EP_PCIEP_RESERVED                                                              0x8d69
#define regRCC_EP_DEV0_1_EP_PCIEP_RESERVED_BASE_IDX                                                     5
#define regRCC_EP_DEV0_1_EP_PCIE_TX_CNTL                                                                0x8d6b
#define regRCC_EP_DEV0_1_EP_PCIE_TX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_1_EP_PCIE_TX_REQUESTER_ID                                                        0x8d6c
#define regRCC_EP_DEV0_1_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               5
#define regRCC_EP_DEV0_1_EP_PCIE_ERR_CNTL                                                               0x8d6d
#define regRCC_EP_DEV0_1_EP_PCIE_ERR_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL                                                                0x8d6e
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_1_EP_PCIE_LC_SPEED_CNTL                                                          0x8d6f
#define regRCC_EP_DEV0_1_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 5


// addressBlock: nbio_nbif0_bif_bx_SYSDEC
// base address: 0x10120000
#define regBIF_BX0_PCIE_INDEX                                                                           0x800c
#define regBIF_BX0_PCIE_INDEX_BASE_IDX                                                                  5
#define regBIF_BX0_PCIE_DATA                                                                            0x800d
#define regBIF_BX0_PCIE_DATA_BASE_IDX                                                                   5
#define regBIF_BX0_PCIE_INDEX2                                                                          0x800e
#define regBIF_BX0_PCIE_INDEX2_BASE_IDX                                                                 0
#define regBIF_BX0_PCIE_DATA2                                                                           0x800f
#define regBIF_BX0_PCIE_DATA2_BASE_IDX                                                                  0
#define regBIF_BX0_SBIOS_SCRATCH_0                                                                      0x8048
#define regBIF_BX0_SBIOS_SCRATCH_0_BASE_IDX                                                             5
#define regBIF_BX0_SBIOS_SCRATCH_1                                                                      0x8049
#define regBIF_BX0_SBIOS_SCRATCH_1_BASE_IDX                                                             5
#define regBIF_BX0_SBIOS_SCRATCH_2                                                                      0x804a
#define regBIF_BX0_SBIOS_SCRATCH_2_BASE_IDX                                                             5
#define regBIF_BX0_SBIOS_SCRATCH_3                                                                      0x804b
#define regBIF_BX0_SBIOS_SCRATCH_3_BASE_IDX                                                             5
#define regBIF_BX0_BIOS_SCRATCH_0                                                                       0x804c
#define regBIF_BX0_BIOS_SCRATCH_0_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_1                                                                       0x804d
#define regBIF_BX0_BIOS_SCRATCH_1_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_2                                                                       0x804e
#define regBIF_BX0_BIOS_SCRATCH_2_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_3                                                                       0x804f
#define regBIF_BX0_BIOS_SCRATCH_3_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_4                                                                       0x8050
#define regBIF_BX0_BIOS_SCRATCH_4_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_5                                                                       0x8051
#define regBIF_BX0_BIOS_SCRATCH_5_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_6                                                                       0x8052
#define regBIF_BX0_BIOS_SCRATCH_6_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_7                                                                       0x8053
#define regBIF_BX0_BIOS_SCRATCH_7_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_8                                                                       0x8054
#define regBIF_BX0_BIOS_SCRATCH_8_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_9                                                                       0x8055
#define regBIF_BX0_BIOS_SCRATCH_9_BASE_IDX                                                              5
#define regBIF_BX0_BIOS_SCRATCH_10                                                                      0x8056
#define regBIF_BX0_BIOS_SCRATCH_10_BASE_IDX                                                             5
#define regBIF_BX0_BIOS_SCRATCH_11                                                                      0x8057
#define regBIF_BX0_BIOS_SCRATCH_11_BASE_IDX                                                             5
#define regBIF_BX0_BIOS_SCRATCH_12                                                                      0x8058
#define regBIF_BX0_BIOS_SCRATCH_12_BASE_IDX                                                             5
#define regBIF_BX0_BIOS_SCRATCH_13                                                                      0x8059
#define regBIF_BX0_BIOS_SCRATCH_13_BASE_IDX                                                             5
#define regBIF_BX0_BIOS_SCRATCH_14                                                                      0x805a
#define regBIF_BX0_BIOS_SCRATCH_14_BASE_IDX                                                             5
#define regBIF_BX0_BIOS_SCRATCH_15                                                                      0x805b
#define regBIF_BX0_BIOS_SCRATCH_15_BASE_IDX                                                             5
#define regBIF_BX0_BIF_RLC_INTR_CNTL                                                                    0x8060
#define regBIF_BX0_BIF_RLC_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX0_BIF_VCE_INTR_CNTL                                                                    0x8061
#define regBIF_BX0_BIF_VCE_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX0_BIF_UVD_INTR_CNTL                                                                    0x8062
#define regBIF_BX0_BIF_UVD_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR0                                                                0x8080
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR0                                                          0x8081
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR1                                                                0x8082
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR1                                                          0x8083
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR2                                                                0x8084
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR2                                                          0x8085
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR3                                                                0x8086
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR3                                                          0x8087
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR4                                                                0x8088
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR4                                                          0x8089
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR5                                                                0x808a
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR5                                                          0x808b
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR6                                                                0x808c
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR6                                                          0x808d
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR7                                                                0x808e
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                       5
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR7                                                          0x808f
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                 5
#define regBIF_BX0_GFX_MMIOREG_CAM_CNTL                                                                 0x8090
#define regBIF_BX0_GFX_MMIOREG_CAM_CNTL_BASE_IDX                                                        5
#define regBIF_BX0_GFX_MMIOREG_CAM_ZERO_CPL                                                             0x8091
#define regBIF_BX0_GFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                    5
#define regBIF_BX0_GFX_MMIOREG_CAM_ONE_CPL                                                              0x8092
#define regBIF_BX0_GFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                     5
#define regBIF_BX0_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                     0x8093
#define regBIF_BX0_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                            5


// addressBlock: nbio_nbif0_bif_bx_pf_SYSPFVFDEC
// base address: 0x10120000
#define regBIF_BX_PF0_MM_INDEX                                                                          0x8000
#define regBIF_BX_PF0_MM_INDEX_BASE_IDX                                                                 5
#define regBIF_BX_PF0_MM_DATA                                                                           0x8001
#define regBIF_BX_PF0_MM_DATA_BASE_IDX                                                                  5
#define regBIF_BX_PF0_MM_INDEX_HI                                                                       0x8006
#define regBIF_BX_PF0_MM_INDEX_HI_BASE_IDX                                                              5
#define regBIF_BX_PF0_RSMU_INDEX                                                                        0x8014
#define regBIF_BX_PF0_RSMU_INDEX_BASE_IDX                                                               5
#define regBIF_BX_PF0_RSMU_DATA                                                                         0x8015
#define regBIF_BX_PF0_RSMU_DATA_BASE_IDX                                                                5


// addressBlock: nbio_nbif0_bif_bx_BIFDEC1
// base address: 0x10120000
#define regBIF_BX0_BIF_MM_INDACCESS_CNTL                                                                0x8e06
#define regBIF_BX0_BIF_MM_INDACCESS_CNTL_BASE_IDX                                                       5
#define regBIF_BX0_BUS_CNTL                                                                             0x8e07
#define regBIF_BX0_BUS_CNTL_BASE_IDX                                                                    5
#define regBIF_BX0_BIF_SCRATCH0                                                                         0x8e08
#define regBIF_BX0_BIF_SCRATCH0_BASE_IDX                                                                5
#define regBIF_BX0_BIF_SCRATCH1                                                                         0x8e09
#define regBIF_BX0_BIF_SCRATCH1_BASE_IDX                                                                5
#define regBIF_BX0_BX_RESET_EN                                                                          0x8e0d
#define regBIF_BX0_BX_RESET_EN_BASE_IDX                                                                 5
#define regBIF_BX0_MM_CFGREGS_CNTL                                                                      0x8e0e
#define regBIF_BX0_MM_CFGREGS_CNTL_BASE_IDX                                                             5
#define regBIF_BX0_BX_RESET_CNTL                                                                        0x8e10
#define regBIF_BX0_BX_RESET_CNTL_BASE_IDX                                                               5
#define regBIF_BX0_INTERRUPT_CNTL                                                                       0x8e11
#define regBIF_BX0_INTERRUPT_CNTL_BASE_IDX                                                              5
#define regBIF_BX0_INTERRUPT_CNTL2                                                                      0x8e12
#define regBIF_BX0_INTERRUPT_CNTL2_BASE_IDX                                                             5
#define regBIF_BX0_CLKREQB_PAD_CNTL                                                                     0x8e18
#define regBIF_BX0_CLKREQB_PAD_CNTL_BASE_IDX                                                            5
#define regBIF_BX0_BIF_FEATURES_CONTROL_MISC                                                            0x8e1b
#define regBIF_BX0_BIF_FEATURES_CONTROL_MISC_BASE_IDX                                                   5
#define regBIF_BX0_HDP_ATOMIC_CONTROL_MISC                                                              0x8e1c
#define regBIF_BX0_HDP_ATOMIC_CONTROL_MISC_BASE_IDX                                                     5
#define regBIF_BX0_BIF_DOORBELL_CNTL                                                                    0x8e1d
#define regBIF_BX0_BIF_DOORBELL_CNTL_BASE_IDX                                                           5
#define regBIF_BX0_BIF_DOORBELL_INT_CNTL                                                                0x8e1e
#define regBIF_BX0_BIF_DOORBELL_INT_CNTL_BASE_IDX                                                       5
#define regBIF_BX0_BIF_FB_EN                                                                            0x8e20
#define regBIF_BX0_BIF_FB_EN_BASE_IDX                                                                   5
#define regBIF_BX0_BIF_INTR_CNTL                                                                        0x8e21
#define regBIF_BX0_BIF_INTR_CNTL_BASE_IDX                                                               5
#define regBIF_BX0_BIF_MST_TRANS_PENDING_VF                                                             0x8e29
#define regBIF_BX0_BIF_MST_TRANS_PENDING_VF_BASE_IDX                                                    5
#define regBIF_BX0_BIF_SLV_TRANS_PENDING_VF                                                             0x8e2a
#define regBIF_BX0_BIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                    5
#define regBIF_BX0_BACO_CNTL                                                                            0x8e2b
#define regBIF_BX0_BACO_CNTL_BASE_IDX                                                                   5
#define regBIF_BX0_BIF_BACO_EXIT_TIME0                                                                  0x8e2c
#define regBIF_BX0_BIF_BACO_EXIT_TIME0_BASE_IDX                                                         5
#define regBIF_BX0_BIF_BACO_EXIT_TIMER1                                                                 0x8e2d
#define regBIF_BX0_BIF_BACO_EXIT_TIMER1_BASE_IDX                                                        5
#define regBIF_BX0_BIF_BACO_EXIT_TIMER2                                                                 0x8e2e
#define regBIF_BX0_BIF_BACO_EXIT_TIMER2_BASE_IDX                                                        5
#define regBIF_BX0_BIF_BACO_EXIT_TIMER3                                                                 0x8e2f
#define regBIF_BX0_BIF_BACO_EXIT_TIMER3_BASE_IDX                                                        5
#define regBIF_BX0_BIF_BACO_EXIT_TIMER4                                                                 0x8e30
#define regBIF_BX0_BIF_BACO_EXIT_TIMER4_BASE_IDX                                                        5
#define regBIF_BX0_MEM_TYPE_CNTL                                                                        0x8e31
#define regBIF_BX0_MEM_TYPE_CNTL_BASE_IDX                                                               5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_CNTL                                                               0x8e33
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_CNTL_BASE_IDX                                                      5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_0                                                                  0x8e34
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_0_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_1                                                                  0x8e35
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_1_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_2                                                                  0x8e36
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_2_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_3                                                                  0x8e37
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_3_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_4                                                                  0x8e38
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_4_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_5                                                                  0x8e39
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_5_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_6                                                                  0x8e3a
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_6_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_7                                                                  0x8e3b
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_7_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_8                                                                  0x8e3c
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_8_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_9                                                                  0x8e3d
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_9_BASE_IDX                                                         5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_10                                                                 0x8e3e
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_10_BASE_IDX                                                        5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_11                                                                 0x8e3f
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_11_BASE_IDX                                                        5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_12                                                                 0x8e40
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_12_BASE_IDX                                                        5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_13                                                                 0x8e41
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_13_BASE_IDX                                                        5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_14                                                                 0x8e42
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_14_BASE_IDX                                                        5
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_15                                                                 0x8e43
#define regBIF_BX0_NBIF_GFX_ADDR_LUT_15_BASE_IDX                                                        5
#define regBIF_BX0_GFX_RST_CNTL                                                                         0x8e4a
#define regBIF_BX0_GFX_RST_CNTL_BASE_IDX                                                                5
#define regBIF_BX0_REMAP_HDP_MEM_FLUSH_CNTL                                                             0x8e4d
#define regBIF_BX0_REMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                    5
#define regBIF_BX0_REMAP_HDP_REG_FLUSH_CNTL                                                             0x8e4e
#define regBIF_BX0_REMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                    5
#define regBIF_BX0_BIF_RB_CNTL                                                                          0x8e4f
#define regBIF_BX0_BIF_RB_CNTL_BASE_IDX                                                                 5
#define regBIF_BX0_BIF_RB_BASE                                                                          0x8e50
#define regBIF_BX0_BIF_RB_BASE_BASE_IDX                                                                 5
#define regBIF_BX0_BIF_RB_RPTR                                                                          0x8e51
#define regBIF_BX0_BIF_RB_RPTR_BASE_IDX                                                                 5
#define regBIF_BX0_BIF_RB_WPTR                                                                          0x8e52
#define regBIF_BX0_BIF_RB_WPTR_BASE_IDX                                                                 5
#define regBIF_BX0_BIF_RB_WPTR_ADDR_HI                                                                  0x8e53
#define regBIF_BX0_BIF_RB_WPTR_ADDR_HI_BASE_IDX                                                         5
#define regBIF_BX0_BIF_RB_WPTR_ADDR_LO                                                                  0x8e54
#define regBIF_BX0_BIF_RB_WPTR_ADDR_LO_BASE_IDX                                                         5
#define regBIF_BX0_MAILBOX_INDEX                                                                        0x8e55
#define regBIF_BX0_MAILBOX_INDEX_BASE_IDX                                                               5
#define regBIF_BX0_BIF_GFX_SDMA_GPUIOV_CFG_SIZE                                                         0x8e65
#define regBIF_BX0_BIF_GFX_SDMA_GPUIOV_CFG_SIZE_BASE_IDX                                                5
#define regBIF_BX0_BIF_PERSTB_PAD_CNTL                                                                  0x8e68
#define regBIF_BX0_BIF_PERSTB_PAD_CNTL_BASE_IDX                                                         5
#define regBIF_BX0_BIF_PX_EN_PAD_CNTL                                                                   0x8e69
#define regBIF_BX0_BIF_PX_EN_PAD_CNTL_BASE_IDX                                                          5
#define regBIF_BX0_BIF_REFPADKIN_PAD_CNTL                                                               0x8e6a
#define regBIF_BX0_BIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                      5
#define regBIF_BX0_BIF_CLKREQB_PAD_CNTL                                                                 0x8e6b
#define regBIF_BX0_BIF_CLKREQB_PAD_CNTL_BASE_IDX                                                        5
#define regBIF_BX0_BIF_PWRBRK_PAD_CNTL                                                                  0x8e6c
#define regBIF_BX0_BIF_PWRBRK_PAD_CNTL_BASE_IDX                                                         5


// addressBlock: nbio_nbif0_bif_bx_pf_BIFPFVFDEC1
// base address: 0x10120000
#define regBIF_BX_PF0_BIF_BME_STATUS                                                                    0x8e0b
#define regBIF_BX_PF0_BIF_BME_STATUS_BASE_IDX                                                           5
#define regBIF_BX_PF0_BIF_ATOMIC_ERR_LOG                                                                0x8e0c
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                              0x8e13
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                     5
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                               0x8e14
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                      5
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_CNTL                                                   0x8e15
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                          5
#define regBIF_BX_PF0_HDP_REG_COHERENCY_FLUSH_CNTL                                                      0x8e16
#define regBIF_BX_PF0_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                             5
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_CNTL                                                      0x8e17
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                             5
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                                 0x8e19
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                                        5
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                            0x8e1a
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                                   5
#define regBIF_BX_PF0_GPU_HDP_FLUSH_ONLY_REQ                                                            0x8e24
#define regBIF_BX_PF0_GPU_HDP_FLUSH_ONLY_REQ_BASE_IDX                                                   5
#define regBIF_BX_PF0_GPU_HDP_INVALIDATE_ONLY_REQ                                                       0x8e25
#define regBIF_BX_PF0_GPU_HDP_INVALIDATE_ONLY_REQ_BASE_IDX                                              5
#define regBIF_BX_PF0_GPU_HDP_FLUSH_REQ                                                                 0x8e26
#define regBIF_BX_PF0_GPU_HDP_FLUSH_REQ_BASE_IDX                                                        5
#define regBIF_BX_PF0_GPU_HDP_FLUSH_DONE                                                                0x8e27
#define regBIF_BX_PF0_GPU_HDP_FLUSH_DONE_BASE_IDX                                                       5
#define regBIF_BX_PF0_BIF_TRANS_PENDING                                                                 0x8e28
#define regBIF_BX_PF0_BIF_TRANS_PENDING_BASE_IDX                                                        5
#define regBIF_BX_PF0_NBIF_GFX_ADDR_LUT_BYPASS                                                          0x8e32
#define regBIF_BX_PF0_NBIF_GFX_ADDR_LUT_BYPASS_BASE_IDX                                                 5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW0                                                            0x8e56
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW1                                                            0x8e57
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW2                                                            0x8e58
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW3                                                            0x8e59
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW0                                                            0x8e5a
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW1                                                            0x8e5b
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW2                                                            0x8e5c
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW3                                                            0x8e5d
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                   5
#define regBIF_BX_PF0_MAILBOX_CONTROL                                                                   0x8e5e
#define regBIF_BX_PF0_MAILBOX_CONTROL_BASE_IDX                                                          5
#define regBIF_BX_PF0_MAILBOX_INT_CNTL                                                                  0x8e5f
#define regBIF_BX_PF0_MAILBOX_INT_CNTL_BASE_IDX                                                         5
#define regBIF_BX_PF0_BIF_VMHV_MAILBOX                                                                  0x8e60
#define regBIF_BX_PF0_BIF_VMHV_MAILBOX_BASE_IDX                                                         5


// addressBlock: nbio_nbif0_bif_bx_SYSDEC:1
// base address: 0x0
#define regBIF_BX1_PCIE_INDEX                                                                           0x000c
#define regBIF_BX1_PCIE_INDEX_BASE_IDX                                                                  0
#define regBIF_BX1_PCIE_DATA                                                                            0x000d
#define regBIF_BX1_PCIE_DATA_BASE_IDX                                                                   0
#define regBIF_BX1_PCIE_INDEX2                                                                          0x000e
#define regBIF_BX1_PCIE_INDEX2_BASE_IDX                                                                 0
#define regBIF_BX1_PCIE_DATA2                                                                           0x000f
#define regBIF_BX1_PCIE_DATA2_BASE_IDX                                                                  0
#define regBIF_BX1_SBIOS_SCRATCH_0                                                                      0x0034
#define regBIF_BX1_SBIOS_SCRATCH_0_BASE_IDX                                                             1
#define regBIF_BX1_SBIOS_SCRATCH_1                                                                      0x0035
#define regBIF_BX1_SBIOS_SCRATCH_1_BASE_IDX                                                             1
#define regBIF_BX1_SBIOS_SCRATCH_2                                                                      0x0036
#define regBIF_BX1_SBIOS_SCRATCH_2_BASE_IDX                                                             1
#define regBIF_BX1_SBIOS_SCRATCH_3                                                                      0x0037
#define regBIF_BX1_SBIOS_SCRATCH_3_BASE_IDX                                                             1
#define regBIF_BX1_BIOS_SCRATCH_0                                                                       0x0038
#define regBIF_BX1_BIOS_SCRATCH_0_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_1                                                                       0x0039
#define regBIF_BX1_BIOS_SCRATCH_1_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_2                                                                       0x003a
#define regBIF_BX1_BIOS_SCRATCH_2_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_3                                                                       0x003b
#define regBIF_BX1_BIOS_SCRATCH_3_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_4                                                                       0x003c
#define regBIF_BX1_BIOS_SCRATCH_4_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_5                                                                       0x003d
#define regBIF_BX1_BIOS_SCRATCH_5_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_6                                                                       0x003e
#define regBIF_BX1_BIOS_SCRATCH_6_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_7                                                                       0x003f
#define regBIF_BX1_BIOS_SCRATCH_7_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_8                                                                       0x0040
#define regBIF_BX1_BIOS_SCRATCH_8_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_9                                                                       0x0041
#define regBIF_BX1_BIOS_SCRATCH_9_BASE_IDX                                                              1
#define regBIF_BX1_BIOS_SCRATCH_10                                                                      0x0042
#define regBIF_BX1_BIOS_SCRATCH_10_BASE_IDX                                                             1
#define regBIF_BX1_BIOS_SCRATCH_11                                                                      0x0043
#define regBIF_BX1_BIOS_SCRATCH_11_BASE_IDX                                                             1
#define regBIF_BX1_BIOS_SCRATCH_12                                                                      0x0044
#define regBIF_BX1_BIOS_SCRATCH_12_BASE_IDX                                                             1
#define regBIF_BX1_BIOS_SCRATCH_13                                                                      0x0045
#define regBIF_BX1_BIOS_SCRATCH_13_BASE_IDX                                                             1
#define regBIF_BX1_BIOS_SCRATCH_14                                                                      0x0046
#define regBIF_BX1_BIOS_SCRATCH_14_BASE_IDX                                                             1
#define regBIF_BX1_BIOS_SCRATCH_15                                                                      0x0047
#define regBIF_BX1_BIOS_SCRATCH_15_BASE_IDX                                                             1
#define regBIF_BX1_BIF_RLC_INTR_CNTL                                                                    0x004c
#define regBIF_BX1_BIF_RLC_INTR_CNTL_BASE_IDX                                                           1
#define regBIF_BX1_BIF_VCE_INTR_CNTL                                                                    0x004d
#define regBIF_BX1_BIF_VCE_INTR_CNTL_BASE_IDX                                                           1
#define regBIF_BX1_BIF_UVD_INTR_CNTL                                                                    0x004e
#define regBIF_BX1_BIF_UVD_INTR_CNTL_BASE_IDX                                                           1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR0                                                                0x006c
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR0                                                          0x006d
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR1                                                                0x006e
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR1                                                          0x006f
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR2                                                                0x0070
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR2                                                          0x0071
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR3                                                                0x0072
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR3                                                          0x0073
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR4                                                                0x0074
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR4                                                          0x0075
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR5                                                                0x0076
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR5                                                          0x0077
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR6                                                                0x0078
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR6                                                          0x0079
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR7                                                                0x007a
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                       1
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR7                                                          0x007b
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                 1
#define regBIF_BX1_GFX_MMIOREG_CAM_CNTL                                                                 0x007c
#define regBIF_BX1_GFX_MMIOREG_CAM_CNTL_BASE_IDX                                                        1
#define regBIF_BX1_GFX_MMIOREG_CAM_ZERO_CPL                                                             0x007d
#define regBIF_BX1_GFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                    1
#define regBIF_BX1_GFX_MMIOREG_CAM_ONE_CPL                                                              0x007e
#define regBIF_BX1_GFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                     1
#define regBIF_BX1_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                     0x007f
#define regBIF_BX1_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                            1


// addressBlock: nbio_nbif0_rcc_dwn_dev0_BIFDEC1:1
// base address: 0x0
#define regRCC_DWN_DEV0_2_DN_PCIE_RESERVED                                                              0x0050
#define regRCC_DWN_DEV0_2_DN_PCIE_RESERVED_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_2_DN_PCIE_SCRATCH                                                               0x0051
#define regRCC_DWN_DEV0_2_DN_PCIE_SCRATCH_BASE_IDX                                                      2
#define regRCC_DWN_DEV0_2_DN_PCIE_CNTL                                                                  0x0053
#define regRCC_DWN_DEV0_2_DN_PCIE_CNTL_BASE_IDX                                                         2
#define regRCC_DWN_DEV0_2_DN_PCIE_CONFIG_CNTL                                                           0x0054
#define regRCC_DWN_DEV0_2_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  2
#define regRCC_DWN_DEV0_2_DN_PCIE_RX_CNTL2                                                              0x0055
#define regRCC_DWN_DEV0_2_DN_PCIE_RX_CNTL2_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_2_DN_PCIE_BUS_CNTL                                                              0x0056
#define regRCC_DWN_DEV0_2_DN_PCIE_BUS_CNTL_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_2_DN_PCIE_CFG_CNTL                                                              0x0057
#define regRCC_DWN_DEV0_2_DN_PCIE_CFG_CNTL_BASE_IDX                                                     2


// addressBlock: nbio_nbif0_rcc_dwnp_dev0_BIFDEC1:1
// base address: 0x0
#define regRCC_DWNP_DEV0_2_PCIE_ERR_CNTL                                                                0x005c
#define regRCC_DWNP_DEV0_2_PCIE_ERR_CNTL_BASE_IDX                                                       2
#define regRCC_DWNP_DEV0_2_PCIE_RX_CNTL                                                                 0x005d
#define regRCC_DWNP_DEV0_2_PCIE_RX_CNTL_BASE_IDX                                                        2
#define regRCC_DWNP_DEV0_2_PCIE_LC_SPEED_CNTL                                                           0x005e
#define regRCC_DWNP_DEV0_2_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  2
#define regRCC_DWNP_DEV0_2_PCIE_LC_CNTL2                                                                0x005f
#define regRCC_DWNP_DEV0_2_PCIE_LC_CNTL2_BASE_IDX                                                       2
#define regRCC_DWNP_DEV0_2_LTR_MSG_INFO_FROM_EP                                                         0x0061
#define regRCC_DWNP_DEV0_2_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                2


// addressBlock: nbio_nbif0_rcc_ep_dev0_BIFDEC1:1
// base address: 0x0
#define regRCC_EP_DEV0_2_EP_PCIE_SCRATCH                                                                0x0036
#define regRCC_EP_DEV0_2_EP_PCIE_SCRATCH_BASE_IDX                                                       2
#define regRCC_EP_DEV0_2_EP_PCIE_CNTL                                                                   0x0038
#define regRCC_EP_DEV0_2_EP_PCIE_CNTL_BASE_IDX                                                          2
#define regRCC_EP_DEV0_2_EP_PCIE_INT_CNTL                                                               0x0039
#define regRCC_EP_DEV0_2_EP_PCIE_INT_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_INT_STATUS                                                             0x003a
#define regRCC_EP_DEV0_2_EP_PCIE_INT_STATUS_BASE_IDX                                                    2
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL2                                                               0x003b
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL2_BASE_IDX                                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_BUS_CNTL                                                               0x003c
#define regRCC_EP_DEV0_2_EP_PCIE_BUS_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_CFG_CNTL                                                               0x003d
#define regRCC_EP_DEV0_2_EP_PCIE_CFG_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_TX_LTR_CNTL                                                            0x003f
#define regRCC_EP_DEV0_2_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0                                               0x0040
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1                                               0x0040
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2                                               0x0040
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3                                               0x0040
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4                                               0x0041
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5                                               0x0041
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6                                               0x0041
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      2
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7                                               0x0041
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CAP                                                             0x0045
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    2
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0x0046
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CNTL                                                            0x0046
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0x0046
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0x0047
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0x0047
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0x0047
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0x0047
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0x0048
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0x0048
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0x0048
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_PME_CONTROL                                                            0x0048
#define regRCC_EP_DEV0_2_EP_PCIE_PME_CONTROL_BASE_IDX                                                   2
#define regRCC_EP_DEV0_2_EP_PCIEP_RESERVED                                                              0x0049
#define regRCC_EP_DEV0_2_EP_PCIEP_RESERVED_BASE_IDX                                                     2
#define regRCC_EP_DEV0_2_EP_PCIE_TX_CNTL                                                                0x004b
#define regRCC_EP_DEV0_2_EP_PCIE_TX_CNTL_BASE_IDX                                                       2
#define regRCC_EP_DEV0_2_EP_PCIE_TX_REQUESTER_ID                                                        0x004c
#define regRCC_EP_DEV0_2_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               2
#define regRCC_EP_DEV0_2_EP_PCIE_ERR_CNTL                                                               0x004d
#define regRCC_EP_DEV0_2_EP_PCIE_ERR_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL                                                                0x004e
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL_BASE_IDX                                                       2
#define regRCC_EP_DEV0_2_EP_PCIE_LC_SPEED_CNTL                                                          0x004f
#define regRCC_EP_DEV0_2_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 2


// addressBlock: nbio_nbif0_bif_bx_pf_SYSPFVFDEC:1
// base address: 0x0
#define regBIF_BX_PF1_MM_INDEX                                                                          0x0000
#define regBIF_BX_PF1_MM_INDEX_BASE_IDX                                                                 0
#define regBIF_BX_PF1_MM_DATA                                                                           0x0001
#define regBIF_BX_PF1_MM_DATA_BASE_IDX                                                                  0
#define regBIF_BX_PF1_MM_INDEX_HI                                                                       0x0006
#define regBIF_BX_PF1_MM_INDEX_HI_BASE_IDX                                                              0
#define regBIF_BX_PF1_RSMU_INDEX                                                                        0x0000
#define regBIF_BX_PF1_RSMU_INDEX_BASE_IDX                                                               1
#define regBIF_BX_PF1_RSMU_DATA                                                                         0x0001
#define regBIF_BX_PF1_RSMU_DATA_BASE_IDX                                                                1

// addressBlock: nbio_nbif0_bif_bx_BIFDEC1:1
// base address: 0x0
#define regBIF_BX1_BIF_MM_INDACCESS_CNTL                                                                0x00e6
#define regBIF_BX1_BIF_MM_INDACCESS_CNTL_BASE_IDX                                                       2
#define regBIF_BX1_BUS_CNTL                                                                             0x00e7
#define regBIF_BX1_BUS_CNTL_BASE_IDX                                                                    2
#define regBIF_BX1_BIF_SCRATCH0                                                                         0x00e8
#define regBIF_BX1_BIF_SCRATCH0_BASE_IDX                                                                2
#define regBIF_BX1_BIF_SCRATCH1                                                                         0x00e9
#define regBIF_BX1_BIF_SCRATCH1_BASE_IDX                                                                2
#define regBIF_BX1_BX_RESET_EN                                                                          0x00ed
#define regBIF_BX1_BX_RESET_EN_BASE_IDX                                                                 2
#define regBIF_BX1_MM_CFGREGS_CNTL                                                                      0x00ee
#define regBIF_BX1_MM_CFGREGS_CNTL_BASE_IDX                                                             2
#define regBIF_BX1_BX_RESET_CNTL                                                                        0x00f0
#define regBIF_BX1_BX_RESET_CNTL_BASE_IDX                                                               2
#define regBIF_BX1_INTERRUPT_CNTL                                                                       0x00f1
#define regBIF_BX1_INTERRUPT_CNTL_BASE_IDX                                                              2
#define regBIF_BX1_INTERRUPT_CNTL2                                                                      0x00f2
#define regBIF_BX1_INTERRUPT_CNTL2_BASE_IDX                                                             2
#define regBIF_BX1_CLKREQB_PAD_CNTL                                                                     0x00f8
#define regBIF_BX1_CLKREQB_PAD_CNTL_BASE_IDX                                                            2
#define regBIF_BX1_BIF_FEATURES_CONTROL_MISC                                                            0x00fb
#define regBIF_BX1_BIF_FEATURES_CONTROL_MISC_BASE_IDX                                                   2
#define regBIF_BX1_HDP_ATOMIC_CONTROL_MISC                                                              0x00fc
#define regBIF_BX1_HDP_ATOMIC_CONTROL_MISC_BASE_IDX                                                     2
#define regBIF_BX1_BIF_DOORBELL_CNTL                                                                    0x00fd
#define regBIF_BX1_BIF_DOORBELL_CNTL_BASE_IDX                                                           2
#define regBIF_BX1_BIF_DOORBELL_INT_CNTL                                                                0x00fe
#define regBIF_BX1_BIF_DOORBELL_INT_CNTL_BASE_IDX                                                       2
#define regBIF_BX1_BIF_FB_EN                                                                            0x0100
#define regBIF_BX1_BIF_FB_EN_BASE_IDX                                                                   2
#define regBIF_BX1_BIF_INTR_CNTL                                                                        0x0101
#define regBIF_BX1_BIF_INTR_CNTL_BASE_IDX                                                               2
#define regBIF_BX1_BIF_MST_TRANS_PENDING_VF                                                             0x0109
#define regBIF_BX1_BIF_MST_TRANS_PENDING_VF_BASE_IDX                                                    2
#define regBIF_BX1_BIF_SLV_TRANS_PENDING_VF                                                             0x010a
#define regBIF_BX1_BIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                    2
#define regBIF_BX1_BACO_CNTL                                                                            0x010b
#define regBIF_BX1_BACO_CNTL_BASE_IDX                                                                   2
#define regBIF_BX1_BIF_BACO_EXIT_TIME0                                                                  0x010c
#define regBIF_BX1_BIF_BACO_EXIT_TIME0_BASE_IDX                                                         2
#define regBIF_BX1_BIF_BACO_EXIT_TIMER1                                                                 0x010d
#define regBIF_BX1_BIF_BACO_EXIT_TIMER1_BASE_IDX                                                        2
#define regBIF_BX1_BIF_BACO_EXIT_TIMER2                                                                 0x010e
#define regBIF_BX1_BIF_BACO_EXIT_TIMER2_BASE_IDX                                                        2
#define regBIF_BX1_BIF_BACO_EXIT_TIMER3                                                                 0x010f
#define regBIF_BX1_BIF_BACO_EXIT_TIMER3_BASE_IDX                                                        2
#define regBIF_BX1_BIF_BACO_EXIT_TIMER4                                                                 0x0110
#define regBIF_BX1_BIF_BACO_EXIT_TIMER4_BASE_IDX                                                        2
#define regBIF_BX1_MEM_TYPE_CNTL                                                                        0x0111
#define regBIF_BX1_MEM_TYPE_CNTL_BASE_IDX                                                               2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_CNTL                                                               0x0113
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_CNTL_BASE_IDX                                                      2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_0                                                                  0x0114
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_0_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_1                                                                  0x0115
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_1_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_2                                                                  0x0116
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_2_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_3                                                                  0x0117
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_3_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_4                                                                  0x0118
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_4_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_5                                                                  0x0119
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_5_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_6                                                                  0x011a
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_6_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_7                                                                  0x011b
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_7_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_8                                                                  0x011c
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_8_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_9                                                                  0x011d
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_9_BASE_IDX                                                         2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_10                                                                 0x011e
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_10_BASE_IDX                                                        2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_11                                                                 0x011f
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_11_BASE_IDX                                                        2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_12                                                                 0x0120
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_12_BASE_IDX                                                        2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_13                                                                 0x0121
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_13_BASE_IDX                                                        2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_14                                                                 0x0122
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_14_BASE_IDX                                                        2
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_15                                                                 0x0123
#define regBIF_BX1_NBIF_GFX_ADDR_LUT_15_BASE_IDX                                                        2
#define regBIF_BX1_GFX_RST_CNTL                                                                         0x012a
#define regBIF_BX1_GFX_RST_CNTL_BASE_IDX                                                                2
#define regBIF_BX1_REMAP_HDP_MEM_FLUSH_CNTL                                                             0x012d
#define regBIF_BX1_REMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                    2
#define regBIF_BX1_REMAP_HDP_REG_FLUSH_CNTL                                                             0x012e
#define regBIF_BX1_REMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                    2
#define regBIF_BX1_BIF_RB_CNTL                                                                          0x012f
#define regBIF_BX1_BIF_RB_CNTL_BASE_IDX                                                                 2
#define regBIF_BX1_BIF_RB_BASE                                                                          0x0130
#define regBIF_BX1_BIF_RB_BASE_BASE_IDX                                                                 2
#define regBIF_BX1_BIF_RB_RPTR                                                                          0x0131
#define regBIF_BX1_BIF_RB_RPTR_BASE_IDX                                                                 2
#define regBIF_BX1_BIF_RB_WPTR                                                                          0x0132
#define regBIF_BX1_BIF_RB_WPTR_BASE_IDX                                                                 2
#define regBIF_BX1_BIF_RB_WPTR_ADDR_HI                                                                  0x0133
#define regBIF_BX1_BIF_RB_WPTR_ADDR_HI_BASE_IDX                                                         2
#define regBIF_BX1_BIF_RB_WPTR_ADDR_LO                                                                  0x0134
#define regBIF_BX1_BIF_RB_WPTR_ADDR_LO_BASE_IDX                                                         2
#define regBIF_BX1_MAILBOX_INDEX                                                                        0x0135
#define regBIF_BX1_MAILBOX_INDEX_BASE_IDX                                                               2
#define regBIF_BX1_BIF_GFX_SDMA_GPUIOV_CFG_SIZE                                                         0x0145
#define regBIF_BX1_BIF_GFX_SDMA_GPUIOV_CFG_SIZE_BASE_IDX                                                2
#define regBIF_BX1_BIF_PERSTB_PAD_CNTL                                                                  0x0148
#define regBIF_BX1_BIF_PERSTB_PAD_CNTL_BASE_IDX                                                         2
#define regBIF_BX1_BIF_PX_EN_PAD_CNTL                                                                   0x0149
#define regBIF_BX1_BIF_PX_EN_PAD_CNTL_BASE_IDX                                                          2
#define regBIF_BX1_BIF_REFPADKIN_PAD_CNTL                                                               0x014a
#define regBIF_BX1_BIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                      2
#define regBIF_BX1_BIF_CLKREQB_PAD_CNTL                                                                 0x014b
#define regBIF_BX1_BIF_CLKREQB_PAD_CNTL_BASE_IDX                                                        2
#define regBIF_BX1_BIF_PWRBRK_PAD_CNTL                                                                  0x014c
#define regBIF_BX1_BIF_PWRBRK_PAD_CNTL_BASE_IDX                                                         2


// addressBlock: nbio_nbif0_rcc_strap_BIFDEC1
// base address: 0x0
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP0                                                              0x0015
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     2


// addressBlock: nbio_nbif0_bif_bx_pf_BIFPFVFDEC1:1
// base address: 0x0
#define regBIF_BX_PF1_BIF_BME_STATUS                                                                    0x00eb
#define regBIF_BX_PF1_BIF_BME_STATUS_BASE_IDX                                                           2
#define regBIF_BX_PF1_BIF_ATOMIC_ERR_LOG                                                                0x00ec
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                              0x00f3
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                     2
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                               0x00f4
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                      2
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_CNTL                                                   0x00f5
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                          2
#define regBIF_BX_PF1_HDP_REG_COHERENCY_FLUSH_CNTL                                                      0x00f6
#define regBIF_BX_PF1_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                             2
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_CNTL                                                      0x00f7
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                             2
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                                 0x00f9
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                                        2
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                            0x00fa
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                                   2
#define regBIF_BX_PF1_GPU_HDP_FLUSH_ONLY_REQ                                                            0x0104
#define regBIF_BX_PF1_GPU_HDP_FLUSH_ONLY_REQ_BASE_IDX                                                   2
#define regBIF_BX_PF1_GPU_HDP_INVALIDATE_ONLY_REQ                                                       0x0105
#define regBIF_BX_PF1_GPU_HDP_INVALIDATE_ONLY_REQ_BASE_IDX                                              2
#define regBIF_BX_PF1_GPU_HDP_FLUSH_REQ                                                                 0x0106
#define regBIF_BX_PF1_GPU_HDP_FLUSH_REQ_BASE_IDX                                                        2
#define regBIF_BX_PF1_GPU_HDP_FLUSH_DONE                                                                0x0107
#define regBIF_BX_PF1_GPU_HDP_FLUSH_DONE_BASE_IDX                                                       2
#define regBIF_BX_PF1_BIF_TRANS_PENDING                                                                 0x0108
#define regBIF_BX_PF1_BIF_TRANS_PENDING_BASE_IDX                                                        2
#define regBIF_BX_PF1_NBIF_GFX_ADDR_LUT_BYPASS                                                          0x0112
#define regBIF_BX_PF1_NBIF_GFX_ADDR_LUT_BYPASS_BASE_IDX                                                 2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW0                                                            0x0136
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW1                                                            0x0137
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW2                                                            0x0138
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW3                                                            0x0139
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW0                                                            0x013a
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW1                                                            0x013b
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW2                                                            0x013c
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW3                                                            0x013d
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                   2
#define regBIF_BX_PF1_MAILBOX_CONTROL                                                                   0x013e
#define regBIF_BX_PF1_MAILBOX_CONTROL_BASE_IDX                                                          2
#define regBIF_BX_PF1_MAILBOX_INT_CNTL                                                                  0x013f
#define regBIF_BX_PF1_MAILBOX_INT_CNTL_BASE_IDX                                                         2
#define regBIF_BX_PF1_BIF_VMHV_MAILBOX                                                                  0x0140
#define regBIF_BX_PF1_BIF_VMHV_MAILBOX_BASE_IDX                                                         2


// addressBlock: nbio_nbif0_rcc_dev0_epf0_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_0_RCC_DOORBELL_APER_EN                                                         0x00c0
#define regRCC_DEV0_EPF0_0_RCC_DOORBELL_APER_EN_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_0_RCC_CONFIG_MEMSIZE                                                           0x00c3
#define regRCC_DEV0_EPF0_0_RCC_CONFIG_MEMSIZE_BASE_IDX                                                  2


// addressBlock: nbio_nbif0_rcc_strap_BIFDEC1:1
// base address: 0x10120000
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP0                                                              0x8d35
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     5


// addressBlock: nbio_nbif0_gdc_GDCDEC
// base address: 0x1400000
#define regGDC0_A2S_QUEUE_FIFO_ARB_CNTL                                                                 0x4f0ae7
#define regGDC0_A2S_QUEUE_FIFO_ARB_CNTL_BASE_IDX                                                        3
#define regGDC0_NBIF_GFX_DOORBELL_STATUS                                                                0x4f0aef
#define regGDC0_NBIF_GFX_DOORBELL_STATUS_BASE_IDX                                                       3
#define regGDC0_BIF_SDMA0_DOORBELL_RANGE                                                                0x4f0af0
#define regGDC0_BIF_SDMA0_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_SDMA1_DOORBELL_RANGE                                                                0x4f0af1
#define regGDC0_BIF_SDMA1_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_IH_DOORBELL_RANGE                                                                   0x4f0af2
#define regGDC0_BIF_IH_DOORBELL_RANGE_BASE_IDX                                                          3
#define regGDC0_BIF_VCN0_DOORBELL_RANGE                                                                 0x4f0af3
#define regGDC0_BIF_VCN0_DOORBELL_RANGE_BASE_IDX                                                        3
#define regGDC0_BIF_RLC_DOORBELL_RANGE                                                                  0x4f0af5
#define regGDC0_BIF_RLC_DOORBELL_RANGE_BASE_IDX                                                         3
#define regGDC0_BIF_SDMA2_DOORBELL_RANGE                                                                0x4f0af6
#define regGDC0_BIF_SDMA2_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_SDMA3_DOORBELL_RANGE                                                                0x4f0af7
#define regGDC0_BIF_SDMA3_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_VCN1_DOORBELL_RANGE                                                                 0x4f0af8
#define regGDC0_BIF_VCN1_DOORBELL_RANGE_BASE_IDX                                                        3
#define regGDC0_BIF_SDMA4_DOORBELL_RANGE                                                                0x4f0af9
#define regGDC0_BIF_SDMA4_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_SDMA5_DOORBELL_RANGE                                                                0x4f0afa
#define regGDC0_BIF_SDMA5_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_CSDMA_DOORBELL_RANGE                                                                0x4f0afb
#define regGDC0_BIF_CSDMA_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC0_BIF_VPE_DOORBELL_RANGE                                                                  0x4f0afc
#define regGDC0_BIF_VPE_DOORBELL_RANGE_BASE_IDX                                                         3
#define regGDC0_ATDMA_MISC_CNTL                                                                         0x4f0afd
#define regGDC0_ATDMA_MISC_CNTL_BASE_IDX                                                                3
#define regGDC0_BIF_DOORBELL_FENCE_CNTL                                                                 0x4f0afe
#define regGDC0_BIF_DOORBELL_FENCE_CNTL_BASE_IDX                                                        3
#define regGDC0_S2A_MISC_CNTL                                                                           0x4f0aff
#define regGDC0_S2A_MISC_CNTL_BASE_IDX                                                                  3


// addressBlock: nbio_nbif0_gdc_GDC_LINEAR_REGION
// base address: 0x1400000
#define regGDC1_A2S_QUEUE_FIFO_ARB_CNTL                                                                 0x4f246c
#define regGDC1_A2S_QUEUE_FIFO_ARB_CNTL_BASE_IDX                                                        3
#define regGDC1_NBIF_GFX_DOORBELL_STATUS                                                                0x4f2476
#define regGDC1_NBIF_GFX_DOORBELL_STATUS_BASE_IDX                                                       3
#define regGDC1_BIF_SDMA0_DOORBELL_RANGE                                                                0x4f2477
#define regGDC1_BIF_SDMA0_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_SDMA1_DOORBELL_RANGE                                                                0x4f2478
#define regGDC1_BIF_SDMA1_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_IH_DOORBELL_RANGE                                                                   0x4f2479
#define regGDC1_BIF_IH_DOORBELL_RANGE_BASE_IDX                                                          3
#define regGDC1_BIF_VCN0_DOORBELL_RANGE                                                                 0x4f247a
#define regGDC1_BIF_VCN0_DOORBELL_RANGE_BASE_IDX                                                        3
#define regGDC1_BIF_RLC_DOORBELL_RANGE                                                                  0x4f247b
#define regGDC1_BIF_RLC_DOORBELL_RANGE_BASE_IDX                                                         3
#define regGDC1_BIF_SDMA2_DOORBELL_RANGE                                                                0x4f247c
#define regGDC1_BIF_SDMA2_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_SDMA3_DOORBELL_RANGE                                                                0x4f247d
#define regGDC1_BIF_SDMA3_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_VCN1_DOORBELL_RANGE                                                                 0x4f247e
#define regGDC1_BIF_VCN1_DOORBELL_RANGE_BASE_IDX                                                        3
#define regGDC1_BIF_SDMA4_DOORBELL_RANGE                                                                0x4f247f
#define regGDC1_BIF_SDMA4_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_SDMA5_DOORBELL_RANGE                                                                0x4f2480
#define regGDC1_BIF_SDMA5_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_CSDMA_DOORBELL_RANGE                                                                0x4f2481
#define regGDC1_BIF_CSDMA_DOORBELL_RANGE_BASE_IDX                                                       3
#define regGDC1_BIF_VPE_DOORBELL_RANGE                                                                  0x4f2482
#define regGDC1_BIF_VPE_DOORBELL_RANGE_BASE_IDX                                                         3
#define regGDC1_ATDMA_MISC_CNTL                                                                         0x4f2483
#define regGDC1_ATDMA_MISC_CNTL_BASE_IDX                                                                3
#define regGDC1_BIF_DOORBELL_FENCE_CNTL                                                                 0x4f2484
#define regGDC1_BIF_DOORBELL_FENCE_CNTL_BASE_IDX                                                        3
#define regGDC1_S2A_MISC_CNTL                                                                           0x4f2485
#define regGDC1_S2A_MISC_CNTL_BASE_IDX                                                                  3


// addressBlock: nbio_nbif0_bif_bx_SYSDEC
// base address: 0xd0000000
#define regBIF_BX2_PCIE_INDEX                                                                           0x2ffc000c
#define regBIF_BX2_PCIE_INDEX_BASE_IDX                                                                  5
#define regBIF_BX2_PCIE_DATA                                                                            0x2ffc000d
#define regBIF_BX2_PCIE_DATA_BASE_IDX                                                                   5
#define regBIF_BX2_PCIE_INDEX2                                                                          0x2ffc000e
#define regBIF_BX2_PCIE_INDEX2_BASE_IDX                                                                 5
#define regBIF_BX2_PCIE_DATA2                                                                           0x2ffc000f
#define regBIF_BX2_PCIE_DATA2_BASE_IDX                                                                  5
#define regBIF_BX2_SBIOS_SCRATCH_0                                                                      0x2ffc0048
#define regBIF_BX2_SBIOS_SCRATCH_0_BASE_IDX                                                             5
#define regBIF_BX2_SBIOS_SCRATCH_1                                                                      0x2ffc0049
#define regBIF_BX2_SBIOS_SCRATCH_1_BASE_IDX                                                             5
#define regBIF_BX2_SBIOS_SCRATCH_2                                                                      0x2ffc004a
#define regBIF_BX2_SBIOS_SCRATCH_2_BASE_IDX                                                             5
#define regBIF_BX2_SBIOS_SCRATCH_3                                                                      0x2ffc004b
#define regBIF_BX2_SBIOS_SCRATCH_3_BASE_IDX                                                             5
#define regBIF_BX2_BIOS_SCRATCH_0                                                                       0x2ffc004c
#define regBIF_BX2_BIOS_SCRATCH_0_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_1                                                                       0x2ffc004d
#define regBIF_BX2_BIOS_SCRATCH_1_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_2                                                                       0x2ffc004e
#define regBIF_BX2_BIOS_SCRATCH_2_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_3                                                                       0x2ffc004f
#define regBIF_BX2_BIOS_SCRATCH_3_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_4                                                                       0x2ffc0050
#define regBIF_BX2_BIOS_SCRATCH_4_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_5                                                                       0x2ffc0051
#define regBIF_BX2_BIOS_SCRATCH_5_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_6                                                                       0x2ffc0052
#define regBIF_BX2_BIOS_SCRATCH_6_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_7                                                                       0x2ffc0053
#define regBIF_BX2_BIOS_SCRATCH_7_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_8                                                                       0x2ffc0054
#define regBIF_BX2_BIOS_SCRATCH_8_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_9                                                                       0x2ffc0055
#define regBIF_BX2_BIOS_SCRATCH_9_BASE_IDX                                                              5
#define regBIF_BX2_BIOS_SCRATCH_10                                                                      0x2ffc0056
#define regBIF_BX2_BIOS_SCRATCH_10_BASE_IDX                                                             5
#define regBIF_BX2_BIOS_SCRATCH_11                                                                      0x2ffc0057
#define regBIF_BX2_BIOS_SCRATCH_11_BASE_IDX                                                             5
#define regBIF_BX2_BIOS_SCRATCH_12                                                                      0x2ffc0058
#define regBIF_BX2_BIOS_SCRATCH_12_BASE_IDX                                                             5
#define regBIF_BX2_BIOS_SCRATCH_13                                                                      0x2ffc0059
#define regBIF_BX2_BIOS_SCRATCH_13_BASE_IDX                                                             5
#define regBIF_BX2_BIOS_SCRATCH_14                                                                      0x2ffc005a
#define regBIF_BX2_BIOS_SCRATCH_14_BASE_IDX                                                             5
#define regBIF_BX2_BIOS_SCRATCH_15                                                                      0x2ffc005b
#define regBIF_BX2_BIOS_SCRATCH_15_BASE_IDX                                                             5
#define regBIF_BX2_BIF_RLC_INTR_CNTL                                                                    0x2ffc0060
#define regBIF_BX2_BIF_RLC_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX2_BIF_VCE_INTR_CNTL                                                                    0x2ffc0061
#define regBIF_BX2_BIF_VCE_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX2_BIF_UVD_INTR_CNTL                                                                    0x2ffc0062
#define regBIF_BX2_BIF_UVD_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR0                                                                0x2ffc0080
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR0                                                          0x2ffc0081
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR1                                                                0x2ffc0082
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR1                                                          0x2ffc0083
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR2                                                                0x2ffc0084
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR2                                                          0x2ffc0085
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR3                                                                0x2ffc0086
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR3                                                          0x2ffc0087
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR4                                                                0x2ffc0088
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR4                                                          0x2ffc0089
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR5                                                                0x2ffc008a
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR5                                                          0x2ffc008b
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR6                                                                0x2ffc008c
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR6                                                          0x2ffc008d
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR7                                                                0x2ffc008e
#define regBIF_BX2_GFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                       5
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR7                                                          0x2ffc008f
#define regBIF_BX2_GFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                 5
#define regBIF_BX2_GFX_MMIOREG_CAM_CNTL                                                                 0x2ffc0090
#define regBIF_BX2_GFX_MMIOREG_CAM_CNTL_BASE_IDX                                                        5
#define regBIF_BX2_GFX_MMIOREG_CAM_ZERO_CPL                                                             0x2ffc0091
#define regBIF_BX2_GFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                    5
#define regBIF_BX2_GFX_MMIOREG_CAM_ONE_CPL                                                              0x2ffc0092
#define regBIF_BX2_GFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                     5
#define regBIF_BX2_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                     0x2ffc0093
#define regBIF_BX2_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                            5


// addressBlock: nbio_nbif0_rcc_dwn_dev0_BIFDEC1
// base address: 0xd0000000
#define regRCC_DWN_DEV0_3_DN_PCIE_RESERVED                                                              0x2ffc0d70
#define regRCC_DWN_DEV0_3_DN_PCIE_RESERVED_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_3_DN_PCIE_SCRATCH                                                               0x2ffc0d71
#define regRCC_DWN_DEV0_3_DN_PCIE_SCRATCH_BASE_IDX                                                      5
#define regRCC_DWN_DEV0_3_DN_PCIE_CNTL                                                                  0x2ffc0d73
#define regRCC_DWN_DEV0_3_DN_PCIE_CNTL_BASE_IDX                                                         5
#define regRCC_DWN_DEV0_3_DN_PCIE_CONFIG_CNTL                                                           0x2ffc0d74
#define regRCC_DWN_DEV0_3_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  5
#define regRCC_DWN_DEV0_3_DN_PCIE_RX_CNTL2                                                              0x2ffc0d75
#define regRCC_DWN_DEV0_3_DN_PCIE_RX_CNTL2_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_3_DN_PCIE_BUS_CNTL                                                              0x2ffc0d76
#define regRCC_DWN_DEV0_3_DN_PCIE_BUS_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_3_DN_PCIE_CFG_CNTL                                                              0x2ffc0d77
#define regRCC_DWN_DEV0_3_DN_PCIE_CFG_CNTL_BASE_IDX                                                     5


// addressBlock: nbio_nbif0_rcc_dwnp_dev0_BIFDEC1
// base address: 0xd0000000
#define regRCC_DWNP_DEV0_3_PCIE_ERR_CNTL                                                                0x2ffc0d7c
#define regRCC_DWNP_DEV0_3_PCIE_ERR_CNTL_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_3_PCIE_RX_CNTL                                                                 0x2ffc0d7d
#define regRCC_DWNP_DEV0_3_PCIE_RX_CNTL_BASE_IDX                                                        5
#define regRCC_DWNP_DEV0_3_PCIE_LC_SPEED_CNTL                                                           0x2ffc0d7e
#define regRCC_DWNP_DEV0_3_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  5
#define regRCC_DWNP_DEV0_3_PCIE_LC_CNTL2                                                                0x2ffc0d7f
#define regRCC_DWNP_DEV0_3_PCIE_LC_CNTL2_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_3_LTR_MSG_INFO_FROM_EP                                                         0x2ffc0d81
#define regRCC_DWNP_DEV0_3_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                5


// addressBlock: nbio_nbif0_rcc_ep_dev0_BIFDEC1
// base address: 0xd0000000
#define regRCC_EP_DEV0_3_EP_PCIE_SCRATCH                                                                0x2ffc0d56
#define regRCC_EP_DEV0_3_EP_PCIE_SCRATCH_BASE_IDX                                                       5
#define regRCC_EP_DEV0_3_EP_PCIE_CNTL                                                                   0x2ffc0d58
#define regRCC_EP_DEV0_3_EP_PCIE_CNTL_BASE_IDX                                                          5
#define regRCC_EP_DEV0_3_EP_PCIE_INT_CNTL                                                               0x2ffc0d59
#define regRCC_EP_DEV0_3_EP_PCIE_INT_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_INT_STATUS                                                             0x2ffc0d5a
#define regRCC_EP_DEV0_3_EP_PCIE_INT_STATUS_BASE_IDX                                                    5
#define regRCC_EP_DEV0_3_EP_PCIE_RX_CNTL2                                                               0x2ffc0d5b
#define regRCC_EP_DEV0_3_EP_PCIE_RX_CNTL2_BASE_IDX                                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_BUS_CNTL                                                               0x2ffc0d5c
#define regRCC_EP_DEV0_3_EP_PCIE_BUS_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_CFG_CNTL                                                               0x2ffc0d5d
#define regRCC_EP_DEV0_3_EP_PCIE_CFG_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_TX_LTR_CNTL                                                            0x2ffc0d5f
#define regRCC_EP_DEV0_3_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0                                               0x2ffc0d60
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1                                               0x2ffc0d60
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2                                               0x2ffc0d60
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3                                               0x2ffc0d60
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4                                               0x2ffc0d61
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5                                               0x2ffc0d61
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6                                               0x2ffc0d61
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7                                               0x2ffc0d61
#define regRCC_EP_DEV0_2_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_F0_DPA_CAP                                                             0x2ffc0d65
#define regRCC_EP_DEV0_3_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    5
#define regRCC_EP_DEV0_3_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0x2ffc0d66
#define regRCC_EP_DEV0_3_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_F0_DPA_CNTL                                                            0x2ffc0d66
#define regRCC_EP_DEV0_3_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0x2ffc0d66
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0x2ffc0d67
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0x2ffc0d67
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0x2ffc0d67
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0x2ffc0d67
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0x2ffc0d68
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0x2ffc0d68
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0x2ffc0d68
#define regRCC_EP_DEV0_3_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_PME_CONTROL                                                            0x2ffc0d68
#define regRCC_EP_DEV0_3_EP_PCIE_PME_CONTROL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_3_EP_PCIEP_RESERVED                                                              0x2ffc0d69
#define regRCC_EP_DEV0_3_EP_PCIEP_RESERVED_BASE_IDX                                                     5
#define regRCC_EP_DEV0_3_EP_PCIE_TX_CNTL                                                                0x2ffc0d6b
#define regRCC_EP_DEV0_3_EP_PCIE_TX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_3_EP_PCIE_TX_REQUESTER_ID                                                        0x2ffc0d6c
#define regRCC_EP_DEV0_3_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               5
#define regRCC_EP_DEV0_3_EP_PCIE_ERR_CNTL                                                               0x2ffc0d6d
#define regRCC_EP_DEV0_3_EP_PCIE_ERR_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_3_EP_PCIE_RX_CNTL                                                                0x2ffc0d6e
#define regRCC_EP_DEV0_3_EP_PCIE_RX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_3_EP_PCIE_LC_SPEED_CNTL                                                          0x2ffc0d6f
#define regRCC_EP_DEV0_3_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 5


// addressBlock: nbio_nbif0_bif_bx_pf_SYSPFVFDEC
// base address: 0xd0000000
#define regBIF_BX_PF2_MM_INDEX                                                                          0x2ffc0000
#define regBIF_BX_PF2_MM_INDEX_BASE_IDX                                                                 5
#define regBIF_BX_PF2_MM_DATA                                                                           0x2ffc0001
#define regBIF_BX_PF2_MM_DATA_BASE_IDX                                                                  5
#define regBIF_BX_PF2_MM_INDEX_HI                                                                       0x2ffc0006
#define regBIF_BX_PF2_MM_INDEX_HI_BASE_IDX                                                              5


// addressBlock: nbio_nbif0_bif_bx_BIFDEC1
// base address: 0xd0000000
#define regBIF_BX2_BIF_MM_INDACCESS_CNTL                                                                0x2ffc0e06
#define regBIF_BX2_BIF_MM_INDACCESS_CNTL_BASE_IDX                                                       5
#define regBIF_BX2_BUS_CNTL                                                                             0x2ffc0e07
#define regBIF_BX2_BUS_CNTL_BASE_IDX                                                                    5
#define regBIF_BX2_BIF_SCRATCH0                                                                         0x2ffc0e08
#define regBIF_BX2_BIF_SCRATCH0_BASE_IDX                                                                5
#define regBIF_BX2_BIF_SCRATCH1                                                                         0x2ffc0e09
#define regBIF_BX2_BIF_SCRATCH1_BASE_IDX                                                                5
#define regBIF_BX2_BX_RESET_EN                                                                          0x2ffc0e0d
#define regBIF_BX2_BX_RESET_EN_BASE_IDX                                                                 5
#define regBIF_BX2_MM_CFGREGS_CNTL                                                                      0x2ffc0e0e
#define regBIF_BX2_MM_CFGREGS_CNTL_BASE_IDX                                                             5
#define regBIF_BX2_BX_RESET_CNTL                                                                        0x2ffc0e10
#define regBIF_BX2_BX_RESET_CNTL_BASE_IDX                                                               5
#define regBIF_BX2_INTERRUPT_CNTL                                                                       0x2ffc0e11
#define regBIF_BX2_INTERRUPT_CNTL_BASE_IDX                                                              5
#define regBIF_BX2_INTERRUPT_CNTL2                                                                      0x2ffc0e12
#define regBIF_BX2_INTERRUPT_CNTL2_BASE_IDX                                                             5
#define regBIF_BX2_CLKREQB_PAD_CNTL                                                                     0x2ffc0e18
#define regBIF_BX2_CLKREQB_PAD_CNTL_BASE_IDX                                                            5
#define regBIF_BX2_BIF_FEATURES_CONTROL_MISC                                                            0x2ffc0e1b
#define regBIF_BX2_BIF_FEATURES_CONTROL_MISC_BASE_IDX                                                   5
#define regBIF_BX2_HDP_ATOMIC_CONTROL_MISC                                                              0x2ffc0e1c
#define regBIF_BX2_HDP_ATOMIC_CONTROL_MISC_BASE_IDX                                                     5
#define regBIF_BX2_BIF_DOORBELL_CNTL                                                                    0x2ffc0e1d
#define regBIF_BX2_BIF_DOORBELL_CNTL_BASE_IDX                                                           5
#define regBIF_BX2_BIF_DOORBELL_INT_CNTL                                                                0x2ffc0e1e
#define regBIF_BX2_BIF_DOORBELL_INT_CNTL_BASE_IDX                                                       5
#define regBIF_BX2_BIF_FB_EN                                                                            0x2ffc0e20
#define regBIF_BX2_BIF_FB_EN_BASE_IDX                                                                   5
#define regBIF_BX2_BIF_INTR_CNTL                                                                        0x2ffc0e21
#define regBIF_BX2_BIF_INTR_CNTL_BASE_IDX                                                               5
#define regBIF_BX2_BIF_MST_TRANS_PENDING_VF                                                             0x2ffc0e29
#define regBIF_BX2_BIF_MST_TRANS_PENDING_VF_BASE_IDX                                                    5
#define regBIF_BX2_BIF_SLV_TRANS_PENDING_VF                                                             0x2ffc0e2a
#define regBIF_BX2_BIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                    5
#define regBIF_BX2_BACO_CNTL                                                                            0x2ffc0e2b
#define regBIF_BX2_BACO_CNTL_BASE_IDX                                                                   5
#define regBIF_BX2_BIF_BACO_EXIT_TIME0                                                                  0x2ffc0e2c
#define regBIF_BX2_BIF_BACO_EXIT_TIME0_BASE_IDX                                                         5
#define regBIF_BX2_BIF_BACO_EXIT_TIMER1                                                                 0x2ffc0e2d
#define regBIF_BX2_BIF_BACO_EXIT_TIMER1_BASE_IDX                                                        5
#define regBIF_BX2_BIF_BACO_EXIT_TIMER2                                                                 0x2ffc0e2e
#define regBIF_BX2_BIF_BACO_EXIT_TIMER2_BASE_IDX                                                        5
#define regBIF_BX2_BIF_BACO_EXIT_TIMER3                                                                 0x2ffc0e2f
#define regBIF_BX2_BIF_BACO_EXIT_TIMER3_BASE_IDX                                                        5
#define regBIF_BX2_BIF_BACO_EXIT_TIMER4                                                                 0x2ffc0e30
#define regBIF_BX2_BIF_BACO_EXIT_TIMER4_BASE_IDX                                                        5
#define regBIF_BX2_MEM_TYPE_CNTL                                                                        0x2ffc0e31
#define regBIF_BX2_MEM_TYPE_CNTL_BASE_IDX                                                               5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_CNTL                                                               0x2ffc0e33
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_CNTL_BASE_IDX                                                      5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_0                                                                  0x2ffc0e34
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_0_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_1                                                                  0x2ffc0e35
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_1_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_2                                                                  0x2ffc0e36
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_2_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_3                                                                  0x2ffc0e37
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_3_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_4                                                                  0x2ffc0e38
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_4_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_5                                                                  0x2ffc0e39
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_5_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_6                                                                  0x2ffc0e3a
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_6_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_7                                                                  0x2ffc0e3b
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_7_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_8                                                                  0x2ffc0e3c
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_8_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_9                                                                  0x2ffc0e3d
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_9_BASE_IDX                                                         5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_10                                                                 0x2ffc0e3e
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_10_BASE_IDX                                                        5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_11                                                                 0x2ffc0e3f
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_11_BASE_IDX                                                        5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_12                                                                 0x2ffc0e40
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_12_BASE_IDX                                                        5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_13                                                                 0x2ffc0e41
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_13_BASE_IDX                                                        5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_14                                                                 0x2ffc0e42
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_14_BASE_IDX                                                        5
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_15                                                                 0x2ffc0e43
#define regBIF_BX2_NBIF_GFX_ADDR_LUT_15_BASE_IDX                                                        5
#define regBIF_BX2_GFX_RST_CNTL                                                                         0x2ffc0e4a
#define regBIF_BX2_GFX_RST_CNTL_BASE_IDX                                                                5
#define regBIF_BX2_REMAP_HDP_MEM_FLUSH_CNTL                                                             0x2ffc0e4d
#define regBIF_BX2_REMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                    5
#define regBIF_BX2_REMAP_HDP_REG_FLUSH_CNTL                                                             0x2ffc0e4e
#define regBIF_BX2_REMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                    5
#define regBIF_BX2_BIF_RB_CNTL                                                                          0x2ffc0e4f
#define regBIF_BX2_BIF_RB_CNTL_BASE_IDX                                                                 5
#define regBIF_BX2_BIF_RB_BASE                                                                          0x2ffc0e50
#define regBIF_BX2_BIF_RB_BASE_BASE_IDX                                                                 5
#define regBIF_BX2_BIF_RB_RPTR                                                                          0x2ffc0e51
#define regBIF_BX2_BIF_RB_RPTR_BASE_IDX                                                                 5
#define regBIF_BX2_BIF_RB_WPTR                                                                          0x2ffc0e52
#define regBIF_BX2_BIF_RB_WPTR_BASE_IDX                                                                 5
#define regBIF_BX2_BIF_RB_WPTR_ADDR_HI                                                                  0x2ffc0e53
#define regBIF_BX2_BIF_RB_WPTR_ADDR_HI_BASE_IDX                                                         5
#define regBIF_BX2_BIF_RB_WPTR_ADDR_LO                                                                  0x2ffc0e54
#define regBIF_BX2_BIF_RB_WPTR_ADDR_LO_BASE_IDX                                                         5
#define regBIF_BX2_MAILBOX_INDEX                                                                        0x2ffc0e55
#define regBIF_BX2_MAILBOX_INDEX_BASE_IDX                                                               5
#define regBIF_BX2_BIF_GFX_SDMA_GPUIOV_CFG_SIZE                                                         0x2ffc0e65
#define regBIF_BX2_BIF_GFX_SDMA_GPUIOV_CFG_SIZE_BASE_IDX                                                5
#define regBIF_BX2_BIF_PERSTB_PAD_CNTL                                                                  0x2ffc0e68
#define regBIF_BX2_BIF_PERSTB_PAD_CNTL_BASE_IDX                                                         5
#define regBIF_BX2_BIF_PX_EN_PAD_CNTL                                                                   0x2ffc0e69
#define regBIF_BX2_BIF_PX_EN_PAD_CNTL_BASE_IDX                                                          5
#define regBIF_BX2_BIF_REFPADKIN_PAD_CNTL                                                               0x2ffc0e6a
#define regBIF_BX2_BIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                      5
#define regBIF_BX2_BIF_CLKREQB_PAD_CNTL                                                                 0x2ffc0e6b
#define regBIF_BX2_BIF_CLKREQB_PAD_CNTL_BASE_IDX                                                        5
#define regBIF_BX2_BIF_PWRBRK_PAD_CNTL                                                                  0x2ffc0e6c
#define regBIF_BX2_BIF_PWRBRK_PAD_CNTL_BASE_IDX                                                         5


// addressBlock: nbio_nbif0_rcc_strap_BIFDEC1
// base address: 0xd0000000
#define regRCC_STRAP3_RCC_DEV0_EPF0_STRAP0                                                              0x2ffc0d35
#define regRCC_STRAP3_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     5


// addressBlock: nbio_nbif0_bif_bx_pf_BIFPFVFDEC1
// base address: 0xd0000000
#define regBIF_BX_PF2_BIF_BME_STATUS                                                                    0x2ffc0e0b
#define regBIF_BX_PF2_BIF_BME_STATUS_BASE_IDX                                                           5
#define regBIF_BX_PF2_BIF_ATOMIC_ERR_LOG                                                                0x2ffc0e0c
#define regBIF_BX_PF2_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                              0x2ffc0e13
#define regBIF_BX_PF2_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                     5
#define regBIF_BX_PF2_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                               0x2ffc0e14
#define regBIF_BX_PF2_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                      5
#define regBIF_BX_PF2_DOORBELL_SELFRING_GPA_APER_CNTL                                                   0x2ffc0e15
#define regBIF_BX_PF2_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                          5
#define regBIF_BX_PF2_HDP_REG_COHERENCY_FLUSH_CNTL                                                      0x2ffc0e16
#define regBIF_BX_PF2_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                             5
#define regBIF_BX_PF2_HDP_MEM_COHERENCY_FLUSH_CNTL                                                      0x2ffc0e17
#define regBIF_BX_PF2_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                             5
#define regBIF_BX_PF2_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                                 0x2ffc0e19
#define regBIF_BX_PF2_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                                        5
#define regBIF_BX_PF2_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                            0x2ffc0e1a
#define regBIF_BX_PF2_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                                   5
#define regBIF_BX_PF2_GPU_HDP_FLUSH_ONLY_REQ                                                            0x2ffc0e24
#define regBIF_BX_PF2_GPU_HDP_FLUSH_ONLY_REQ_BASE_IDX                                                   5
#define regBIF_BX_PF2_GPU_HDP_INVALIDATE_ONLY_REQ                                                       0x2ffc0e25
#define regBIF_BX_PF2_GPU_HDP_INVALIDATE_ONLY_REQ_BASE_IDX                                              5
#define regBIF_BX_PF2_GPU_HDP_FLUSH_REQ                                                                 0x2ffc0e26
#define regBIF_BX_PF2_GPU_HDP_FLUSH_REQ_BASE_IDX                                                        5
#define regBIF_BX_PF2_GPU_HDP_FLUSH_DONE                                                                0x2ffc0e27
#define regBIF_BX_PF2_GPU_HDP_FLUSH_DONE_BASE_IDX                                                       5
#define regBIF_BX_PF2_BIF_TRANS_PENDING                                                                 0x2ffc0e28
#define regBIF_BX_PF2_BIF_TRANS_PENDING_BASE_IDX                                                        5
#define regBIF_BX_PF2_NBIF_GFX_ADDR_LUT_BYPASS                                                          0x2ffc0e32
#define regBIF_BX_PF2_NBIF_GFX_ADDR_LUT_BYPASS_BASE_IDX                                                 5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW0                                                            0x2ffc0e56
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW1                                                            0x2ffc0e57
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW2                                                            0x2ffc0e58
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW3                                                            0x2ffc0e59
#define regBIF_BX_PF2_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW0                                                            0x2ffc0e5a
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW1                                                            0x2ffc0e5b
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW2                                                            0x2ffc0e5c
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW3                                                            0x2ffc0e5d
#define regBIF_BX_PF2_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                   5
#define regBIF_BX_PF2_MAILBOX_CONTROL                                                                   0x2ffc0e5e
#define regBIF_BX_PF2_MAILBOX_CONTROL_BASE_IDX                                                          5
#define regBIF_BX_PF2_MAILBOX_INT_CNTL                                                                  0x2ffc0e5f
#define regBIF_BX_PF2_MAILBOX_INT_CNTL_BASE_IDX                                                         5
#define regBIF_BX_PF2_BIF_VMHV_MAILBOX                                                                  0x2ffc0e60
#define regBIF_BX_PF2_BIF_VMHV_MAILBOX_BASE_IDX                                                         5


// addressBlock: nbio_nbif0_rcc_dev0_epf0_BIFPFVFDEC1[13440..14975]
// base address: 0xd0003480
#define regRCC_DEV0_EPF0_1_RCC_DOORBELL_APER_EN                                                         0x2ffc0de0
#define regRCC_DEV0_EPF0_1_RCC_DOORBELL_APER_EN_BASE_IDX                                                5
#define regRCC_DEV0_EPF0_1_RCC_CONFIG_MEMSIZE                                                           0x2ffc0de3
#define regRCC_DEV0_EPF0_1_RCC_CONFIG_MEMSIZE_BASE_IDX                                                  5


// addressBlock: nbio_nbif0_gdc_GDCDEC
// base address: 0xd0000000
#define regGDC2_A2S_QUEUE_FIFO_ARB_CNTL                                                                 0x2ffc0ee7
#define regGDC2_A2S_QUEUE_FIFO_ARB_CNTL_BASE_IDX                                                        5
#define regGDC2_NBIF_GFX_DOORBELL_STATUS                                                                0x2ffc0eef
#define regGDC2_NBIF_GFX_DOORBELL_STATUS_BASE_IDX                                                       5
#define regGDC2_BIF_SDMA0_DOORBELL_RANGE                                                                0x2ffc0ef0
#define regGDC2_BIF_SDMA0_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_SDMA1_DOORBELL_RANGE                                                                0x2ffc0ef1
#define regGDC2_BIF_SDMA1_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_IH_DOORBELL_RANGE                                                                   0x2ffc0ef2
#define regGDC2_BIF_IH_DOORBELL_RANGE_BASE_IDX                                                          5
#define regGDC2_BIF_VCN0_DOORBELL_RANGE                                                                 0x2ffc0ef3
#define regGDC2_BIF_VCN0_DOORBELL_RANGE_BASE_IDX                                                        5
#define regGDC2_BIF_RLC_DOORBELL_RANGE                                                                  0x2ffc0ef5
#define regGDC2_BIF_RLC_DOORBELL_RANGE_BASE_IDX                                                         5
#define regGDC2_BIF_SDMA2_DOORBELL_RANGE                                                                0x2ffc0ef6
#define regGDC2_BIF_SDMA2_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_SDMA3_DOORBELL_RANGE                                                                0x2ffc0ef7
#define regGDC2_BIF_SDMA3_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_VCN1_DOORBELL_RANGE                                                                 0x2ffc0ef8
#define regGDC2_BIF_VCN1_DOORBELL_RANGE_BASE_IDX                                                        5
#define regGDC2_BIF_SDMA4_DOORBELL_RANGE                                                                0x2ffc0ef9
#define regGDC2_BIF_SDMA4_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_SDMA5_DOORBELL_RANGE                                                                0x2ffc0efa
#define regGDC2_BIF_SDMA5_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_CSDMA_DOORBELL_RANGE                                                                0x2ffc0efb
#define regGDC2_BIF_CSDMA_DOORBELL_RANGE_BASE_IDX                                                       5
#define regGDC2_BIF_VPE_DOORBELL_RANGE                                                                  0x2ffc0efc
#define regGDC2_BIF_VPE_DOORBELL_RANGE_BASE_IDX                                                         5
#define regGDC2_ATDMA_MISC_CNTL                                                                         0x2ffc0efd
#define regGDC2_ATDMA_MISC_CNTL_BASE_IDX                                                                5
#define regGDC2_BIF_DOORBELL_FENCE_CNTL                                                                 0x2ffc0efe
#define regGDC2_BIF_DOORBELL_FENCE_CNTL_BASE_IDX                                                        5


#endif
