// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Numerics;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.Arm;
using Xunit;

// Generated by Fuzzlyn v2.2 on 2024-08-01 14:42:46
// Run on Arm64 MacOS
// Seed: 17520120436908093806-vectort,vector64,vector128,armadvsimd,armadvsimdarm64,armaes,armarmbase,armarmbasearm64,armcrc32,armcrc32arm64,armdp,armrdm,armrdmarm64,armsha1,armsha256
// Reduced from 35.4 KiB to 0.6 KiB in 00:00:19
// Debug: Throws 'System.NullReferenceException'
// Release: Runs successfully

public class Runtime_105818
{
    private static Vector64<long> s_1;

    [Fact]
    public static void TestEntryPoint()
    {
        if (AdvSimd.IsSupported)
        {
            Assert.Throws<NullReferenceException>(() => M1());
        }
    }

    private static void M1()
    {
        var vr2 = Vector64.Create<uint>(4294967295U);
        var vr3 = Vector64.Create<uint>(0);
        AdvSimd.BitwiseSelect(vr2, vr3, Vector64.CreateScalar(M2()));
        System.Console.WriteLine(s_1);
    }

    private static uint M2()
    {
        sbyte[] var0 = default(sbyte[]);
        return (uint)var0[0];
    }
}
