/*
 *  SPDX-FileCopyrightText: 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _STATESHAPECHANGESTATECOMMAND_H_
#define _STATESHAPECHANGESTATECOMMAND_H_

#include <kundo2command.h>

class StateShape;

class StateShapeChangeStateCommand : public KUndo2Command
{
public:
    StateShapeChangeStateCommand(StateShape *_shape, const QString &_newCategoryId, const QString &_newStateId);
    void undo() override;
    void redo() override;

private:
    StateShape *m_shape;
    QString m_newCategoryId, m_newStateId;
    QString m_oldCategoryId, m_oldStateId;
};

#endif
