/* whoopsie
 * 
 * Copyright © 2015 Canonical Ltd.
 * Author: Ted Gould <ted.gould@canonical.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>
#include <glib.h>
#include "../recoverable-problem.h"

#define TEST_SIGNATURE "DuplicateSignature\0test-signature"
#define TEST_DATALIST "DuplicateSignature\0test-signature\0Foo\0Bar\0LongDataList\0A\n B\n C"

void
test_recoverable (void)
{
    gchar * contents = NULL;
    gsize length = 0;

    /* Basic First Run */
    whoopsie_report_recoverable_problem("test-signature", 0, TRUE, NULL);

    g_file_get_contents("recoverable_mock.contents", &contents, &length, NULL);
    if (length != sizeof(TEST_SIGNATURE) - 1) { /* Don't count trailing NULL */
        g_error("Size of contents is %d instead of %d", (int)length, (int)sizeof(TEST_SIGNATURE) - 1);
        return;
    }
    if (memcmp(contents, TEST_SIGNATURE, length) != 0) {
        g_error("Contents is '%s' instead of '%s'", contents, TEST_SIGNATURE);
        return;
    }

    g_free(contents);

    /* Let's add some properties */
    const gchar * properties[5] = {
        "Foo", "Bar",
        "LongDataList", "A\n B\n C",
        NULL
    };

    whoopsie_report_recoverable_problem("test-signature", 0, TRUE, properties);

    g_file_get_contents("recoverable_mock.contents", &contents, &length, NULL);
    if (length != sizeof(TEST_DATALIST) - 1) { /* Don't count trailing NULL */
        g_error("Size of contents is %d instead of %d", (int)length, (int)sizeof(TEST_DATALIST) - 1);
        return;
    }
    if (memcmp(contents, TEST_DATALIST, length) != 0) {
        g_error("Contents is '%s' instead of '%s'", contents, TEST_DATALIST);
        return;
    }

    g_free(contents);
    
    /* Set a PID */
    whoopsie_report_recoverable_problem("test-signature", 1234, TRUE, NULL);

    g_file_get_contents("recoverable_mock.cmdline", &contents, &length, NULL);
    if (g_strcmp0(contents, "-p 1234") != 0) {
        g_error("Contents is '%s' instead of '%s'", contents, "-p 1234");
        return;
    }

    g_free(contents);

    /* Don't wait */
    /* We can't reliably test to see if we can't wait, so this is
       here to ensure mostly that we don't crash */
    whoopsie_report_recoverable_problem("test-signature", 0, FALSE, NULL);
}

int
main (int argc, char** argv)
{
#if GLIB_MAJOR_VERSION <= 2 && GLIB_MINOR_VERSION < 35
    /* Deprecated in glib 2.35/2.36. */
    g_type_init ();
#endif
    g_test_init (&argc, &argv, NULL);

    g_setenv("WHOOPSIE_RECOVERABLE_PROBLEM_PATH", "./recoverable_mock.sh", TRUE);

    g_test_add_func ("/whoopsie/recoverbale-error",
                     test_recoverable);
    return g_test_run ();
}
