/*
 * Copyright 2008 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.user.client.ui;

/**
 * A widget that implements this interface can receive keyboard focus.
 */
public interface Focusable {

  /**
   * Gets the widget's position in the tab index.
   * 
   * @return the widget's tab index
   */
  int getTabIndex();

  /**
   * Sets the widget's 'access key'. This key is used (in conjunction with a
   * browser-specific modifier key) to automatically focus the widget.
   * 
   * @param key the widget's access key
   */
  void setAccessKey(char key);

  /**
   * Explicitly focus/unfocus this widget. Only one widget can have focus at a
   * time, and the widget that does will receive all keyboard events.
   * 
   * NOTE: Most browsers fire FocusEvents asynchronously. Especially within GWT tests, you'll
   * need to make your test asynchronous to properly do verifications. See
   * {@code GWTTestCase#delayTestFinish} for more information on how to do this.
   * 
   * @param focused whether this widget should take focus or release it
   */
  void setFocus(boolean focused);

  /**
   * Sets the widget's position in the tab index. If more than one widget has
   * the same tab index, each such widget will receive focus in an arbitrary
   * order. Setting the tab index to <code>-1</code> will cause this widget to
   * be removed from the tab order.
   * 
   * @param index the widget's tab index
   */
  void setTabIndex(int index);
}
