/*
 * Decompiled with CFR 0.152.
 */
package nicknack;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.lib.MultipleTextOutputFormat;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCSVOutputFormat
extends MultipleTextOutputFormat<Text, Text> {
    private static final CsvPreference STANDARD_SURROUNDING_SPACES_NEED_QUOTES = new CsvPreference.Builder('\"', 44, "").surroundingSpacesNeedQuotes(true).build();

    protected String generateFileNameForKeyValue(Text key, Text value, String name) {
        List<String> columns;
        CsvListReader reader = new CsvListReader(new StringReader(key.toString()), STANDARD_SURROUNDING_SPACES_NEED_QUOTES);
        try {
            columns = reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (columns.size() == 1) {
            return name;
        }
        String first = columns.get(0);
        return new Path(first, name).toString();
    }

    protected Text generateActualKey(Text key, Text value) {
        CsvListReader reader = new CsvListReader(new StringReader(key.toString()), STANDARD_SURROUNDING_SPACES_NEED_QUOTES);
        try {
            List<String> columns = reader.read();
            if (columns.size() == 1) {
                return key;
            }
            StringWriter stringWriter = new StringWriter();
            CsvListWriter writer = new CsvListWriter(stringWriter, STANDARD_SURROUNDING_SPACES_NEED_QUOTES);
            writer.write(columns.subList(1, columns.size()));
            writer.flush();
            String csvData = stringWriter.toString();
            return new Text(csvData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

