/**
 * Update Command
 *
 * Refreshes OpenSpec skills and commands for configured tools.
 * Supports smart update detection to skip updates when already current.
 */
/**
 * Options for the update command.
 */
export interface UpdateCommandOptions {
    /** Force update even when tools are up to date */
    force?: boolean;
}
export declare class UpdateCommand {
    private readonly force;
    constructor(options?: UpdateCommandOptions);
    execute(projectPath: string): Promise<void>;
    /**
     * Display message when all tools are up to date.
     */
    private displayUpToDateMessage;
    /**
     * Display the update plan showing which tools need updating.
     */
    private displayUpdatePlan;
    /**
     * Detect and handle legacy OpenSpec artifacts.
     * Unlike init, update warns but continues if legacy files found in non-interactive mode.
     * Returns array of tool IDs that were newly configured during legacy upgrade.
     */
    private handleLegacyCleanup;
    /**
     * Perform cleanup of legacy artifacts.
     */
    private performLegacyCleanup;
    /**
     * Upgrade legacy tools to new skills system.
     * Returns array of tool IDs that were newly configured.
     */
    private upgradeLegacyTools;
}
//# sourceMappingURL=update.d.ts.map