/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class ArtifactDescriptorException
extends RepositoryException {
    private final transient ArtifactDescriptorResult result;

    public ArtifactDescriptorException(ArtifactDescriptorResult result) {
        super("Failed to read artifact descriptor" + (result != null ? " for " + result.getRequest().getArtifact() : ""), ArtifactDescriptorException.getFirstCause(result));
        if (result != null) {
            result.getExceptions().forEach(this::addSuppressed);
        }
        this.result = result;
    }

    public ArtifactDescriptorException(ArtifactDescriptorResult result, String message) {
        super(message, ArtifactDescriptorException.getFirstCause(result));
        if (result != null) {
            result.getExceptions().forEach(this::addSuppressed);
        }
        this.result = result;
    }

    public ArtifactDescriptorException(ArtifactDescriptorResult result, String message, Throwable cause) {
        super(message, cause);
        if (result != null) {
            result.getExceptions().forEach(this::addSuppressed);
        }
        this.result = result;
    }

    public ArtifactDescriptorResult getResult() {
        return this.result;
    }

    private static Throwable getFirstCause(ArtifactDescriptorResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }
}

