/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/css/names.py"!
 * Do not change this file!
 */


#ifndef LXB_CSS_PROPERTY_CONST_H
#define LXB_CSS_PROPERTY_CONST_H


#include "lexbor/css/value/const.h"


enum {
    LXB_CSS_PROPERTY__UNDEF                = 0x0000,
    LXB_CSS_PROPERTY__CUSTOM               = 0x0001,
    LXB_CSS_PROPERTY_ALIGN_CONTENT         = 0x0002,
    LXB_CSS_PROPERTY_ALIGN_ITEMS           = 0x0003,
    LXB_CSS_PROPERTY_ALIGN_SELF            = 0x0004,
    LXB_CSS_PROPERTY_ALIGNMENT_BASELINE    = 0x0005,
    LXB_CSS_PROPERTY_BACKGROUND_COLOR      = 0x0006,
    LXB_CSS_PROPERTY_BASELINE_SHIFT        = 0x0007,
    LXB_CSS_PROPERTY_BASELINE_SOURCE       = 0x0008,
    LXB_CSS_PROPERTY_BORDER                = 0x0009,
    LXB_CSS_PROPERTY_BORDER_BOTTOM         = 0x000a,
    LXB_CSS_PROPERTY_BORDER_BOTTOM_COLOR   = 0x000b,
    LXB_CSS_PROPERTY_BORDER_LEFT           = 0x000c,
    LXB_CSS_PROPERTY_BORDER_LEFT_COLOR     = 0x000d,
    LXB_CSS_PROPERTY_BORDER_RIGHT          = 0x000e,
    LXB_CSS_PROPERTY_BORDER_RIGHT_COLOR    = 0x000f,
    LXB_CSS_PROPERTY_BORDER_TOP            = 0x0010,
    LXB_CSS_PROPERTY_BORDER_TOP_COLOR      = 0x0011,
    LXB_CSS_PROPERTY_BOTTOM                = 0x0012,
    LXB_CSS_PROPERTY_BOX_SIZING            = 0x0013,
    LXB_CSS_PROPERTY_CLEAR                 = 0x0014,
    LXB_CSS_PROPERTY_COLOR                 = 0x0015,
    LXB_CSS_PROPERTY_DIRECTION             = 0x0016,
    LXB_CSS_PROPERTY_DISPLAY               = 0x0017,
    LXB_CSS_PROPERTY_DOMINANT_BASELINE     = 0x0018,
    LXB_CSS_PROPERTY_FLEX                  = 0x0019,
    LXB_CSS_PROPERTY_FLEX_BASIS            = 0x001a,
    LXB_CSS_PROPERTY_FLEX_DIRECTION        = 0x001b,
    LXB_CSS_PROPERTY_FLEX_FLOW             = 0x001c,
    LXB_CSS_PROPERTY_FLEX_GROW             = 0x001d,
    LXB_CSS_PROPERTY_FLEX_SHRINK           = 0x001e,
    LXB_CSS_PROPERTY_FLEX_WRAP             = 0x001f,
    LXB_CSS_PROPERTY_FLOAT                 = 0x0020,
    LXB_CSS_PROPERTY_FLOAT_DEFER           = 0x0021,
    LXB_CSS_PROPERTY_FLOAT_OFFSET          = 0x0022,
    LXB_CSS_PROPERTY_FLOAT_REFERENCE       = 0x0023,
    LXB_CSS_PROPERTY_FONT_FAMILY           = 0x0024,
    LXB_CSS_PROPERTY_FONT_SIZE             = 0x0025,
    LXB_CSS_PROPERTY_FONT_STRETCH          = 0x0026,
    LXB_CSS_PROPERTY_FONT_STYLE            = 0x0027,
    LXB_CSS_PROPERTY_FONT_WEIGHT           = 0x0028,
    LXB_CSS_PROPERTY_HANGING_PUNCTUATION   = 0x0029,
    LXB_CSS_PROPERTY_HEIGHT                = 0x002a,
    LXB_CSS_PROPERTY_HYPHENS               = 0x002b,
    LXB_CSS_PROPERTY_INSET_BLOCK_END       = 0x002c,
    LXB_CSS_PROPERTY_INSET_BLOCK_START     = 0x002d,
    LXB_CSS_PROPERTY_INSET_INLINE_END      = 0x002e,
    LXB_CSS_PROPERTY_INSET_INLINE_START    = 0x002f,
    LXB_CSS_PROPERTY_JUSTIFY_CONTENT       = 0x0030,
    LXB_CSS_PROPERTY_LEFT                  = 0x0031,
    LXB_CSS_PROPERTY_LETTER_SPACING        = 0x0032,
    LXB_CSS_PROPERTY_LINE_BREAK            = 0x0033,
    LXB_CSS_PROPERTY_LINE_HEIGHT           = 0x0034,
    LXB_CSS_PROPERTY_MARGIN                = 0x0035,
    LXB_CSS_PROPERTY_MARGIN_BOTTOM         = 0x0036,
    LXB_CSS_PROPERTY_MARGIN_LEFT           = 0x0037,
    LXB_CSS_PROPERTY_MARGIN_RIGHT          = 0x0038,
    LXB_CSS_PROPERTY_MARGIN_TOP            = 0x0039,
    LXB_CSS_PROPERTY_MAX_HEIGHT            = 0x003a,
    LXB_CSS_PROPERTY_MAX_WIDTH             = 0x003b,
    LXB_CSS_PROPERTY_MIN_HEIGHT            = 0x003c,
    LXB_CSS_PROPERTY_MIN_WIDTH             = 0x003d,
    LXB_CSS_PROPERTY_OPACITY               = 0x003e,
    LXB_CSS_PROPERTY_ORDER                 = 0x003f,
    LXB_CSS_PROPERTY_OVERFLOW_BLOCK        = 0x0040,
    LXB_CSS_PROPERTY_OVERFLOW_INLINE       = 0x0041,
    LXB_CSS_PROPERTY_OVERFLOW_WRAP         = 0x0042,
    LXB_CSS_PROPERTY_OVERFLOW_X            = 0x0043,
    LXB_CSS_PROPERTY_OVERFLOW_Y            = 0x0044,
    LXB_CSS_PROPERTY_PADDING               = 0x0045,
    LXB_CSS_PROPERTY_PADDING_BOTTOM        = 0x0046,
    LXB_CSS_PROPERTY_PADDING_LEFT          = 0x0047,
    LXB_CSS_PROPERTY_PADDING_RIGHT         = 0x0048,
    LXB_CSS_PROPERTY_PADDING_TOP           = 0x0049,
    LXB_CSS_PROPERTY_POSITION              = 0x004a,
    LXB_CSS_PROPERTY_RIGHT                 = 0x004b,
    LXB_CSS_PROPERTY_TAB_SIZE              = 0x004c,
    LXB_CSS_PROPERTY_TEXT_ALIGN            = 0x004d,
    LXB_CSS_PROPERTY_TEXT_ALIGN_ALL        = 0x004e,
    LXB_CSS_PROPERTY_TEXT_ALIGN_LAST       = 0x004f,
    LXB_CSS_PROPERTY_TEXT_COMBINE_UPRIGHT  = 0x0050,
    LXB_CSS_PROPERTY_TEXT_DECORATION       = 0x0051,
    LXB_CSS_PROPERTY_TEXT_DECORATION_COLOR = 0x0052,
    LXB_CSS_PROPERTY_TEXT_DECORATION_LINE  = 0x0053,
    LXB_CSS_PROPERTY_TEXT_DECORATION_STYLE = 0x0054,
    LXB_CSS_PROPERTY_TEXT_INDENT           = 0x0055,
    LXB_CSS_PROPERTY_TEXT_JUSTIFY          = 0x0056,
    LXB_CSS_PROPERTY_TEXT_ORIENTATION      = 0x0057,
    LXB_CSS_PROPERTY_TEXT_OVERFLOW         = 0x0058,
    LXB_CSS_PROPERTY_TEXT_TRANSFORM        = 0x0059,
    LXB_CSS_PROPERTY_TOP                   = 0x005a,
    LXB_CSS_PROPERTY_UNICODE_BIDI          = 0x005b,
    LXB_CSS_PROPERTY_VERTICAL_ALIGN        = 0x005c,
    LXB_CSS_PROPERTY_VISIBILITY            = 0x005d,
    LXB_CSS_PROPERTY_WHITE_SPACE           = 0x005e,
    LXB_CSS_PROPERTY_WIDTH                 = 0x005f,
    LXB_CSS_PROPERTY_WORD_BREAK            = 0x0060,
    LXB_CSS_PROPERTY_WORD_SPACING          = 0x0061,
    LXB_CSS_PROPERTY_WORD_WRAP             = 0x0062,
    LXB_CSS_PROPERTY_WRAP_FLOW             = 0x0063,
    LXB_CSS_PROPERTY_WRAP_THROUGH          = 0x0064,
    LXB_CSS_PROPERTY_WRITING_MODE          = 0x0065,
    LXB_CSS_PROPERTY_Z_INDEX               = 0x0066,
    LXB_CSS_PROPERTY__LAST_ENTRY           = 0x0067
};
typedef uintptr_t lxb_css_property_type_t;

enum {
    LXB_CSS_ALIGN_CONTENT_FLEX_START    = LXB_CSS_VALUE_FLEX_START,
    LXB_CSS_ALIGN_CONTENT_FLEX_END      = LXB_CSS_VALUE_FLEX_END,
    LXB_CSS_ALIGN_CONTENT_CENTER        = LXB_CSS_VALUE_CENTER,
    LXB_CSS_ALIGN_CONTENT_SPACE_BETWEEN = LXB_CSS_VALUE_SPACE_BETWEEN,
    LXB_CSS_ALIGN_CONTENT_SPACE_AROUND  = LXB_CSS_VALUE_SPACE_AROUND,
    LXB_CSS_ALIGN_CONTENT_STRETCH       = LXB_CSS_VALUE_STRETCH
};
typedef unsigned int lxb_css_align_content_type_t;

enum {
    LXB_CSS_ALIGN_ITEMS_FLEX_START = LXB_CSS_VALUE_FLEX_START,
    LXB_CSS_ALIGN_ITEMS_FLEX_END   = LXB_CSS_VALUE_FLEX_END,
    LXB_CSS_ALIGN_ITEMS_CENTER     = LXB_CSS_VALUE_CENTER,
    LXB_CSS_ALIGN_ITEMS_BASELINE   = LXB_CSS_VALUE_BASELINE,
    LXB_CSS_ALIGN_ITEMS_STRETCH    = LXB_CSS_VALUE_STRETCH
};
typedef unsigned int lxb_css_align_items_type_t;

enum {
    LXB_CSS_ALIGN_SELF_AUTO       = LXB_CSS_VALUE_AUTO,
    LXB_CSS_ALIGN_SELF_FLEX_START = LXB_CSS_VALUE_FLEX_START,
    LXB_CSS_ALIGN_SELF_FLEX_END   = LXB_CSS_VALUE_FLEX_END,
    LXB_CSS_ALIGN_SELF_CENTER     = LXB_CSS_VALUE_CENTER,
    LXB_CSS_ALIGN_SELF_BASELINE   = LXB_CSS_VALUE_BASELINE,
    LXB_CSS_ALIGN_SELF_STRETCH    = LXB_CSS_VALUE_STRETCH
};
typedef unsigned int lxb_css_align_self_type_t;

enum {
    LXB_CSS_ALIGNMENT_BASELINE_BASELINE     = LXB_CSS_VALUE_BASELINE,
    LXB_CSS_ALIGNMENT_BASELINE_TEXT_BOTTOM  = LXB_CSS_VALUE_TEXT_BOTTOM,
    LXB_CSS_ALIGNMENT_BASELINE_ALPHABETIC   = LXB_CSS_VALUE_ALPHABETIC,
    LXB_CSS_ALIGNMENT_BASELINE_IDEOGRAPHIC  = LXB_CSS_VALUE_IDEOGRAPHIC,
    LXB_CSS_ALIGNMENT_BASELINE_MIDDLE       = LXB_CSS_VALUE_MIDDLE,
    LXB_CSS_ALIGNMENT_BASELINE_CENTRAL      = LXB_CSS_VALUE_CENTRAL,
    LXB_CSS_ALIGNMENT_BASELINE_MATHEMATICAL = LXB_CSS_VALUE_MATHEMATICAL,
    LXB_CSS_ALIGNMENT_BASELINE_TEXT_TOP     = LXB_CSS_VALUE_TEXT_TOP
};
typedef unsigned int lxb_css_alignment_baseline_type_t;



enum {
    LXB_CSS_BASELINE_SHIFT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_BASELINE_SHIFT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_BASELINE_SHIFT_SUB         = LXB_CSS_VALUE_SUB,
    LXB_CSS_BASELINE_SHIFT_SUPER       = LXB_CSS_VALUE_SUPER,
    LXB_CSS_BASELINE_SHIFT_TOP         = LXB_CSS_VALUE_TOP,
    LXB_CSS_BASELINE_SHIFT_CENTER      = LXB_CSS_VALUE_CENTER,
    LXB_CSS_BASELINE_SHIFT_BOTTOM      = LXB_CSS_VALUE_BOTTOM
};
typedef unsigned int lxb_css_baseline_shift_type_t;

enum {
    LXB_CSS_BASELINE_SOURCE_AUTO  = LXB_CSS_VALUE_AUTO,
    LXB_CSS_BASELINE_SOURCE_FIRST = LXB_CSS_VALUE_FIRST,
    LXB_CSS_BASELINE_SOURCE_LAST  = LXB_CSS_VALUE_LAST
};
typedef unsigned int lxb_css_baseline_source_type_t;

enum {
    LXB_CSS_BORDER_THIN    = LXB_CSS_VALUE_THIN,
    LXB_CSS_BORDER_MEDIUM  = LXB_CSS_VALUE_MEDIUM,
    LXB_CSS_BORDER_THICK   = LXB_CSS_VALUE_THICK,
    LXB_CSS_BORDER_NONE    = LXB_CSS_VALUE_NONE,
    LXB_CSS_BORDER_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_BORDER_DOTTED  = LXB_CSS_VALUE_DOTTED,
    LXB_CSS_BORDER_DASHED  = LXB_CSS_VALUE_DASHED,
    LXB_CSS_BORDER_SOLID   = LXB_CSS_VALUE_SOLID,
    LXB_CSS_BORDER_DOUBLE  = LXB_CSS_VALUE_DOUBLE,
    LXB_CSS_BORDER_GROOVE  = LXB_CSS_VALUE_GROOVE,
    LXB_CSS_BORDER_RIDGE   = LXB_CSS_VALUE_RIDGE,
    LXB_CSS_BORDER_INSET   = LXB_CSS_VALUE_INSET,
    LXB_CSS_BORDER_OUTSET  = LXB_CSS_VALUE_OUTSET,
    LXB_CSS_BORDER__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_border_type_t;

enum {
    LXB_CSS_BORDER_BOTTOM_THIN    = LXB_CSS_VALUE_THIN,
    LXB_CSS_BORDER_BOTTOM_MEDIUM  = LXB_CSS_VALUE_MEDIUM,
    LXB_CSS_BORDER_BOTTOM_THICK   = LXB_CSS_VALUE_THICK,
    LXB_CSS_BORDER_BOTTOM_NONE    = LXB_CSS_VALUE_NONE,
    LXB_CSS_BORDER_BOTTOM_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_BORDER_BOTTOM_DOTTED  = LXB_CSS_VALUE_DOTTED,
    LXB_CSS_BORDER_BOTTOM_DASHED  = LXB_CSS_VALUE_DASHED,
    LXB_CSS_BORDER_BOTTOM_SOLID   = LXB_CSS_VALUE_SOLID,
    LXB_CSS_BORDER_BOTTOM_DOUBLE  = LXB_CSS_VALUE_DOUBLE,
    LXB_CSS_BORDER_BOTTOM_GROOVE  = LXB_CSS_VALUE_GROOVE,
    LXB_CSS_BORDER_BOTTOM_RIDGE   = LXB_CSS_VALUE_RIDGE,
    LXB_CSS_BORDER_BOTTOM_INSET   = LXB_CSS_VALUE_INSET,
    LXB_CSS_BORDER_BOTTOM_OUTSET  = LXB_CSS_VALUE_OUTSET,
    LXB_CSS_BORDER_BOTTOM__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_border_bottom_type_t;



enum {
    LXB_CSS_BORDER_LEFT_THIN    = LXB_CSS_VALUE_THIN,
    LXB_CSS_BORDER_LEFT_MEDIUM  = LXB_CSS_VALUE_MEDIUM,
    LXB_CSS_BORDER_LEFT_THICK   = LXB_CSS_VALUE_THICK,
    LXB_CSS_BORDER_LEFT_NONE    = LXB_CSS_VALUE_NONE,
    LXB_CSS_BORDER_LEFT_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_BORDER_LEFT_DOTTED  = LXB_CSS_VALUE_DOTTED,
    LXB_CSS_BORDER_LEFT_DASHED  = LXB_CSS_VALUE_DASHED,
    LXB_CSS_BORDER_LEFT_SOLID   = LXB_CSS_VALUE_SOLID,
    LXB_CSS_BORDER_LEFT_DOUBLE  = LXB_CSS_VALUE_DOUBLE,
    LXB_CSS_BORDER_LEFT_GROOVE  = LXB_CSS_VALUE_GROOVE,
    LXB_CSS_BORDER_LEFT_RIDGE   = LXB_CSS_VALUE_RIDGE,
    LXB_CSS_BORDER_LEFT_INSET   = LXB_CSS_VALUE_INSET,
    LXB_CSS_BORDER_LEFT_OUTSET  = LXB_CSS_VALUE_OUTSET,
    LXB_CSS_BORDER_LEFT__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_border_left_type_t;



enum {
    LXB_CSS_BORDER_RIGHT_THIN    = LXB_CSS_VALUE_THIN,
    LXB_CSS_BORDER_RIGHT_MEDIUM  = LXB_CSS_VALUE_MEDIUM,
    LXB_CSS_BORDER_RIGHT_THICK   = LXB_CSS_VALUE_THICK,
    LXB_CSS_BORDER_RIGHT_NONE    = LXB_CSS_VALUE_NONE,
    LXB_CSS_BORDER_RIGHT_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_BORDER_RIGHT_DOTTED  = LXB_CSS_VALUE_DOTTED,
    LXB_CSS_BORDER_RIGHT_DASHED  = LXB_CSS_VALUE_DASHED,
    LXB_CSS_BORDER_RIGHT_SOLID   = LXB_CSS_VALUE_SOLID,
    LXB_CSS_BORDER_RIGHT_DOUBLE  = LXB_CSS_VALUE_DOUBLE,
    LXB_CSS_BORDER_RIGHT_GROOVE  = LXB_CSS_VALUE_GROOVE,
    LXB_CSS_BORDER_RIGHT_RIDGE   = LXB_CSS_VALUE_RIDGE,
    LXB_CSS_BORDER_RIGHT_INSET   = LXB_CSS_VALUE_INSET,
    LXB_CSS_BORDER_RIGHT_OUTSET  = LXB_CSS_VALUE_OUTSET,
    LXB_CSS_BORDER_RIGHT__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_border_right_type_t;



enum {
    LXB_CSS_BORDER_TOP_THIN    = LXB_CSS_VALUE_THIN,
    LXB_CSS_BORDER_TOP_MEDIUM  = LXB_CSS_VALUE_MEDIUM,
    LXB_CSS_BORDER_TOP_THICK   = LXB_CSS_VALUE_THICK,
    LXB_CSS_BORDER_TOP_NONE    = LXB_CSS_VALUE_NONE,
    LXB_CSS_BORDER_TOP_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_BORDER_TOP_DOTTED  = LXB_CSS_VALUE_DOTTED,
    LXB_CSS_BORDER_TOP_DASHED  = LXB_CSS_VALUE_DASHED,
    LXB_CSS_BORDER_TOP_SOLID   = LXB_CSS_VALUE_SOLID,
    LXB_CSS_BORDER_TOP_DOUBLE  = LXB_CSS_VALUE_DOUBLE,
    LXB_CSS_BORDER_TOP_GROOVE  = LXB_CSS_VALUE_GROOVE,
    LXB_CSS_BORDER_TOP_RIDGE   = LXB_CSS_VALUE_RIDGE,
    LXB_CSS_BORDER_TOP_INSET   = LXB_CSS_VALUE_INSET,
    LXB_CSS_BORDER_TOP_OUTSET  = LXB_CSS_VALUE_OUTSET,
    LXB_CSS_BORDER_TOP__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_border_top_type_t;



enum {
    LXB_CSS_BOTTOM_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_BOTTOM__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_BOTTOM__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_bottom_type_t;

enum {
    LXB_CSS_BOX_SIZING_CONTENT_BOX = LXB_CSS_VALUE_CONTENT_BOX,
    LXB_CSS_BOX_SIZING_BORDER_BOX  = LXB_CSS_VALUE_BORDER_BOX
};
typedef unsigned int lxb_css_box_sizing_type_t;

enum {
    LXB_CSS_CLEAR_INLINE_START = LXB_CSS_VALUE_INLINE_START,
    LXB_CSS_CLEAR_INLINE_END   = LXB_CSS_VALUE_INLINE_END,
    LXB_CSS_CLEAR_BLOCK_START  = LXB_CSS_VALUE_BLOCK_START,
    LXB_CSS_CLEAR_BLOCK_END    = LXB_CSS_VALUE_BLOCK_END,
    LXB_CSS_CLEAR_LEFT         = LXB_CSS_VALUE_LEFT,
    LXB_CSS_CLEAR_RIGHT        = LXB_CSS_VALUE_RIGHT,
    LXB_CSS_CLEAR_TOP          = LXB_CSS_VALUE_TOP,
    LXB_CSS_CLEAR_BOTTOM       = LXB_CSS_VALUE_BOTTOM,
    LXB_CSS_CLEAR_NONE         = LXB_CSS_VALUE_NONE
};
typedef unsigned int lxb_css_clear_type_t;

enum {
    LXB_CSS_COLOR_CURRENTCOLOR         = LXB_CSS_VALUE_CURRENTCOLOR,
    LXB_CSS_COLOR_TRANSPARENT          = LXB_CSS_VALUE_TRANSPARENT,
    LXB_CSS_COLOR_HEX                  = LXB_CSS_VALUE_HEX,
    LXB_CSS_COLOR_ALICEBLUE            = LXB_CSS_VALUE_ALICEBLUE,
    LXB_CSS_COLOR_ANTIQUEWHITE         = LXB_CSS_VALUE_ANTIQUEWHITE,
    LXB_CSS_COLOR_AQUA                 = LXB_CSS_VALUE_AQUA,
    LXB_CSS_COLOR_AQUAMARINE           = LXB_CSS_VALUE_AQUAMARINE,
    LXB_CSS_COLOR_AZURE                = LXB_CSS_VALUE_AZURE,
    LXB_CSS_COLOR_BEIGE                = LXB_CSS_VALUE_BEIGE,
    LXB_CSS_COLOR_BISQUE               = LXB_CSS_VALUE_BISQUE,
    LXB_CSS_COLOR_BLACK                = LXB_CSS_VALUE_BLACK,
    LXB_CSS_COLOR_BLANCHEDALMOND       = LXB_CSS_VALUE_BLANCHEDALMOND,
    LXB_CSS_COLOR_BLUE                 = LXB_CSS_VALUE_BLUE,
    LXB_CSS_COLOR_BLUEVIOLET           = LXB_CSS_VALUE_BLUEVIOLET,
    LXB_CSS_COLOR_BROWN                = LXB_CSS_VALUE_BROWN,
    LXB_CSS_COLOR_BURLYWOOD            = LXB_CSS_VALUE_BURLYWOOD,
    LXB_CSS_COLOR_CADETBLUE            = LXB_CSS_VALUE_CADETBLUE,
    LXB_CSS_COLOR_CHARTREUSE           = LXB_CSS_VALUE_CHARTREUSE,
    LXB_CSS_COLOR_CHOCOLATE            = LXB_CSS_VALUE_CHOCOLATE,
    LXB_CSS_COLOR_CORAL                = LXB_CSS_VALUE_CORAL,
    LXB_CSS_COLOR_CORNFLOWERBLUE       = LXB_CSS_VALUE_CORNFLOWERBLUE,
    LXB_CSS_COLOR_CORNSILK             = LXB_CSS_VALUE_CORNSILK,
    LXB_CSS_COLOR_CRIMSON              = LXB_CSS_VALUE_CRIMSON,
    LXB_CSS_COLOR_CYAN                 = LXB_CSS_VALUE_CYAN,
    LXB_CSS_COLOR_DARKBLUE             = LXB_CSS_VALUE_DARKBLUE,
    LXB_CSS_COLOR_DARKCYAN             = LXB_CSS_VALUE_DARKCYAN,
    LXB_CSS_COLOR_DARKGOLDENROD        = LXB_CSS_VALUE_DARKGOLDENROD,
    LXB_CSS_COLOR_DARKGRAY             = LXB_CSS_VALUE_DARKGRAY,
    LXB_CSS_COLOR_DARKGREEN            = LXB_CSS_VALUE_DARKGREEN,
    LXB_CSS_COLOR_DARKGREY             = LXB_CSS_VALUE_DARKGREY,
    LXB_CSS_COLOR_DARKKHAKI            = LXB_CSS_VALUE_DARKKHAKI,
    LXB_CSS_COLOR_DARKMAGENTA          = LXB_CSS_VALUE_DARKMAGENTA,
    LXB_CSS_COLOR_DARKOLIVEGREEN       = LXB_CSS_VALUE_DARKOLIVEGREEN,
    LXB_CSS_COLOR_DARKORANGE           = LXB_CSS_VALUE_DARKORANGE,
    LXB_CSS_COLOR_DARKORCHID           = LXB_CSS_VALUE_DARKORCHID,
    LXB_CSS_COLOR_DARKRED              = LXB_CSS_VALUE_DARKRED,
    LXB_CSS_COLOR_DARKSALMON           = LXB_CSS_VALUE_DARKSALMON,
    LXB_CSS_COLOR_DARKSEAGREEN         = LXB_CSS_VALUE_DARKSEAGREEN,
    LXB_CSS_COLOR_DARKSLATEBLUE        = LXB_CSS_VALUE_DARKSLATEBLUE,
    LXB_CSS_COLOR_DARKSLATEGRAY        = LXB_CSS_VALUE_DARKSLATEGRAY,
    LXB_CSS_COLOR_DARKSLATEGREY        = LXB_CSS_VALUE_DARKSLATEGREY,
    LXB_CSS_COLOR_DARKTURQUOISE        = LXB_CSS_VALUE_DARKTURQUOISE,
    LXB_CSS_COLOR_DARKVIOLET           = LXB_CSS_VALUE_DARKVIOLET,
    LXB_CSS_COLOR_DEEPPINK             = LXB_CSS_VALUE_DEEPPINK,
    LXB_CSS_COLOR_DEEPSKYBLUE          = LXB_CSS_VALUE_DEEPSKYBLUE,
    LXB_CSS_COLOR_DIMGRAY              = LXB_CSS_VALUE_DIMGRAY,
    LXB_CSS_COLOR_DIMGREY              = LXB_CSS_VALUE_DIMGREY,
    LXB_CSS_COLOR_DODGERBLUE           = LXB_CSS_VALUE_DODGERBLUE,
    LXB_CSS_COLOR_FIREBRICK            = LXB_CSS_VALUE_FIREBRICK,
    LXB_CSS_COLOR_FLORALWHITE          = LXB_CSS_VALUE_FLORALWHITE,
    LXB_CSS_COLOR_FORESTGREEN          = LXB_CSS_VALUE_FORESTGREEN,
    LXB_CSS_COLOR_FUCHSIA              = LXB_CSS_VALUE_FUCHSIA,
    LXB_CSS_COLOR_GAINSBORO            = LXB_CSS_VALUE_GAINSBORO,
    LXB_CSS_COLOR_GHOSTWHITE           = LXB_CSS_VALUE_GHOSTWHITE,
    LXB_CSS_COLOR_GOLD                 = LXB_CSS_VALUE_GOLD,
    LXB_CSS_COLOR_GOLDENROD            = LXB_CSS_VALUE_GOLDENROD,
    LXB_CSS_COLOR_GRAY                 = LXB_CSS_VALUE_GRAY,
    LXB_CSS_COLOR_GREEN                = LXB_CSS_VALUE_GREEN,
    LXB_CSS_COLOR_GREENYELLOW          = LXB_CSS_VALUE_GREENYELLOW,
    LXB_CSS_COLOR_GREY                 = LXB_CSS_VALUE_GREY,
    LXB_CSS_COLOR_HONEYDEW             = LXB_CSS_VALUE_HONEYDEW,
    LXB_CSS_COLOR_HOTPINK              = LXB_CSS_VALUE_HOTPINK,
    LXB_CSS_COLOR_INDIANRED            = LXB_CSS_VALUE_INDIANRED,
    LXB_CSS_COLOR_INDIGO               = LXB_CSS_VALUE_INDIGO,
    LXB_CSS_COLOR_IVORY                = LXB_CSS_VALUE_IVORY,
    LXB_CSS_COLOR_KHAKI                = LXB_CSS_VALUE_KHAKI,
    LXB_CSS_COLOR_LAVENDER             = LXB_CSS_VALUE_LAVENDER,
    LXB_CSS_COLOR_LAVENDERBLUSH        = LXB_CSS_VALUE_LAVENDERBLUSH,
    LXB_CSS_COLOR_LAWNGREEN            = LXB_CSS_VALUE_LAWNGREEN,
    LXB_CSS_COLOR_LEMONCHIFFON         = LXB_CSS_VALUE_LEMONCHIFFON,
    LXB_CSS_COLOR_LIGHTBLUE            = LXB_CSS_VALUE_LIGHTBLUE,
    LXB_CSS_COLOR_LIGHTCORAL           = LXB_CSS_VALUE_LIGHTCORAL,
    LXB_CSS_COLOR_LIGHTCYAN            = LXB_CSS_VALUE_LIGHTCYAN,
    LXB_CSS_COLOR_LIGHTGOLDENRODYELLOW = LXB_CSS_VALUE_LIGHTGOLDENRODYELLOW,
    LXB_CSS_COLOR_LIGHTGRAY            = LXB_CSS_VALUE_LIGHTGRAY,
    LXB_CSS_COLOR_LIGHTGREEN           = LXB_CSS_VALUE_LIGHTGREEN,
    LXB_CSS_COLOR_LIGHTGREY            = LXB_CSS_VALUE_LIGHTGREY,
    LXB_CSS_COLOR_LIGHTPINK            = LXB_CSS_VALUE_LIGHTPINK,
    LXB_CSS_COLOR_LIGHTSALMON          = LXB_CSS_VALUE_LIGHTSALMON,
    LXB_CSS_COLOR_LIGHTSEAGREEN        = LXB_CSS_VALUE_LIGHTSEAGREEN,
    LXB_CSS_COLOR_LIGHTSKYBLUE         = LXB_CSS_VALUE_LIGHTSKYBLUE,
    LXB_CSS_COLOR_LIGHTSLATEGRAY       = LXB_CSS_VALUE_LIGHTSLATEGRAY,
    LXB_CSS_COLOR_LIGHTSLATEGREY       = LXB_CSS_VALUE_LIGHTSLATEGREY,
    LXB_CSS_COLOR_LIGHTSTEELBLUE       = LXB_CSS_VALUE_LIGHTSTEELBLUE,
    LXB_CSS_COLOR_LIGHTYELLOW          = LXB_CSS_VALUE_LIGHTYELLOW,
    LXB_CSS_COLOR_LIME                 = LXB_CSS_VALUE_LIME,
    LXB_CSS_COLOR_LIMEGREEN            = LXB_CSS_VALUE_LIMEGREEN,
    LXB_CSS_COLOR_LINEN                = LXB_CSS_VALUE_LINEN,
    LXB_CSS_COLOR_MAGENTA              = LXB_CSS_VALUE_MAGENTA,
    LXB_CSS_COLOR_MAROON               = LXB_CSS_VALUE_MAROON,
    LXB_CSS_COLOR_MEDIUMAQUAMARINE     = LXB_CSS_VALUE_MEDIUMAQUAMARINE,
    LXB_CSS_COLOR_MEDIUMBLUE           = LXB_CSS_VALUE_MEDIUMBLUE,
    LXB_CSS_COLOR_MEDIUMORCHID         = LXB_CSS_VALUE_MEDIUMORCHID,
    LXB_CSS_COLOR_MEDIUMPURPLE         = LXB_CSS_VALUE_MEDIUMPURPLE,
    LXB_CSS_COLOR_MEDIUMSEAGREEN       = LXB_CSS_VALUE_MEDIUMSEAGREEN,
    LXB_CSS_COLOR_MEDIUMSLATEBLUE      = LXB_CSS_VALUE_MEDIUMSLATEBLUE,
    LXB_CSS_COLOR_MEDIUMSPRINGGREEN    = LXB_CSS_VALUE_MEDIUMSPRINGGREEN,
    LXB_CSS_COLOR_MEDIUMTURQUOISE      = LXB_CSS_VALUE_MEDIUMTURQUOISE,
    LXB_CSS_COLOR_MEDIUMVIOLETRED      = LXB_CSS_VALUE_MEDIUMVIOLETRED,
    LXB_CSS_COLOR_MIDNIGHTBLUE         = LXB_CSS_VALUE_MIDNIGHTBLUE,
    LXB_CSS_COLOR_MINTCREAM            = LXB_CSS_VALUE_MINTCREAM,
    LXB_CSS_COLOR_MISTYROSE            = LXB_CSS_VALUE_MISTYROSE,
    LXB_CSS_COLOR_MOCCASIN             = LXB_CSS_VALUE_MOCCASIN,
    LXB_CSS_COLOR_NAVAJOWHITE          = LXB_CSS_VALUE_NAVAJOWHITE,
    LXB_CSS_COLOR_NAVY                 = LXB_CSS_VALUE_NAVY,
    LXB_CSS_COLOR_OLDLACE              = LXB_CSS_VALUE_OLDLACE,
    LXB_CSS_COLOR_OLIVE                = LXB_CSS_VALUE_OLIVE,
    LXB_CSS_COLOR_OLIVEDRAB            = LXB_CSS_VALUE_OLIVEDRAB,
    LXB_CSS_COLOR_ORANGE               = LXB_CSS_VALUE_ORANGE,
    LXB_CSS_COLOR_ORANGERED            = LXB_CSS_VALUE_ORANGERED,
    LXB_CSS_COLOR_ORCHID               = LXB_CSS_VALUE_ORCHID,
    LXB_CSS_COLOR_PALEGOLDENROD        = LXB_CSS_VALUE_PALEGOLDENROD,
    LXB_CSS_COLOR_PALEGREEN            = LXB_CSS_VALUE_PALEGREEN,
    LXB_CSS_COLOR_PALETURQUOISE        = LXB_CSS_VALUE_PALETURQUOISE,
    LXB_CSS_COLOR_PALEVIOLETRED        = LXB_CSS_VALUE_PALEVIOLETRED,
    LXB_CSS_COLOR_PAPAYAWHIP           = LXB_CSS_VALUE_PAPAYAWHIP,
    LXB_CSS_COLOR_PEACHPUFF            = LXB_CSS_VALUE_PEACHPUFF,
    LXB_CSS_COLOR_PERU                 = LXB_CSS_VALUE_PERU,
    LXB_CSS_COLOR_PINK                 = LXB_CSS_VALUE_PINK,
    LXB_CSS_COLOR_PLUM                 = LXB_CSS_VALUE_PLUM,
    LXB_CSS_COLOR_POWDERBLUE           = LXB_CSS_VALUE_POWDERBLUE,
    LXB_CSS_COLOR_PURPLE               = LXB_CSS_VALUE_PURPLE,
    LXB_CSS_COLOR_REBECCAPURPLE        = LXB_CSS_VALUE_REBECCAPURPLE,
    LXB_CSS_COLOR_RED                  = LXB_CSS_VALUE_RED,
    LXB_CSS_COLOR_ROSYBROWN            = LXB_CSS_VALUE_ROSYBROWN,
    LXB_CSS_COLOR_ROYALBLUE            = LXB_CSS_VALUE_ROYALBLUE,
    LXB_CSS_COLOR_SADDLEBROWN          = LXB_CSS_VALUE_SADDLEBROWN,
    LXB_CSS_COLOR_SALMON               = LXB_CSS_VALUE_SALMON,
    LXB_CSS_COLOR_SANDYBROWN           = LXB_CSS_VALUE_SANDYBROWN,
    LXB_CSS_COLOR_SEAGREEN             = LXB_CSS_VALUE_SEAGREEN,
    LXB_CSS_COLOR_SEASHELL             = LXB_CSS_VALUE_SEASHELL,
    LXB_CSS_COLOR_SIENNA               = LXB_CSS_VALUE_SIENNA,
    LXB_CSS_COLOR_SILVER               = LXB_CSS_VALUE_SILVER,
    LXB_CSS_COLOR_SKYBLUE              = LXB_CSS_VALUE_SKYBLUE,
    LXB_CSS_COLOR_SLATEBLUE            = LXB_CSS_VALUE_SLATEBLUE,
    LXB_CSS_COLOR_SLATEGRAY            = LXB_CSS_VALUE_SLATEGRAY,
    LXB_CSS_COLOR_SLATEGREY            = LXB_CSS_VALUE_SLATEGREY,
    LXB_CSS_COLOR_SNOW                 = LXB_CSS_VALUE_SNOW,
    LXB_CSS_COLOR_SPRINGGREEN          = LXB_CSS_VALUE_SPRINGGREEN,
    LXB_CSS_COLOR_STEELBLUE            = LXB_CSS_VALUE_STEELBLUE,
    LXB_CSS_COLOR_TAN                  = LXB_CSS_VALUE_TAN,
    LXB_CSS_COLOR_TEAL                 = LXB_CSS_VALUE_TEAL,
    LXB_CSS_COLOR_THISTLE              = LXB_CSS_VALUE_THISTLE,
    LXB_CSS_COLOR_TOMATO               = LXB_CSS_VALUE_TOMATO,
    LXB_CSS_COLOR_TURQUOISE            = LXB_CSS_VALUE_TURQUOISE,
    LXB_CSS_COLOR_VIOLET               = LXB_CSS_VALUE_VIOLET,
    LXB_CSS_COLOR_WHEAT                = LXB_CSS_VALUE_WHEAT,
    LXB_CSS_COLOR_WHITE                = LXB_CSS_VALUE_WHITE,
    LXB_CSS_COLOR_WHITESMOKE           = LXB_CSS_VALUE_WHITESMOKE,
    LXB_CSS_COLOR_YELLOW               = LXB_CSS_VALUE_YELLOW,
    LXB_CSS_COLOR_YELLOWGREEN          = LXB_CSS_VALUE_YELLOWGREEN,
    LXB_CSS_COLOR_CANVAS               = LXB_CSS_VALUE_CANVAS,
    LXB_CSS_COLOR_CANVASTEXT           = LXB_CSS_VALUE_CANVASTEXT,
    LXB_CSS_COLOR_LINKTEXT             = LXB_CSS_VALUE_LINKTEXT,
    LXB_CSS_COLOR_VISITEDTEXT          = LXB_CSS_VALUE_VISITEDTEXT,
    LXB_CSS_COLOR_ACTIVETEXT           = LXB_CSS_VALUE_ACTIVETEXT,
    LXB_CSS_COLOR_BUTTONFACE           = LXB_CSS_VALUE_BUTTONFACE,
    LXB_CSS_COLOR_BUTTONTEXT           = LXB_CSS_VALUE_BUTTONTEXT,
    LXB_CSS_COLOR_BUTTONBORDER         = LXB_CSS_VALUE_BUTTONBORDER,
    LXB_CSS_COLOR_FIELD                = LXB_CSS_VALUE_FIELD,
    LXB_CSS_COLOR_FIELDTEXT            = LXB_CSS_VALUE_FIELDTEXT,
    LXB_CSS_COLOR_HIGHLIGHT            = LXB_CSS_VALUE_HIGHLIGHT,
    LXB_CSS_COLOR_HIGHLIGHTTEXT        = LXB_CSS_VALUE_HIGHLIGHTTEXT,
    LXB_CSS_COLOR_SELECTEDITEM         = LXB_CSS_VALUE_SELECTEDITEM,
    LXB_CSS_COLOR_SELECTEDITEMTEXT     = LXB_CSS_VALUE_SELECTEDITEMTEXT,
    LXB_CSS_COLOR_MARK                 = LXB_CSS_VALUE_MARK,
    LXB_CSS_COLOR_MARKTEXT             = LXB_CSS_VALUE_MARKTEXT,
    LXB_CSS_COLOR_GRAYTEXT             = LXB_CSS_VALUE_GRAYTEXT,
    LXB_CSS_COLOR_ACCENTCOLOR          = LXB_CSS_VALUE_ACCENTCOLOR,
    LXB_CSS_COLOR_ACCENTCOLORTEXT      = LXB_CSS_VALUE_ACCENTCOLORTEXT,
    LXB_CSS_COLOR_RGB                  = LXB_CSS_VALUE_RGB,
    LXB_CSS_COLOR_RGBA                 = LXB_CSS_VALUE_RGBA,
    LXB_CSS_COLOR_HSL                  = LXB_CSS_VALUE_HSL,
    LXB_CSS_COLOR_HSLA                 = LXB_CSS_VALUE_HSLA,
    LXB_CSS_COLOR_HWB                  = LXB_CSS_VALUE_HWB,
    LXB_CSS_COLOR_LAB                  = LXB_CSS_VALUE_LAB,
    LXB_CSS_COLOR_LCH                  = LXB_CSS_VALUE_LCH,
    LXB_CSS_COLOR_OKLAB                = LXB_CSS_VALUE_OKLAB,
    LXB_CSS_COLOR_OKLCH                = LXB_CSS_VALUE_OKLCH,
    LXB_CSS_COLOR_COLOR                = LXB_CSS_VALUE_COLOR
};
typedef unsigned int lxb_css_color_type_t;

enum {
    LXB_CSS_DIRECTION_LTR = LXB_CSS_VALUE_LTR,
    LXB_CSS_DIRECTION_RTL = LXB_CSS_VALUE_RTL
};
typedef unsigned int lxb_css_direction_type_t;

enum {
    LXB_CSS_DISPLAY_BLOCK               = LXB_CSS_VALUE_BLOCK,
    LXB_CSS_DISPLAY_INLINE              = LXB_CSS_VALUE_INLINE,
    LXB_CSS_DISPLAY_RUN_IN              = LXB_CSS_VALUE_RUN_IN,
    LXB_CSS_DISPLAY_FLOW                = LXB_CSS_VALUE_FLOW,
    LXB_CSS_DISPLAY_FLOW_ROOT           = LXB_CSS_VALUE_FLOW_ROOT,
    LXB_CSS_DISPLAY_TABLE               = LXB_CSS_VALUE_TABLE,
    LXB_CSS_DISPLAY_FLEX                = LXB_CSS_VALUE_FLEX,
    LXB_CSS_DISPLAY_GRID                = LXB_CSS_VALUE_GRID,
    LXB_CSS_DISPLAY_RUBY                = LXB_CSS_VALUE_RUBY,
    LXB_CSS_DISPLAY_LIST_ITEM           = LXB_CSS_VALUE_LIST_ITEM,
    LXB_CSS_DISPLAY_TABLE_ROW_GROUP     = LXB_CSS_VALUE_TABLE_ROW_GROUP,
    LXB_CSS_DISPLAY_TABLE_HEADER_GROUP  = LXB_CSS_VALUE_TABLE_HEADER_GROUP,
    LXB_CSS_DISPLAY_TABLE_FOOTER_GROUP  = LXB_CSS_VALUE_TABLE_FOOTER_GROUP,
    LXB_CSS_DISPLAY_TABLE_ROW           = LXB_CSS_VALUE_TABLE_ROW,
    LXB_CSS_DISPLAY_TABLE_CELL          = LXB_CSS_VALUE_TABLE_CELL,
    LXB_CSS_DISPLAY_TABLE_COLUMN_GROUP  = LXB_CSS_VALUE_TABLE_COLUMN_GROUP,
    LXB_CSS_DISPLAY_TABLE_COLUMN        = LXB_CSS_VALUE_TABLE_COLUMN,
    LXB_CSS_DISPLAY_TABLE_CAPTION       = LXB_CSS_VALUE_TABLE_CAPTION,
    LXB_CSS_DISPLAY_RUBY_BASE           = LXB_CSS_VALUE_RUBY_BASE,
    LXB_CSS_DISPLAY_RUBY_TEXT           = LXB_CSS_VALUE_RUBY_TEXT,
    LXB_CSS_DISPLAY_RUBY_BASE_CONTAINER = LXB_CSS_VALUE_RUBY_BASE_CONTAINER,
    LXB_CSS_DISPLAY_RUBY_TEXT_CONTAINER = LXB_CSS_VALUE_RUBY_TEXT_CONTAINER,
    LXB_CSS_DISPLAY_CONTENTS            = LXB_CSS_VALUE_CONTENTS,
    LXB_CSS_DISPLAY_NONE                = LXB_CSS_VALUE_NONE,
    LXB_CSS_DISPLAY_INLINE_BLOCK        = LXB_CSS_VALUE_INLINE_BLOCK,
    LXB_CSS_DISPLAY_INLINE_TABLE        = LXB_CSS_VALUE_INLINE_TABLE,
    LXB_CSS_DISPLAY_INLINE_FLEX         = LXB_CSS_VALUE_INLINE_FLEX,
    LXB_CSS_DISPLAY_INLINE_GRID         = LXB_CSS_VALUE_INLINE_GRID
};
typedef unsigned int lxb_css_display_type_t;

enum {
    LXB_CSS_DOMINANT_BASELINE_AUTO         = LXB_CSS_VALUE_AUTO,
    LXB_CSS_DOMINANT_BASELINE_TEXT_BOTTOM  = LXB_CSS_VALUE_TEXT_BOTTOM,
    LXB_CSS_DOMINANT_BASELINE_ALPHABETIC   = LXB_CSS_VALUE_ALPHABETIC,
    LXB_CSS_DOMINANT_BASELINE_IDEOGRAPHIC  = LXB_CSS_VALUE_IDEOGRAPHIC,
    LXB_CSS_DOMINANT_BASELINE_MIDDLE       = LXB_CSS_VALUE_MIDDLE,
    LXB_CSS_DOMINANT_BASELINE_CENTRAL      = LXB_CSS_VALUE_CENTRAL,
    LXB_CSS_DOMINANT_BASELINE_MATHEMATICAL = LXB_CSS_VALUE_MATHEMATICAL,
    LXB_CSS_DOMINANT_BASELINE_HANGING      = LXB_CSS_VALUE_HANGING,
    LXB_CSS_DOMINANT_BASELINE_TEXT_TOP     = LXB_CSS_VALUE_TEXT_TOP
};
typedef unsigned int lxb_css_dominant_baseline_type_t;

enum {
    LXB_CSS_FLEX_NONE = LXB_CSS_VALUE_NONE
};
typedef unsigned int lxb_css_flex_type_t;

enum {
    LXB_CSS_FLEX_BASIS_CONTENT = LXB_CSS_VALUE_CONTENT
};
typedef unsigned int lxb_css_flex_basis_type_t;

enum {
    LXB_CSS_FLEX_DIRECTION_ROW            = LXB_CSS_VALUE_ROW,
    LXB_CSS_FLEX_DIRECTION_ROW_REVERSE    = LXB_CSS_VALUE_ROW_REVERSE,
    LXB_CSS_FLEX_DIRECTION_COLUMN         = LXB_CSS_VALUE_COLUMN,
    LXB_CSS_FLEX_DIRECTION_COLUMN_REVERSE = LXB_CSS_VALUE_COLUMN_REVERSE
};
typedef unsigned int lxb_css_flex_direction_type_t;



enum {
    LXB_CSS_FLEX_GROW__NUMBER = LXB_CSS_VALUE__NUMBER
};
typedef unsigned int lxb_css_flex_grow_type_t;

enum {
    LXB_CSS_FLEX_SHRINK__NUMBER = LXB_CSS_VALUE__NUMBER
};
typedef unsigned int lxb_css_flex_shrink_type_t;

enum {
    LXB_CSS_FLEX_WRAP_NOWRAP       = LXB_CSS_VALUE_NOWRAP,
    LXB_CSS_FLEX_WRAP_WRAP         = LXB_CSS_VALUE_WRAP,
    LXB_CSS_FLEX_WRAP_WRAP_REVERSE = LXB_CSS_VALUE_WRAP_REVERSE
};
typedef unsigned int lxb_css_flex_wrap_type_t;

enum {
    LXB_CSS_FLOAT_BLOCK_START  = LXB_CSS_VALUE_BLOCK_START,
    LXB_CSS_FLOAT_BLOCK_END    = LXB_CSS_VALUE_BLOCK_END,
    LXB_CSS_FLOAT_INLINE_START = LXB_CSS_VALUE_INLINE_START,
    LXB_CSS_FLOAT_INLINE_END   = LXB_CSS_VALUE_INLINE_END,
    LXB_CSS_FLOAT_SNAP_BLOCK   = LXB_CSS_VALUE_SNAP_BLOCK,
    LXB_CSS_FLOAT_START        = LXB_CSS_VALUE_START,
    LXB_CSS_FLOAT_END          = LXB_CSS_VALUE_END,
    LXB_CSS_FLOAT_NEAR         = LXB_CSS_VALUE_NEAR,
    LXB_CSS_FLOAT_SNAP_INLINE  = LXB_CSS_VALUE_SNAP_INLINE,
    LXB_CSS_FLOAT_LEFT         = LXB_CSS_VALUE_LEFT,
    LXB_CSS_FLOAT_RIGHT        = LXB_CSS_VALUE_RIGHT,
    LXB_CSS_FLOAT_TOP          = LXB_CSS_VALUE_TOP,
    LXB_CSS_FLOAT_BOTTOM       = LXB_CSS_VALUE_BOTTOM,
    LXB_CSS_FLOAT_NONE         = LXB_CSS_VALUE_NONE
};
typedef unsigned int lxb_css_float_type_t;

enum {
    LXB_CSS_FLOAT_DEFER__INTEGER = LXB_CSS_VALUE__INTEGER,
    LXB_CSS_FLOAT_DEFER_LAST     = LXB_CSS_VALUE_LAST,
    LXB_CSS_FLOAT_DEFER_NONE     = LXB_CSS_VALUE_NONE
};
typedef unsigned int lxb_css_float_defer_type_t;

enum {
    LXB_CSS_FLOAT_OFFSET__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_FLOAT_OFFSET__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_float_offset_type_t;

enum {
    LXB_CSS_FLOAT_REFERENCE_INLINE = LXB_CSS_VALUE_INLINE,
    LXB_CSS_FLOAT_REFERENCE_COLUMN = LXB_CSS_VALUE_COLUMN,
    LXB_CSS_FLOAT_REFERENCE_REGION = LXB_CSS_VALUE_REGION,
    LXB_CSS_FLOAT_REFERENCE_PAGE   = LXB_CSS_VALUE_PAGE
};
typedef unsigned int lxb_css_float_reference_type_t;

enum {
    LXB_CSS_FONT_FAMILY_SERIF         = LXB_CSS_VALUE_SERIF,
    LXB_CSS_FONT_FAMILY_SANS_SERIF    = LXB_CSS_VALUE_SANS_SERIF,
    LXB_CSS_FONT_FAMILY_CURSIVE       = LXB_CSS_VALUE_CURSIVE,
    LXB_CSS_FONT_FAMILY_FANTASY       = LXB_CSS_VALUE_FANTASY,
    LXB_CSS_FONT_FAMILY_MONOSPACE     = LXB_CSS_VALUE_MONOSPACE,
    LXB_CSS_FONT_FAMILY_SYSTEM_UI     = LXB_CSS_VALUE_SYSTEM_UI,
    LXB_CSS_FONT_FAMILY_EMOJI         = LXB_CSS_VALUE_EMOJI,
    LXB_CSS_FONT_FAMILY_MATH          = LXB_CSS_VALUE_MATH,
    LXB_CSS_FONT_FAMILY_FANGSONG      = LXB_CSS_VALUE_FANGSONG,
    LXB_CSS_FONT_FAMILY_UI_SERIF      = LXB_CSS_VALUE_UI_SERIF,
    LXB_CSS_FONT_FAMILY_UI_SANS_SERIF = LXB_CSS_VALUE_UI_SANS_SERIF,
    LXB_CSS_FONT_FAMILY_UI_MONOSPACE  = LXB_CSS_VALUE_UI_MONOSPACE,
    LXB_CSS_FONT_FAMILY_UI_ROUNDED    = LXB_CSS_VALUE_UI_ROUNDED
};
typedef unsigned int lxb_css_font_family_type_t;

enum {
    LXB_CSS_FONT_SIZE_XX_SMALL  = LXB_CSS_VALUE_XX_SMALL,
    LXB_CSS_FONT_SIZE_X_SMALL   = LXB_CSS_VALUE_X_SMALL,
    LXB_CSS_FONT_SIZE_SMALL     = LXB_CSS_VALUE_SMALL,
    LXB_CSS_FONT_SIZE_MEDIUM    = LXB_CSS_VALUE_MEDIUM,
    LXB_CSS_FONT_SIZE_LARGE     = LXB_CSS_VALUE_LARGE,
    LXB_CSS_FONT_SIZE_X_LARGE   = LXB_CSS_VALUE_X_LARGE,
    LXB_CSS_FONT_SIZE_XX_LARGE  = LXB_CSS_VALUE_XX_LARGE,
    LXB_CSS_FONT_SIZE_XXX_LARGE = LXB_CSS_VALUE_XXX_LARGE,
    LXB_CSS_FONT_SIZE_LARGER    = LXB_CSS_VALUE_LARGER,
    LXB_CSS_FONT_SIZE_SMALLER   = LXB_CSS_VALUE_SMALLER,
    LXB_CSS_FONT_SIZE_MATH      = LXB_CSS_VALUE_MATH,
    LXB_CSS_FONT_SIZE__LENGTH   = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_font_size_type_t;

enum {
    LXB_CSS_FONT_STRETCH_NORMAL          = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_FONT_STRETCH__PERCENTAGE     = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_FONT_STRETCH_ULTRA_CONDENSED = LXB_CSS_VALUE_ULTRA_CONDENSED,
    LXB_CSS_FONT_STRETCH_EXTRA_CONDENSED = LXB_CSS_VALUE_EXTRA_CONDENSED,
    LXB_CSS_FONT_STRETCH_CONDENSED       = LXB_CSS_VALUE_CONDENSED,
    LXB_CSS_FONT_STRETCH_SEMI_CONDENSED  = LXB_CSS_VALUE_SEMI_CONDENSED,
    LXB_CSS_FONT_STRETCH_SEMI_EXPANDED   = LXB_CSS_VALUE_SEMI_EXPANDED,
    LXB_CSS_FONT_STRETCH_EXPANDED        = LXB_CSS_VALUE_EXPANDED,
    LXB_CSS_FONT_STRETCH_EXTRA_EXPANDED  = LXB_CSS_VALUE_EXTRA_EXPANDED,
    LXB_CSS_FONT_STRETCH_ULTRA_EXPANDED  = LXB_CSS_VALUE_ULTRA_EXPANDED
};
typedef unsigned int lxb_css_font_stretch_type_t;

enum {
    LXB_CSS_FONT_STYLE_NORMAL  = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_FONT_STYLE_ITALIC  = LXB_CSS_VALUE_ITALIC,
    LXB_CSS_FONT_STYLE_OBLIQUE = LXB_CSS_VALUE_OBLIQUE
};
typedef unsigned int lxb_css_font_style_type_t;

enum {
    LXB_CSS_FONT_WEIGHT_NORMAL  = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_FONT_WEIGHT_BOLD    = LXB_CSS_VALUE_BOLD,
    LXB_CSS_FONT_WEIGHT__NUMBER = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_FONT_WEIGHT_BOLDER  = LXB_CSS_VALUE_BOLDER,
    LXB_CSS_FONT_WEIGHT_LIGHTER = LXB_CSS_VALUE_LIGHTER
};
typedef unsigned int lxb_css_font_weight_type_t;

enum {
    LXB_CSS_HANGING_PUNCTUATION_NONE      = LXB_CSS_VALUE_NONE,
    LXB_CSS_HANGING_PUNCTUATION_FIRST     = LXB_CSS_VALUE_FIRST,
    LXB_CSS_HANGING_PUNCTUATION_FORCE_END = LXB_CSS_VALUE_FORCE_END,
    LXB_CSS_HANGING_PUNCTUATION_ALLOW_END = LXB_CSS_VALUE_ALLOW_END,
    LXB_CSS_HANGING_PUNCTUATION_LAST      = LXB_CSS_VALUE_LAST
};
typedef unsigned int lxb_css_hanging_punctuation_type_t;

enum {
    LXB_CSS_HEIGHT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_HEIGHT_MIN_CONTENT = LXB_CSS_VALUE_MIN_CONTENT,
    LXB_CSS_HEIGHT_MAX_CONTENT = LXB_CSS_VALUE_MAX_CONTENT,
    LXB_CSS_HEIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_HEIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_HEIGHT__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_HEIGHT__ANGLE      = LXB_CSS_VALUE__ANGLE
};
typedef unsigned int lxb_css_height_type_t;

enum {
    LXB_CSS_HYPHENS_NONE   = LXB_CSS_VALUE_NONE,
    LXB_CSS_HYPHENS_MANUAL = LXB_CSS_VALUE_MANUAL,
    LXB_CSS_HYPHENS_AUTO   = LXB_CSS_VALUE_AUTO
};
typedef unsigned int lxb_css_hyphens_type_t;

enum {
    LXB_CSS_INSET_BLOCK_END_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_INSET_BLOCK_END__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_INSET_BLOCK_END__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_inset_block_end_type_t;

enum {
    LXB_CSS_INSET_BLOCK_START_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_INSET_BLOCK_START__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_INSET_BLOCK_START__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_inset_block_start_type_t;

enum {
    LXB_CSS_INSET_INLINE_END_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_INSET_INLINE_END__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_INSET_INLINE_END__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_inset_inline_end_type_t;

enum {
    LXB_CSS_INSET_INLINE_START_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_INSET_INLINE_START__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_INSET_INLINE_START__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_inset_inline_start_type_t;

enum {
    LXB_CSS_JUSTIFY_CONTENT_FLEX_START    = LXB_CSS_VALUE_FLEX_START,
    LXB_CSS_JUSTIFY_CONTENT_FLEX_END      = LXB_CSS_VALUE_FLEX_END,
    LXB_CSS_JUSTIFY_CONTENT_CENTER        = LXB_CSS_VALUE_CENTER,
    LXB_CSS_JUSTIFY_CONTENT_SPACE_BETWEEN = LXB_CSS_VALUE_SPACE_BETWEEN,
    LXB_CSS_JUSTIFY_CONTENT_SPACE_AROUND  = LXB_CSS_VALUE_SPACE_AROUND
};
typedef unsigned int lxb_css_justify_content_type_t;

enum {
    LXB_CSS_LEFT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_LEFT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_LEFT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_left_type_t;

enum {
    LXB_CSS_LETTER_SPACING_NORMAL  = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_LETTER_SPACING__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_letter_spacing_type_t;

enum {
    LXB_CSS_LINE_BREAK_AUTO     = LXB_CSS_VALUE_AUTO,
    LXB_CSS_LINE_BREAK_LOOSE    = LXB_CSS_VALUE_LOOSE,
    LXB_CSS_LINE_BREAK_NORMAL   = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_LINE_BREAK_STRICT   = LXB_CSS_VALUE_STRICT,
    LXB_CSS_LINE_BREAK_ANYWHERE = LXB_CSS_VALUE_ANYWHERE
};
typedef unsigned int lxb_css_line_break_type_t;

enum {
    LXB_CSS_LINE_HEIGHT_NORMAL      = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_LINE_HEIGHT__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_LINE_HEIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_LINE_HEIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_line_height_type_t;

enum {
    LXB_CSS_MARGIN_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MARGIN__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MARGIN__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_margin_type_t;

enum {
    LXB_CSS_MARGIN_BOTTOM_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MARGIN_BOTTOM__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MARGIN_BOTTOM__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_margin_bottom_type_t;

enum {
    LXB_CSS_MARGIN_LEFT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MARGIN_LEFT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MARGIN_LEFT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_margin_left_type_t;

enum {
    LXB_CSS_MARGIN_RIGHT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MARGIN_RIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MARGIN_RIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_margin_right_type_t;

enum {
    LXB_CSS_MARGIN_TOP_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MARGIN_TOP__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MARGIN_TOP__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_margin_top_type_t;

enum {
    LXB_CSS_MAX_HEIGHT_NONE        = LXB_CSS_VALUE_NONE,
    LXB_CSS_MAX_HEIGHT_MIN_CONTENT = LXB_CSS_VALUE_MIN_CONTENT,
    LXB_CSS_MAX_HEIGHT_MAX_CONTENT = LXB_CSS_VALUE_MAX_CONTENT,
    LXB_CSS_MAX_HEIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MAX_HEIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_MAX_HEIGHT__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_MAX_HEIGHT__ANGLE      = LXB_CSS_VALUE__ANGLE
};
typedef unsigned int lxb_css_max_height_type_t;

enum {
    LXB_CSS_MAX_WIDTH_NONE        = LXB_CSS_VALUE_NONE,
    LXB_CSS_MAX_WIDTH_MIN_CONTENT = LXB_CSS_VALUE_MIN_CONTENT,
    LXB_CSS_MAX_WIDTH_MAX_CONTENT = LXB_CSS_VALUE_MAX_CONTENT,
    LXB_CSS_MAX_WIDTH__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MAX_WIDTH__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_MAX_WIDTH__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_MAX_WIDTH__ANGLE      = LXB_CSS_VALUE__ANGLE
};
typedef unsigned int lxb_css_max_width_type_t;

enum {
    LXB_CSS_MIN_HEIGHT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MIN_HEIGHT_MIN_CONTENT = LXB_CSS_VALUE_MIN_CONTENT,
    LXB_CSS_MIN_HEIGHT_MAX_CONTENT = LXB_CSS_VALUE_MAX_CONTENT,
    LXB_CSS_MIN_HEIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MIN_HEIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_MIN_HEIGHT__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_MIN_HEIGHT__ANGLE      = LXB_CSS_VALUE__ANGLE
};
typedef unsigned int lxb_css_min_height_type_t;

enum {
    LXB_CSS_MIN_WIDTH_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_MIN_WIDTH_MIN_CONTENT = LXB_CSS_VALUE_MIN_CONTENT,
    LXB_CSS_MIN_WIDTH_MAX_CONTENT = LXB_CSS_VALUE_MAX_CONTENT,
    LXB_CSS_MIN_WIDTH__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_MIN_WIDTH__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_MIN_WIDTH__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_MIN_WIDTH__ANGLE      = LXB_CSS_VALUE__ANGLE
};
typedef unsigned int lxb_css_min_width_type_t;

enum {
    LXB_CSS_OPACITY__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_OPACITY__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_opacity_type_t;

enum {
    LXB_CSS_ORDER__INTEGER = LXB_CSS_VALUE__INTEGER
};
typedef unsigned int lxb_css_order_type_t;

enum {
    LXB_CSS_OVERFLOW_BLOCK_VISIBLE = LXB_CSS_VALUE_VISIBLE,
    LXB_CSS_OVERFLOW_BLOCK_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_OVERFLOW_BLOCK_CLIP    = LXB_CSS_VALUE_CLIP,
    LXB_CSS_OVERFLOW_BLOCK_SCROLL  = LXB_CSS_VALUE_SCROLL,
    LXB_CSS_OVERFLOW_BLOCK_AUTO    = LXB_CSS_VALUE_AUTO
};
typedef unsigned int lxb_css_overflow_block_type_t;

enum {
    LXB_CSS_OVERFLOW_INLINE_VISIBLE = LXB_CSS_VALUE_VISIBLE,
    LXB_CSS_OVERFLOW_INLINE_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_OVERFLOW_INLINE_CLIP    = LXB_CSS_VALUE_CLIP,
    LXB_CSS_OVERFLOW_INLINE_SCROLL  = LXB_CSS_VALUE_SCROLL,
    LXB_CSS_OVERFLOW_INLINE_AUTO    = LXB_CSS_VALUE_AUTO
};
typedef unsigned int lxb_css_overflow_inline_type_t;

enum {
    LXB_CSS_OVERFLOW_WRAP_NORMAL     = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_OVERFLOW_WRAP_BREAK_WORD = LXB_CSS_VALUE_BREAK_WORD,
    LXB_CSS_OVERFLOW_WRAP_ANYWHERE   = LXB_CSS_VALUE_ANYWHERE
};
typedef unsigned int lxb_css_overflow_wrap_type_t;

enum {
    LXB_CSS_OVERFLOW_X_VISIBLE = LXB_CSS_VALUE_VISIBLE,
    LXB_CSS_OVERFLOW_X_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_OVERFLOW_X_CLIP    = LXB_CSS_VALUE_CLIP,
    LXB_CSS_OVERFLOW_X_SCROLL  = LXB_CSS_VALUE_SCROLL,
    LXB_CSS_OVERFLOW_X_AUTO    = LXB_CSS_VALUE_AUTO
};
typedef unsigned int lxb_css_overflow_x_type_t;

enum {
    LXB_CSS_OVERFLOW_Y_VISIBLE = LXB_CSS_VALUE_VISIBLE,
    LXB_CSS_OVERFLOW_Y_HIDDEN  = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_OVERFLOW_Y_CLIP    = LXB_CSS_VALUE_CLIP,
    LXB_CSS_OVERFLOW_Y_SCROLL  = LXB_CSS_VALUE_SCROLL,
    LXB_CSS_OVERFLOW_Y_AUTO    = LXB_CSS_VALUE_AUTO
};
typedef unsigned int lxb_css_overflow_y_type_t;

enum {
    LXB_CSS_PADDING_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_PADDING__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_PADDING__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_padding_type_t;

enum {
    LXB_CSS_PADDING_BOTTOM_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_PADDING_BOTTOM__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_PADDING_BOTTOM__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_padding_bottom_type_t;

enum {
    LXB_CSS_PADDING_LEFT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_PADDING_LEFT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_PADDING_LEFT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_padding_left_type_t;

enum {
    LXB_CSS_PADDING_RIGHT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_PADDING_RIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_PADDING_RIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_padding_right_type_t;

enum {
    LXB_CSS_PADDING_TOP_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_PADDING_TOP__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_PADDING_TOP__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_padding_top_type_t;

enum {
    LXB_CSS_POSITION_STATIC   = LXB_CSS_VALUE_STATIC,
    LXB_CSS_POSITION_RELATIVE = LXB_CSS_VALUE_RELATIVE,
    LXB_CSS_POSITION_ABSOLUTE = LXB_CSS_VALUE_ABSOLUTE,
    LXB_CSS_POSITION_STICKY   = LXB_CSS_VALUE_STICKY,
    LXB_CSS_POSITION_FIXED    = LXB_CSS_VALUE_FIXED
};
typedef unsigned int lxb_css_position_type_t;

enum {
    LXB_CSS_RIGHT_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_RIGHT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_RIGHT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_right_type_t;

enum {
    LXB_CSS_TAB_SIZE__NUMBER = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_TAB_SIZE__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_tab_size_type_t;

enum {
    LXB_CSS_TEXT_ALIGN_START        = LXB_CSS_VALUE_START,
    LXB_CSS_TEXT_ALIGN_END          = LXB_CSS_VALUE_END,
    LXB_CSS_TEXT_ALIGN_LEFT         = LXB_CSS_VALUE_LEFT,
    LXB_CSS_TEXT_ALIGN_RIGHT        = LXB_CSS_VALUE_RIGHT,
    LXB_CSS_TEXT_ALIGN_CENTER       = LXB_CSS_VALUE_CENTER,
    LXB_CSS_TEXT_ALIGN_JUSTIFY      = LXB_CSS_VALUE_JUSTIFY,
    LXB_CSS_TEXT_ALIGN_MATCH_PARENT = LXB_CSS_VALUE_MATCH_PARENT,
    LXB_CSS_TEXT_ALIGN_JUSTIFY_ALL  = LXB_CSS_VALUE_JUSTIFY_ALL
};
typedef unsigned int lxb_css_text_align_type_t;

enum {
    LXB_CSS_TEXT_ALIGN_ALL_START        = LXB_CSS_VALUE_START,
    LXB_CSS_TEXT_ALIGN_ALL_END          = LXB_CSS_VALUE_END,
    LXB_CSS_TEXT_ALIGN_ALL_LEFT         = LXB_CSS_VALUE_LEFT,
    LXB_CSS_TEXT_ALIGN_ALL_RIGHT        = LXB_CSS_VALUE_RIGHT,
    LXB_CSS_TEXT_ALIGN_ALL_CENTER       = LXB_CSS_VALUE_CENTER,
    LXB_CSS_TEXT_ALIGN_ALL_JUSTIFY      = LXB_CSS_VALUE_JUSTIFY,
    LXB_CSS_TEXT_ALIGN_ALL_MATCH_PARENT = LXB_CSS_VALUE_MATCH_PARENT
};
typedef unsigned int lxb_css_text_align_all_type_t;

enum {
    LXB_CSS_TEXT_ALIGN_LAST_AUTO         = LXB_CSS_VALUE_AUTO,
    LXB_CSS_TEXT_ALIGN_LAST_START        = LXB_CSS_VALUE_START,
    LXB_CSS_TEXT_ALIGN_LAST_END          = LXB_CSS_VALUE_END,
    LXB_CSS_TEXT_ALIGN_LAST_LEFT         = LXB_CSS_VALUE_LEFT,
    LXB_CSS_TEXT_ALIGN_LAST_RIGHT        = LXB_CSS_VALUE_RIGHT,
    LXB_CSS_TEXT_ALIGN_LAST_CENTER       = LXB_CSS_VALUE_CENTER,
    LXB_CSS_TEXT_ALIGN_LAST_JUSTIFY      = LXB_CSS_VALUE_JUSTIFY,
    LXB_CSS_TEXT_ALIGN_LAST_MATCH_PARENT = LXB_CSS_VALUE_MATCH_PARENT
};
typedef unsigned int lxb_css_text_align_last_type_t;

enum {
    LXB_CSS_TEXT_COMBINE_UPRIGHT_NONE   = LXB_CSS_VALUE_NONE,
    LXB_CSS_TEXT_COMBINE_UPRIGHT_ALL    = LXB_CSS_VALUE_ALL,
    LXB_CSS_TEXT_COMBINE_UPRIGHT_DIGITS = LXB_CSS_VALUE_DIGITS
};
typedef unsigned int lxb_css_text_combine_upright_type_t;





enum {
    LXB_CSS_TEXT_DECORATION_LINE_NONE         = LXB_CSS_VALUE_NONE,
    LXB_CSS_TEXT_DECORATION_LINE_UNDERLINE    = LXB_CSS_VALUE_UNDERLINE,
    LXB_CSS_TEXT_DECORATION_LINE_OVERLINE     = LXB_CSS_VALUE_OVERLINE,
    LXB_CSS_TEXT_DECORATION_LINE_LINE_THROUGH = LXB_CSS_VALUE_LINE_THROUGH,
    LXB_CSS_TEXT_DECORATION_LINE_BLINK        = LXB_CSS_VALUE_BLINK
};
typedef unsigned int lxb_css_text_decoration_line_type_t;

enum {
    LXB_CSS_TEXT_DECORATION_STYLE_SOLID  = LXB_CSS_VALUE_SOLID,
    LXB_CSS_TEXT_DECORATION_STYLE_DOUBLE = LXB_CSS_VALUE_DOUBLE,
    LXB_CSS_TEXT_DECORATION_STYLE_DOTTED = LXB_CSS_VALUE_DOTTED,
    LXB_CSS_TEXT_DECORATION_STYLE_DASHED = LXB_CSS_VALUE_DASHED,
    LXB_CSS_TEXT_DECORATION_STYLE_WAVY   = LXB_CSS_VALUE_WAVY
};
typedef unsigned int lxb_css_text_decoration_style_type_t;

enum {
    LXB_CSS_TEXT_INDENT__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_TEXT_INDENT__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_TEXT_INDENT_HANGING     = LXB_CSS_VALUE_HANGING,
    LXB_CSS_TEXT_INDENT_EACH_LINE   = LXB_CSS_VALUE_EACH_LINE
};
typedef unsigned int lxb_css_text_indent_type_t;

enum {
    LXB_CSS_TEXT_JUSTIFY_AUTO            = LXB_CSS_VALUE_AUTO,
    LXB_CSS_TEXT_JUSTIFY_NONE            = LXB_CSS_VALUE_NONE,
    LXB_CSS_TEXT_JUSTIFY_INTER_WORD      = LXB_CSS_VALUE_INTER_WORD,
    LXB_CSS_TEXT_JUSTIFY_INTER_CHARACTER = LXB_CSS_VALUE_INTER_CHARACTER
};
typedef unsigned int lxb_css_text_justify_type_t;

enum {
    LXB_CSS_TEXT_ORIENTATION_MIXED    = LXB_CSS_VALUE_MIXED,
    LXB_CSS_TEXT_ORIENTATION_UPRIGHT  = LXB_CSS_VALUE_UPRIGHT,
    LXB_CSS_TEXT_ORIENTATION_SIDEWAYS = LXB_CSS_VALUE_SIDEWAYS
};
typedef unsigned int lxb_css_text_orientation_type_t;

enum {
    LXB_CSS_TEXT_OVERFLOW_CLIP     = LXB_CSS_VALUE_CLIP,
    LXB_CSS_TEXT_OVERFLOW_ELLIPSIS = LXB_CSS_VALUE_ELLIPSIS
};
typedef unsigned int lxb_css_text_overflow_type_t;

enum {
    LXB_CSS_TEXT_TRANSFORM_NONE           = LXB_CSS_VALUE_NONE,
    LXB_CSS_TEXT_TRANSFORM_CAPITALIZE     = LXB_CSS_VALUE_CAPITALIZE,
    LXB_CSS_TEXT_TRANSFORM_UPPERCASE      = LXB_CSS_VALUE_UPPERCASE,
    LXB_CSS_TEXT_TRANSFORM_LOWERCASE      = LXB_CSS_VALUE_LOWERCASE,
    LXB_CSS_TEXT_TRANSFORM_FULL_WIDTH     = LXB_CSS_VALUE_FULL_WIDTH,
    LXB_CSS_TEXT_TRANSFORM_FULL_SIZE_KANA = LXB_CSS_VALUE_FULL_SIZE_KANA
};
typedef unsigned int lxb_css_text_transform_type_t;

enum {
    LXB_CSS_TOP_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_TOP__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_TOP__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE
};
typedef unsigned int lxb_css_top_type_t;

enum {
    LXB_CSS_UNICODE_BIDI_NORMAL           = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_UNICODE_BIDI_EMBED            = LXB_CSS_VALUE_EMBED,
    LXB_CSS_UNICODE_BIDI_ISOLATE          = LXB_CSS_VALUE_ISOLATE,
    LXB_CSS_UNICODE_BIDI_BIDI_OVERRIDE    = LXB_CSS_VALUE_BIDI_OVERRIDE,
    LXB_CSS_UNICODE_BIDI_ISOLATE_OVERRIDE = LXB_CSS_VALUE_ISOLATE_OVERRIDE,
    LXB_CSS_UNICODE_BIDI_PLAINTEXT        = LXB_CSS_VALUE_PLAINTEXT
};
typedef unsigned int lxb_css_unicode_bidi_type_t;

enum {
    LXB_CSS_VERTICAL_ALIGN_FIRST = LXB_CSS_VALUE_FIRST,
    LXB_CSS_VERTICAL_ALIGN_LAST  = LXB_CSS_VALUE_LAST
};
typedef unsigned int lxb_css_vertical_align_type_t;

enum {
    LXB_CSS_VISIBILITY_VISIBLE  = LXB_CSS_VALUE_VISIBLE,
    LXB_CSS_VISIBILITY_HIDDEN   = LXB_CSS_VALUE_HIDDEN,
    LXB_CSS_VISIBILITY_COLLAPSE = LXB_CSS_VALUE_COLLAPSE
};
typedef unsigned int lxb_css_visibility_type_t;

enum {
    LXB_CSS_WHITE_SPACE_NORMAL       = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_WHITE_SPACE_PRE          = LXB_CSS_VALUE_PRE,
    LXB_CSS_WHITE_SPACE_NOWRAP       = LXB_CSS_VALUE_NOWRAP,
    LXB_CSS_WHITE_SPACE_PRE_WRAP     = LXB_CSS_VALUE_PRE_WRAP,
    LXB_CSS_WHITE_SPACE_BREAK_SPACES = LXB_CSS_VALUE_BREAK_SPACES,
    LXB_CSS_WHITE_SPACE_PRE_LINE     = LXB_CSS_VALUE_PRE_LINE
};
typedef unsigned int lxb_css_white_space_type_t;

enum {
    LXB_CSS_WIDTH_AUTO        = LXB_CSS_VALUE_AUTO,
    LXB_CSS_WIDTH_MIN_CONTENT = LXB_CSS_VALUE_MIN_CONTENT,
    LXB_CSS_WIDTH_MAX_CONTENT = LXB_CSS_VALUE_MAX_CONTENT,
    LXB_CSS_WIDTH__LENGTH     = LXB_CSS_VALUE__LENGTH,
    LXB_CSS_WIDTH__PERCENTAGE = LXB_CSS_VALUE__PERCENTAGE,
    LXB_CSS_WIDTH__NUMBER     = LXB_CSS_VALUE__NUMBER,
    LXB_CSS_WIDTH__ANGLE      = LXB_CSS_VALUE__ANGLE
};
typedef unsigned int lxb_css_width_type_t;

enum {
    LXB_CSS_WORD_BREAK_NORMAL     = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_WORD_BREAK_KEEP_ALL   = LXB_CSS_VALUE_KEEP_ALL,
    LXB_CSS_WORD_BREAK_BREAK_ALL  = LXB_CSS_VALUE_BREAK_ALL,
    LXB_CSS_WORD_BREAK_BREAK_WORD = LXB_CSS_VALUE_BREAK_WORD
};
typedef unsigned int lxb_css_word_break_type_t;

enum {
    LXB_CSS_WORD_SPACING_NORMAL  = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_WORD_SPACING__LENGTH = LXB_CSS_VALUE__LENGTH
};
typedef unsigned int lxb_css_word_spacing_type_t;

enum {
    LXB_CSS_WORD_WRAP_NORMAL     = LXB_CSS_VALUE_NORMAL,
    LXB_CSS_WORD_WRAP_BREAK_WORD = LXB_CSS_VALUE_BREAK_WORD,
    LXB_CSS_WORD_WRAP_ANYWHERE   = LXB_CSS_VALUE_ANYWHERE
};
typedef unsigned int lxb_css_word_wrap_type_t;

enum {
    LXB_CSS_WRAP_FLOW_AUTO    = LXB_CSS_VALUE_AUTO,
    LXB_CSS_WRAP_FLOW_BOTH    = LXB_CSS_VALUE_BOTH,
    LXB_CSS_WRAP_FLOW_START   = LXB_CSS_VALUE_START,
    LXB_CSS_WRAP_FLOW_END     = LXB_CSS_VALUE_END,
    LXB_CSS_WRAP_FLOW_MINIMUM = LXB_CSS_VALUE_MINIMUM,
    LXB_CSS_WRAP_FLOW_MAXIMUM = LXB_CSS_VALUE_MAXIMUM,
    LXB_CSS_WRAP_FLOW_CLEAR   = LXB_CSS_VALUE_CLEAR
};
typedef unsigned int lxb_css_wrap_flow_type_t;

enum {
    LXB_CSS_WRAP_THROUGH_WRAP = LXB_CSS_VALUE_WRAP,
    LXB_CSS_WRAP_THROUGH_NONE = LXB_CSS_VALUE_NONE
};
typedef unsigned int lxb_css_wrap_through_type_t;

enum {
    LXB_CSS_WRITING_MODE_HORIZONTAL_TB = LXB_CSS_VALUE_HORIZONTAL_TB,
    LXB_CSS_WRITING_MODE_VERTICAL_RL   = LXB_CSS_VALUE_VERTICAL_RL,
    LXB_CSS_WRITING_MODE_VERTICAL_LR   = LXB_CSS_VALUE_VERTICAL_LR,
    LXB_CSS_WRITING_MODE_SIDEWAYS_RL   = LXB_CSS_VALUE_SIDEWAYS_RL,
    LXB_CSS_WRITING_MODE_SIDEWAYS_LR   = LXB_CSS_VALUE_SIDEWAYS_LR
};
typedef unsigned int lxb_css_writing_mode_type_t;

enum {
    LXB_CSS_Z_INDEX_AUTO     = LXB_CSS_VALUE_AUTO,
    LXB_CSS_Z_INDEX__INTEGER = LXB_CSS_VALUE__INTEGER
};
typedef unsigned int lxb_css_z_index_type_t;


#endif /* LXB_CSS_PROPERTY_CONST_H */
