/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0010H\u0016R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCommonAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "arraysContentEquals", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getArrayContentEqualsSymbol", "type", "implementAnnotationPropertiesAndConstructor", "", "annotationClass", "generatedConstructor", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsAnnotationImplementationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsAnnotationImplementationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCommonAnnotationImplementationTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1#2:107\n672#3,11:108\n*S KotlinDebug\n*F\n+ 1 JsAnnotationImplementationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCommonAnnotationImplementationTransformer\n*L\n93#1:108,11\n*E\n"})
public final class JsCommonAnnotationImplementationTransformer
extends AnnotationImplementationTransformer
implements DeclarationTransformer {
    @NotNull
    private final Map<IrType, IrSimpleFunctionSymbol> arraysContentEquals;

    public JsCommonAnnotationImplementationTransformer(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2, context2.getSymbolTable(), null);
        Map<IrType, IrSimpleFunctionSymbol> map = context2.getSymbols().getArraysContentEquals();
        if (map == null) {
            JsCommonAnnotationImplementationTransformer jsCommonAnnotationImplementationTransformer = this;
            boolean bl = false;
            JsCommonAnnotationImplementationTransformer jsCommonAnnotationImplementationTransformer2 = jsCommonAnnotationImplementationTransformer;
            String string = "contentEquals symbols should be defined in the context";
            throw new IllegalArgumentException(string.toString());
        }
        this.arraysContentEquals = map;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        List<IrClass> list;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof IrClass && IrUtilsKt.isAnnotationClass((IrClass)declaration)) {
            IrStatement irStatement = this.visitClassNew((IrClass)declaration);
            Intrinsics.checkNotNull(irStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            list = CollectionsKt.listOf((IrClass)irStatement);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return expression2;
    }

    @Override
    @NotNull
    public IrConstructor chooseConstructor(@NotNull IrClass implClass, @NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CompilationExceptionKt.compilationException("Should not be called", implClass);
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!IrUtilsKt.isAnnotationClass(declaration)) {
            return declaration;
        }
        LoweringContext loweringContext = this.getContext();
        ReferenceSymbolTable referenceSymbolTable = this.getSymbolTable();
        StringBuilder stringBuilder = new StringBuilder().append('@');
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable(declaration);
        Intrinsics.checkNotNull(fqName);
        AnnotationImplementationMemberGenerator generator = new AnnotationImplementationMemberGenerator(loweringContext, referenceSymbolTable, declaration, stringBuilder.append(fqName.asString()).toString(), this.getForbidDirectFieldAccessInMethods(), (arg_0, arg_1, arg_2, arg_3) -> JsCommonAnnotationImplementationTransformer.visitClassNew$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
        IrSimpleFunction eqFun = null;
        IrOverridableDeclaration hcFun = null;
        IrSimpleFunction toStringFun = null;
        Iterator<IrSimpleFunction> iterator2 = IrUtilsKt.getFunctions(declaration).iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction f2 = iterator2.next();
            if (IrUtilsKt.isEquals(f2)) {
                eqFun = f2;
                continue;
            }
            if (IrUtilsKt.isToString(f2)) {
                toStringFun = f2;
                continue;
            }
            if (!IrUtilsKt.isHashCode(f2)) continue;
            hcFun = f2;
        }
        if (eqFun == null) {
            boolean $i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$42 = false;
            String $i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$42 = "Annotation class has no equals method";
            throw new IllegalStateException($i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$42.toString());
        }
        if (hcFun == null) {
            boolean $i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$52 = false;
            String $i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$52 = "Annotation class has no equals method";
            throw new IllegalStateException($i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$52.toString());
        }
        if (toStringFun == null) {
            boolean $i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$62 = false;
            String $i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$62 = "Annotation class has no equals method";
            throw new IllegalStateException($i$a$-checkNotNull-JsCommonAnnotationImplementationTransformer$visitClassNew$62.toString());
        }
        eqFun.setFakeOverride(false);
        hcFun.setFakeOverride(false);
        toStringFun.setFakeOverride(false);
        IrSimpleType dispatchReceiverType = IrUtilsKt.getDefaultType(declaration);
        IrValueParameter irValueParameter = eqFun.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            irValueParameter.setType(dispatchReceiverType);
        }
        IrValueParameter irValueParameter2 = ((IrFunction)((Object)hcFun)).getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter2.setType(dispatchReceiverType);
        }
        IrValueParameter irValueParameter3 = toStringFun.getDispatchReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter3.setType(dispatchReceiverType);
        }
        this.generateFunctionBodies(declaration, declaration, eqFun, (IrSimpleFunction)hcFun, toStringFun, generator);
        this.addConstructorBodyForCompatibility(declaration);
        return declaration;
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter(type, "type");
        if (IrTypeUtilsKt.isPrimitiveArray(type) || IrTypeUtilsKt.isUnsignedArray(type)) {
            irSimpleFunctionSymbol = this.arraysContentEquals.get(type);
        } else {
            Object v1;
            block5: {
                Iterable $this$singleOrNull$iv = this.arraysContentEquals.entrySet();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    IrType k2 = (IrType)entry.getKey();
                    if (!IrTypePredicatesKt.isArray(k2)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            Map.Entry entry = v1;
            irSimpleFunctionSymbol = entry != null ? (IrSimpleFunctionSymbol)entry.getValue() : null;
        }
        if (irSimpleFunctionSymbol == null) {
            CompilationExceptionKt.compilationException("Can't find an Arrays.contentEquals method for array type", type);
            throw new KotlinNothingValueException();
        }
        return irSimpleFunctionSymbol;
    }

    @Override
    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(annotationClass, "annotationClass");
        Intrinsics.checkNotNullParameter(generatedConstructor, "generatedConstructor");
        CompilationExceptionKt.compilationException("Should not be called", implClass);
        throw new KotlinNothingValueException();
    }

    private static final IrExpression visitClassNew$lambda$0(JsCommonAnnotationImplementationTransformer this$0, IrBlockBodyBuilder $this$AnnotationImplementationMemberGenerator, IrType type, IrExpression a2, IrExpression b2) {
        Intrinsics.checkNotNullParameter($this$AnnotationImplementationMemberGenerator, "$this$AnnotationImplementationMemberGenerator");
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return this$0.generatedEquals($this$AnnotationImplementationMemberGenerator, type, a2, b2);
    }
}

