/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirJavaValueBasedClassUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentityEqualsOnJavaValueBasedClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityOperatorCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmIdentityEqualsOnJavaValueBasedClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmIdentityEqualsOnJavaValueBasedClass.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentityEqualsOnJavaValueBasedClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1#2:41\n1807#3,3:42\n*S KotlinDebug\n*F\n+ 1 FirJvmIdentityEqualsOnJavaValueBasedClass.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentityEqualsOnJavaValueBasedClass\n*L\n29#1:42,3\n*E\n"})
public final class FirJvmIdentityEqualsOnJavaValueBasedClass
extends FirExpressionChecker<FirEqualityOperatorCall> {
    @NotNull
    public static final FirJvmIdentityEqualsOnJavaValueBasedClass INSTANCE = new FirJvmIdentityEqualsOnJavaValueBasedClass();

    private FirJvmIdentityEqualsOnJavaValueBasedClass() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirEqualityOperatorCall expression2) {
        boolean bl;
        List<FirExpression> arguments;
        block8: {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (expression2.getOperation() != FirOperation.IDENTITY && expression2.getOperation() != FirOperation.NOT_IDENTITY) {
                return;
            }
            if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.DisableWarningsForValueBasedJavaClasses)) {
                return;
            }
            arguments = expression2.getArgumentList().getArguments();
            if (!(arguments.size() == 2)) {
                boolean $i$a$-require-FirJvmIdentityEqualsOnJavaValueBasedClass$check$22 = false;
                String $i$a$-require-FirJvmIdentityEqualsOnJavaValueBasedClass$check$22 = "Expected arguments of size 2";
                throw new IllegalArgumentException($i$a$-require-FirJvmIdentityEqualsOnJavaValueBasedClass$check$22.toString());
            }
            Iterable $this$any$iv = arguments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (!ConeBuiltinTypeUtilsKt.isNullableNothing(FirTypeUtilsKt.getResolvedType(it))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (FirExpression arg : arguments) {
            ConeKotlinType type = FirTypeUtilsKt.getResolvedType(arg);
            if (!FirJavaValueBasedClassUtilsKt.isJavaValueBasedClass(type, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)arg.getSource(), FirJvmErrors.INSTANCE.getIDENTITY_SENSITIVE_OPERATIONS_WITH_VALUE_TYPE(), (Object)type, null, 16, null);
        }
    }
}

