/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.opentelemetry.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.kotlin.io.opentelemetry.api.OpenTelemetry;
import org.jetbrains.kotlin.io.opentelemetry.api.internal.ConfigUtil;
import org.jetbrains.kotlin.io.opentelemetry.api.logs.LoggerProvider;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.Meter;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.MeterBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.metrics.MeterProvider;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.Tracer;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.TracerBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.TracerProvider;
import org.jetbrains.kotlin.io.opentelemetry.context.propagation.ContextPropagators;

public final class GlobalOpenTelemetry {
    private static final Logger logger = Logger.getLogger(GlobalOpenTelemetry.class.getName());
    private static final Object mutex = new Object();
    private static volatile ObfuscatedOpenTelemetry globalOpenTelemetry;
    private static Throwable setGlobalCaller;

    private GlobalOpenTelemetry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry get() {
        ObfuscatedOpenTelemetry openTelemetry = globalOpenTelemetry;
        if (openTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                openTelemetry = globalOpenTelemetry;
                if (openTelemetry == null) {
                    OpenTelemetry autoConfigured = GlobalOpenTelemetry.maybeAutoConfigureAndSetGlobal();
                    if (autoConfigured != null) {
                        return autoConfigured;
                    }
                    GlobalOpenTelemetry.set(OpenTelemetry.noop());
                    return OpenTelemetry.noop();
                }
            }
        }
        return openTelemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(OpenTelemetry openTelemetry) {
        Object object = mutex;
        synchronized (object) {
            if (globalOpenTelemetry != null) {
                throw new IllegalStateException("GlobalOpenTelemetry.set has already been called. GlobalOpenTelemetry.set must be called only once before any calls to GlobalOpenTelemetry.get. If you are using the OpenTelemetrySdk, use OpenTelemetrySdkBuilder.buildAndRegisterGlobal instead. Previous invocation set to cause of this exception.", setGlobalCaller);
            }
            globalOpenTelemetry = new ObfuscatedOpenTelemetry(openTelemetry);
            setGlobalCaller = new Throwable();
        }
    }

    public static TracerProvider getTracerProvider() {
        return GlobalOpenTelemetry.get().getTracerProvider();
    }

    public static Tracer getTracer(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationScopeName);
    }

    public static Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return GlobalOpenTelemetry.get().getTracer(instrumentationScopeName, instrumentationScopeVersion);
    }

    public static TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().tracerBuilder(instrumentationScopeName);
    }

    public static MeterProvider getMeterProvider() {
        return GlobalOpenTelemetry.get().getMeterProvider();
    }

    public static Meter getMeter(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().getMeter(instrumentationScopeName);
    }

    public static MeterBuilder meterBuilder(String instrumentationScopeName) {
        return GlobalOpenTelemetry.get().meterBuilder(instrumentationScopeName);
    }

    public static void resetForTest() {
        globalOpenTelemetry = null;
    }

    public static ContextPropagators getPropagators() {
        return GlobalOpenTelemetry.get().getPropagators();
    }

    private static OpenTelemetry maybeAutoConfigureAndSetGlobal() {
        Class<?> openTelemetrySdkAutoConfiguration;
        try {
            openTelemetrySdkAutoConfiguration = Class.forName("org.jetbrains.kotlin.io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk");
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
        boolean globalAutoconfigureEnabled = Boolean.parseBoolean(ConfigUtil.getString("otel.java.global-autoconfigure.enabled", "false"));
        if (!globalAutoconfigureEnabled) {
            logger.log(Level.INFO, "AutoConfiguredOpenTelemetrySdk found on classpath but automatic configuration is disabled. To enable, run your JVM with -Dotel.java.global-autoconfigure.enabled=true");
            return null;
        }
        try {
            Method initialize2 = openTelemetrySdkAutoConfiguration.getMethod("initialize", new Class[0]);
            Object autoConfiguredSdk = initialize2.invoke(null, new Object[0]);
            Method getOpenTelemetrySdk = openTelemetrySdkAutoConfiguration.getMethod("getOpenTelemetrySdk", new Class[0]);
            return new ObfuscatedOpenTelemetry((OpenTelemetry)getOpenTelemetrySdk.invoke(autoConfiguredSdk, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e3) {
            throw new IllegalStateException("AutoConfiguredOpenTelemetrySdk detected on classpath but could not invoke initialize method. This is a bug in OpenTelemetry.", e3);
        }
        catch (InvocationTargetException t2) {
            logger.log(Level.SEVERE, "Error automatically configuring OpenTelemetry SDK. OpenTelemetry will not be enabled.", t2.getTargetException());
            return null;
        }
    }

    static class ObfuscatedOpenTelemetry
    implements OpenTelemetry {
        private final OpenTelemetry delegate;

        ObfuscatedOpenTelemetry(OpenTelemetry delegate) {
            this.delegate = delegate;
        }

        @Override
        public TracerProvider getTracerProvider() {
            return this.delegate.getTracerProvider();
        }

        @Override
        public MeterProvider getMeterProvider() {
            return this.delegate.getMeterProvider();
        }

        @Override
        public LoggerProvider getLogsBridge() {
            return this.delegate.getLogsBridge();
        }

        @Override
        public ContextPropagators getPropagators() {
            return this.delegate.getPropagators();
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }
    }
}

