"""Generated client library for connectgateway version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.connectgateway.v1alpha1 import connectgateway_v1alpha1_messages as messages


class ConnectgatewayV1alpha1(base_api.BaseApiClient):
  """Generated client library for service connectgateway version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://connectgateway.googleapis.com/'
  MTLS_BASE_URL = 'https://connectgateway.mtls.googleapis.com/'

  _PACKAGE = 'connectgateway'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ConnectgatewayV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new connectgateway handle."""
    url = url or self.BASE_URL
    super(ConnectgatewayV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_memberships = self.ProjectsLocationsMembershipsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsMembershipsService(base_api.BaseApiService):
    """Service class for the projects_locations_memberships resource."""

    _NAME = 'projects_locations_memberships'

    def __init__(self, client):
      super(ConnectgatewayV1alpha1.ProjectsLocationsMembershipsService, self).__init__(client)
      self._upload_configs = {
          }

    def GenerateCredentials(self, request, global_params=None):
      r"""GenerateCredentials provides connection information that allows a user to access the specified membership using Connect Gateway.

      Args:
        request: (ConnectgatewayProjectsLocationsMembershipsGenerateCredentialsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateCredentialsResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateCredentials')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateCredentials.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/memberships/{membershipsId}:generateCredentials',
        http_method='GET',
        method_id='connectgateway.projects.locations.memberships.generateCredentials',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['forceUseAgent', 'impersonatedServiceAccount', 'kubernetesNamespace', 'operatingSystem', 'version'],
        relative_path='v1alpha1/{+name}:generateCredentials',
        request_field='',
        request_type_name='ConnectgatewayProjectsLocationsMembershipsGenerateCredentialsRequest',
        response_type_name='GenerateCredentialsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ConnectgatewayV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ConnectgatewayV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
