// Code generated by 'tmplgen'; DO NOT EDIT.

//go:build goexperiment.simd && amd64

// This file contains functions testing unary simd methods.
// Each function in this file is specialized for a
// particular simd type <BaseType><Width>x<Count>.

package simd_test

import (
	"simd/archsimd"
	"testing"
)

// testInt8x16Unary tests the simd unary method f against the expected behavior generated by want
func testInt8x16Unary(t *testing.T, f func(_ archsimd.Int8x16) archsimd.Int8x16, want func(_ []int8) []int8) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8Unary tests the simd unary method f against the expected behavior generated by want
func testInt16x8Unary(t *testing.T, f func(_ archsimd.Int16x8) archsimd.Int16x8, want func(_ []int16) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4Unary tests the simd unary method f against the expected behavior generated by want
func testInt32x4Unary(t *testing.T, f func(_ archsimd.Int32x4) archsimd.Int32x4, want func(_ []int32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2Unary tests the simd unary method f against the expected behavior generated by want
func testInt64x2Unary(t *testing.T, f func(_ archsimd.Int64x2) archsimd.Int64x2, want func(_ []int64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16Unary tests the simd unary method f against the expected behavior generated by want
func testUint8x16Unary(t *testing.T, f func(_ archsimd.Uint8x16) archsimd.Uint8x16, want func(_ []uint8) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8Unary tests the simd unary method f against the expected behavior generated by want
func testUint16x8Unary(t *testing.T, f func(_ archsimd.Uint16x8) archsimd.Uint16x8, want func(_ []uint16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4Unary tests the simd unary method f against the expected behavior generated by want
func testUint32x4Unary(t *testing.T, f func(_ archsimd.Uint32x4) archsimd.Uint32x4, want func(_ []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2Unary tests the simd unary method f against the expected behavior generated by want
func testUint64x2Unary(t *testing.T, f func(_ archsimd.Uint64x2) archsimd.Uint64x2, want func(_ []uint64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4Unary tests the simd unary method f against the expected behavior generated by want
func testFloat32x4Unary(t *testing.T, f func(_ archsimd.Float32x4) archsimd.Float32x4, want func(_ []float32) []float32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2Unary tests the simd unary method f against the expected behavior generated by want
func testFloat64x2Unary(t *testing.T, f func(_ archsimd.Float64x2) archsimd.Float64x2, want func(_ []float64) []float64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32Unary tests the simd unary method f against the expected behavior generated by want
func testInt8x32Unary(t *testing.T, f func(_ archsimd.Int8x32) archsimd.Int8x32, want func(_ []int8) []int8) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16Unary tests the simd unary method f against the expected behavior generated by want
func testInt16x16Unary(t *testing.T, f func(_ archsimd.Int16x16) archsimd.Int16x16, want func(_ []int16) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8Unary tests the simd unary method f against the expected behavior generated by want
func testInt32x8Unary(t *testing.T, f func(_ archsimd.Int32x8) archsimd.Int32x8, want func(_ []int32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4Unary tests the simd unary method f against the expected behavior generated by want
func testInt64x4Unary(t *testing.T, f func(_ archsimd.Int64x4) archsimd.Int64x4, want func(_ []int64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32Unary tests the simd unary method f against the expected behavior generated by want
func testUint8x32Unary(t *testing.T, f func(_ archsimd.Uint8x32) archsimd.Uint8x32, want func(_ []uint8) []uint8) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16Unary tests the simd unary method f against the expected behavior generated by want
func testUint16x16Unary(t *testing.T, f func(_ archsimd.Uint16x16) archsimd.Uint16x16, want func(_ []uint16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8Unary tests the simd unary method f against the expected behavior generated by want
func testUint32x8Unary(t *testing.T, f func(_ archsimd.Uint32x8) archsimd.Uint32x8, want func(_ []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4Unary tests the simd unary method f against the expected behavior generated by want
func testUint64x4Unary(t *testing.T, f func(_ archsimd.Uint64x4) archsimd.Uint64x4, want func(_ []uint64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8Unary tests the simd unary method f against the expected behavior generated by want
func testFloat32x8Unary(t *testing.T, f func(_ archsimd.Float32x8) archsimd.Float32x8, want func(_ []float32) []float32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4Unary tests the simd unary method f against the expected behavior generated by want
func testFloat64x4Unary(t *testing.T, f func(_ archsimd.Float64x4) archsimd.Float64x4, want func(_ []float64) []float64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64Unary tests the simd unary method f against the expected behavior generated by want
func testInt8x64Unary(t *testing.T, f func(_ archsimd.Int8x64) archsimd.Int8x64, want func(_ []int8) []int8) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32Unary tests the simd unary method f against the expected behavior generated by want
func testInt16x32Unary(t *testing.T, f func(_ archsimd.Int16x32) archsimd.Int16x32, want func(_ []int16) []int16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16Unary tests the simd unary method f against the expected behavior generated by want
func testInt32x16Unary(t *testing.T, f func(_ archsimd.Int32x16) archsimd.Int32x16, want func(_ []int32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8Unary tests the simd unary method f against the expected behavior generated by want
func testInt64x8Unary(t *testing.T, f func(_ archsimd.Int64x8) archsimd.Int64x8, want func(_ []int64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64Unary tests the simd unary method f against the expected behavior generated by want
func testUint8x64Unary(t *testing.T, f func(_ archsimd.Uint8x64) archsimd.Uint8x64, want func(_ []uint8) []uint8) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32Unary tests the simd unary method f against the expected behavior generated by want
func testUint16x32Unary(t *testing.T, f func(_ archsimd.Uint16x32) archsimd.Uint16x32, want func(_ []uint16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16Unary tests the simd unary method f against the expected behavior generated by want
func testUint32x16Unary(t *testing.T, f func(_ archsimd.Uint32x16) archsimd.Uint32x16, want func(_ []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8Unary tests the simd unary method f against the expected behavior generated by want
func testUint64x8Unary(t *testing.T, f func(_ archsimd.Uint64x8) archsimd.Uint64x8, want func(_ []uint64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16Unary tests the simd unary method f against the expected behavior generated by want
func testFloat32x16Unary(t *testing.T, f func(_ archsimd.Float32x16) archsimd.Float32x16, want func(_ []float32) []float32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8Unary tests the simd unary method f against the expected behavior generated by want
func testFloat64x8Unary(t *testing.T, f func(_ archsimd.Float64x8) archsimd.Float64x8, want func(_ []float64) []float64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToInt8(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int8x16, want func(x []int8) []int8) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToInt8(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int8x16, want func(x []int16) []int8) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToInt8(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int8x16, want func(x []int32) []int8) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToInt8(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int8x16, want func(x []int64) []int8) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToInt8(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int8x16, want func(x []uint8) []int8) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToInt8(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int8x16, want func(x []uint16) []int8) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToInt8(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int8x16, want func(x []uint32) []int8) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToInt8(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int8x16, want func(x []uint64) []int8) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToInt8(t *testing.T, f func(x archsimd.Float32x4) archsimd.Int8x16, want func(x []float32) []int8) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToInt8(t *testing.T, f func(x archsimd.Float64x2) archsimd.Int8x16, want func(x []float64) []int8) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToInt8(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int8x32, want func(x []int8) []int8) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToInt8(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int8x16, want func(x []int16) []int8) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToInt8(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int8x16, want func(x []int32) []int8) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToInt8(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int8x16, want func(x []int64) []int8) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToInt8(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int8x32, want func(x []uint8) []int8) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToInt8(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int8x16, want func(x []uint16) []int8) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToInt8(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int8x16, want func(x []uint32) []int8) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToInt8(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int8x16, want func(x []uint64) []int8) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToInt8(t *testing.T, f func(x archsimd.Float32x8) archsimd.Int8x16, want func(x []float32) []int8) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToInt8(t *testing.T, f func(x archsimd.Float64x4) archsimd.Int8x16, want func(x []float64) []int8) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToInt8(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int8x64, want func(x []int8) []int8) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int8, 64)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToInt8(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int8x32, want func(x []int16) []int8) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToInt8(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int8x16, want func(x []int32) []int8) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToInt8(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int8x16, want func(x []int64) []int8) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToInt8(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int8x64, want func(x []uint8) []int8) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int8, 64)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToInt8(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int8x32, want func(x []uint16) []int8) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToInt8(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int8x16, want func(x []uint32) []int8) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToInt8(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int8x16, want func(x []uint64) []int8) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToInt8(t *testing.T, f func(x archsimd.Float32x16) archsimd.Int8x16, want func(x []float32) []int8) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToInt8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToInt8(t *testing.T, f func(x archsimd.Float64x8) archsimd.Int8x16, want func(x []float64) []int8) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]int8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToUint8(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint8x16, want func(x []int8) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToUint8(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint8x16, want func(x []int16) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToUint8(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint8x16, want func(x []int32) []uint8) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToUint8(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint8x16, want func(x []int64) []uint8) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToUint8(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint8x16, want func(x []uint8) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToUint8(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint8x16, want func(x []uint16) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToUint8(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint8x16, want func(x []uint32) []uint8) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToUint8(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint8x16, want func(x []uint64) []uint8) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToUint8(t *testing.T, f func(x archsimd.Float32x4) archsimd.Uint8x16, want func(x []float32) []uint8) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToUint8(t *testing.T, f func(x archsimd.Float64x2) archsimd.Uint8x16, want func(x []float64) []uint8) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToUint8(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint8x32, want func(x []int8) []uint8) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToUint8(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint8x16, want func(x []int16) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToUint8(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint8x16, want func(x []int32) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToUint8(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint8x16, want func(x []int64) []uint8) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToUint8(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint8x32, want func(x []uint8) []uint8) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToUint8(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint8x16, want func(x []uint16) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToUint8(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint8x16, want func(x []uint32) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToUint8(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint8x16, want func(x []uint64) []uint8) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToUint8(t *testing.T, f func(x archsimd.Float32x8) archsimd.Uint8x16, want func(x []float32) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToUint8(t *testing.T, f func(x archsimd.Float64x4) archsimd.Uint8x16, want func(x []float64) []uint8) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToUint8(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint8x64, want func(x []int8) []uint8) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint8, 64)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToUint8(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint8x32, want func(x []int16) []uint8) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToUint8(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint8x16, want func(x []int32) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToUint8(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint8x16, want func(x []int64) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToUint8(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint8x64, want func(x []uint8) []uint8) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint8, 64)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToUint8(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint8x32, want func(x []uint16) []uint8) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint8, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToUint8(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint8x16, want func(x []uint32) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToUint8(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint8x16, want func(x []uint64) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToUint8(t *testing.T, f func(x archsimd.Float32x16) archsimd.Uint8x16, want func(x []float32) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToUint8 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToUint8(t *testing.T, f func(x archsimd.Float64x8) archsimd.Uint8x16, want func(x []float64) []uint8) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]uint8, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToInt16(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int16x16, want func(x []int8) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToInt16(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int16x8, want func(x []int16) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToInt16(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int16x8, want func(x []int32) []int16) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToInt16(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int16x8, want func(x []int64) []int16) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToInt16(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int16x16, want func(x []uint8) []int16) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToInt16(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int16x8, want func(x []uint16) []int16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToInt16(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int16x8, want func(x []uint32) []int16) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToInt16(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int16x8, want func(x []uint64) []int16) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToInt16(t *testing.T, f func(x archsimd.Float32x4) archsimd.Int16x8, want func(x []float32) []int16) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToInt16(t *testing.T, f func(x archsimd.Float64x2) archsimd.Int16x8, want func(x []float64) []int16) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToInt16(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int16x32, want func(x []int8) []int16) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToInt16(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int16x16, want func(x []int16) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToInt16(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int16x8, want func(x []int32) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToInt16(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int16x8, want func(x []int64) []int16) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToInt16(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int16x32, want func(x []uint8) []int16) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToInt16(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int16x16, want func(x []uint16) []int16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToInt16(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int16x8, want func(x []uint32) []int16) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToInt16(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int16x8, want func(x []uint64) []int16) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToInt16(t *testing.T, f func(x archsimd.Float32x8) archsimd.Int16x8, want func(x []float32) []int16) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToInt16(t *testing.T, f func(x archsimd.Float64x4) archsimd.Int16x8, want func(x []float64) []int16) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToInt16(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int16x32, want func(x []int8) []int16) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToInt16(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int16x32, want func(x []int16) []int16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToInt16(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int16x16, want func(x []int32) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToInt16(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int16x8, want func(x []int64) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToInt16(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int16x32, want func(x []uint8) []int16) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToInt16(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int16x32, want func(x []uint16) []int16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToInt16(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int16x16, want func(x []uint32) []int16) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToInt16(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int16x8, want func(x []uint64) []int16) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToInt16(t *testing.T, f func(x archsimd.Float32x16) archsimd.Int16x16, want func(x []float32) []int16) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]int16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToInt16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToInt16(t *testing.T, f func(x archsimd.Float64x8) archsimd.Int16x8, want func(x []float64) []int16) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToUint16(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint16x16, want func(x []int8) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToUint16(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint16x8, want func(x []int16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToUint16(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint16x8, want func(x []int32) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToUint16(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToUint16(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint16x16, want func(x []uint8) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToUint16(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint16x8, want func(x []uint16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToUint16(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint16x8, want func(x []uint32) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToUint16(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToUint16(t *testing.T, f func(x archsimd.Float32x4) archsimd.Uint16x8, want func(x []float32) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToUint16(t *testing.T, f func(x archsimd.Float64x2) archsimd.Uint16x8, want func(x []float64) []uint16) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToUint16(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint16x32, want func(x []int8) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToUint16(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint16x16, want func(x []int16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToUint16(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint16x8, want func(x []int32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToUint16(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToUint16(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint16x32, want func(x []uint8) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToUint16(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint16x16, want func(x []uint16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToUint16(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint16x8, want func(x []uint32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToUint16(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToUint16(t *testing.T, f func(x archsimd.Float32x8) archsimd.Uint16x8, want func(x []float32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToUint16(t *testing.T, f func(x archsimd.Float64x4) archsimd.Uint16x8, want func(x []float64) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToUint16(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint16x32, want func(x []int8) []uint16) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToUint16(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint16x32, want func(x []int16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToUint16(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint16x16, want func(x []int32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToUint16(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToUint16(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint16x32, want func(x []uint8) []uint16) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToUint16(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint16x32, want func(x []uint16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint16, 32)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToUint16(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint16x16, want func(x []uint32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToUint16(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToUint16(t *testing.T, f func(x archsimd.Float32x16) archsimd.Uint16x16, want func(x []float32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]uint16, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToUint16(t *testing.T, f func(x archsimd.Float64x8) archsimd.Uint16x8, want func(x []float64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToInt32(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int32x16, want func(x []int8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToInt32(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int32x8, want func(x []int16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToInt32(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int32x4, want func(x []int32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToInt32(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int32x4, want func(x []int64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToInt32(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int32x16, want func(x []uint8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToInt32(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int32x8, want func(x []uint16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToInt32(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int32x4, want func(x []uint32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToInt32(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int32x4, want func(x []uint64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToInt32(t *testing.T, f func(x archsimd.Float32x4) archsimd.Int32x4, want func(x []float32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToInt32(t *testing.T, f func(x archsimd.Float64x2) archsimd.Int32x4, want func(x []float64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToInt32(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int32x16, want func(x []int8) []int32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToInt32(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int32x16, want func(x []int16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToInt32(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int32x8, want func(x []int32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToInt32(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int32x4, want func(x []int64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToInt32(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int32x16, want func(x []uint8) []int32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToInt32(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int32x16, want func(x []uint16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToInt32(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int32x8, want func(x []uint32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToInt32(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int32x4, want func(x []uint64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToInt32(t *testing.T, f func(x archsimd.Float32x8) archsimd.Int32x8, want func(x []float32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToInt32(t *testing.T, f func(x archsimd.Float64x4) archsimd.Int32x4, want func(x []float64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToInt32(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int32x16, want func(x []int8) []int32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToInt32(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int32x16, want func(x []int16) []int32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToInt32(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int32x16, want func(x []int32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToInt32(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int32x8, want func(x []int64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToInt32(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int32x16, want func(x []uint8) []int32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToInt32(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int32x16, want func(x []uint16) []int32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToInt32(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int32x16, want func(x []uint32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToInt32(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int32x8, want func(x []uint64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToInt32(t *testing.T, f func(x archsimd.Float32x16) archsimd.Int32x16, want func(x []float32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]int32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToInt32(t *testing.T, f func(x archsimd.Float64x8) archsimd.Int32x8, want func(x []float64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToUint32(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint32x16, want func(x []int8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToUint32(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint32x8, want func(x []int16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToUint32(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint32x4, want func(x []int32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToUint32(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint32x4, want func(x []int64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToUint32(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint32x16, want func(x []uint8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToUint32(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint32x8, want func(x []uint16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToUint32(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint32x4, want func(x []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToUint32(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint32x4, want func(x []uint64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToUint32(t *testing.T, f func(x archsimd.Float32x4) archsimd.Uint32x4, want func(x []float32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToUint32(t *testing.T, f func(x archsimd.Float64x2) archsimd.Uint32x4, want func(x []float64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToUint32(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint32x16, want func(x []int8) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToUint32(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint32x16, want func(x []int16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToUint32(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint32x8, want func(x []int32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToUint32(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint32x4, want func(x []int64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToUint32(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint32x16, want func(x []uint8) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToUint32(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint32x16, want func(x []uint16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToUint32(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint32x8, want func(x []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToUint32(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint32x4, want func(x []uint64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToUint32(t *testing.T, f func(x archsimd.Float32x8) archsimd.Uint32x8, want func(x []float32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToUint32(t *testing.T, f func(x archsimd.Float64x4) archsimd.Uint32x4, want func(x []float64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToUint32(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint32x16, want func(x []int8) []uint32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToUint32(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint32x16, want func(x []int16) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToUint32(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint32x16, want func(x []int32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToUint32(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint32x8, want func(x []int64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToUint32(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint32x16, want func(x []uint8) []uint32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToUint32(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint32x16, want func(x []uint16) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToUint32(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint32x16, want func(x []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToUint32(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint32x8, want func(x []uint64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToUint32(t *testing.T, f func(x archsimd.Float32x16) archsimd.Uint32x16, want func(x []float32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]uint32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToUint32(t *testing.T, f func(x archsimd.Float64x8) archsimd.Uint32x8, want func(x []float64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToInt64(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int64x8, want func(x []int8) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToInt64(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int64x8, want func(x []int16) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToInt64(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int64x4, want func(x []int32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToInt64(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int64x2, want func(x []int64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToInt64(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int64x8, want func(x []uint8) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToInt64(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int64x8, want func(x []uint16) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToInt64(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int64x4, want func(x []uint32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToInt64(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int64x2, want func(x []uint64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToInt64(t *testing.T, f func(x archsimd.Float32x4) archsimd.Int64x4, want func(x []float32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToInt64(t *testing.T, f func(x archsimd.Float64x2) archsimd.Int64x2, want func(x []float64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToInt64(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int64x8, want func(x []int8) []int64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToInt64(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int64x8, want func(x []int16) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToInt64(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int64x8, want func(x []int32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToInt64(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int64x4, want func(x []int64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToInt64(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int64x8, want func(x []uint8) []int64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToInt64(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int64x8, want func(x []uint16) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToInt64(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int64x8, want func(x []uint32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToInt64(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int64x4, want func(x []uint64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToInt64(t *testing.T, f func(x archsimd.Float32x8) archsimd.Int64x8, want func(x []float32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToInt64(t *testing.T, f func(x archsimd.Float64x4) archsimd.Int64x4, want func(x []float64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToInt64(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int64x8, want func(x []int8) []int64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToInt64(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int64x8, want func(x []int16) []int64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToInt64(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int64x8, want func(x []int32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToInt64(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int64x8, want func(x []int64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToInt64(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int64x8, want func(x []uint8) []int64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToInt64(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int64x8, want func(x []uint16) []int64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToInt64(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int64x8, want func(x []uint32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToInt64(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int64x8, want func(x []uint64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToInt64(t *testing.T, f func(x archsimd.Float32x16) archsimd.Int64x8, want func(x []float32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToInt64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToInt64(t *testing.T, f func(x archsimd.Float64x8) archsimd.Int64x8, want func(x []float64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]int64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToUint64(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint64x8, want func(x []int8) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToUint64(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint64x8, want func(x []int16) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToUint64(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint64x4, want func(x []int32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToUint64(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint64x2, want func(x []int64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToUint64(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint64x8, want func(x []uint8) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToUint64(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint64x8, want func(x []uint16) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToUint64(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint64x4, want func(x []uint32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToUint64(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint64x2, want func(x []uint64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToUint64(t *testing.T, f func(x archsimd.Float32x4) archsimd.Uint64x4, want func(x []float32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToUint64(t *testing.T, f func(x archsimd.Float64x2) archsimd.Uint64x2, want func(x []float64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToUint64(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint64x8, want func(x []int8) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToUint64(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint64x8, want func(x []int16) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToUint64(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint64x8, want func(x []int32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToUint64(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint64x4, want func(x []int64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToUint64(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint64x8, want func(x []uint8) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToUint64(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint64x8, want func(x []uint16) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToUint64(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint64x8, want func(x []uint32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToUint64(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint64x4, want func(x []uint64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToUint64(t *testing.T, f func(x archsimd.Float32x8) archsimd.Uint64x8, want func(x []float32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToUint64(t *testing.T, f func(x archsimd.Float64x4) archsimd.Uint64x4, want func(x []float64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToUint64(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint64x8, want func(x []int8) []uint64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToUint64(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint64x8, want func(x []int16) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToUint64(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint64x8, want func(x []int32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToUint64(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint64x8, want func(x []int64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToUint64(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint64x8, want func(x []uint8) []uint64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToUint64(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint64x8, want func(x []uint16) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToUint64(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint64x8, want func(x []uint32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToUint64(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint64x8, want func(x []uint64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToUint64(t *testing.T, f func(x archsimd.Float32x16) archsimd.Uint64x8, want func(x []float32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToUint64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToUint64(t *testing.T, f func(x archsimd.Float64x8) archsimd.Uint64x8, want func(x []float64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]uint64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToFloat32(t *testing.T, f func(x archsimd.Int8x16) archsimd.Float32x16, want func(x []int8) []float32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToFloat32(t *testing.T, f func(x archsimd.Int16x8) archsimd.Float32x8, want func(x []int16) []float32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToFloat32(t *testing.T, f func(x archsimd.Int32x4) archsimd.Float32x4, want func(x []int32) []float32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToFloat32(t *testing.T, f func(x archsimd.Int64x2) archsimd.Float32x4, want func(x []int64) []float32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToFloat32(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Float32x16, want func(x []uint8) []float32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToFloat32(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Float32x8, want func(x []uint16) []float32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToFloat32(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Float32x4, want func(x []uint32) []float32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToFloat32(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Float32x4, want func(x []uint64) []float32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToFloat32(t *testing.T, f func(x archsimd.Float32x4) archsimd.Float32x4, want func(x []float32) []float32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToFloat32(t *testing.T, f func(x archsimd.Float64x2) archsimd.Float32x4, want func(x []float64) []float32) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToFloat32(t *testing.T, f func(x archsimd.Int8x32) archsimd.Float32x16, want func(x []int8) []float32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToFloat32(t *testing.T, f func(x archsimd.Int16x16) archsimd.Float32x16, want func(x []int16) []float32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToFloat32(t *testing.T, f func(x archsimd.Int32x8) archsimd.Float32x8, want func(x []int32) []float32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToFloat32(t *testing.T, f func(x archsimd.Int64x4) archsimd.Float32x4, want func(x []int64) []float32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToFloat32(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Float32x16, want func(x []uint8) []float32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToFloat32(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Float32x16, want func(x []uint16) []float32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToFloat32(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Float32x8, want func(x []uint32) []float32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToFloat32(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Float32x4, want func(x []uint64) []float32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToFloat32(t *testing.T, f func(x archsimd.Float32x8) archsimd.Float32x8, want func(x []float32) []float32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToFloat32(t *testing.T, f func(x archsimd.Float64x4) archsimd.Float32x4, want func(x []float64) []float32) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]float32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToFloat32(t *testing.T, f func(x archsimd.Int8x64) archsimd.Float32x16, want func(x []int8) []float32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToFloat32(t *testing.T, f func(x archsimd.Int16x32) archsimd.Float32x16, want func(x []int16) []float32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToFloat32(t *testing.T, f func(x archsimd.Int32x16) archsimd.Float32x16, want func(x []int32) []float32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToFloat32(t *testing.T, f func(x archsimd.Int64x8) archsimd.Float32x8, want func(x []int64) []float32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToFloat32(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Float32x16, want func(x []uint8) []float32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToFloat32(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Float32x16, want func(x []uint16) []float32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToFloat32(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Float32x16, want func(x []uint32) []float32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToFloat32(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Float32x8, want func(x []uint64) []float32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToFloat32(t *testing.T, f func(x archsimd.Float32x16) archsimd.Float32x16, want func(x []float32) []float32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]float32, 16)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToFloat32 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToFloat32(t *testing.T, f func(x archsimd.Float64x8) archsimd.Float32x8, want func(x []float64) []float32) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]float32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x16ConvertToFloat64(t *testing.T, f func(x archsimd.Int8x16) archsimd.Float64x8, want func(x []int8) []float64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x8ConvertToFloat64(t *testing.T, f func(x archsimd.Int16x8) archsimd.Float64x8, want func(x []int16) []float64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x4ConvertToFloat64(t *testing.T, f func(x archsimd.Int32x4) archsimd.Float64x4, want func(x []int32) []float64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]float64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x2ConvertToFloat64(t *testing.T, f func(x archsimd.Int64x2) archsimd.Float64x2, want func(x []int64) []float64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]float64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x16ConvertToFloat64(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Float64x8, want func(x []uint8) []float64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x8ConvertToFloat64(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Float64x8, want func(x []uint16) []float64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x4ConvertToFloat64(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Float64x4, want func(x []uint32) []float64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]float64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x2ConvertToFloat64(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Float64x2, want func(x []uint64) []float64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]float64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x4ConvertToFloat64(t *testing.T, f func(x archsimd.Float32x4) archsimd.Float64x4, want func(x []float32) []float64) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]float64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x2ConvertToFloat64(t *testing.T, f func(x archsimd.Float64x2) archsimd.Float64x2, want func(x []float64) []float64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]float64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x32ConvertToFloat64(t *testing.T, f func(x archsimd.Int8x32) archsimd.Float64x8, want func(x []int8) []float64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x16ConvertToFloat64(t *testing.T, f func(x archsimd.Int16x16) archsimd.Float64x8, want func(x []int16) []float64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x8ConvertToFloat64(t *testing.T, f func(x archsimd.Int32x8) archsimd.Float64x8, want func(x []int32) []float64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x4ConvertToFloat64(t *testing.T, f func(x archsimd.Int64x4) archsimd.Float64x4, want func(x []int64) []float64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]float64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x32ConvertToFloat64(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Float64x8, want func(x []uint8) []float64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x16ConvertToFloat64(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Float64x8, want func(x []uint16) []float64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x8ConvertToFloat64(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Float64x8, want func(x []uint32) []float64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x4ConvertToFloat64(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Float64x4, want func(x []uint64) []float64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]float64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x8ConvertToFloat64(t *testing.T, f func(x archsimd.Float32x8) archsimd.Float64x8, want func(x []float32) []float64) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x4ConvertToFloat64(t *testing.T, f func(x archsimd.Float64x4) archsimd.Float64x4, want func(x []float64) []float64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]float64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt8x64ConvertToFloat64(t *testing.T, f func(x archsimd.Int8x64) archsimd.Float64x8, want func(x []int8) []float64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt16x32ConvertToFloat64(t *testing.T, f func(x archsimd.Int16x32) archsimd.Float64x8, want func(x []int16) []float64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt32x16ConvertToFloat64(t *testing.T, f func(x archsimd.Int32x16) archsimd.Float64x8, want func(x []int32) []float64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testInt64x8ConvertToFloat64(t *testing.T, f func(x archsimd.Int64x8) archsimd.Float64x8, want func(x []int64) []float64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint8x64ConvertToFloat64(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Float64x8, want func(x []uint8) []float64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint16x32ConvertToFloat64(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Float64x8, want func(x []uint16) []float64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint32x16ConvertToFloat64(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Float64x8, want func(x []uint32) []float64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testUint64x8ConvertToFloat64(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Float64x8, want func(x []uint64) []float64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat32x16ConvertToFloat64(t *testing.T, f func(x archsimd.Float32x16) archsimd.Float64x8, want func(x []float32) []float64) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToFloat64 tests the simd conversion method f against the expected behavior generated by want.
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width,
// (extended to at least 128 bits, or truncated to at most 512 bits).
func testFloat64x8ConvertToFloat64(t *testing.T, f func(x archsimd.Float64x8) archsimd.Float64x8, want func(x []float64) []float64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]float64, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt8x16ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int64x2, want func(x []int8) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt16x8ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int64x2, want func(x []int16) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt32x4ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int64x2, want func(x []int32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt64x2ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int64x2, want func(x []int64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint8x16ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int64x2, want func(x []uint8) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint16x8ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int64x2, want func(x []uint16) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint32x4ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int64x2, want func(x []uint32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint64x2ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int64x2, want func(x []uint64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt8x32ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int64x2, want func(x []int8) []int64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt16x16ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int64x2, want func(x []int16) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt32x8ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int64x2, want func(x []int32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt64x4ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int64x2, want func(x []int64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint8x32ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int64x2, want func(x []uint8) []int64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint16x16ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int64x2, want func(x []uint16) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint32x8ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int64x2, want func(x []uint32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint64x4ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int64x2, want func(x []uint64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt8x64ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int64x2, want func(x []int8) []int64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt16x32ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int64x2, want func(x []int16) []int64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt32x16ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int64x2, want func(x []int32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt64x8ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int64x2, want func(x []int64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint8x64ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int64x2, want func(x []uint8) []int64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint16x32ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int64x2, want func(x []uint16) []int64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint32x16ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int64x2, want func(x []uint32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToInt64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint64x8ConvertLoToInt64x2(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int64x2, want func(x []uint64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x16ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int64x4, want func(x []int8) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x8ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int64x4, want func(x []int16) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x4ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int64x4, want func(x []int32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x2ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int64x4, want func(x []int64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x16ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int64x4, want func(x []uint8) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x8ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int64x4, want func(x []uint16) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x4ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int64x4, want func(x []uint32) []int64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x2ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int64x4, want func(x []uint64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x32ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int64x4, want func(x []int8) []int64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x16ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int64x4, want func(x []int16) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x8ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int64x4, want func(x []int32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x4ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int64x4, want func(x []int64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x32ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int64x4, want func(x []uint8) []int64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x16ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int64x4, want func(x []uint16) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x8ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int64x4, want func(x []uint32) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x4ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int64x4, want func(x []uint64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x64ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int64x4, want func(x []int8) []int64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x32ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int64x4, want func(x []int16) []int64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x16ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int64x4, want func(x []int32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x8ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int64x4, want func(x []int64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x64ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int64x4, want func(x []uint8) []int64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x32ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int64x4, want func(x []uint16) []int64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x16ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int64x4, want func(x []uint32) []int64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToInt64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x8ConvertLoToInt64x4(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int64x4, want func(x []uint64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt8x16ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint64x2, want func(x []int8) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt16x8ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint64x2, want func(x []int16) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt32x4ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint64x2, want func(x []int32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt64x2ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint64x2, want func(x []int64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint8x16ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint64x2, want func(x []uint8) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint16x8ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint64x2, want func(x []uint16) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint32x4ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint64x2, want func(x []uint32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint64x2ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint64x2, want func(x []uint64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt8x32ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint64x2, want func(x []int8) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt16x16ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint64x2, want func(x []int16) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt32x8ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint64x2, want func(x []int32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt64x4ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint64x2, want func(x []int64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint8x32ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint64x2, want func(x []uint8) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint16x16ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint64x2, want func(x []uint16) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint32x8ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint64x2, want func(x []uint32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint64x4ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint64x2, want func(x []uint64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt8x64ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint64x2, want func(x []int8) []uint64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt16x32ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint64x2, want func(x []int16) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt32x16ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint64x2, want func(x []int32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testInt64x8ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint64x2, want func(x []int64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint8x64ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint64x2, want func(x []uint8) []uint64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint16x32ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint64x2, want func(x []uint16) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint32x16ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint64x2, want func(x []uint32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToUint64x2 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 2 elements.
func testUint64x8ConvertLoToUint64x2(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint64x2, want func(x []uint64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint64, 2)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x16ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint64x4, want func(x []int8) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x8ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint64x4, want func(x []int16) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x4ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint64x4, want func(x []int32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x2ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint64x4, want func(x []int64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x16ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint64x4, want func(x []uint8) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x8ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint64x4, want func(x []uint16) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x4ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint64x4, want func(x []uint32) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x2ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint64x4, want func(x []uint64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x32ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint64x4, want func(x []int8) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x16ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint64x4, want func(x []int16) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x8ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint64x4, want func(x []int32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x4ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint64x4, want func(x []int64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x32ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint64x4, want func(x []uint8) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x16ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint64x4, want func(x []uint16) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x8ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint64x4, want func(x []uint32) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x4ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint64x4, want func(x []uint64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x64ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint64x4, want func(x []int8) []uint64) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x32ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint64x4, want func(x []int16) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x16ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint64x4, want func(x []int32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x8ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint64x4, want func(x []int64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x64ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint64x4, want func(x []uint8) []uint64) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x32ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint64x4, want func(x []uint16) []uint64) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x16ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint64x4, want func(x []uint32) []uint64) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToUint64x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x8ConvertLoToUint64x4(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint64x4, want func(x []uint64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint64, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x16ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int32x4, want func(x []int8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x8ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int32x4, want func(x []int16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x4ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int32x4, want func(x []int32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x2ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int32x4, want func(x []int64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x16ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int32x4, want func(x []uint8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x8ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int32x4, want func(x []uint16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x4ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int32x4, want func(x []uint32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x2ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int32x4, want func(x []uint64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x32ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int32x4, want func(x []int8) []int32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x16ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int32x4, want func(x []int16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x8ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int32x4, want func(x []int32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x4ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int32x4, want func(x []int64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x32ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int32x4, want func(x []uint8) []int32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x16ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int32x4, want func(x []uint16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x8ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int32x4, want func(x []uint32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x4ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int32x4, want func(x []uint64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x64ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int32x4, want func(x []int8) []int32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x32ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int32x4, want func(x []int16) []int32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x16ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int32x4, want func(x []int32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x8ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int32x4, want func(x []int64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x64ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int32x4, want func(x []uint8) []int32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x32ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int32x4, want func(x []uint16) []int32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x16ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int32x4, want func(x []uint32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToInt32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x8ConvertLoToInt32x4(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int32x4, want func(x []uint64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x16ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int32x8, want func(x []int8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x8ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int32x8, want func(x []int16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x4ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int32x8, want func(x []int32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x2ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int32x8, want func(x []int64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x16ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int32x8, want func(x []uint8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x8ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int32x8, want func(x []uint16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x4ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int32x8, want func(x []uint32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x2ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int32x8, want func(x []uint64) []int32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x32ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int32x8, want func(x []int8) []int32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x16ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int32x8, want func(x []int16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x8ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int32x8, want func(x []int32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x4ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int32x8, want func(x []int64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x32ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int32x8, want func(x []uint8) []int32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x16ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int32x8, want func(x []uint16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x8ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int32x8, want func(x []uint32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x4ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int32x8, want func(x []uint64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x64ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int32x8, want func(x []int8) []int32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x32ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int32x8, want func(x []int16) []int32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x16ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int32x8, want func(x []int32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x8ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int32x8, want func(x []int64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x64ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int32x8, want func(x []uint8) []int32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x32ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int32x8, want func(x []uint16) []int32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x16ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int32x8, want func(x []uint32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToInt32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x8ConvertLoToInt32x8(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int32x8, want func(x []uint64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x16ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint32x4, want func(x []int8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x8ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint32x4, want func(x []int16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x4ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint32x4, want func(x []int32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x2ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint32x4, want func(x []int64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x16ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint32x4, want func(x []uint8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x8ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint32x4, want func(x []uint16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x4ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint32x4, want func(x []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x2ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint32x4, want func(x []uint64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x32ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint32x4, want func(x []int8) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x16ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint32x4, want func(x []int16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x8ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint32x4, want func(x []int32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x4ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint32x4, want func(x []int64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x32ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint32x4, want func(x []uint8) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x16ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint32x4, want func(x []uint16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x8ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint32x4, want func(x []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x4ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint32x4, want func(x []uint64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt8x64ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint32x4, want func(x []int8) []uint32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt16x32ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint32x4, want func(x []int16) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt32x16ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint32x4, want func(x []int32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testInt64x8ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint32x4, want func(x []int64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint8x64ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint32x4, want func(x []uint8) []uint32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint16x32ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint32x4, want func(x []uint16) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint32x16ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint32x4, want func(x []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToUint32x4 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 4 elements.
func testUint64x8ConvertLoToUint32x4(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint32x4, want func(x []uint64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint32, 4)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x16ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint32x8, want func(x []int8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x8ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint32x8, want func(x []int16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x4ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint32x8, want func(x []int32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x2ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint32x8, want func(x []int64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x16ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint32x8, want func(x []uint8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x8ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint32x8, want func(x []uint16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x4ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint32x8, want func(x []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x2ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint32x8, want func(x []uint64) []uint32) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x32ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint32x8, want func(x []int8) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x16ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint32x8, want func(x []int16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x8ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint32x8, want func(x []int32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x4ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint32x8, want func(x []int64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x32ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint32x8, want func(x []uint8) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x16ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint32x8, want func(x []uint16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x8ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint32x8, want func(x []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x4ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint32x8, want func(x []uint64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x64ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint32x8, want func(x []int8) []uint32) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x32ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint32x8, want func(x []int16) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x16ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint32x8, want func(x []int32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x8ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint32x8, want func(x []int64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x64ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint32x8, want func(x []uint8) []uint32) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x32ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint32x8, want func(x []uint16) []uint32) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x16ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint32x8, want func(x []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToUint32x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x8ConvertLoToUint32x8(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint32x8, want func(x []uint64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint32, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x16ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int16x8, want func(x []int8) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x8ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int16x8, want func(x []int16) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x4ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int16x8, want func(x []int32) []int16) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x2ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int64x2) archsimd.Int16x8, want func(x []int64) []int16) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x16ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int16x8, want func(x []uint8) []int16) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x8ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int16x8, want func(x []uint16) []int16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x4ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int16x8, want func(x []uint32) []int16) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x2ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Int16x8, want func(x []uint64) []int16) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x32ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int8x32) archsimd.Int16x8, want func(x []int8) []int16) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x16ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int16x8, want func(x []int16) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x8ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int16x8, want func(x []int32) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x4ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int16x8, want func(x []int64) []int16) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x32ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Int16x8, want func(x []uint8) []int16) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x16ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int16x8, want func(x []uint16) []int16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x8ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int16x8, want func(x []uint32) []int16) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x4ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int16x8, want func(x []uint64) []int16) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x64ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int8x64) archsimd.Int16x8, want func(x []int8) []int16) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x32ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int16x32) archsimd.Int16x8, want func(x []int16) []int16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x16ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int16x8, want func(x []int32) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x8ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int16x8, want func(x []int64) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x64ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Int16x8, want func(x []uint8) []int16) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x32ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Int16x8, want func(x []uint16) []int16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x16ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int16x8, want func(x []uint32) []int16) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToInt16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x8ConvertLoToInt16x8(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int16x8, want func(x []uint64) []int16) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x16ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint16x8, want func(x []int8) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x8ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint16x8, want func(x []int16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x4ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint16x8, want func(x []int32) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x2ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int64x2) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x16ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint16x8, want func(x []uint8) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x8ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint16x8, want func(x []uint16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x4ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint16x8, want func(x []uint32) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x2ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint64x2) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x32ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint16x8, want func(x []int8) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x16ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint16x8, want func(x []int16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x8ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint16x8, want func(x []int32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x4ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x32ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint16x8, want func(x []uint8) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x16ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint16x8, want func(x []uint16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x8ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint16x8, want func(x []uint32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x4ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt8x64ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int8x64) archsimd.Uint16x8, want func(x []int8) []uint16) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt16x32ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint16x8, want func(x []int16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt32x16ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint16x8, want func(x []int32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testInt64x8ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint8x64ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint8x64) archsimd.Uint16x8, want func(x []uint8) []uint16) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint16x32ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint16x8, want func(x []uint16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint32x16ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint16x8, want func(x []uint32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertLoToUint16x8 tests the simd conversion method f against the expected behavior generated by want.
// This converts only the low 8 elements.
func testUint64x8ConvertLoToUint16x8(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint16, 8)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat32x4UnaryFlaky(t *testing.T, f func(x archsimd.Float32x4) archsimd.Float32x4, want func(x []float32) []float32, flakiness float64) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat64x2UnaryFlaky(t *testing.T, f func(x archsimd.Float64x2) archsimd.Float64x2, want func(x []float64) []float64, flakiness float64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat32x8UnaryFlaky(t *testing.T, f func(x archsimd.Float32x8) archsimd.Float32x8, want func(x []float32) []float32, flakiness float64) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat64x4UnaryFlaky(t *testing.T, f func(x archsimd.Float64x4) archsimd.Float64x4, want func(x []float64) []float64, flakiness float64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat32x16UnaryFlaky(t *testing.T, f func(x archsimd.Float32x16) archsimd.Float32x16, want func(x []float32) []float32, flakiness float64) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat64x8UnaryFlaky(t *testing.T, f func(x archsimd.Float64x8) archsimd.Float64x8, want func(x []float64) []float64, flakiness float64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}
