/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.util.AbstractPeekableIterator;
import generic.util.MergeSortingIterator;
import generic.util.PeekableIterator;
import generic.util.PeekableIterators;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.util.AddressRangeComparators;
import ghidra.util.MathUtilities;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class UnionAddressRangeIterator
extends AbstractPeekableIterator<AddressRange>
implements AddressRangeIterator {
    private final PeekableIterator<AddressRange> it;
    private final boolean forward;

    public UnionAddressRangeIterator(Iterator<AddressRange> it, boolean forward) {
        this.it = PeekableIterators.castOrWrap(it);
        this.forward = forward;
    }

    public UnionAddressRangeIterator(Collection<Iterator<AddressRange>> iterators, boolean forward) {
        this.it = new MergeSortingIterator(iterators, (Comparator)(forward ? AddressRangeComparators.FORWARD : AddressRangeComparators.BACKWARD));
        this.forward = forward;
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this;
    }

    protected AddressRange seekNext() {
        if (!this.it.hasNext()) {
            return null;
        }
        AddressRange peek = (AddressRange)this.it.peek();
        Address min = peek.getMinAddress();
        Address max = peek.getMaxAddress();
        while (true) {
            this.it.next();
            if (!this.it.hasNext() || (peek = (AddressRange)this.it.peek()).getAddressSpace() != min.getAddressSpace()) break;
            if (this.forward) {
                Address n = max.next();
                if (n != null && peek.getMinAddress().compareTo(n) > 0) break;
                max = (Address)MathUtilities.cmax((Comparable)max, (Comparable)peek.getMaxAddress());
                continue;
            }
            Address p = min.previous();
            if (p != null && peek.getMaxAddress().compareTo(p) < 0) break;
            min = (Address)MathUtilities.cmin((Comparable)min, (Comparable)peek.getMinAddress());
        }
        return new AddressRangeImpl(min, max);
    }
}

