/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import ghidra.program.database.register.AddressRangeObjectMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.RangeMapAdapter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class InMemoryRangeMapAdapter
implements RangeMapAdapter {
    private AddressRangeObjectMap<byte[]> rangeMap = new AddressRangeObjectMap();

    @Override
    public void clearRange(Address start, Address end) {
        this.rangeMap.clearRange(start, end);
    }

    @Override
    public void clearAll() {
        this.rangeMap = new AddressRangeObjectMap();
    }

    @Override
    public AddressRange getValueRangeContaining(Address addr) {
        return this.rangeMap.getAddressRangeContaining(addr);
    }

    @Override
    public AddressRangeIterator getAddressRangeIterator(Address start, Address end) {
        return this.rangeMap.getAddressRangeIterator(start, end);
    }

    @Override
    public AddressRangeIterator getAddressRangeIterator() {
        return this.rangeMap.getAddressRangeIterator();
    }

    @Override
    public byte[] getValue(Address address) {
        return this.rangeMap.getObject(address);
    }

    @Override
    public void set(Address start, Address end, byte[] bytes) {
        this.rangeMap.setObject(start, end, bytes);
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.rangeMap.moveAddressRange(fromAddr, toAddr, length, monitor);
    }

    @Override
    public boolean isEmpty() {
        return this.rangeMap.isEmpty();
    }

    @Override
    public void checkWritableState() {
    }

    @Override
    public void setLanguage(LanguageTranslator translator, Register mapReg, TaskMonitor monitor) throws CancelledException {
        Register newReg = translator.getNewRegister(mapReg);
        if (newReg == null) {
            this.clearAll();
            return;
        }
        if (newReg.isBaseRegister() && !translator.isValueTranslationRequired(mapReg)) {
            return;
        }
        AddressRangeObjectMap<byte[]> newRangeMap = new AddressRangeObjectMap<byte[]>();
        AddressRangeIterator addressRangeIterator = this.rangeMap.getAddressRangeIterator();
        while (addressRangeIterator.hasNext()) {
            monitor.checkCancelled();
            AddressRange range = (AddressRange)addressRangeIterator.next();
            byte[] oldBytes = this.rangeMap.getObject(range.getMinAddress());
            RegisterValue regValue = new RegisterValue(mapReg, oldBytes);
            if ((regValue = translator.getNewRegisterValue(regValue)) == null || !regValue.hasAnyValue()) continue;
            byte[] newBytes = regValue.toBytes();
            newRangeMap.setObject(range.getMinAddress(), range.getMaxAddress(), newBytes);
        }
        this.rangeMap = newRangeMap;
    }

    @Override
    public void invalidate() {
        this.rangeMap.clearCache();
    }
}

