/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tab;

import docking.widgets.tab.GTab;
import docking.widgets.tab.GTabPanelBorder;
import docking.widgets.tab.HiddenValuesButton;
import docking.widgets.tab.TabListPopup;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import resources.ResourceManager;
import utility.function.Dummy;

public class GTabPanel<T>
extends JPanel {
    private T selectedValue;
    private T highlightedValue;
    private boolean ignoreFocusLost;
    private TabListPopup<T> tabList;
    private String tabTypeName;
    private Set<T> allValues = new LinkedHashSet<T>();
    private List<GTab<T>> allTabs = new ArrayList<GTab<T>>();
    private HiddenValuesButton hiddenValuesControl = new HiddenValuesButton(this);
    private Function<T, String> nameFunction = v -> v.toString();
    private Function<T, Icon> iconFunction = Dummy.function();
    private Function<T, String> toolTipFunction = Dummy.function();
    private Consumer<T> selectedTabConsumer = Dummy.consumer();
    private Consumer<T> closeTabConsumer = t -> this.removeTab(t);
    private boolean showTabsAlways = true;
    private Cursor moveCursor = GTabPanel.createMoveCursor();
    private boolean isDragging;

    public GTabPanel(String tabTypeName) {
        this.tabTypeName = tabTypeName;
        this.setLayout((LayoutManager)new HorizontalLayout(0));
        this.setFocusable(true);
        this.getAccessibleContext().setAccessibleDescription("Use left and right arrows to highlight other tabs and press enter to select the highlighted tab");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GTabPanel.this.closeTabList();
                GTabPanel.this.rebuildTabs();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 10: 
                    case 32: {
                        GTabPanel.this.selectHighlightedValue();
                        e.consume();
                        break;
                    }
                    case 37: {
                        GTabPanel.this.highlightNextPreviousTab(false);
                        e.consume();
                        break;
                    }
                    case 39: {
                        GTabPanel.this.highlightNextPreviousTab(true);
                        e.consume();
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GTabPanel.this.updateTabColors();
            }

            @Override
            public void focusLost(FocusEvent e) {
                GTabPanel.this.highlightedValue = null;
                GTabPanel.this.updateAccessibleName();
                GTabPanel.this.updateTabColors();
            }
        });
    }

    public void addTab(T value) {
        if (this.doAddValue(value)) {
            this.rebuildTabs();
        }
    }

    public void addTabs(List<T> values) {
        for (T t : values) {
            this.doAddValue(t);
        }
        this.rebuildTabs();
    }

    public void removeTab(T value) {
        this.allValues.remove(value);
        this.highlightedValue = null;
        if (value == this.selectedValue) {
            this.selectTab(null);
        } else {
            this.rebuildTabs();
        }
    }

    public void removeTabs(Collection<T> values) {
        this.allValues.removeAll(values);
        if (!this.allValues.contains(this.selectedValue)) {
            this.selectTab(null);
        } else {
            this.rebuildTabs();
        }
    }

    public T getSelectedTabValue() {
        return this.selectedValue;
    }

    public T getHighlightedTabValue() {
        return this.highlightedValue;
    }

    public void selectTab(T value) {
        if (value == this.selectedValue) {
            return;
        }
        if (value != null && !this.allValues.contains(value)) {
            throw new IllegalArgumentException("Attempted to set selected value to non added value");
        }
        this.closeTabList();
        this.highlightedValue = null;
        T oldValue = this.selectedValue;
        this.selectedValue = value;
        if (this.isVisibleTab(this.selectedValue)) {
            GTab<T> oldTab = this.getTab(oldValue);
            if (oldTab != null) {
                oldTab.setSelected(false);
            }
            GTab<T> newTab = this.getTab(value);
            newTab.setSelected(true);
        } else {
            this.rebuildTabs();
        }
        this.selectedTabConsumer.accept(value);
    }

    public List<T> getTabValues() {
        return new ArrayList<T>(this.allValues);
    }

    public boolean isVisibleTab(T value) {
        for (GTab<T> gTab : this.allTabs) {
            if (!gTab.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public int getTabCount() {
        return this.allValues.size();
    }

    public void highlightTab(T value) {
        this.highlightedValue = value == this.selectedValue ? null : value;
        this.updateTabColors();
        this.updateAccessibleName();
    }

    public boolean hasHiddenTabs() {
        return this.allTabs.size() < this.allValues.size();
    }

    public List<T> getHiddenTabs() {
        LinkedHashSet<T> hiddenValues = new LinkedHashSet<T>(this.allValues);
        hiddenValues.removeAll(this.getVisibleTabs());
        return new ArrayList<T>(hiddenValues);
    }

    public List<T> getVisibleTabs() {
        return this.allTabs.stream().map(t -> t.getValue()).collect(Collectors.toList());
    }

    public void showTabList(boolean show) {
        if (show) {
            this.showTabList();
        } else {
            this.closeTabList();
        }
    }

    public void highlightNextPreviousTab(boolean forward) {
        T current;
        if (this.allValues.size() < 2) {
            return;
        }
        T t = current = this.highlightedValue == null ? this.selectedValue : this.highlightedValue;
        if (this.isShowingTabList()) {
            current = null;
            this.closeTabList();
        }
        T next = forward ? this.getTabbedValueAfter(current) : this.getTabbedValueBefore(current);
        this.highlightTab(next);
        if (next == null) {
            this.showTabList(true);
        }
    }

    public void refreshTab(T value) {
        int tabIndex = this.getTabIndex(value);
        if (tabIndex >= 0) {
            this.allTabs.get(tabIndex).refresh();
        }
    }

    public void setNameFunction(Function<T, String> nameFunction) {
        this.nameFunction = nameFunction;
    }

    public void setIconFunction(Function<T, Icon> iconFunction) {
        this.iconFunction = iconFunction;
    }

    public void setToolTipFunction(Function<T, String> toolTipFunction) {
        this.toolTipFunction = toolTipFunction;
    }

    public void setCloseTabConsumer(Consumer<T> closeTabConsumer) {
        this.closeTabConsumer = closeTabConsumer;
    }

    public void setSelectedTabConsumer(Consumer<T> selectedTabConsumer) {
        this.selectedTabConsumer = selectedTabConsumer;
    }

    public boolean isShowingTabList() {
        return this.tabList != null;
    }

    public void setShowTabsAlways(boolean b) {
        this.showTabsAlways = b;
        this.rebuildTabs();
    }

    public T getValueFor(MouseEvent event) {
        JLabel label;
        Container parent;
        Object source = event.getSource();
        if (source instanceof JLabel && (parent = (label = (JLabel)source).getParent()) instanceof GTab) {
            GTab gTab = (GTab)parent;
            return gTab.getValue();
        }
        return null;
    }

    public GTab<T> getTab(T value) {
        for (GTab<T> tab : this.allTabs) {
            if (!tab.getValue().equals(value)) continue;
            return tab;
        }
        return null;
    }

    void showTabList() {
        if (this.tabList != null) {
            return;
        }
        HiddenValuesButton c = this.hasHiddenTabs() ? this.hiddenValuesControl : (JComponent)this.allTabs.get(this.allTabs.size() - 1);
        this.tabList = new TabListPopup(this, c, this.tabTypeName);
        this.tabList.setVisible(true);
    }

    void closeTab(T value) {
        this.closeTabConsumer.accept(value);
    }

    private void selectHighlightedValue() {
        if (this.highlightedValue != null) {
            this.selectTab(this.highlightedValue);
        }
    }

    void highlightFromTabList(boolean forward) {
        this.closeTabList();
        int highlightIndex = forward ? 0 : this.allTabs.size() - 1;
        this.highlightTab(this.allTabs.get(highlightIndex).getValue());
        this.requestFocus();
    }

    private T getTabbedValueAfter(T current) {
        if (current == null) {
            return this.allTabs.get(0).getValue();
        }
        int tabIndex = this.getTabIndex(current);
        if (tabIndex >= 0 && tabIndex < this.allTabs.size() - 1) {
            return this.allTabs.get(tabIndex + 1).getValue();
        }
        if (this.hasHiddenTabs()) {
            return null;
        }
        return this.allTabs.get(0).getValue();
    }

    private T getTabbedValueBefore(T current) {
        if (current == null) {
            return this.allTabs.get(this.allTabs.size() - 1).getValue();
        }
        int tabIndex = this.getTabIndex(current);
        if (tabIndex >= 1) {
            return this.allTabs.get(tabIndex - 1).getValue();
        }
        if (this.hasHiddenTabs()) {
            return null;
        }
        return this.allTabs.get(this.allTabs.size() - 1).getValue();
    }

    private int getTabIndex(T value) {
        for (int i = 0; i < this.allTabs.size(); ++i) {
            if (!this.allTabs.get(i).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    private void updateTabColors() {
        boolean tabPanelHasFocus = this.hasFocus();
        for (GTab<T> tab : this.allTabs) {
            T value = tab.getValue();
            tab.setHighlight(this.shouldHighlight(value, tabPanelHasFocus));
        }
    }

    private boolean shouldHighlight(T value, boolean tabPanelHasFocus) {
        if (value.equals(this.highlightedValue)) {
            return true;
        }
        if (tabPanelHasFocus && this.highlightedValue == null) {
            return value.equals(this.selectedValue);
        }
        return false;
    }

    private boolean doAddValue(T value) {
        Objects.requireNonNull(value);
        if (!this.allValues.contains(value)) {
            this.allValues.add(value);
            return true;
        }
        return false;
    }

    private void rebuildTabs() {
        this.allTabs.clear();
        this.removeAll();
        this.closeTabList();
        this.setBorder(null);
        this.setFocusable(false);
        if (this.shouldShowTabs()) {
            this.setFocusable(true);
            this.setBorder(new GTabPanelBorder());
            this.populateTabs();
        }
        this.updateTabColors();
        this.updateAccessibleName();
        this.revalidate();
        this.repaint();
    }

    private void populateTabs() {
        int availableWidth = this.getPanelWidth();
        if (!this.buildTabs(availableWidth)) {
            this.hiddenValuesControl.setHiddenCount(this.allValues.size() - this.allTabs.size());
            int hiddenValuesControlWidth = this.getParentedComponentWidth(this.hiddenValuesControl);
            this.buildTabs(availableWidth - hiddenValuesControlWidth);
            this.hiddenValuesControl.setHiddenCount(this.allValues.size() - this.allTabs.size());
            this.add(this.hiddenValuesControl);
        }
    }

    private boolean buildTabs(int availableWidth) {
        this.allTabs.clear();
        this.removeAll();
        GTab<T> selectedTab = this.selectedValue != null ? new GTab<T>(this, this.selectedValue, true) : null;
        availableWidth -= this.getParentedComponentWidth(selectedTab);
        boolean selectedTabAdded = false;
        for (T value : this.allValues) {
            int tabWidth;
            boolean isSelectedValue = value == this.selectedValue;
            GTab<T> nextTab = isSelectedValue ? selectedTab : new GTab<T>(this, value, false);
            int n = tabWidth = isSelectedValue ? 0 : this.getParentedComponentWidth(nextTab);
            if (tabWidth > availableWidth) break;
            this.allTabs.add(nextTab);
            this.add(nextTab);
            selectedTabAdded |= isSelectedValue;
            availableWidth -= tabWidth;
        }
        if (selectedTab != null && !selectedTabAdded && availableWidth >= 0) {
            this.allTabs.add(selectedTab);
            this.add(selectedTab);
        }
        return this.allTabs.size() == this.allValues.size();
    }

    private boolean shouldShowTabs() {
        if (this.allValues.isEmpty()) {
            return false;
        }
        return this.allValues.size() != 1 || this.showTabsAlways;
    }

    private void updateAccessibleName() {
        this.getAccessibleContext().setAccessibleName(this.getAccessibleName());
    }

    String getAccessibleName() {
        StringBuilder builder = new StringBuilder(this.tabTypeName);
        builder.append(" Tab Panel: ");
        if (this.allValues.isEmpty()) {
            builder.append("No Tabs");
            return builder.toString();
        }
        if (this.selectedValue != null) {
            builder.append(this.getDisplayName(this.selectedValue));
            builder.append(" selected");
        } else {
            builder.append("No Selected Tab");
        }
        if (this.highlightedValue != null) {
            builder.append(": ");
            builder.append(this.getDisplayName(this.highlightedValue));
            builder.append(" highlighted");
        }
        return builder.toString();
    }

    private int getParentedComponentWidth(Component component) {
        if (component == null) {
            return 0;
        }
        if (component.getParent() != null) {
            return component.getPreferredSize().width;
        }
        this.add(component);
        int width = component.getPreferredSize().width;
        this.remove(component);
        return width;
    }

    private int getPanelWidth() {
        return this.getSize().width;
    }

    boolean isListWindowShowing() {
        return this.tabList != null;
    }

    String getDisplayName(T t) {
        return this.nameFunction.apply(t);
    }

    Icon getValueIcon(T value) {
        return this.iconFunction.apply(value);
    }

    String getValueToolTip(T value) {
        return this.toolTipFunction.apply(value);
    }

    void tabListFocusLost() {
        if (!this.ignoreFocusLost) {
            this.closeTabList();
        }
    }

    void closeTabList() {
        if (this.tabList != null) {
            this.tabList.close();
            this.tabList = null;
        }
    }

    public void setIgnoreFocus(boolean ignoreFocusLost) {
        this.ignoreFocusLost = ignoreFocusLost;
    }

    void mouseDragged(GTab<T> draggedTab, MouseEvent e) {
        this.isDragging = true;
        this.clearAllHighlights();
        GTab<T> targetTab = this.getTab(e);
        if (targetTab == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.setCursor(this.moveCursor);
        if (targetTab != draggedTab) {
            targetTab.setHighlight(true);
        }
    }

    void mouseReleased(GTab<T> draggedTab, MouseEvent e) {
        if (!this.isDragging) {
            return;
        }
        this.isDragging = false;
        this.setCursor(Cursor.getDefaultCursor());
        int targetTabIndex = this.getTabIndex(e);
        if (targetTabIndex >= 0) {
            int draggedTabIndex = this.allTabs.indexOf(draggedTab);
            if (draggedTabIndex == targetTabIndex) {
                return;
            }
            this.moveTab(draggedTab.getValue(), targetTabIndex);
        }
    }

    private GTab<T> getTab(MouseEvent e) {
        int index = this.getTabIndex(e);
        if (index < 0) {
            return null;
        }
        return this.allTabs.get(index);
    }

    private int getTabIndex(MouseEvent e) {
        Point gTabPoint = e.getPoint();
        Point p = SwingUtilities.convertPoint(e.getComponent(), gTabPoint, this);
        Dimension size = this.getSize();
        if (p.x < 0 || p.y < 0 || p.x >= size.width || p.y >= size.height) {
            return -1;
        }
        for (int i = 0; i < this.allTabs.size(); ++i) {
            GTab<T> tab = this.allTabs.get(i);
            Rectangle tabBounds = tab.getBounds();
            if (!tabBounds.contains(p)) continue;
            return i;
        }
        return this.allTabs.size() - 1;
    }

    public void moveTab(T value, int newIndex) {
        ArrayList<T> newValues = new ArrayList<T>(this.allValues);
        newValues.remove(value);
        newValues.add(newIndex, value);
        this.allValues.clear();
        this.allValues.addAll(newValues);
        this.rebuildTabs();
    }

    private static Cursor createMoveCursor() {
        Icon icon = ResourceManager.loadIcon((String)"move.png");
        Image image = ResourceManager.getImageIcon((Icon)icon).getImage();
        return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(8, 8), "nope");
    }

    private void clearAllHighlights() {
        this.allTabs.forEach(t -> t.setHighlight(false));
    }
}

