/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack.vars;

import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.stack.vars.VariableValueHoverService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Debugger", category="Debugger", shortDescription="Variable Values Hover", description="Displays live variable values in a tooltip as you hover over a variable in the listings or decompiler.", eventsConsumed={TraceClosedPluginEvent.class}, servicesProvided={ListingHoverService.class, DecompilerHoverService.class})
public class VariableValueHoverPlugin
extends Plugin {
    private VariableValueHoverService hoverService;

    public VariableValueHoverPlugin(PluginTool tool) {
        super(tool);
        this.hoverService = new VariableValueHoverService(tool);
        this.registerServiceProvided(ListingHoverService.class, (Object)this.hoverService);
        this.registerServiceProvided(DecompilerHoverService.class, (Object)this.hoverService);
    }

    public VariableValueHoverService getHoverService() {
        return this.hoverService;
    }

    protected void dispose() {
        this.hoverService.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            this.hoverService.traceClosed(evt.getTrace());
        }
    }
}

