/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.thread.TraceProcess;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class DBTraceBreakpointLocation
implements TraceBreakpointLocation,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final BreakpointChangeTranslator translator;

    public DBTraceBreakpointLocation(DBTraceObject object) {
        this.object = object;
        this.translator = new BreakpointChangeTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(long snap, String name) {
        this.setName(Lifespan.nowOn(snap), name);
    }

    @Override
    public String getName(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String display = TraceObjectInterfaceUtils.getValue(this.object, snap, "_display", String.class, null);
            if (display != null) {
                String string = display;
                return string;
            }
            TraceObject spec = this.object.findCanonicalAncestorsInterface(TraceBreakpointSpec.class).findFirst().orElse(null);
            if (spec == null) {
                String string = "";
                return string;
            }
            String string = spec.getCanonicalPath().parent().relativize(this.object.getCanonicalPath()).toString();
            return string;
        }
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
        }
    }

    @Override
    public AddressRange getRange(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            AddressRange addressRange = TraceObjectInterfaceUtils.getValue(this.object, snap, "_range", AddressRange.class, null);
            return addressRange;
        }
    }

    @Override
    public Address getMinAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public Address getMaxAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public long getLength(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? 0L : range.getLength();
    }

    @Override
    public void setEnabled(Lifespan lifespan, boolean enabled) {
        this.object.setValue(lifespan, "_enabled", enabled);
    }

    @Override
    public void setEnabled(long snap, boolean enabled) {
        this.setEnabled(Lifespan.nowOn(snap), enabled);
    }

    @Override
    public boolean isEnabled(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Boolean locEn = TraceObjectInterfaceUtils.getValue(this.object, snap, "_enabled", Boolean.class, null);
            if (locEn != null) {
                boolean bl = locEn != false && this.getSpecification().isEnabled(snap);
                return bl;
            }
            boolean bl = this.getSpecification().isEnabled(snap);
            return bl;
        }
    }

    @Override
    public Set<TraceThread> getThreads(long snap) {
        DBTraceObjectManager manager = this.object.getManager();
        TraceObjectSchema schema = manager.getRootSchema();
        try (LockHold hold = this.object.getTrace().lockRead();){
            Set<TraceThread> threads = this.object.queryAncestorsInterface(Lifespan.at(snap), TraceThread.class).collect(Collectors.toSet());
            if (!threads.isEmpty()) {
                Set<TraceThread> set = threads;
                return set;
            }
            PathFilter procFilter = schema.searchFor(TraceProcess.class, false);
            Lifespan lifespan = Lifespan.at(snap);
            Set<TraceThread> set = this.object.getAncestorsRoot(lifespan, procFilter).flatMap(proc -> proc.getSource(this.object).querySuccessorsInterface(lifespan, TraceThread.class, true)).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public void setComment(Lifespan lifespan, String comment) {
        this.object.setValue(lifespan, "_comment", comment);
    }

    @Override
    public void setComment(long snap, String comment) {
        this.setComment(Lifespan.nowOn(snap), comment);
    }

    @Override
    public String getComment(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String comment = TraceObjectInterfaceUtils.getValue(this.object, snap, "_comment", String.class, "");
            if (!comment.isBlank()) {
                String string = comment;
                return string;
            }
            TraceBreakpointSpec spec = this.getSpecification();
            if (spec == null) {
                String string = "";
                return string;
            }
            String string = spec.getComment(snap);
            return string;
        }
    }

    @Override
    public void setEmuEnabled(Lifespan lifespan, boolean emuEnabled) {
        this.object.setValue(lifespan, "_emu_enabled", emuEnabled ? null : Boolean.valueOf(false));
    }

    @Override
    public void setEmuEnabled(long snap, boolean emuEnabled) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setEmuEnabled(Lifespan.nowOn(snap), emuEnabled);
        }
    }

    @Override
    public boolean isEmuEnabled(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            boolean bl = TraceObjectInterfaceUtils.getValue(this.object, snap, "_emu_enabled", Boolean.class, true);
            return bl;
        }
    }

    @Override
    public void setEmuSleigh(Lifespan lifespan, String sleigh) {
        if (sleigh == null || "emu_swi();\nemu_exec_decoded();\n".equals(sleigh)) {
            this.object.setValue(lifespan, "_emu_sleigh", null);
        } else {
            this.object.setValue(lifespan, "_emu_sleigh", sleigh.trim());
        }
    }

    @Override
    public void setEmuSleigh(long snap, String sleigh) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setEmuSleigh(Lifespan.nowOn(snap), sleigh);
        }
    }

    @Override
    public String getEmuSleigh(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String string = TraceObjectInterfaceUtils.getValue(this.object, snap, "_emu_sleigh", String.class, "emu_swi();\nemu_exec_decoded();\n");
            return string;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public boolean isAlive(Lifespan span) {
        return this.object.isAlive(span);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    public TraceBreakpointSpec getOrCreateSpecification() {
        return this.object.queryOrCreateCanonicalAncestorInterface(TraceBreakpointSpec.class);
    }

    @Override
    public TraceBreakpointSpec getSpecification() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceBreakpointSpec traceBreakpointSpec = this.object.queryCanonicalAncestorsInterface(TraceBreakpointSpec.class).findAny().orElseThrow();
            return traceBreakpointSpec;
        }
    }

    public AddressSpace getAddressSpace(long snap) {
        return this.spaceForValue(snap, "_range");
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected static class BreakpointChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceBreakpointLocation> {
        private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
        private final Set<String> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BreakpointChangeTranslator(DBTraceObject object, TraceBreakpointLocation iface) {
            super("_range", object, iface);
            TraceObjectSchema schema = object.getSchema();
            Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(schema.checkAliasedAttribute("_range"), schema.checkAliasedAttribute("_display"), schema.checkAliasedAttribute("_enabled"), schema.checkAliasedAttribute("_comment")));
            }
        }

        @Override
        protected TraceEvent<TraceBreakpointLocation, Void> getAddedType() {
            return TraceEvents.BREAKPOINT_ADDED;
        }

        @Override
        protected TraceEvent<TraceBreakpointLocation, Lifespan> getLifespanChangedType() {
            return TraceEvents.BREAKPOINT_LIFESPAN_CHANGED;
        }

        @Override
        protected TraceEvent<TraceBreakpointLocation, Void> getChangedType() {
            return TraceEvents.BREAKPOINT_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.contains(key);
        }

        @Override
        protected TraceEvent<TraceBreakpointLocation, Void> getDeletedType() {
            return TraceEvents.BREAKPOINT_DELETED;
        }
    }
}

