/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.protocol.QueryNearest;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.SimilarityResult;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResponseNearest
extends QueryResponseRecord {
    public int totalfunc = 0;
    public int totalmatch = 0;
    public int uniquematch = 0;
    public final DescriptionManager manage = new DescriptionManager();
    public List<SimilarityResult> result = new ArrayList<SimilarityResult>();
    public QueryNearest qnear;

    public ResponseNearest(QueryNearest q) {
        super("responsenearest");
        this.qnear = q;
    }

    @Override
    public void sort() {
        for (SimilarityResult sim : this.result) {
            sim.sortNotes();
        }
    }

    @Override
    public void mergeResults(QueryResponseRecord subresponse) throws LSHException {
        ResponseNearest subnearest = (ResponseNearest)subresponse;
        if (this.totalfunc == 0) {
            this.manage.transferSettings(subnearest.manage);
        }
        this.totalfunc += subnearest.totalfunc;
        this.totalmatch += subnearest.totalmatch;
        this.uniquematch += subnearest.uniquematch;
        this.result.addAll(subnearest.result);
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        this.manage.populateExecutableXref();
        this.qnear.manage.populateExecutableXref();
        fwrite.append('<').append(this.name).append(">\n");
        fwrite.append(" <tfunc>").append(SpecXmlUtils.encodeSignedInteger((long)this.totalfunc)).append("</tfunc>\n");
        fwrite.append(" <tmatch>").append(SpecXmlUtils.encodeSignedInteger((long)this.totalmatch)).append("</tmatch>\n");
        fwrite.append(" <umatch>").append(SpecXmlUtils.encodeSignedInteger((long)this.uniquematch)).append("</umatch>\n");
        this.manage.saveXml(fwrite);
        Iterator<SimilarityResult> iter = this.result.iterator();
        while (iter.hasNext()) {
            iter.next().saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        parser.start(new String[]{"tfunc"});
        this.totalfunc = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"tmatch"});
        this.totalmatch = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"umatch"});
        this.uniquematch = SpecXmlUtils.decodeInt((String)parser.end().getText());
        this.manage.restoreXml(parser, vectorFactory);
        Map<Integer, ExecutableRecord> qMap = this.qnear.manage.generateExecutableXrefMap();
        Map<Integer, ExecutableRecord> rMap = this.manage.generateExecutableXrefMap();
        while (parser.peek().isStart()) {
            SimilarityResult res = new SimilarityResult();
            res.restoreXml(parser, this.qnear.manage, this.manage, qMap, rMap);
            this.result.add(res);
        }
        parser.end();
    }
}

