/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project;

import generic.io.JarWriter;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

class ProjectJarWriter
extends JarWriter {
    private static final String PROPERTIES_FILE_NAME = ".properties";
    private static final String ORIGINAL_PROPERTIES_FILE_NAME = "original.properties";

    ProjectJarWriter(JarOutputStream jarOut) {
        super(jarOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean outputFile(File baseFile, String jarPath) {
        boolean succeeded = true;
        if (baseFile.isDirectory()) {
            return false;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(baseFile);
        }
        catch (FileNotFoundException fnfe) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + fnfe.getMessage()), (Throwable)fnfe);
            return false;
        }
        byte[] bytes = new byte[4096];
        int numRead = 0;
        String name = baseFile.getName();
        if (name.equals(PROPERTIES_FILE_NAME)) {
            name = ORIGINAL_PROPERTIES_FILE_NAME;
        }
        ZipEntry entry = new ZipEntry(jarPath + name);
        entry.setComment("project file");
        try {
            this.jarOut.putNextEntry(entry);
            try {
                while ((numRead = in.read(bytes)) != -1) {
                    this.jarOut.write(bytes, 0, numRead);
                }
            }
            catch (IOException ioe) {
                succeeded = false;
            }
            finally {
                this.jarOut.closeEntry();
            }
        }
        catch (IOException ioe) {
            succeeded = false;
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + ioe.getMessage()), (Throwable)ioe);
            }
        }
        return succeeded;
    }
}

