/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.quickfix;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.GTable;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.theme.GIcon;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.quickfix.QuickFixTableModel;
import ghidra.features.base.quickfix.TableDataLoader;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramTask;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.DeleteTableRowAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class QuickFixTableProvider
extends ComponentProvider {
    private static final Icon EXECUTE_ICON = new GIcon("icon.base.plugin.quickfix.done");
    private JComponent component;
    private QuickFixTableModel tableModel;
    private GhidraThreadedTablePanel<QuickFix> threadedPanel;
    private GhidraTableFilterPanel<QuickFix> tableFilterPanel;
    private GhidraTable table;
    private ToggleDockingAction toggleAutoDeleteAction;
    private boolean autoDelete;

    public QuickFixTableProvider(PluginTool tool, String title, String owner, Program program, TableDataLoader<QuickFix> loader) {
        super((Tool)tool, title, owner);
        this.setIcon((Icon)new GIcon("icon.plugin.table.service"));
        this.setTransient();
        this.setTitle(title);
        this.tableModel = new QuickFixTableModel(program, title, (ServiceProvider)tool, loader);
        this.tableModel.addInitialLoadListener(b -> this.tableLoaded((boolean)b, loader));
        this.component = this.buildMainPanel();
        this.createActions(owner);
        this.tableModel.addTableModelListener(e -> this.tableDataChanged());
    }

    protected void tableLoaded(boolean wasCancelled, TableDataLoader<QuickFix> loader) {
    }

    private void updateSubTitle() {
        StringBuilder builder = new StringBuilder();
        builder.append(" ");
        int count = this.tableModel.getUnfilteredRowCount();
        if (count > 0) {
            builder.append("(");
            builder.append(count);
            builder.append(count == 1 ? " item)" : " items)");
        }
        this.setSubTitle(builder.toString());
    }

    protected void createActions(String owner) {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Apply Action", owner).popupMenuPath(new String[]{"Apply Selected Items(s)"})).popupMenuIcon(EXECUTE_ICON)).popupMenuGroup("aaa")).toolBarIcon(EXECUTE_ICON)).description("Applies the selected items")).helpLocation(new HelpLocation("Search", "Apply_Selected"))).keyBinding("ctrl e")).withContext(QuickFixActionContext.class).enabledWhen(c -> c.getSelectedRowCount() > 0).onAction(this::applySelectedItems).buildAndInstallLocal((ComponentProvider)this);
        this.toggleAutoDeleteAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Auto Delete", owner).popupMenuPath(new String[]{"Auto Delete Completed Items"})).popupMenuGroup("settings")).helpLocation(new HelpLocation("Search", "Auto_Delete"))).description("If on, automatically remove completed items from the list")).onAction(this::toggleAutoDelete)).buildAndInstallLocal((ComponentProvider)this);
        this.addLocalAction((DockingActionIf)new SelectionNavigationAction(owner, this.table));
        GoToService service = (GoToService)this.dockingTool.getService(GoToService.class);
        if (service != null) {
            Navigatable navigatable = service.getDefaultNavigatable();
            this.addLocalAction((DockingActionIf)new MakeProgramSelectionAction(navigatable, owner, this.table, "bbb"));
        }
        DeleteTableRowAction deleteAction = new DeleteTableRowAction(this.table, owner, "bbb"){

            @Override
            public void actionPerformed(ActionContext context) {
                super.actionPerformed(context);
                QuickFixTableProvider.this.updateSubTitle();
            }
        };
        this.addLocalAction((DockingActionIf)deleteAction);
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new QuickFixActionContext();
    }

    private void tableDataChanged() {
        this.updateTitle();
    }

    private void updateTitle() {
        int rowCount = this.tableModel.getRowCount();
        int filteredRowCount = this.tableFilterPanel.getRowCount();
        this.setSubTitle("(" + filteredRowCount + " of " + rowCount + ")");
    }

    public void closeComponent() {
        super.closeComponent();
        this.tableFilterPanel.dispose();
    }

    public JComponent getComponent() {
        return this.component;
    }

    protected JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.threadedPanel = new GhidraThreadedTablePanel<QuickFix>((ThreadedTableModel)this.tableModel){

            @Override
            protected GTable createTable(ThreadedTableModel<QuickFix, ?> model) {
                return new QuickFixGhidraTable(model);
            }
        };
        this.table = this.threadedPanel.getTable();
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.dockingTool.contextChanged((ComponentProvider)this);
        });
        this.table.setActionsEnabled(true);
        this.table.installNavigation((ServiceProvider)this.dockingTool);
        panel.add((Component)((Object)this.threadedPanel), "Center");
        panel.add((Component)this.createFilterFieldPanel(), "South");
        panel.setPreferredSize(new Dimension(1000, 600));
        return panel;
    }

    private JPanel createFilterFieldPanel() {
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.tableModel);
        return this.tableFilterPanel;
    }

    public boolean isBusy(TableModel model) {
        if (!(model instanceof ThreadedTableModel)) {
            return false;
        }
        ThreadedTableModel threadedModel = (ThreadedTableModel)model;
        return threadedModel.isBusy();
    }

    private void applySelectedItems(QuickFixActionContext context) {
        int index;
        List selectedItems = this.tableFilterPanel.getSelectedItems();
        int nextIndex = selectedItems.size() == 1 ? this.table.getSelectedRow() : -1;
        this.applyItems(selectedItems);
        if (nextIndex >= 0 && (index = nextIndex + 1) < this.table.getRowCount()) {
            this.table.selectRow(nextIndex + 1);
        }
        if (this.autoDelete) {
            this.removeCompletedItems(selectedItems);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void toggleAutoDelete(ActionContext context) {
        this.autoDelete = this.toggleAutoDeleteAction.isSelected();
        if (this.autoDelete) {
            this.removeCompletedItems(this.tableModel.getModelData());
        }
    }

    private void removeCompletedItems(List<QuickFix> items) {
        ArrayList<QuickFix> toDelete = new ArrayList<QuickFix>();
        for (QuickFix item : items) {
            if (item.getStatus() != QuickFixStatus.DONE) continue;
            toDelete.add(item);
        }
        for (QuickFix quickFix : toDelete) {
            this.tableModel.removeObject(quickFix);
        }
    }

    private void applyItems(List<QuickFix> quickFixList) {
        Program program = this.tableModel.getProgram();
        ApplyItemsTask task = new ApplyItemsTask(program, this.getTaskTitle(), quickFixList);
        TaskLauncher.launch((Task)task);
    }

    public void executeAll() {
        List allItems = this.tableModel.getModelData();
        this.applyItems(allItems);
        this.tableModel.fireTableDataChanged();
    }

    protected String getTaskTitle() {
        return "Applying Items";
    }

    public void programClosed(Program program) {
        if (program == this.tableModel.getProgram()) {
            this.closeComponent();
        }
    }

    public QuickFixTableModel getTableModel() {
        return this.tableModel;
    }

    public void setSelection(int start, int end) {
        this.table.setRowSelectionInterval(start, end);
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public void applySelected() {
        this.applySelectedItems(null);
    }

    private class QuickFixActionContext
    extends DefaultActionContext {
        QuickFixActionContext() {
            super((ComponentProvider)QuickFixTableProvider.this, (Component)((Object)QuickFixTableProvider.this.table));
        }

        public int getSelectedRowCount() {
            return QuickFixTableProvider.this.table.getSelectedRowCount();
        }
    }

    private static class ApplyItemsTask
    extends ProgramTask {
        private List<QuickFix> quickFixList;

        public ApplyItemsTask(Program program, String title, List<QuickFix> quickFixList) {
            super(program, title, true, true, true);
            this.quickFixList = quickFixList;
        }

        protected void doRun(TaskMonitor monitor) {
            for (QuickFix quickFix : this.quickFixList) {
                quickFix.performAction();
            }
        }
    }

    private class QuickFixGhidraTable
    extends GhidraTable {
        boolean fromSelectionChange;

        public QuickFixGhidraTable(ThreadedTableModel<QuickFix, ?> model) {
            super((TableModel)model);
            this.fromSelectionChange = false;
        }

        @Override
        public void navigate(int row, int column) {
            if (!this.doSpecialNavigate(row)) {
                super.navigate(row, column);
            }
        }

        @Override
        protected void navigateOnCurrentSelection(int row, int column) {
            this.fromSelectionChange = true;
            try {
                super.navigateOnCurrentSelection(row, column);
            }
            finally {
                this.fromSelectionChange = false;
            }
        }

        private boolean doSpecialNavigate(int row) {
            QuickFix quickFix = (QuickFix)QuickFixTableProvider.this.tableFilterPanel.getRowObject(row);
            return quickFix.navigateSpecial((ServiceProvider)QuickFixTableProvider.this.dockingTool, this.fromSelectionChange);
        }
    }
}

