/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import ghidra.app.util.viewer.field.EolEnablement;
import ghidra.app.util.viewer.field.EolExtraCommentsOption;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class EolExtraCommentsPropertyEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private static final String REPEATABLE_LABEL = "Repeatable Comment";
    private static final String REF_REPEATABLE_LABEL = "Referenced Repeatable Comments";
    private static final String AUTO_DATA_LABEL = "Auto Data Comment";
    private static final String AUTO_FUNCTION_LABEL = "Auto Function Comment";
    private static final String ABBREVIATED_LABEL = "Use Abbreviated Comments";
    private static final String REPEATABLE_TOOLTIP = "<html>For repeatable comments:<UL>\t<LI>ALWAYS - show even if an EOL comment exists</LI>\t<LI>DEFAULT - show only when no EOL comment exists</LI>\t<LI>NEVER - do not show</LI></UL>";
    private static final String REF_REPEATABLE_TOOLTIP = "<html>For referenced repeatable comments:<UL>\t<LI>ALWAYS - show even if a higher priority comment exists</LI>\t<LI>DEFAULT - show only when no higher priority comment exists</LI>\t<LI>NEVER - do not show</LI></UL>";
    private static final String AUTO_TOOLTIP = "<html>For automatic comments:<UL>\t<LI>ALWAYS - show even if a higher priority comment exists</LI>\t<LI>DEFAULT - show only when no higher priority comment exists</LI>\t<LI>NEVER - do not show</LI></UL>";
    private static final String ABBREVIATED_TOOLTIP = "When showing automatic comments, show the smallest amount of information possible";
    private static final String[] NAMES = new String[]{"Repeatable Comment", "Referenced Repeatable Comments", "Auto Data Comment", "Auto Function Comment", "Use Abbreviated Comments"};
    private static final String[] DESCRIPTIONS = new String[]{"<html>For repeatable comments:<UL>\t<LI>ALWAYS - show even if an EOL comment exists</LI>\t<LI>DEFAULT - show only when no EOL comment exists</LI>\t<LI>NEVER - do not show</LI></UL>", "<html>For referenced repeatable comments:<UL>\t<LI>ALWAYS - show even if a higher priority comment exists</LI>\t<LI>DEFAULT - show only when no higher priority comment exists</LI>\t<LI>NEVER - do not show</LI></UL>", "<html>For automatic comments:<UL>\t<LI>ALWAYS - show even if a higher priority comment exists</LI>\t<LI>DEFAULT - show only when no higher priority comment exists</LI>\t<LI>NEVER - do not show</LI></UL>", "<html>For automatic comments:<UL>\t<LI>ALWAYS - show even if a higher priority comment exists</LI>\t<LI>DEFAULT - show only when no higher priority comment exists</LI>\t<LI>NEVER - do not show</LI></UL>", "When showing automatic comments, show the smallest amount of information possible"};
    private Component editorComponent = this.buildEditor();
    private GComboBox<EolEnablement> repeatableCombo;
    private GComboBox<EolEnablement> refRepeatableCombo;
    private GComboBox<EolEnablement> autoDataCombo;
    private GComboBox<EolEnablement> autoFunctionCombo;
    private JCheckBox abbreviatedCheckbox;
    private EolExtraCommentsOption commentsOption;

    private Component buildEditor() {
        int vgap = 3;
        int hgap = 5;
        int minRightSize = 150;
        JPanel panel = new JPanel((LayoutManager)new PairLayout(vgap, hgap, minRightSize));
        JLabel label = new JLabel(REPEATABLE_LABEL);
        label.setToolTipText(REPEATABLE_TOOLTIP);
        this.repeatableCombo = new GComboBox((Object[])EolEnablement.values());
        this.repeatableCombo.setSelectedItem((Object)EolEnablement.DEFAULT);
        this.repeatableCombo.addItemListener(e -> this.firePropertyChange());
        panel.add(label);
        panel.add((Component)this.repeatableCombo);
        label = new JLabel(REF_REPEATABLE_LABEL);
        label.setToolTipText(REF_REPEATABLE_TOOLTIP);
        this.refRepeatableCombo = new GComboBox((Object[])EolEnablement.values());
        this.refRepeatableCombo.setSelectedItem((Object)EolEnablement.DEFAULT);
        this.refRepeatableCombo.addItemListener(e -> this.firePropertyChange());
        panel.add(label);
        panel.add((Component)this.refRepeatableCombo);
        label = new JLabel(AUTO_DATA_LABEL);
        label.setToolTipText(AUTO_TOOLTIP);
        this.autoDataCombo = new GComboBox((Object[])EolEnablement.values());
        this.autoDataCombo.setSelectedItem((Object)EolEnablement.DEFAULT);
        this.autoDataCombo.addItemListener(e -> this.firePropertyChange());
        panel.add(label);
        panel.add((Component)this.autoDataCombo);
        label = new JLabel(AUTO_FUNCTION_LABEL);
        label.setToolTipText(AUTO_TOOLTIP);
        this.autoFunctionCombo = new GComboBox((Object[])EolEnablement.values());
        this.autoFunctionCombo.setSelectedItem((Object)EolEnablement.DEFAULT);
        this.autoFunctionCombo.addItemListener(e -> this.firePropertyChange());
        panel.add(label);
        panel.add((Component)this.autoFunctionCombo);
        this.abbreviatedCheckbox = new GCheckBox(ABBREVIATED_LABEL);
        this.abbreviatedCheckbox.setSelected(true);
        this.abbreviatedCheckbox.setToolTipText(ABBREVIATED_TOOLTIP);
        ItemListener listener = e -> this.firePropertyChange();
        this.repeatableCombo.addItemListener(listener);
        this.refRepeatableCombo.addItemListener(listener);
        this.autoDataCombo.addItemListener(listener);
        this.autoFunctionCombo.addItemListener(listener);
        this.abbreviatedCheckbox.addItemListener(listener);
        panel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder("Additional Comment Types"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return panel;
    }

    private Object cloneOptionValues() {
        EolExtraCommentsOption newOption = new EolExtraCommentsOption();
        newOption.setRepeatable((EolEnablement)((Object)this.repeatableCombo.getSelectedItem()));
        newOption.setRefRepeatable((EolEnablement)((Object)this.refRepeatableCombo.getSelectedItem()));
        newOption.setAutoData((EolEnablement)((Object)this.autoDataCombo.getSelectedItem()));
        newOption.setAutoFunction((EolEnablement)((Object)this.autoFunctionCombo.getSelectedItem()));
        return newOption;
    }

    public String[] getOptionNames() {
        return NAMES;
    }

    public String[] getOptionDescriptions() {
        return DESCRIPTIONS;
    }

    @Override
    public Object getValue() {
        return this.cloneOptionValues();
    }

    @Override
    public Component getCustomEditor() {
        return this.editorComponent;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof EolExtraCommentsOption)) {
            return;
        }
        this.commentsOption = (EolExtraCommentsOption)value;
        this.setLocalValues(this.commentsOption);
        this.firePropertyChange();
    }

    private void setLocalValues(EolExtraCommentsOption sourceOption) {
        EolEnablement newPriority;
        EolEnablement currentPriority = (EolEnablement)((Object)this.repeatableCombo.getSelectedItem());
        if (currentPriority != (newPriority = sourceOption.getRepeatable())) {
            this.repeatableCombo.setSelectedItem((Object)newPriority);
        }
        if ((currentPriority = (EolEnablement)((Object)this.refRepeatableCombo.getSelectedItem())) != (newPriority = sourceOption.getRefRepeatable())) {
            this.refRepeatableCombo.setSelectedItem((Object)newPriority);
        }
        if ((currentPriority = (EolEnablement)((Object)this.autoDataCombo.getSelectedItem())) != (newPriority = sourceOption.getAutoData())) {
            this.autoDataCombo.setSelectedItem((Object)newPriority);
        }
        if ((currentPriority = (EolEnablement)((Object)this.autoFunctionCombo.getSelectedItem())) != (newPriority = sourceOption.getAutoFunction())) {
            this.autoFunctionCombo.setSelectedItem((Object)newPriority);
        }
    }
}

