/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.PefException;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.app.util.bin.format.pef.SectionKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.MacintoshTimeStampDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ContainerHeader
implements StructConverter {
    public static final String TAG1 = "Joy!";
    public static final String TAG2 = "peff";
    public static final String ARCHITECTURE_PPC = "pwpc";
    public static final String ARCHITECTURE_68k = "m68k";
    private String tag1;
    private String tag2;
    private String architecture;
    private int formatVersion;
    private int dateTimeStamp;
    private int oldDefVersion;
    private int oldImpVersion;
    private int currentVersion;
    private short sectionCount;
    private short instSectionCount;
    private int reservedA;
    private LoaderInfoHeader _loader;
    private List<SectionHeader> _sections = new ArrayList<SectionHeader>();
    private long _sectionIndex;
    private BinaryReader _reader;

    public ContainerHeader(ByteProvider provider) throws IOException, PefException {
        this._reader = new BinaryReader(provider, false);
        this.tag1 = this._reader.readNextAsciiString(4);
        this.tag2 = this._reader.readNextAsciiString(4);
        this.architecture = this._reader.readNextAsciiString(4);
        this.formatVersion = this._reader.readNextInt();
        this.dateTimeStamp = this._reader.readNextInt();
        this.oldDefVersion = this._reader.readNextInt();
        this.oldImpVersion = this._reader.readNextInt();
        this.currentVersion = this._reader.readNextInt();
        this.sectionCount = this._reader.readNextShort();
        this.instSectionCount = this._reader.readNextShort();
        this.reservedA = this._reader.readNextInt();
        if (!this.tag1.equals(TAG1) || !this.tag2.equals(TAG2)) {
            throw new PefException("Invalid PEF file.");
        }
        if (!ARCHITECTURE_68k.equals(this.architecture) && !ARCHITECTURE_PPC.equals(this.architecture)) {
            throw new PefException("Invalid architecture specified: " + this.architecture);
        }
        this._sectionIndex = this._reader.getPointerIndex();
    }

    public void parse() throws IOException, PefException {
        this._reader.setPointerIndex(this._sectionIndex);
        for (int i = 0; i < this.sectionCount; ++i) {
            SectionHeader section = new SectionHeader(this._reader);
            if (section.getSectionKind() == SectionKind.Loader) {
                if (this._loader != null) {
                    throw new PefException("Multple loader sections exist!");
                }
                this._loader = new LoaderInfoHeader(this._reader, section);
            }
            this._sections.add(section);
        }
    }

    public String getTag1() {
        return this.tag1;
    }

    public String getTag2() {
        return this.tag2;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public int getDateTimeStamp() {
        return this.dateTimeStamp;
    }

    public int getOldDefVersion() {
        return this.oldDefVersion;
    }

    public int getOldImpVersion() {
        return this.oldImpVersion;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public short getSectionCount() {
        return this.sectionCount;
    }

    public short getInstantiatedSectionCount() {
        return this.instSectionCount;
    }

    public int getReservedA() {
        return this.reservedA;
    }

    public List<SectionHeader> getSections() {
        return this._sections;
    }

    public LoaderInfoHeader getLoader() {
        return this._loader;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ContainerHeader", 0);
        struct.add(STRING, 4, "tag1", null);
        struct.add(STRING, 4, "tag2", null);
        struct.add(STRING, 4, "architecture", null);
        struct.add(DWORD, "formatVersion", null);
        struct.add((DataType)new MacintoshTimeStampDataType(), "dateTimeStamp", null);
        struct.add(DWORD, "oldDefVersion", null);
        struct.add(DWORD, "oldImpVersion", null);
        struct.add(DWORD, "currentVersion", null);
        struct.add(WORD, "sectionCount", null);
        struct.add(WORD, "instSectionCount", null);
        struct.add(DWORD, "reservedA", null);
        return struct;
    }

    public long getImageBase() {
        return 0L;
    }
}

