/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class PowerPCDisassembleCommand
extends DisassembleCommand {
    private boolean vleMode;

    public PowerPCDisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean vleMode) {
        super(startSet, restrictedSet, true);
        this.vleMode = vleMode;
    }

    public PowerPCDisassembleCommand(Address start, AddressSetView restrictedSet, boolean vleMode) {
        super(start, restrictedSet, true);
        this.vleMode = vleMode;
    }

    public String getName() {
        return "Disassemble " + (this.vleMode ? "PPC-VLE" : "PPC");
    }

    @Override
    public void setSeedContext(DisassemblerContextImpl seedContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialContext(RegisterValue initialContextValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean applyTo(Program program, TaskMonitor monitor) {
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        Register vlemodeReg = program.getProgramContext().getRegister("vle");
        if (vlemodeReg == null) {
            if (this.vleMode) {
                this.setStatusMsg("PowerISA VLE mode not supported");
                return false;
            }
            return super.applyTo(program, monitor);
        }
        RegisterValue vlemodeValue = new RegisterValue(vlemodeReg, BigInteger.valueOf(this.vleMode ? 1L : 0L));
        super.setInitialContext(vlemodeValue);
        int alignment = this.vleMode ? 2 : 4;
        long alignMask = this.vleMode ? -2L : -4L;
        try {
            if (this.startSet != null) {
                AddressSet alignedSet = new AddressSet();
                for (AddressRange range : this.startSet) {
                    Address max;
                    long maxOffset;
                    Address min = range.getMinAddress();
                    long minOfffset = min.getOffset() & alignMask;
                    if (minOfffset != min.getOffset()) {
                        min = min.getNewAddress(minOfffset);
                    }
                    if ((maxOffset = (max = range.getMaxAddress()).getOffset() & alignMask) < minOfffset) continue;
                    if (maxOffset != max.getOffset()) {
                        max = max.getNewAddress(maxOffset);
                    }
                    alignedSet.addRange(min, max);
                }
                if (alignedSet.isEmpty()) {
                    this.unalignedStart = true;
                    return false;
                }
                this.startSet = program.getListing().getUndefinedRanges((AddressSetView)alignedSet, true, monitor);
                if (this.startSet.isEmpty()) {
                    return true;
                }
            }
        }
        catch (CancelledException e) {
            return true;
        }
        return this.doDisassembly(monitor, program, alignment);
    }
}

