/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cramfs.CramFsBlock;
import ghidra.file.formats.cramfs.CramFsInode;
import java.util.ArrayList;
import java.util.List;

public class CramFsBlockFactory {
    static final int IS_DIRECT_POINTER = 0x40000000;
    static final int IS_UNCOMPRESSED = Integer.MIN_VALUE;
    private CramFsInode cramfsInode;
    private ByteProvider provider;
    private List<Integer> blockPointerList;
    private List<Integer> blockSizes;
    private boolean blockPointerExtensionsEnabled;

    public CramFsBlockFactory(CramFsInode cramfsInode, ByteProvider provider, List<Integer> blockPointerList, boolean blockPointerExtensionsEnabled) {
        this.cramfsInode = cramfsInode;
        this.provider = provider;
        this.blockPointerExtensionsEnabled = blockPointerExtensionsEnabled;
        this.blockPointerList = blockPointerList;
    }

    public List<CramFsBlock> produceBlocks() {
        ArrayList<CramFsBlock> blockList = new ArrayList<CramFsBlock>();
        if (!this.blockPointerExtensionsEnabled) {
            this.blockSizes = this.calculateCompressedBlockSizes();
            for (int i = 0; i < this.blockSizes.size(); ++i) {
                blockList.add(new CramFsBlock(this.blockPointerList.get(i), this.blockSizes.get(i), this.provider));
            }
        }
        return blockList;
    }

    public CramFsInode getCramfsInode() {
        return this.cramfsInode;
    }

    private List<Integer> calculateCompressedBlockSizes() {
        ArrayList<Integer> compressedBlockSizes = new ArrayList<Integer>();
        for (int i = 0; i < this.blockPointerList.size() - 1; ++i) {
            compressedBlockSizes.add(this.blockPointerList.get(i + 1) - this.blockPointerList.get(i));
        }
        return compressedBlockSizes;
    }
}

