/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import docking.widgets.OptionDialog;
import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RemoveMatchTask
extends VtTask {
    private final List<VTMatch> matches;

    public RemoveMatchTask(VTSession session, List<VTMatch> matches) {
        super("Remove Matches", session);
        this.matches = matches;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        this.removeMatches(monitor);
        return true;
    }

    private void removeMatches(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Removing matches");
        int n = this.matches.size();
        monitor.initialize((long)n);
        ArrayList<VTMatch> list = new ArrayList<VTMatch>(this.matches);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            monitor.checkCancelled();
            VTMatch match = (VTMatch)it.next();
            VTMatchSetDB matchSet = (VTMatchSetDB)match.getMatchSet();
            if (matchSet.removeMatch(match)) {
                it.remove();
            }
            monitor.incrementProgress(1L);
        }
        if (list.isEmpty()) {
            return;
        }
        int delta = n - list.size();
        String message = "Deleted %d of %d matches.\n\nThe remaining %d matches are ACCEPTED.  Do you wish to delete these matches and\nleave any applied destination program markup in place?\n(Press F1 to see more help details)\n".formatted(delta, n, list.size());
        RemoveMatchDialog dialog = new RemoveMatchDialog(this, message);
        if (!dialog.promptToDelete()) {
            return;
        }
        it = list.iterator();
        while (it.hasNext()) {
            monitor.checkCancelled();
            VTMatch match = (VTMatch)it.next();
            VTMatchSetDB matchSet = (VTMatchSetDB)match.getMatchSet();
            matchSet.deleteMatch(match);
            it.remove();
            monitor.incrementProgress(1L);
        }
    }

    private class RemoveMatchDialog
    extends OptionDialog {
        RemoveMatchDialog(RemoveMatchTask removeMatchTask, String message) {
            super("Delete ACCEPTED Matches?", message, "Delete Accepted Matches", "Finish", 3, null, false);
            this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Remove_Match"));
        }

        boolean promptToDelete() {
            int choice = super.show();
            return choice == 1;
        }
    }
}

