/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.EdgeSorting;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.NormalizesFavoredEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;
import org.jungrapht.visualization.layout.algorithms.util.AfterRunnable;
import org.jungrapht.visualization.layout.algorithms.util.ComponentGrouping;
import org.jungrapht.visualization.layout.algorithms.util.EdgeArticulationFunctionSupplier;
import org.jungrapht.visualization.layout.algorithms.util.ExecutorConsumer;
import org.jungrapht.visualization.layout.algorithms.util.LayeredRunnable;
import org.jungrapht.visualization.layout.algorithms.util.Threaded;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.Expansion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHierarchicalMinCrossLayoutAlgorithm<V, E>
implements LayoutAlgorithm<V>,
VertexBoundsFunctionConsumer<V>,
EdgeArticulationFunctionSupplier<E>,
Layered<V, E>,
EdgeSorting<E>,
NormalizesFavoredEdge<E>,
AfterRunnable,
Threaded,
ExecutorConsumer {
    private static final Logger log = LoggerFactory.getLogger(AbstractHierarchicalMinCrossLayoutAlgorithm.class);
    protected static final Rectangle IDENTITY_SHAPE;
    protected static final String MINCROSS_STRAIGHTEN_EDGES = "jungrapht.mincross.straightenEdges";
    protected static final String MINCROSS_POST_STRAIGHTEN = "jungrapht.mincross.postStraighten";
    protected static final String MINCROSS_THREADED = "jungrapht.mincross.threaded";
    protected static final String TRANSPOSE_LIMIT = "jungrapht.mincross.transposeLimit";
    protected static final String MAX_LEVEL_CROSS = "jungrapht.mincross.maxLevelCross";
    protected Rectangle bounds = Rectangle.IDENTITY;
    protected List<V> roots;
    protected Function<V, Rectangle> vertexBoundsFunction;
    protected boolean straightenEdges;
    protected boolean postStraighten;
    protected boolean transpose;
    protected int maxLevelCross;
    protected Function<Graph<V, E>, Integer> maxLevelCrossFunction;
    protected boolean expandLayout;
    protected boolean threaded;
    protected Layering layering;
    protected Executor executor;
    protected Runnable after;
    protected boolean separateComponents;
    protected Map<E, List<Point>> edgePointMap = new HashMap<E, List<Point>>();
    protected AtomicInteger completionCounter = new AtomicInteger();
    protected Set<LayeredRunnable<E>> runnables = new HashSet<LayeredRunnable<E>>();
    protected LayoutModel<V> layoutModel;
    protected boolean cancelled;
    protected Comparator<E> edgeComparator;
    protected Predicate<E> favoredEdgePredicate = Layered.truePredicate;

    protected AbstractHierarchicalMinCrossLayoutAlgorithm(Builder builder) {
        this(builder.vertexBoundsFunction, builder.straightenEdges, builder.postStraighten, builder.transpose, builder.maxLevelCross, builder.maxLevelCrossFunction, builder.expandLayout, builder.layering, builder.edgeComparator, builder.threaded, builder.executor, builder.separateComponents, builder.favoredEdgePredicate, builder.after);
    }

    protected AbstractHierarchicalMinCrossLayoutAlgorithm(Function<V, Rectangle> vertexBoundsFunction, boolean straightenEdges, boolean postStraighten, boolean transpose, int maxLevelCross, Function<Graph<V, E>, Integer> maxLevelCrossFunction, boolean expandLayout, Layering layering, Comparator<E> edgeComparator, boolean threaded, Executor executor, boolean separateComponents, Predicate<E> favoredEdgePredicate, Runnable after) {
        this.vertexBoundsFunction = vertexBoundsFunction;
        this.straightenEdges = straightenEdges;
        this.postStraighten = postStraighten;
        this.transpose = transpose;
        this.maxLevelCross = maxLevelCross;
        this.maxLevelCrossFunction = maxLevelCrossFunction;
        this.expandLayout = expandLayout;
        this.layering = layering;
        this.threaded = threaded;
        this.executor = executor;
        this.separateComponents = separateComponents;
        this.edgeComparator = edgeComparator;
        this.favoredEdgePredicate = favoredEdgePredicate;
        this.after = after;
    }

    @Override
    public void setEdgeComparator(Comparator<E> edgeComparator) {
        this.edgeComparator = edgeComparator;
    }

    @Override
    public void setFavoredEdgePredicate(Predicate<E> favoredEdgePredicate) {
        this.favoredEdgePredicate = favoredEdgePredicate;
    }

    @Override
    public void setVertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
        this.vertexBoundsFunction = vertexBoundsFunction;
    }

    @Override
    public Function<E, List<Point>> getEdgeArticulationFunction() {
        return e -> this.edgePointMap.getOrDefault(e, Collections.emptyList());
    }

    @Override
    public void setLayering(Layering layering) {
        this.edgePointMap.clear();
        this.layering = layering;
    }

    @Override
    public void setMaxLevelCrossFunction(Function<Graph<V, E>, Integer> maxLevelCrossFunction) {
        this.maxLevelCrossFunction = maxLevelCrossFunction;
    }

    @Override
    public boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.runnables.forEach(LayeredRunnable::cancel);
        if (this.layoutModel != null) {
            this.layoutModel.setFireEvents(true);
        }
    }

    protected boolean isComplete(int expected) {
        boolean isComplete;
        boolean bl = isComplete = this.completionCounter.incrementAndGet() >= expected;
        if (log.isTraceEnabled()) {
            log.trace(" completionCounter:{}, expected: {} isComplete:{}", new Object[]{this.completionCounter.get(), expected, isComplete});
        }
        return isComplete;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    protected abstract LayeredRunnable<E> getRunnable(int var1, LayoutModel<V> var2);

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        List graphs;
        this.layoutModel = layoutModel;
        this.completionCounter.set(0);
        this.edgePointMap.clear();
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        ArrayList<LayoutModel<V>> layoutModels = new ArrayList<LayoutModel<V>>();
        if (this.separateComponents) {
            graphs = ComponentGrouping.getComponentGraphs(graph);
            layoutModel.setFireEvents(false);
            for (int i = 0; i < graphs.size(); ++i) {
                Object t = ((LayoutModel.Builder)((LayoutModel.Builder)((LayoutModel.Builder)LayoutModel.builder().graph(graphs.get(i))).width(layoutModel.getWidth())).height(layoutModel.getHeight())).build();
                layoutModels.add((LayoutModel<V>)t);
                log.trace("multiComponent model size: {}x{}", (Object)t.getWidth(), (Object)t.getHeight());
            }
        } else {
            graphs = Collections.singletonList(graph);
            layoutModels.add(layoutModel);
            log.trace("singleComponent model size: {}x{}", (Object)layoutModel.getWidth(), (Object)layoutModel.getHeight());
        }
        for (LayoutModel layoutModel2 : layoutModels) {
            LayeredRunnable<E> runnable = this.getRunnable(graphs.size(), layoutModel2);
            this.runnables.add(runnable);
            if (this.threaded) {
                if (this.executor != null) {
                    CompletableFuture.runAsync(runnable, this.executor).thenRun(() -> {
                        log.trace("MinCross layout done");
                        this.edgePointMap.putAll(runnable.getEdgePointMap());
                        if (!this.cancelled && this.isComplete(graphs.size())) {
                            this.fillAndCenter(layoutModel, layoutModels);
                        }
                    });
                    continue;
                }
                CompletableFuture.runAsync(runnable).thenRun(() -> {
                    log.trace("MinCross layout done");
                    this.edgePointMap.putAll(runnable.getEdgePointMap());
                    if (!this.cancelled && this.isComplete(graphs.size())) {
                        this.fillAndCenter(layoutModel, layoutModels);
                    }
                });
                continue;
            }
            runnable.run();
            log.trace("MinCross layout done");
            this.edgePointMap.putAll(runnable.getEdgePointMap());
            if (this.cancelled || !this.isComplete(graphs.size())) continue;
            this.fillAndCenter(layoutModel, layoutModels);
        }
    }

    protected void fillAndCenter(LayoutModel<V> layoutModel, List<LayoutModel<V>> layoutModels) {
        layoutModel.setFireEvents(true);
        this.appendAll(layoutModel, layoutModels);
        this.expandLayoutWidthOrHeight(layoutModel, this.edgePointMap.values());
        layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
        this.after.run();
    }

    protected void expandLayoutWidthOrHeight(LayoutModel<V> layoutModel, Collection<List<Point>> articulations) {
        int maxSize = Math.max(layoutModel.getWidth(), layoutModel.getHeight());
        double horizontalRatio = maxSize / layoutModel.getWidth();
        double verticalRatio = maxSize / layoutModel.getHeight();
        layoutModel.getLocations().forEach((v, p) -> {
            p = Point.of(p.x * horizontalRatio, p.y * verticalRatio);
            layoutModel.set((Object)v, (Point)p);
        });
        for (List<Point> lp : articulations) {
            for (int i = 0; i < lp.size(); ++i) {
                Point p2 = lp.get(i);
                p2 = Point.of(p2.x * horizontalRatio, p2.y * verticalRatio);
                lp.set(i, p2);
            }
        }
        layoutModel.setSize(maxSize, maxSize);
        this.centerIt(layoutModel, articulations);
    }

    protected void centerIt(LayoutModel<V> layoutModel, Collection<List<Point>> articulations) {
        Rectangle extent = Expansion.computeLayoutExtent2(layoutModel, articulations);
        double widthOfExtent = extent.width;
        int widthOfLayoutModel = layoutModel.getWidth();
        double moveBy = extent.x + widthOfExtent / 2.0 - (double)(widthOfLayoutModel / 2);
        layoutModel.getLocations().forEach((v, p) -> {
            p = Point.of(p.x - moveBy, p.y);
            layoutModel.set((Object)v, (Point)p);
        });
        for (List<Point> lp : articulations) {
            for (int i = 0; i < lp.size(); ++i) {
                Point p2 = lp.get(i);
                p2 = Point.of(p2.x - moveBy, p2.y);
                lp.set(i, p2);
            }
        }
    }

    private void appendAll(LayoutModel<V> parentLayoutModel, Collection<LayoutModel<V>> childLayoutModels) {
        log.trace("appendAll, cancelled: {}", (Object)this.cancelled);
        if (!this.cancelled) {
            log.trace("appending: {} child layout models", (Object)childLayoutModels.size());
            childLayoutModels.forEach(parentLayoutModel::appendLayoutModel);
        }
    }

    @Override
    public void runAfter() {
        if (this.after != null) {
            this.after.run();
        }
    }

    @Override
    public void setAfter(Runnable after) {
        this.after = after;
    }

    @Override
    public boolean constrained() {
        return false;
    }

    static {
        PropertyLoader.load();
        IDENTITY_SHAPE = Rectangle.IDENTITY;
    }

    public static abstract class Builder<V, E, T extends AbstractHierarchicalMinCrossLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected Executor executor;
        protected Function<V, Rectangle> vertexBoundsFunction = v -> IDENTITY_SHAPE;
        protected boolean straightenEdges = Boolean.parseBoolean(System.getProperty("jungrapht.mincross.straightenEdges", "true"));
        protected boolean postStraighten = Boolean.parseBoolean(System.getProperty("jungrapht.mincross.postStraighten", "true"));
        protected boolean transpose = true;
        protected int maxLevelCross = Integer.getInteger("jungrapht.mincross.maxLevelCross", 23);
        protected Function<Graph<V, E>, Integer> maxLevelCrossFunction = g -> this.maxLevelCross;
        protected boolean expandLayout = true;
        protected Layering layering = Layering.TOP_DOWN;
        protected Runnable after = () -> {};
        protected boolean threaded = Boolean.parseBoolean(System.getProperty("jungrapht.mincross.threaded", "true"));
        protected boolean separateComponents = true;
        protected Comparator<E> edgeComparator = Layered.noopComparator;
        protected Predicate<E> favoredEdgePredicate = Layered.truePredicate;

        protected B self() {
            return (B)this;
        }

        public B vertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
            this.vertexBoundsFunction = vertexBoundsFunction;
            return this.self();
        }

        public B straightenEdges(boolean straightenEdges) {
            this.straightenEdges = straightenEdges;
            return this.self();
        }

        public B postStraighten(boolean postStraighten) {
            this.postStraighten = postStraighten;
            return this.self();
        }

        public B transpose(boolean transpose) {
            this.transpose = transpose;
            return this.self();
        }

        public B maxLevelCross(int maxLevelCross) {
            this.maxLevelCross = maxLevelCross;
            return this.self();
        }

        public B maxLevelCrossFunction(Function<Graph<V, E>, Integer> maxLevelCrossFunction) {
            this.maxLevelCrossFunction = maxLevelCrossFunction;
            return this.self();
        }

        public B edgeComparator(Comparator<E> edgeComparator) {
            this.edgeComparator = edgeComparator;
            return this.self();
        }

        public B expandLayout(boolean expandLayout) {
            this.expandLayout = expandLayout;
            return this.self();
        }

        public B layering(Layering layering) {
            this.layering = layering;
            return this.self();
        }

        public B threaded(boolean threaded) {
            this.threaded = threaded;
            return this.self();
        }

        public B executor(Executor executor) {
            this.executor = executor;
            return this.self();
        }

        public B after(Runnable after) {
            this.after = after;
            return this.self();
        }

        public B favoredEdgePredicate(Predicate<E> favoredEdgePredicate) {
            this.favoredEdgePredicate = favoredEdgePredicate;
            return this.self();
        }

        public B separateComponents(boolean separateComponents) {
            this.separateComponents = separateComponents;
            return this.self();
        }

        static {
            PropertyLoader.load();
        }
    }
}

